/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <dirent.h>
#include <errno.h>

#include "config.h"

#ifdef X_FACE
#include <Nws/Nws.h>
#include <X11/Shell.h>
#include <X11/CompositeP.h>
#include <X11/xpm.h>

#include "uconfig.h"
#include "recurse.h"
#include "url.h"
#include "schedule.h"
#include "tools.h"
#include "update_links.h"
#include "mode.h"
#include "ainterface.h"
#include "appdef.h"
#include "html.h"
#include "dns.h"

#include "icons/restart.xpm"
#include "icons/continue.xpm"
#include "icons/break.xpm"
#include "icons/gobg.xpm"
#include "icons/stop.xpm"
#include "icons/configure.xpm"
#include "icons/exit.xpm"
#include "icons/schedule.xpm"
#include "pavuk_logo.xpm"

#include "lang.h"
#include "charset.h"
#include "mimetype.h"


#define PAVUK_ABOUT	0
#define PAVUK_CFGCOMM	1
#define PAVUK_CFGSCH	2
#define PAVUK_CFGLIM	3
#define PAVUK_TREE	4
#define PAVUK_SCNLD	5
#define PAVUK_SCNSV	6


extern char *get_strategie_label(int);

static void build_about(Widget , int);
static void build_config_comm(Widget , int);
static void build_config_sch(Widget , int);
static void build_config_lim(Widget , int);
static void build_tree_preview(Widget , int);
static void build_scenario_loader(Widget , int);
static void build_scenario_saver(Widget , int);

typedef struct _ListOpRec {
	Widget		entryw;
	Widget		listw;
} ListOpRec;

static char *en_month_names[] = {
	gettext_nop("January") ,
	gettext_nop("February") ,
	gettext_nop("March") ,
	gettext_nop("April") ,
	gettext_nop("May") ,
	gettext_nop("June") ,
	gettext_nop("July") ,
	gettext_nop("August") ,
	gettext_nop("September") ,
	gettext_nop("October") ,
	gettext_nop("November") ,
	gettext_nop("December")
};

static char *en_day_names[] = {
	gettext_nop("Sun") ,
	gettext_nop("Mon"),
	gettext_nop("Tue") ,
	gettext_nop("Wed") ,
	gettext_nop("Thu") ,
	gettext_nop("Fri") ,
	gettext_nop("Sat") ,
};

static int _restart_iface;
static char *last_lang = NULL;
static int _go_bg = FALSE;

#ifdef DEBUG
static void set_debug_level_mi()
{
	int i;

	for(i = 0 ; cfg_debug_levels[i].id ; i++)
	{
		XtVaSetValues(((CompositeRec *)cfg.X.debug_level_m)->composite.children[i] , XtNon ,
			(cfg.debug_level & cfg_debug_levels[i].id) != 0, NULL);
	}
	XtSetSensitive(cfg.X.debug_level_mi , cfg.debug);
}
#endif

static Widget str_entry(parent , label , frame_type)
Widget parent;
char *label;
int frame_type;
{
	Widget pom , retw;

	pom = XtVaCreateManagedWidget("_row_" , rowWidgetClass , parent ,  
		XtNbox_type , frame_type ,
		NULL);

	XtVaCreateManagedWidget("_label_" , labelWidgetClass , pom ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(label) ,
		NULL);

	retw = XtVaCreateManagedWidget("_entry_" ,
		entryLineWidgetClass , pom ,
		XtNresizable , True ,
		NULL);

	return retw;
}

static Widget num_entry(parent , label , frame_type)
Widget parent;
char *label;
int frame_type;
{
	Widget pom , retw;

	pom = XtVaCreateManagedWidget("_row_" , rowWidgetClass , parent ,
		XtNbox_type , frame_type ,
		NULL);

	XtVaCreateManagedWidget("_label_" , labelWidgetClass , pom ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(label) ,
		NULL);

	retw = XtVaCreateManagedWidget("_num_entry_" ,
		numberEntryWidgetClass , pom ,
		XtNwidth , 80 ,
		NULL);

	return retw;
}

static Widget float_entry(parent , label , frame_type , decimals)
Widget parent;
char *label;
int frame_type;
int decimals;
{
	Widget pom , retw;

	pom = XtVaCreateManagedWidget("_row_" , rowWidgetClass , parent ,
		XtNbox_type , frame_type ,
		NULL);

	XtVaCreateManagedWidget("_label_" , labelWidgetClass , pom ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(label) ,
		NULL);

	retw = XtVaCreateManagedWidget("_num_entry_" ,
		floatEntryWidgetClass , pom ,
		XtNwidth , 80 ,
		XtNdecimals , decimals ,
		NULL);

	return retw;
}


static void SetFileEntry(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	char pom[PATH_MAX];
	char *p;
	char *d;

	XtVaGetValues(w , XtNfile , &p , NULL);
	XtVaGetValues(w , XtNdir , &d , NULL);

	sprintf(pom , "%s%s" , d , p ? p : "");
	XtVaSetValues((Widget) client_data , XtNtext , pom , NULL);
}

static void GetPath(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Widget fs,fss;

	CreateFSShell("dirsel_shell" , "dirsel" , cfg.X.toplevel , &fss , &fs);

	XtVaSetValues(fss , XtNtitle , gettext("Pavuk: Get File") , NULL);

	XtDestroyWidget(GetFileSelWidget(fs , XtCapply_button));
	XtDestroyWidget(GetFileSelWidget(fs , XtChelp_button));

	XtVaSetValues(fs , XtNcancel_label , gettext("Cancel") ,
		XtNdir_label , gettext("Directory: ") ,
		XtNfilter_label , gettext("Filter: ") ,
		XtNfile_label , gettext("File: ") ,
		XtNrescan_label , gettext("Rescan") ,
		XtNok_label , gettext("OK") ,
		NULL);

	XtAddCallback(fs , XtNok_button_cb , SetFileEntry , (XtPointer) client_data);

	XtPopup(fss , XtGrabNone);
}

static void GetDir(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	Widget fs,fss;

	CreateDSShell("dirsel_shell" , "dirsel" , cfg.X.toplevel , &fss , &fs);

	XtVaSetValues(fss , XtNtitle , gettext("Pavuk: Get Directory") , NULL);

	XtDestroyWidget(GetFileSelWidget(fs , XtCapply_button));
	XtDestroyWidget(GetFileSelWidget(fs , XtChelp_button));

	XtVaSetValues(fs , XtNcancel_label , gettext("Cancel") ,
		XtNdir_label , gettext("Directory: ") ,
		XtNfilter_label , gettext("Filter: ") ,
		XtNfile_label , gettext("File: ") ,
		XtNrescan_label , gettext("Rescan") ,
		XtNok_label , gettext("OK") ,
		NULL);

	XtAddCallback(fs , XtNok_button_cb , SetFileEntry , (XtPointer) client_data);

	XtPopup(fss , XtGrabNone);
}

static Widget path_entry(parent , label , frame_type , dir)
Widget parent;
char *label;
int frame_type;
int dir;
{
	Widget pom , retw , but;

	pom = XtVaCreateManagedWidget("_row_" , rowWidgetClass , parent ,
		XtNbox_type , frame_type ,
		NULL);

	XtVaCreateManagedWidget("_label_" , labelWidgetClass , pom ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(label) ,
		NULL);

	retw = XtVaCreateManagedWidget("_path_entry_" ,
		entryLineWidgetClass , pom ,
		XtNresizable , True ,
		NULL);

	but = XtVaCreateManagedWidget("_button_" ,
		buttonWidgetClass , pom ,
		XtNlabel , gettext("Browse ...") ,
		NULL);

	XtAddCallback(but , XtNactivate , dir ? GetDir : GetPath , retw);

	return retw;
}

static void ResetCfg(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	cfg_setup_default();

	cfg.xi_face = True;

	if (cfg.X.cfg_limits)
		xset_cfg_values_lim();
	if (cfg.X.config_shell)
		xset_cfg_values_comm();

	if (cfg.use_prefs)
		cfg_dump_pref();

}

#ifdef GETTEXT_NLS
static void ChangeLang(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	if (last_lang && client_data && !strcmp(last_lang , client_data)) return;
	else if (!last_lang && !client_data) return;

	if (!client_data)
		unsetenv("LC_MESSAGES");

	cfg.language = (char *)client_data;
	_INIT_NLS

	_free(last_lang);
	last_lang = new_string((char *)client_data);

	_restart_iface = TRUE;
}
#endif


static void SwitchMode(gr , w , data)
ToggleGroup *gr;
Widget w;
XtPointer data;
{
	XtVaGetValues(w , XtNwid , &cfg.mode , NULL);
	if (cfg.done && cfg.mode_started)
	{
		if (cfg.mode != cfg.prev_mode)
		{
			XtSetSensitive(cfg.X.bt_start,FALSE);
			XtSetSensitive(cfg.X.mea_start,FALSE);
		}
		else
		{
			XtSetSensitive(cfg.X.bt_start,TRUE);
			XtSetSensitive(cfg.X.mea_start,TRUE);
		}
	}
}

static void Gobg(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	_go_bg = TRUE;
	cfg.stop = True;

	if (cfg.use_prefs)
		cfg_dump_pref();

}

static void DeleteFromList(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct *l = ListGetSelected((Widget)client_data);

	if (l)
	{
		DeleteListItem((Widget)client_data , l->index);
	}
	else XBell(cfg.X.dpy , 50);
}

static void AppendToList(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListOpRec *info = (ListOpRec *) client_data;
	ListStruct plist;

       	plist.sensitive = True;
  	plist.left_icon = NULL;
  	plist.right_icon = NULL;
  	plist.related_info = NULL;
	plist.label = EntryLineGetText(info->entryw);

	if (plist.label && strlen(plist.label))
	{
		ListAppendItems(info->listw , &plist , 1);
	}
	else XBell(cfg.X.dpy , 50);
}

static void AppendToLangList(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct plist,*lp;
	char pom[3] = {'\0','\0','\0'};

	lp = ListGetSelected(cfg.X.alanglist);
	if (!lp)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}
	
       	plist.sensitive = True;
  	plist.left_icon = NULL;
  	plist.right_icon = NULL;
  	plist.related_info = NULL;
	plist.label = pom;
	strncpy(pom , lp->label , 2);

	if (plist.label && strlen(plist.label))
	{
		ListAppendItems(cfg.X.langlist , &plist , 1);
	}
	else XBell(cfg.X.dpy , 50);
}

static void AppendToChsetList(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct plist,*lp;

	lp = ListGetSelected(cfg.X.acharset_list);
	if (!lp)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}
	
       	plist.sensitive = True;
  	plist.left_icon = NULL;
  	plist.right_icon = NULL;
  	plist.related_info = NULL;
	plist.label = lp->label;

	if (plist.label && strlen(plist.label))
	{
		ListAppendItems(cfg.X.charset_list , &plist , 1);
	}
	else XBell(cfg.X.dpy , 50);
}

static void AppendToMIMEList(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ListStruct plist,*lp;

	lp = ListGetSelected(cfg.X.mimelist);
	if (!lp)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}
	
       	plist.sensitive = True;
  	plist.left_icon = NULL;
  	plist.right_icon = NULL;
  	plist.related_info = NULL;
	plist.label = lp->label;

	if (plist.label && strlen(plist.label))
	{
		ListAppendItems(cfg.X.amimelist , &plist , 1);
	}
	else XBell(cfg.X.dpy , 50);
}

static void CalendarMonth(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	static struct tm *t;
	ListStruct *ls;

	XtVaGetValues((Widget)client_data , XtNtime , &t , NULL);

	ls = ListGetSelected(ComboGetListWidget(w));

	t->tm_mon = ls->index;
	
	XtVaSetValues((Widget)client_data,XtNtime,t,NULL);
}

static void CalendarYear(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	static struct tm *t;

	XtVaGetValues((Widget)client_data , XtNtime , &t , NULL);

	t->tm_year = NumberEntryGetValue(w);

	XtVaSetValues((Widget)client_data ,XtNtime,t,NULL);
}

static void ToggleLogScroll(w , client_data , call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	bool *v = (bool *) client_data;

	XtVaGetValues(w , XtNon , v , NULL);
	XtVaSetValues(cfg.X.logw , XtNbottom_grav , *v , NULL);
}

static void ClearLog(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	LogClear(cfg.X.logw);
}

static void OpenURL(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	CardBoxSwitchTo(cfg.X.cb_comcfg , 0);
}

static void FetchUrl(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	char *p,*p_seldata,*cb_url;
	int n;
	
	p_seldata = (char *) XFetchBuffer(cfg.X.dpy , &n , 0);

	if (!n)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	p = strchr(p_seldata , '\n');
	if (p)
		cb_url = new_n_string(p_seldata , p - p_seldata); 	
	else
		cb_url = new_n_string(p_seldata , n);

	if (cfg.X.config_shell)
	{
		ListStruct plist;

		plist.sensitive = True;
		plist.left_icon = NULL;
		plist.right_icon = NULL;
		plist.related_info = NULL;
		plist.label = cb_url;

		ListAppendItems(cfg.X.url_list , &plist , 1);
	}

	cfg.prepurlstr = dllist_append(cfg.prepurlstr , new_string(cb_url));

#ifdef DEBUG
	if (cfg.debug)
		xprintf(0 , gettext("Fetched URL from clipboard: %s\n") , cb_url);
#endif

	_free(cb_url);
}

static void Quit(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	if (cfg.use_prefs)
		cfg_dump_pref();

	pavuk_do_at_exit();
        exit(0);
}

static void PopupW(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int which = (int) client_data;

	switch (which)
	{
	    case PAVUK_ABOUT:
		build_about(cfg.X.toplevel , TRUE);
		break;
	    case PAVUK_CFGCOMM:
		build_config_comm(cfg.X.toplevel , TRUE);
		xset_cfg_values_comm();
		break;
	    case PAVUK_CFGSCH:
		build_config_sch(cfg.X.toplevel , TRUE);
	    	{
	    		time_t t = time(NULL);
	    		struct tm *ltime = localtime(&t);

			ltime->tm_year += 1900;

			XtVaSetValues(w , XtNtime , ltime , NULL);
	    		ComboSetIndex(cfg.X.month , ltime->tm_mon);
	    		XtVaSetValues(cfg.X.year , XtNvalue , ltime->tm_year , NULL);
			XtVaSetValues(cfg.X.hour_label , XtNvalue , ltime->tm_hour , NULL);
			XtVaSetValues(cfg.X.min_label , XtNvalue , ltime->tm_min , NULL);
			EntryLineSetText(cfg.X.sched_cmd, cfg.sched_cmd);
	    	}
		break;
	    case PAVUK_CFGLIM:
		build_config_lim(cfg.X.toplevel , TRUE);
		xset_cfg_values_lim();
		break;
	    case PAVUK_TREE:
		build_tree_preview(cfg.X.toplevel , TRUE);
		break;
	    case PAVUK_SCNLD:
		build_scenario_loader(cfg.X.toplevel , TRUE);
		break;
	    case PAVUK_SCNSV:
		build_scenario_saver(cfg.X.toplevel , TRUE);
		break;
	    default:
		xprintf(1 , gettext("Unknown window to popup"));
	}
}

static void PopdownW(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	XtPopdown((Widget)client_data);
}

static void Start(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	if (cfg.processing)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	XtSetSensitive(cfg.X.mbb_mode , FALSE);
	XtSetSensitive(cfg.X.bt_rest,FALSE);
	XtSetSensitive(cfg.X.mea_rest,FALSE);
	XtSetSensitive(cfg.X.bt_start,FALSE);
	XtSetSensitive(cfg.X.mea_start,FALSE);
	XtSetSensitive(cfg.X.bt_stop,TRUE);
	XtSetSensitive(cfg.X.mea_stop,TRUE);
	XtSetSensitive(cfg.X.bt_break,TRUE);
	XtSetSensitive(cfg.X.mea_break,TRUE);
#ifdef WITH_TREE
	LabelSetLabel(cfg.X.tree_help , "");
#endif
	XtSetSensitive(cfg.X.me_surl,FALSE);
	XtSetSensitive(cfg.X.me_sch,FALSE);
	XtSetSensitive(cfg.X.scn_lme,FALSE);
	XtSetSensitive(cfg.X.scn_sme,FALSE);

	cfg.processing = TRUE;

	if (client_data || cfg.mode != cfg.prev_mode || !cfg.mode_started)
	{
		absi_restart();
	}
	else
	{
		absi_cont();
	}

	cfg.processing = FALSE;

	XBell(cfg.X.dpy , 50);

	XtSetSensitive(cfg.X.mbb_mode , TRUE);
	XtSetSensitive(cfg.X.bt_rest,TRUE);
	XtSetSensitive(cfg.X.mea_rest,TRUE);
	if (cfg.urlstack)
	{
		XtSetSensitive(cfg.X.bt_start,TRUE);
		XtSetSensitive(cfg.X.mea_start,TRUE);
	}
	XtSetSensitive(cfg.X.bt_stop,FALSE);
	XtSetSensitive(cfg.X.mea_stop,FALSE);
	XtSetSensitive(cfg.X.bt_break,FALSE);
	XtSetSensitive(cfg.X.mea_break,FALSE);

	XtSetSensitive(cfg.X.me_surl,TRUE);
	XtSetSensitive(cfg.X.me_sch,TRUE);
	XtSetSensitive(cfg.X.scn_lme,TRUE);
	XtSetSensitive(cfg.X.scn_sme,TRUE);

	cfg.stop = FALSE;
	cfg.rbreak = FALSE;
}

static void Stop(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	cfg.stop = True;
}

static void Break(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	cfg.rbreak = True;
	cfg.stop = True;
	cfg.X.endloop = TRUE;
	errno = EINTR;

	_X_EscLoop();
}

static void CfgLimits(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int retv = 0;

	retv = xget_cfg_values_lim();
}

static void CfgCommon(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int retv = 0;

	retv = xget_cfg_values_comm();
}

static void DoConfig(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	int retv = 0;

	if ((Widget)client_data == cfg.X.config_shell)
		retv = xget_cfg_values_comm();
	else if ((Widget)client_data == cfg.X.cfg_limits)
		retv = xget_cfg_values_lim();

	if (!retv)
	{
		XtPopdown((Widget) client_data);
		if (cfg.use_prefs)
			cfg_dump_pref();

	}
	else XBell(cfg.X.dpy , 50);
}

#ifdef WITH_TREE
static void PopupMenu(w , client_data , event , ctd)
Widget w;
XtPointer client_data;
XEvent *event;
Boolean * ctd;
{
        Widget menu = (Widget) client_data;
        Position x,y;
        Dimension width , height ,
                dwidth = DisplayWidth(cfg.X.dpy , DefaultScreen(cfg.X.dpy)) ,
                dheight = DisplayHeight(cfg.X.dpy , DefaultScreen(cfg.X.dpy)) ;
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	url *urlp;

	if (event->type != ButtonPress || event->xbutton.button != Button3) return;

        if (!XtIsRealized(menu))  XtRealizeWidget(menu); 

        XtVaGetValues(menu , XtNwidth , &width , XtNheight , &height , NULL);

        XtTranslateCoords((Widget) w , event->xbutton.x ,
		event->xbutton.y , &x ,&y);

        if ( (x + width) > dwidth ) x = dwidth - width;

        if ( (y + height ) > dheight ) y = y - height;

        if ( y < 0 ) y = 0;

        XtVaSetValues(menu,XtNx,x,XtNy,y,NULL);

	if (!item || !item->item->related_info)
	{
		XtSetSensitive(cfg.X.me_disable_url , FALSE);
		XtSetSensitive(cfg.X.me_enable_url , FALSE);
		XtSetSensitive(cfg.X.me_browse_url , FALSE);
		XtSetSensitive(cfg.X.me_prop_url , FALSE);
		XtSetSensitive(cfg.X.me_download_url , FALSE);
	}
	else
	{
		XtSetSensitive(cfg.X.me_browse_url , TRUE);
		XtSetSensitive(cfg.X.me_prop_url , TRUE);

		urlp = (url *)item->item->related_info;

		if (urlp->status & URL_PROCESSED && !(urlp->status & URL_USER_DISABLED))
		{
			XtSetSensitive(cfg.X.me_disable_url , FALSE);
			XtSetSensitive(cfg.X.me_enable_url , FALSE);
			XtSetSensitive(cfg.X.me_download_url , 
				(urlp->status & URL_REJECTED) || 
				(urlp->status & URL_TRUNCATED) ||
				(urlp->status & URL_ERR_REC));
		}
		else
		{
			XtSetSensitive(cfg.X.me_disable_url , 
				!(urlp->status & URL_USER_DISABLED));
			XtSetSensitive(cfg.X.me_enable_url , 
				(urlp->status & URL_USER_DISABLED));
			XtSetSensitive(cfg.X.me_download_url ,
				cfg.processing ? FALSE :
				!(urlp->status & URL_USER_DISABLED));
		}
	}

        XtPopupSpringLoaded(menu);
}

static void LaunchBrowser(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	char pom[2048];
	char *p;

	if (!cfg.browser || !item || !item->item->related_info)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	p = new_string(url_to_filename((url *)item->item->related_info , TRUE));

	if (access(p,R_OK))
	{
		_free(p);
		p = url_to_urlstr((url *)item->item->related_info , FALSE);
	}

	sprintf(pom , "%s %s &" , cfg.browser , p);
	system(pom);

	_free(p);
}

static void Propert(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	char pom[2048];
	url_prop *prp;

	if (!item || !item->item->related_info)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}
	
	prp = ((url *)item->item->related_info)->prop;

	if (!prp)
	{
		sprintf(pom , gettext("Not available"));
	}
	else
	{
		if (prp->type)
			sprintf(pom , gettext("Size: %d   Type: %s") , prp->size , gettext(prp->type));
		else
			sprintf(pom , gettext("Size: %d   Type: unknown") , prp->size);		
	}

	LabelSetLabel(cfg.X.tree_help , pom);
}

static void DisableURL(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	url *urlp;
	int i;

	if (!item || !item->item->related_info)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	urlp = 	(url *)item->item->related_info;

	urlp->status |= URL_USER_DISABLED;

	for (i = 0 ; i < urlp->ref_cnt ; i++)
		TreeListItemSetSensitive(cfg.X.tree_widget , urlp->tree_nfo[i] , FALSE);
}

static void EnableURL(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	url *urlp;
	int i;

	if (!item || !item->item->related_info)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	urlp = 	(url *)item->item->related_info;

	urlp->status &= ~URL_USER_DISABLED;

	for (i = 0 ; i < urlp->ref_cnt ; i++)
		TreeListItemSetSensitive(cfg.X.tree_widget , urlp->tree_nfo[i] , TRUE);

	if (urlp->status & URL_PROCESSED)
	{
		urlp->status &= ~URL_PROCESSED;

		LOCK_CFG_URLSTACK
		cfg.urlstack = dllist_append(cfg.urlstack , urlp);
		cfg.total_cnt++;
		UNLOCK_CFG_URLSTACK
	}
}

static void DownloadThisURL(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	TreeList *item = TreeListGetSelectedItem(cfg.X.tree_widget);
	url *urlp;
	doc docu;
	global_connection_info con_info;

	if (!item || !item->item->related_info || cfg.processing)
	{
		XBell(cfg.X.dpy , 50);
		return;
	}

	urlp = 	(url *)item->item->related_info;

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;

	cfg.processing = TRUE;

	doc_init(&docu, urlp);
	process_document(&docu , FALSE);

	init_global_connection_data(&con_info);
	save_global_connection_data(&con_info, &docu);
	kill_global_connection_data(&con_info);

	cfg.processing = FALSE;

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;

	iface_set_what("Done");
}

static void ClrHlp(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	LabelSetLabel(cfg.X.tree_help , "");
}

#endif

void get_sch_cfg_values()
{
	char *p;

	cfg.time->tm_hour = NumberEntryGetValue(cfg.X.hour_label);
	cfg.time->tm_min = NumberEntryGetValue(cfg.X.min_label);

	_free(cfg.sched_cmd);
	p = EntryLineGetText(cfg.X.sched_cmd);
	if (p && *p)
		cfg.sched_cmd = new_string(p);

}

static void Schedule(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	get_sch_cfg_values();

	if (!at_schedule())
	{
		XtPopdown(cfg.X.cfg_sch);
		return;
	}
	xprintf(1 , gettext("Error scheduling\n"));
	XBell(cfg.X.dpy , 50);
}


static void ToggleBool(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	bool *v = (bool *) client_data;

	XtVaGetValues(w , XtNon , v , NULL);
}


static void PopupScenario(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	if (client_data)
	{
		build_scenario_saver(cfg.X.toplevel , TRUE);
	}
	else
	{
		build_scenario_loader(cfg.X.toplevel , TRUE);
	}
}

static void SaveScenario(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	char pom[PATH_MAX];
	char *p;
	char *d;

	XtVaGetValues(w , XtNfile , &p , NULL);
	XtVaGetValues(w , XtNdir , &d , NULL);

	if (p && *p)
	{
		sprintf(pom , "%s/%s" , d , p);
		if (cfg_dump(pom))
			XBell(cfg.X.dpy , 50);
		else
			XtPopdown(XtParent(cfg.X.scn_save_shell));
	}
	else XBell(cfg.X.dpy , 50);
}

static void LoadScenario(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	char pom[PATH_MAX];
	char *p;
	char *d;

	XtVaGetValues(w , XtNfile , &p , NULL);
	XtVaGetValues(w , XtNdir , &d , NULL);

	if (p && *p)
	{
		sprintf(pom , "%s/%s" , d , p);

		if (cfg_load(pom))
			XBell(cfg.X.dpy , 50);
		else
		{
			ToggleGroupSetActive(cfg.X.modegr ,
				ToggleGetWidgetByWid(cfg.X.modegr , cfg.mode));

			if (!cfg.progres)
			{
				XtSetSensitive(cfg.X.bt_start,FALSE);
				XtSetSensitive(cfg.X.mea_start,FALSE);

				free_all();
				cfg.total_cnt = 0;
				cfg.urlstack = NULL;
				cfg.mode_started = FALSE;
			}

			if (cfg.X.config_shell) xset_cfg_values_comm();
			if (cfg.X.cfg_limits) xset_cfg_values_lim();
#ifdef DEBUG
			XtVaSetValues(cfg.X.me_debug , XtNon , cfg.debug , NULL);
			set_debug_level_mi();
#endif
			XtVaSetValues(cfg.X.me_quiet , XtNon , cfg.quiet , NULL);

			XtPopdown(XtParent(cfg.X.scn_load_shell));
		}
	}
	else XBell(cfg.X.dpy , 50);
}

static void build_scenario_loader(parent , popup)
Widget parent;
int popup;
{
	Widget fss,fs;

	if (cfg.X.scn_load_shell)
	{
		if (popup) XtPopup(cfg.X.scn_load_shell , XtGrabNone);
		return;
	}
	
	CreateFSShell("dirsel_shell" , "dirsel" , parent , &fss , &fs);

	cfg.X.scn_load_shell = fss;
	XtVaSetValues(fss , XtNtitle , gettext("Pavuk: Scenario loader") , NULL);

	XtDestroyWidget(GetFileSelWidget(fs , XtCapply_button));
	XtDestroyWidget(GetFileSelWidget(fs , XtChelp_button));

	if (cfg.scndir)
		XtVaSetValues(fss , XtNdir , cfg.scndir , NULL);

	XtVaSetValues(fs , XtNcancel_label , gettext("Cancel") ,
		XtNdir_label , gettext("Directory: ") ,
		XtNfilter_label , gettext("Filter: ") ,
		XtNfile_label , gettext("File: ") ,
		XtNrescan_label , gettext("Rescan") ,
		XtNok_label , gettext("OK") ,
		NULL);

	XtAddCallback(fs , XtNok_button_cb , LoadScenario , (XtPointer) 0);

	if (popup) XtPopup(cfg.X.scn_load_shell , XtGrabNone);
}

static void build_scenario_saver(parent , popup)
Widget parent;
int popup;
{
	Widget fs , fss;

	if (cfg.X.scn_save_shell)
	{
		if (popup) XtPopup(cfg.X.scn_save_shell , XtGrabNone);
		return;
	}

	CreateFSShell("dirsel_shell" , "dirsel" , parent , &fss , &fs);

	cfg.X.scn_save_shell = fss;
	XtVaSetValues(fss , XtNtitle , gettext("Pavuk: Scenario saver") , NULL);

	XtDestroyWidget(GetFileSelWidget(fs , XtCapply_button));
	XtDestroyWidget(GetFileSelWidget(fs , XtChelp_button));

	if (cfg.scndir)
		XtVaSetValues(fss , XtNdir , cfg.scndir , NULL);

	XtVaSetValues(fs , XtNcancel_label , gettext("Cancel") ,
		XtNdir_label , gettext("Directory: ") ,
		XtNfilter_label , gettext("Filter: ") ,
		XtNfile_label , gettext("File: ") ,
		XtNrescan_label , gettext("Rescan") ,
		XtNok_label , gettext("OK") ,
		NULL);

	XtAddCallback(fs , XtNok_button_cb , SaveScenario , (XtPointer) 1);

	if (popup) XtPopup(cfg.X.scn_save_shell , XtGrabNone);
}


static void build_tree_preview(parent , popup)
Widget parent;
int popup;
{
#ifdef WITH_TREE
	Widget col;
	static Widget but;

	if (cfg.X.tree_shell)
	{
		XtVaSetValues(cfg.X.tree_shell , XtNtitle , gettext("Pavuk: URL tree preview") , NULL);
		XtVaSetValues(cfg.X.tree_help , XtNlabel , " " , NULL);
		XtVaSetValues(cfg.X.me_browse_url ,  XtNlabel , gettext("Launch browser") , NULL);
		XtVaSetValues(cfg.X.me_prop_url , XtNlabel , gettext("Properties") , NULL);
		XtVaSetValues(cfg.X.me_disable_url , XtNlabel , gettext("Disable URL") , NULL);
		XtVaSetValues(cfg.X.me_enable_url , XtNlabel , gettext("Enable URL") , NULL);
		XtVaSetValues(cfg.X.me_download_url ,  XtNlabel , gettext("Download URL") , NULL);
		XtVaSetValues(but , XtNlabel , gettext("Cancel"), NULL);
		if (popup) XtPopup(cfg.X.tree_shell , XtGrabNone);
		return;
	}

	cfg.X.tree_shell = XtVaCreatePopupShell("tree_shell", 
			topLevelShellWidgetClass , parent , 
			XtNtitle , gettext("Pavuk: URL tree preview") , NULL);

	col = XtVaCreateManagedWidget("tree_col" , colWidgetClass ,
		cfg.X.tree_shell , NULL);
		 
	cfg.X.tree_widget = GetTreeListWidget(XtVaCreateManagedWidget("url_tree" , 
		scrollTreeListWidgetClass , col , 
		XtNresizable , True , NULL));

	XtAddCallback(cfg.X.tree_widget , XtNselect_changed_cb , ClrHlp , NULL);

	cfg.X.tree_help = XtVaCreateManagedWidget("tree_help" , 
		labelWidgetClass , col ,
		XtNlabel , " " ,
		XtNwidth , 10,
		XtNtop_space , 5 ,
		XtNbottom_space , 5 ,		
		NULL);

	but = XtVaCreateManagedWidget("but_cancel" , buttonWidgetClass , col , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Cancel") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , PopdownW , cfg.X.tree_shell);

	cfg.X.tmenu = XtVaCreatePopupShell ("tree_menu" , menuWidgetClass ,
		cfg.X.tree_widget , NULL);

        XtAddEventHandler(cfg.X.tree_widget , ButtonPressMask , 
                True , PopupMenu , (XtPointer)cfg.X.tmenu);

	cfg.X.me_browse_url = XtVaCreateManagedWidget ("me_launch" , labelMEObjectClass ,
		cfg.X.tmenu , XtNlabel , gettext("Launch browser") , NULL);

	XtAddCallback(cfg.X.me_browse_url , XtNactivate , LaunchBrowser , cfg.X.tree_shell);

	cfg.X.me_prop_url = XtVaCreateManagedWidget ("me_prop" , labelMEObjectClass ,
		cfg.X.tmenu , XtNlabel , gettext("Properties") , NULL);

	XtAddCallback(cfg.X.me_prop_url , XtNactivate , Propert , cfg.X.tree_shell);

	cfg.X.me_disable_url = XtVaCreateManagedWidget ("me_disable" , labelMEObjectClass ,
		cfg.X.tmenu , XtNlabel , gettext("Disable URL") , NULL);

	XtAddCallback(cfg.X.me_disable_url , XtNactivate , DisableURL , cfg.X.tree_shell);

	cfg.X.me_enable_url = XtVaCreateManagedWidget ("me_enable" , labelMEObjectClass ,
		cfg.X.tmenu , XtNlabel , gettext("Enable URL") , NULL);

	XtAddCallback(cfg.X.me_enable_url , XtNactivate , EnableURL , cfg.X.tree_shell);

	cfg.X.me_download_url = XtVaCreateManagedWidget ("me_download" , labelMEObjectClass ,
		cfg.X.tmenu , XtNlabel , gettext("Download URL") , NULL);

	XtAddCallback(cfg.X.me_download_url , XtNactivate , DownloadThisURL , cfg.X.tree_shell);

	if (popup) XtPopup(cfg.X.tree_shell , XtGrabNone);
#endif
}

static void build_about(parent , popup)
Widget parent;
int popup;
{
	Widget	col,but;
	Icon *icon;
	char pom[1024];

	if (cfg.X.about_shell)
	{
		if (popup) XtPopup(cfg.X.about_shell , XtGrabNone);
		return;
	}

	cfg.X.about_shell = XtVaCreatePopupShell("about_shell", 
			topLevelShellWidgetClass , parent , 
			XtNtitle , gettext("Pavuk: About") , NULL);

	col = XtVaCreateManagedWidget("dumy_col" , colWidgetClass ,
		cfg.X.about_shell , NULL);

	icon = X_XpmDataToIcon(cfg.X.dpy , pavuk_logo_xpm);

	sprintf(pom , gettext("Pavuk %s\n \nan automatic WEB file grabber\n \nBy Stefan Ondrejicka\n \n(ondrej@idata.sk)\n \nURL : http://www.idata.sk/~ondrej/pavuk/\n ") , VERSION);

	XtVaCreateManagedWidget("about_label" , labelWidgetClass , col ,
		XtNlabel , pom ,
		XtNicon , icon ,
		XtNicon_justify , XtCright ,
		XtNresizable , True , NULL);

	but = XtVaCreateManagedWidget("but_cancel" , buttonWidgetClass , col , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Cancel") ,
		XtNgravitation , XtCright ,
		NULL);

	XtAddCallback(but , XtNactivate , PopdownW , cfg.X.about_shell);

	if (popup) XtPopup(cfg.X.about_shell , XtGrabNone);
}

#ifdef DEBUG
static void SetDebugLevel(w, wdata, cdata)
Widget w;
XtPointer wdata;
XtPointer cdata;
{
	int v;

	XtVaGetValues(w , XtNon , &v , NULL);

	if (v)
		cfg.debug_level |= (int)cdata;
	else
		cfg.debug_level &= ~(int)cdata;
	
}

static void ToggleDebug(w , wdata, cdata)
Widget w;
XtPointer wdata;
XtPointer cdata;
{
	XtVaGetValues(w , XtNon , &cfg.debug , NULL);
	XtSetSensitive(cfg.X.debug_level_mi, cfg.debug);
}
#endif

static void build_menu(parent)
Widget parent;
{
	Widget mbar,fmenu,mbb,m_entry;

	mbar = XtVaCreateManagedWidget("mbar" , menuBarWidgetClass , parent , NULL);

	mbb = XtVaCreateManagedWidget("mb_file" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_file" ,
		XtNlabel , gettext("File") , NULL);

	mbb = XtVaCreateManagedWidget("mb_view" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_view" , 
		XtNlabel , gettext("View") , NULL);

	cfg.X.mbb_mode = XtVaCreateManagedWidget("mb_mode" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_mode" , 
		XtNlabel , gettext("Mode") , NULL);

	cfg.X.mbb_cfg = XtVaCreateManagedWidget("mb_cfg" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_cfg" , 
		XtNlabel , gettext("Config") , NULL);

	mbb = XtVaCreateManagedWidget("mb_action" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_action" , 
		XtNlabel , gettext("Action") , NULL);

	mbb = XtVaCreateManagedWidget("mb_help" , mBButtonObjectClass , mbar ,
		XtNmenu_name , "menu_help" , 
		XtNgravitation , XtCright ,
		XtNlabel , gettext("Help") ,
		NULL);

/*** FILE menu ***/
	fmenu = XtVaCreatePopupShell ("menu_file" , menuWidgetClass , mbar , NULL);

	cfg.X.me_surl = m_entry = XtVaCreateManagedWidget ("me_url" , labelMEObjectClass , 
			fmenu , XtNlabel , gettext("Open URL ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , (XtPointer)PAVUK_CFGCOMM);
	XtAddCallback(m_entry , XtNactivate , OpenURL , NULL);

	cfg.X.me_surl = m_entry = XtVaCreateManagedWidget ("me_ftcb" , labelMEObjectClass , 
			fmenu , XtNlabel , gettext("Fetch URL from Clipboard") , NULL);

	XtAddCallback(m_entry , XtNactivate , FetchUrl , NULL);

	cfg.X.me_sch = m_entry = XtVaCreateManagedWidget ("me_sch" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Schedule ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , (XtPointer)PAVUK_CFGSCH);

	XtVaCreateManagedWidget("line" , lineMEObjectClass , fmenu , NULL);
	
	cfg.X.scn_lme = m_entry = XtVaCreateManagedWidget ("me_scn_load" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Load scenario ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupScenario , (XtPointer)0);

	cfg.X.scn_sme = m_entry = XtVaCreateManagedWidget ("me_scn_save" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Save scenario ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupScenario , (XtPointer)1);

	XtVaCreateManagedWidget("line" , lineMEObjectClass , fmenu , NULL);

	m_entry = XtVaCreateManagedWidget ("me_quit" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Exit") , NULL);

	XtAddCallback(m_entry , XtNactivate , Quit , NULL);

/*** CONFIG menu ***/
	fmenu = XtVaCreatePopupShell ("menu_cfg" , menuWidgetClass , parent , NULL);

	m_entry = XtVaCreateManagedWidget ("me_cfg_comm" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Common ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , (XtPointer)PAVUK_CFGCOMM);

	m_entry = XtVaCreateManagedWidget ("me_cfg_lim" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Limitations ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , (XtPointer)PAVUK_CFGLIM);

	m_entry = XtVaCreateManagedWidget ("me_cfg_reset" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Reset configuration") , NULL);

	XtAddCallback(m_entry , XtNactivate , ResetCfg , (XtPointer)NULL);


#ifdef GETTEXT_NLS
{
	Widget smenu;
	static char **al = NULL;
	int i;
	if (al || (al = get_available_languages()))
	{
		XtVaCreateManagedWidget("line" , lineMEObjectClass , fmenu , NULL);

		m_entry = XtVaCreateManagedWidget ("me_cfg_lang" , subMEObjectClass ,
			fmenu , XtNlabel , gettext("Language") , XtNmenu_name , "language_menu" , NULL);

		smenu = XtVaCreatePopupShell ("language_menu" , menuWidgetClass , fmenu , NULL);

		m_entry = XtVaCreateManagedWidget ("lng" , labelMEObjectClass ,
			smenu , XtNlabel , "en" , NULL);

		XtAddCallback(m_entry , XtNactivate , ChangeLang , (XtPointer)"C");

		for (i = 0; al[i] ; i++)
		{
			m_entry = XtVaCreateManagedWidget ("lng" , labelMEObjectClass ,
				smenu , XtNlabel , al[i] , NULL);

			XtAddCallback(m_entry , XtNactivate , ChangeLang , (XtPointer)al[i]);
		}
	}
}
#endif
	XtVaCreateManagedWidget("line" , lineMEObjectClass , fmenu , NULL);


#ifdef DEBUG
{
	int i;

	cfg.X.debug_level_mi = XtVaCreateManagedWidget("me_debugl" , subMEObjectClass , fmenu ,
			XtNlabel , gettext("Debug level"),
			XtNmenu_name , "debug_level_menu", NULL);

	cfg.X.me_debug = XtVaCreateManagedWidget ("me_cfg_debug" , checkMEObjectClass ,
			fmenu , XtNon , cfg.debug ,
			XtNlabel , gettext("Debug") , NULL);

	XtAddCallback(cfg.X.me_debug , XtNswitch , ToggleDebug , NULL);

	cfg.X.debug_level_m = XtVaCreatePopupShell ("debug_level_menu" , menuWidgetClass , fmenu , NULL);

	for (i = 0; cfg_debug_levels[i].id ; i++)
	{
		m_entry = XtVaCreateManagedWidget("dl" , checkMEObjectClass ,
			cfg.X.debug_level_m,
			XtNlabel , gettext(cfg_debug_levels[i].label), NULL);

		XtAddCallback(m_entry , XtNactivate , SetDebugLevel , 
			(XtPointer)cfg_debug_levels[i].id);
	}
	set_debug_level_mi();
	XtVaCreateManagedWidget("line" , lineMEObjectClass , fmenu , NULL);
}
#endif
	m_entry = XtVaCreateManagedWidget ("me_scroll" , checkMEObjectClass ,
			fmenu ,  XtNon , cfg.log_autoscroll ,
			XtNlabel , gettext("Log window autoscroll") , NULL);

	XtAddCallback(m_entry , XtNswitch , ToggleLogScroll , &cfg.log_autoscroll);

	cfg.X.me_quiet = m_entry = XtVaCreateManagedWidget ("me_cfg_quiet" , checkMEObjectClass ,
			fmenu , XtNon , cfg.quiet , 
			XtNlabel , gettext("Quiet") , NULL);

	XtAddCallback(m_entry , XtNswitch , ToggleBool , &cfg.quiet);

/*** MODE menu ***/
	cfg.X.modegr = CreateToggleGroup();
	ToggleAddCallback(cfg.X.modegr , SwitchMode , NULL);

	fmenu = XtVaCreatePopupShell ("menu_mode" , menuWidgetClass , mbar , NULL);

	m_entry = XtVaCreateManagedWidget ("me_normal" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_NORMAL , 
			XtNlabel , gettext("normal recurse") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_NORMAL)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);
	
	m_entry = XtVaCreateManagedWidget ("me_sync" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_SYNC , 
			XtNlabel , gettext("synchronize") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_SYNC)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_spage" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_SINGLE , 
			XtNlabel , gettext("single page") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_SINGLE)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_lnupd" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_LNUPD , 
			XtNlabel , gettext("update local links") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_LNUPD)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_resume" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_RESUME , 
			XtNlabel , gettext("resume files") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_RESUME)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_sreget" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_SREGET , 
			XtNlabel , gettext("unlimited reget") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_SREGET)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_nostore" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_NOSTORE , 
			XtNlabel , gettext("transfer but don't store") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_NOSTORE)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_remind" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_RESUME , 
			XtNlabel , gettext("reminder") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_REMIND)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

	m_entry = XtVaCreateManagedWidget ("me_ftpdir" , checkMEObjectClass ,
			fmenu , XtNwid , MODE_FTPDIR , 
			XtNlabel , gettext("list ftp directory") , NULL);

	AddWidgetToToggleGroup(cfg.X.modegr , m_entry);
	if (cfg.mode == MODE_FTPDIR)
		ToggleGroupSetActive(cfg.X.modegr , m_entry);

/*** HELP menu ***/
	fmenu = XtVaCreatePopupShell ("menu_help" , menuWidgetClass , mbar , NULL);

	m_entry = XtVaCreateManagedWidget ("me_about" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("About ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , PAVUK_ABOUT);
/*
	m_entry = XtVaCreateManagedWidget ("me_help" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Help ...") , NULL);
*/

/*** VIEW menu ***/
	fmenu = XtVaCreatePopupShell ("menu_view" , menuWidgetClass , mbar , NULL);

#ifdef WITH_TREE

	cfg.X.me_tree = m_entry = XtVaCreateManagedWidget ("me_tree" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Document Tree ...") , NULL);

	XtAddCallback(m_entry , XtNactivate , PopupW , (XtPointer) PAVUK_TREE);
#endif

	m_entry = XtVaCreateManagedWidget ("me_logclear" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Clear log window") , NULL);

	XtAddCallback(m_entry , XtNactivate , ClearLog , NULL);

/*** ACTION menu ***/
	fmenu = XtVaCreatePopupShell ("menu_action" , menuWidgetClass , mbar , NULL);

	cfg.X.mea_rest = m_entry = XtVaCreateManagedWidget ("me_rest" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Restart") , NULL);

	XtAddCallback(m_entry , XtNactivate , Start , (XtPointer)TRUE);

	cfg.X.mea_start = m_entry = XtVaCreateManagedWidget ("me_cont" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Continue") , NULL);

	XtAddCallback(m_entry , XtNactivate , Start , (XtPointer)FALSE);

	cfg.X.mea_stop = m_entry = XtVaCreateManagedWidget ("me_stop" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Stop") , NULL);

	XtAddCallback(m_entry , XtNactivate , Stop , NULL);

	cfg.X.mea_break = m_entry = XtVaCreateManagedWidget ("me_break" , labelMEObjectClass ,
			fmenu , XtNlabel , gettext("Break") , NULL);

	XtAddCallback(m_entry , XtNactivate , Break , NULL);

        XtSetSensitive(cfg.X.mea_start,FALSE);
        XtSetSensitive(cfg.X.mea_stop,FALSE);
        XtSetSensitive(cfg.X.mea_break,FALSE);
}

static Widget time_sel_new(parent , calendar , hentry , mentry , mcombo , yentry)
Widget parent;
Widget *calendar;
Widget *hentry;
Widget *mentry;
Widget *mcombo;
Widget *yentry;
{
	Widget col,pom2,cl;
	static ListStruct *lst = NULL;
	static char *dn[7] = {NULL};
	static char *mn[12] = {NULL};
	int i;

	col = XtVaCreateManagedWidget("cfg_col" , colWidgetClass , parent , NULL);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , col , 
		XtNbox_width , 0 ,
		XtNbox_type , XtCno_box ,
		NULL);

	*mcombo = XtVaCreateManagedWidget("month_combo" , comboWidgetClass , pom2 , 
		XtNresizable , True , XtNeditable , False , NULL);

	cl = ComboGetListWidget(*mcombo);

	if (lst)
	{
		for (i = 0 ; i < 12 ; i++) _free(lst[i].label);
		_free(lst);
	}
	lst = (ListStruct *) _malloc(12 * sizeof(ListStruct));
	for (i = 0 ; i < 12 ; i++)
	{
		lst[i].label = new_string(gettext(en_month_names[i]));
		lst[i].index = 0;
		lst[i].left_icon = None;
		lst[i].right_icon = None;
		lst[i].sensitive = True;
		lst[i].related_info = NULL;
	}

	if (dn[0])
		for (i = 0 ; i < 7 ; i++) _free(dn[i]);
	for (i = 0 ; i < 7 ; i++) dn[i] = new_string(gettext(en_day_names[i]));

	if (mn[0])
		for (i = 0 ; i < 12 ; i++) _free(mn[i]);
	for (i = 0 ; i < 12 ; i++) mn[i] = new_string(gettext(en_month_names[i]));

	ListChange(cl , lst , 12 , FALSE);

	*yentry = XtVaCreateManagedWidget("year_entry" , numberEntryWidgetClass , pom2 ,
		XtNresizable , True , NULL);


	*calendar = XtVaCreateManagedWidget("calendar" , calendarWidgetClass , col ,
		XtNday_names , dn ,
		XtNmonth_names , mn ,
		NULL);

	XtAddCallback(*mcombo , XtNchange , CalendarMonth , 
		(XtPointer) *calendar);

	XtAddCallback(*yentry , XtNchange , CalendarYear , 
		(XtPointer) *calendar);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , col ,  
				XtNtop_space , 15 , NULL);

	XtVaCreateManagedWidget("time_label" , labelWidgetClass , pom2 ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext("Time: ") ,
		NULL);

	*hentry = XtVaCreateManagedWidget("timed_label" , numberEntryWidgetClass ,
		pom2 ,
		XtNresizable , True ,
		XtNmaxval , 23 ,
		XtNwidth , 10 ,
		NULL);

	XtVaCreateManagedWidget("x_label" , labelWidgetClass , pom2 ,
		XtNbox_type , XtCno_box , XtNlabel , " : " ,
		NULL);

	*mentry = XtVaCreateManagedWidget("timed_label" , numberEntryWidgetClass ,
		pom2 ,
		XtNresizable , True ,
		XtNmaxval , 59 ,
		XtNwidth , 10 ,
		NULL);

	return col;
}

/**** SCHEDULER CFG ****/
static void build_config_sch(parent , popup)
Widget parent;
int popup;
{
	Widget col,cpar,but;
	Icon *icona;

	if (cfg.X.cfg_sch)
	{
		if (popup) XtPopup(cfg.X.cfg_sch , XtGrabNone);
		return;
	}

	cfg.X.cfg_sch = XtVaCreatePopupShell("cfg_sche", topLevelShellWidgetClass , parent , 
			XtNtitle , gettext("Pavuk: Scheduler") , NULL);

	col = time_sel_new(cfg.X.cfg_sch , &cfg.X.calendar , &cfg.X.hour_label ,
		&cfg.X.min_label ,
		&cfg.X.month , &cfg.X.year);

	cpar = XtVaCreateManagedWidget("dummy_row" , rowWidgetClass , col , NULL);

	XtVaCreateManagedWidget("sched_cmd" , labelWidgetClass , cpar ,
		XtNbox_type , XtCno_box , XtNlabel , gettext("Scheduling command: ") , NULL);

	cfg.X.sched_cmd = XtVaCreateManagedWidget("sched_cmd" , numberEntryWidgetClass , cpar ,
		XtNresizable , True , XtNvalue , cfg.reschedh , NULL);

	cpar = XtVaCreateManagedWidget("dummy_row" , rowWidgetClass , col , NULL);

	XtVaCreateManagedWidget("resch_l1" , labelWidgetClass , cpar ,
		XtNbox_type , XtCno_box , XtNlabel , gettext("Reschedule after ") , NULL);

	cfg.X.resched = XtVaCreateManagedWidget("resch_t" , numberEntryWidgetClass , cpar ,
		XtNresizable , True , XtNvalue , cfg.reschedh , NULL);

	XtVaCreateManagedWidget("resch_l2" , labelWidgetClass , cpar ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" hours") , NULL);
	
	XtVaSetValues(cfg.X.calendar , XtNtime , (XtPointer)cfg.time, NULL);
	XtVaSetValues(cfg.X.year , XtNvalue , cfg.time->tm_year , NULL);
	ComboSetIndex(cfg.X.month , cfg.time->tm_mon);

	XtVaSetValues(cfg.X.hour_label , XtNvalue , cfg.time->tm_hour , NULL);
	XtVaSetValues(cfg.X.min_label , XtNvalue , cfg.time->tm_min , NULL);

	cpar = XtVaCreateManagedWidget("cfg_brow" , rowWidgetClass , col , NULL);

	icona = X_XpmDataToIcon(cfg.X.dpy , schedule_xpm);

	but = XtVaCreateManagedWidget("but_ok" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNgravitation , XtCleft , 
		XtNlabel_justify , XtCcenter ,
		XtNicon_justify , XtCright ,
		XtNlabel , gettext("OK") ,
		XtNicon , icona , NULL);

	XtAddCallback(but , XtNactivate , Schedule , cfg.X.config_shell);

	but = XtVaCreateManagedWidget("but_cancel" , buttonWidgetClass , cpar , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Cancel") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , PopdownW , cfg.X.cfg_sch);

	if (popup) XtPopup(cfg.X.cfg_sch , XtGrabNone);
}

/*** LIMITS CFG ***/
static void build_config_lim(parent , popup)
Widget parent;
int popup;
{
	Widget col,cpar,but,pom,pom2,cb,pom3;
	static ListOpRec hosts;
	static ListOpRec domains;
	static ListOpRec sfx;
	static ListOpRec prefix;
	static ListOpRec mimet;
	char *blabels[6];
	int i,j;
	ListStruct plist;
	char **p;

	blabels[0] = gettext("Tree");
	blabels[1] = gettext("Hosts");
	blabels[2] = gettext("Documents");
	blabels[3] = gettext("MIME types");
	blabels[4] = gettext("Time");
	blabels[5] = gettext("HTML");

	if (cfg.X.cfg_limits)
	{
		if (popup) XtPopup(cfg.X.cfg_limits , XtGrabNone);
		return;
	}

	cfg.X.cfg_limits = XtVaCreatePopupShell("cfg_lim",
		topLevelShellWidgetClass , parent , 
		XtNtitle , gettext("Pavuk: Limits config") , NULL);
	
	col = XtVaCreateManagedWidget("cfg_col" , colWidgetClass ,
		cfg.X.cfg_limits , NULL);
	
	cb = XtVaCreateManagedWidget("card_box" ,cardBoxWidgetClass , col ,
		XtNbutton_labels , blabels , 
		XtNnumber_of_buttons , XtNumber(blabels),
		XtNresizable , True ,
		NULL);

	cpar = XtVaCreateManagedWidget("cfg_brow" , rowWidgetClass , col , NULL);

	but = XtVaCreateManagedWidget("but_ok" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("OK") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , DoConfig , cfg.X.cfg_limits);

	but = XtVaCreateManagedWidget("but_apply" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Apply") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , CfgLimits , cfg.X.cfg_limits);

	but = XtVaCreateManagedWidget("but_comm" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Common ...") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , PopupW , (XtPointer)PAVUK_CFGCOMM);

	but = XtVaCreateManagedWidget("but_cancel" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 , 
		XtNlabel , gettext("Cancel") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , PopdownW , cfg.X.cfg_limits);

/*** TREE ***/
	cpar = XtVaCreateManagedWidget("cfg_lim_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[0] , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar , 
			XtNresizable , True ,
			XtNbox_type , XtCno_box ,
			NULL);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,
			XtNresizable , False ,
			XtNbox_type , XtCno_box ,
			NULL);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom2 ,
			XtNresizable , True ,
			XtNbox_type , XtCno_box ,
			NULL);

	cfg.X.cgi_sw = XtVaCreateManagedWidget("cgi_switch" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Download cgi-generated pages") ,
		NULL);

	cfg.X.ftpd_sw = XtVaCreateManagedWidget("ftpdir_switch" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Recurse through FTP directory") ,
		NULL);

	cfg.X.robots_sw = XtVaCreateManagedWidget("robots_switch" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Allow \"robots.txt\"") ,
		NULL);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom2 ,
			XtNresizable , True ,
			XtNbox_type , XtCno_box ,
			NULL);

	cfg.X.leaves_sw = XtVaCreateManagedWidget("leave_site" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Don't leave starting site") ,
		NULL);

	cfg.X.leaved_sw = XtVaCreateManagedWidget("leave_dir" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Don't leave starting directory") ,
		NULL);

	cfg.X.ftp_html = XtVaCreateManagedWidget("ftp_html" , 
		checkButtonWidgetClass , pom3 , 
		XtNlabel , gettext("Process HTML files downloaded over FTP") ,
		NULL);


	cfg.X.maxdoc_label = num_entry(pom , gettext_nop("Max. count of documents: ") ,
				XtCno_box);

	cfg.X.maxlev_label = num_entry(pom , gettext_nop("Max. depth of tree: ") ,
				XtCno_box);

	cfg.X.min_size = num_entry(pom , gettext_nop("Min. document size: ") ,
				XtCno_box);
	
	cfg.X.maxsize_label = num_entry(pom , gettext_nop("Max. document size: ") ,
				XtCno_box);

	cfg.X.leave_level = num_entry(pom , 
			gettext_nop("Max. levels to leave from starting site: ") , XtCno_box);

	cfg.X.site_level = num_entry(pom , 
			gettext_nop("Max. site levels to leave from starting site: ") , XtCno_box);

	cfg.X.subdir_label = path_entry(pom , gettext("Working subdirectory: ") ,
				XtCno_box , True);

	cfg.X.en_uexit = str_entry(pom , gettext_nop("User condition script: ") ,
				XtCno_box);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,
			XtNresizable , True ,
			XtNbox_type , XtCframeout_box ,
			XtNlabel , "Widcard patterns" ,
			NULL);

	cfg.X.pattern_label = str_entry(pom3 , gettext_nop("Documents matching pattern: ") ,
				XtCno_box);

	XtVaCreateManagedWidget("skip" , labelWidgetClass , XtParent(cfg.X.pattern_label) ,
				XtNlabel , gettext("skip: ") ,
				XtNbox_type , XtCno_box ,
				NULL);
 
	cfg.X.skip_pattern = XtVaCreateManagedWidget("skip" , entryLineWidgetClass , 
				XtParent(cfg.X.pattern_label) , 
				XtNresizable , True ,
				NULL);

	cfg.X.url_pattern_label = str_entry(pom3 , gettext_nop("URL matching pattern: ") ,
				XtCno_box);

	XtVaCreateManagedWidget("skip" , labelWidgetClass , XtParent(cfg.X.url_pattern_label) ,
				XtNlabel , gettext("skip: ") ,
				XtNbox_type , XtCno_box ,
				NULL);
 
	cfg.X.skip_url_pattern = XtVaCreateManagedWidget("skip" , entryLineWidgetClass , 
				XtParent(cfg.X.url_pattern_label) , 
				XtNresizable , True ,
				NULL);

#ifdef HAVE_REGEX
	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,
			XtNresizable , True ,
			XtNbox_type , XtCframeout_box ,
			XtNlabel , "RE patterns" ,
			NULL);


	cfg.X.rpattern = str_entry(pom3 , gettext_nop("Documents matching pattern: ") ,
				XtCno_box);

	XtVaCreateManagedWidget("skip" , labelWidgetClass , XtParent(cfg.X.rpattern) ,
				XtNlabel , gettext("skip: ") ,
				XtNbox_type , XtCno_box ,
				NULL);
 
	cfg.X.skip_rpattern = XtVaCreateManagedWidget("skip" , entryLineWidgetClass , 
				XtParent(cfg.X.rpattern) , 
				XtNresizable , True ,
				NULL);

	cfg.X.url_rpattern = str_entry(pom3 , gettext_nop("URL matching pattern: ") ,
				XtCno_box);

	XtVaCreateManagedWidget("skip" , labelWidgetClass , XtParent(cfg.X.url_rpattern) ,
				XtNlabel , gettext("skip: ") ,
				XtNbox_type , XtCno_box ,
				NULL);
 
	cfg.X.url_skip_rpattern = XtVaCreateManagedWidget("skip" , entryLineWidgetClass , 
				XtParent(cfg.X.url_rpattern) , 
				XtNresizable , True ,
				NULL);
#endif

/*** HOSTS ***/
	cpar = XtVaCreateWidget("cfg_lim_row" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNresizable , True ,
		XtNassociated_button , blabels[1] , NULL);

	pom3 = XtVaCreateManagedWidget("prow" , rowWidgetClass , cpar ,
		XtNbox_width , 3 ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box , NULL);
	
	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom3 ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.hosts_sw = XtVaCreateManagedWidget("hosts_sw" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.allow_site ,
		XtNlabel , gettext("Allow / Disallow sites") ,
		NULL);

	cfg.X.hosts_list = GetListWidget(
		XtVaCreateManagedWidget("hosts_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));


	cfg.X.hosts_entry = str_entry(pom , gettext_nop("Site: ") , XtCup_box);

	hosts.listw = cfg.X.hosts_list;
	hosts.entryw = cfg.X.hosts_entry;

	XtAddCallback(cfg.X.hosts_entry , XtNactivate , AppendToList , &hosts);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &hosts);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.hosts_list);
/*** DOMAINS ***/
	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom3 ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.domain_sw = XtVaCreateManagedWidget("domain_sw" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.allow_domain ,
		XtNlabel , gettext("Allow / Disallow domains") ,
		NULL);

	cfg.X.domain_list = GetListWidget(
		XtVaCreateManagedWidget("domain_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	cfg.X.domain_entry = str_entry(pom , gettext_nop("Domain: ") , XtCup_box);

	domains.listw = cfg.X.domain_list;
	domains.entryw = cfg.X.domain_entry;

	XtAddCallback(cfg.X.domain_entry , XtNactivate , AppendToList , &domains);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &domains);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.domain_list);

#ifdef HAVE_REGEX
	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,
			XtNbox_type , XtCframeout_box ,
			XtNlabel , "IP address RE patterns" ,
			NULL);

	cfg.X.aip = str_entry(pom3 , gettext_nop("Server IP matching pattern: ") ,
				XtCno_box);

	XtVaCreateManagedWidget("skip" , labelWidgetClass , XtParent(cfg.X.aip) ,
				XtNlabel , gettext("skip: ") ,
				XtNbox_type , XtCno_box ,
				NULL);
 
	cfg.X.skipip = XtVaCreateManagedWidget("skip" , entryLineWidgetClass , 
				XtParent(cfg.X.aip) , 
				XtNresizable , True ,
				NULL);
#endif


/*** DOCUMENTS ***/
	cpar = XtVaCreateWidget("cfg_lim_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[2] , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.sufix_sw = XtVaCreateManagedWidget("_sfxswitch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.allow_sufix ,
		XtNlabel , gettext("Allow / Disallow suffix") ,
		NULL);

	cfg.X.sufixlist = GetListWidget(
		XtVaCreateManagedWidget("sufix_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	cfg.X.sufix_label = str_entry(pom , gettext_nop("Suffix: ") , XtCup_box);

	sfx.listw = cfg.X.sufixlist;
	sfx.entryw = cfg.X.sufix_label;

	XtAddCallback(cfg.X.sufix_label , XtNactivate , AppendToList , &sfx);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &sfx);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.sufixlist);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.prefix_sw = XtVaCreateManagedWidget("_pfxswitch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.allow_prefix ,
		XtNlabel , gettext("Allow / Disallow prefix") ,
		NULL);

	cfg.X.prefixlist = GetListWidget(
		XtVaCreateManagedWidget("prefix_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	cfg.X.prefix_label = str_entry(pom , gettext_nop("Prefix: ") , XtCup_box);

	prefix.listw = cfg.X.prefixlist;
	prefix.entryw = cfg.X.prefix_label;

	XtAddCallback(cfg.X.prefix_label , XtNactivate , AppendToList , &prefix);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &prefix);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.prefixlist);

/**** MIME Types ****/
	cpar = XtVaCreateWidget("cfg_mime_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNassociated_button , blabels[3] , NULL);

	pom = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNresizable , True , NULL);

	pom2 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.mime_sw = XtVaCreateManagedWidget("mime_sw" , 
		checkButtonWidgetClass , pom2 , 
		XtNon , cfg.condition.allow_mime ,
		XtNlabel , gettext("Allow / Disallow MIME type") ,
		NULL);

	cfg.X.amimelist = GetListWidget(
		XtVaCreateManagedWidget("amime_list" , scrollListWidgetClass , 
		pom2 , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	pom2 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCleft_arrow ,
		XtNlabel , gettext("Append") ,
		XtNtop_space , 50 ,
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCtop , NULL);

	XtAddCallback(but , XtNactivate , AppendToMIMEList , NULL);

	but = XtVaCreateManagedWidget("but_delete" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCright_arrow ,
		XtNbottom_space , 50 , 
		XtNlabel , gettext("Delete") ,
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCbottom , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList ,  cfg.X.amimelist);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.mimelist = GetListWidget(
		XtVaCreateManagedWidget("mime_list" , scrollListWidgetClass , 
		pom3 , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	plist.sensitive = True;
	plist.left_icon = NULL;
	plist.right_icon = NULL;
  	plist.related_info = NULL;

	p = mimetypes;
	ListChange(cfg.X.mimelist , NULL , 0 , True);
	if (p) while(*p)
	{
		plist.label = *p;
		ListAppendItems(cfg.X.mimelist , &plist , 1);
		p++;
	}

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,  NULL);

	XtVaCreateManagedWidget("mimet_label" , labelWidgetClass , pom2 ,
		XtNbox_type , XtCno_box ,
		XtNlabel ,  gettext("Other MIME type: ") ,
		NULL);

	cfg.X.mimet_entry = XtVaCreateManagedWidget("mimet_entry" , entryLineWidgetClass ,
		pom2 ,
		XtNresizable , True ,
		NULL);

	mimet.listw = cfg.X.amimelist;
	mimet.entryw = cfg.X.mimet_entry;

	XtAddCallback(cfg.X.mimet_entry , XtNactivate , AppendToList , &mimet);
	XtAddCallback(cfg.X.mimelist , XtNselect_cb , AppendToMIMEList , &mimet);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &mimet);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList ,  cfg.X.amimelist);

/**** TIME ****/
	pom2 = XtVaCreateWidget("cfg_time_row" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNassociated_button , blabels[4] , NULL);

	cpar = XtVaCreateManagedWidget("prow" , rowWidgetClass , pom2 ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box , NULL);

	pom = time_sel_new(cpar , &cfg.X.btime_cal , &cfg.X.btime_h_entry ,
		&cfg.X.btime_min_entry ,
		&cfg.X.btime_mon , &cfg.X.btime_yentry);

	XtVaSetValues(pom , XtNlabel , gettext("Lower document time limit") ,
		XtNbox_type , XtCframein_box , NULL);

	cfg.X.btime_sw = XtVaCreateManagedWidget("btime_sw" , checkButtonWidgetClass ,
			pom , XtNlabel , gettext("Check if doc. time newer than this") , NULL);

	pom = time_sel_new(cpar , &cfg.X.etime_cal , &cfg.X.etime_h_entry ,
		&cfg.X.etime_min_entry ,
		&cfg.X.etime_mon , &cfg.X.etime_yentry);

	XtVaSetValues(pom , XtNlabel , gettext("Upper document time limit") , 
		XtNbox_type , XtCframein_box , NULL);

	cfg.X.etime_sw = XtVaCreateManagedWidget("etime_sw" , checkButtonWidgetClass ,
			pom , XtNlabel , gettext("Check if doc. time older than this") , 
			NULL);

	cfg.X.max_time = num_entry(pom2 , 
			gettext_nop("Maximal allowed time of downloading: ") , XtCno_box);

/**** HTML ****/
	cpar = XtVaCreateWidget("cfg_html_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNassociated_button , blabels[5] , NULL);

	cfg.X.html_tags = XtVaCreateManagedWidget("html_tags" , multiColWidgetClass , cpar ,
		XtNlabel , gettext("Select allowed HTML tags and attributes") ,
		XtNresizable , True ,
		XtNbox_type , XtCframein_box ,
		NULL);

	for (i = 0 ; i < NUM_ELEM(linky) ; i++)
	{
		for(j = 0 ; linky[i].attribs[j].attrib ; j++)
		{
			if (!( linky[i].attribs[j].stat & LINK_STYLE))
			{
				char txt[100];

				sprintf(txt , gettext("%s of %s") ,
					linky[i].attribs[j].attrib , linky[i].tag);

				XtVaCreateManagedWidget("html_tags_sw" , 
					checkButtonWidgetClass , cfg.X.html_tags ,
					XtNlabel , new_string(txt) ,
					XtNuser_data , (XtPointer) &linky[i].attribs[j].stat ,
					NULL);
			}
		}
	}

	if (popup) XtPopup(cfg.X.cfg_limits , XtGrabNone);
}


static void ToggleRwHtml(widget , client_data , call_data)
Widget widget;
XtPointer call_data;
XtPointer client_data;
{
	int ison = FALSE;

	XtVaGetValues(widget , XtNon , &ison, NULL);

	XtSetSensitive((Widget)client_data , ison);
}

/*** COMMON CFG ***/
static void build_config_comm(parent , popup)
Widget parent;
int popup;
{
	Widget cl,label,col,cb,cpar,but,pom,pom2,prow,pcol,pom3,pom4,rg,entry;
	static ListOpRec urls;
	static ListOpRec alang;	
	static ListOpRec achs;	
	static ListOpRec domains;
	static ListOpRec advs;
	static ListStruct *lst = NULL;
#ifdef USE_SSL
	char *blabels[13];
#else
	char *blabels[12];
#endif
	ListStruct plist;
	char **p;
	int i;

	blabels[0] = gettext("URL");
	blabels[1] = gettext("Grabber I");
	blabels[2] = gettext("Grabber II");
	blabels[3] = gettext("Net");
	blabels[4] = gettext("Proxy");
	blabels[5] = gettext("Languages");
	blabels[6] = gettext("Character Sets");
	blabels[7] = gettext("Auth");
	blabels[8] = gettext("Log");
	blabels[9] = gettext("Cookies");
	blabels[10] = gettext("Filename");
	blabels[11] = gettext("Advertisement");
#ifdef USE_SSL
	blabels[12] = gettext("SSL");
#endif

	if (cfg.X.config_shell)
	{
		if (popup) XtPopup(cfg.X.config_shell , XtGrabNone);
		return;
	}

	cfg.X.config_shell = XtVaCreatePopupShell("cfg_shell",
		topLevelShellWidgetClass , parent , 
		XtNtitle , gettext("Pavuk: Common config") , NULL);
	
	col = XtVaCreateManagedWidget("cfg_col" , colWidgetClass ,
		cfg.X.config_shell , NULL);	

	cfg.X.cb_comcfg = cb = XtVaCreateManagedWidget("card_box" ,
		cardBoxWidgetClass , col ,
		XtNbutton_labels , blabels , 
		XtNnumber_of_buttons , XtNumber(blabels),
		XtNresizable , True ,
		NULL);

	cpar = XtVaCreateManagedWidget("cfg_brow" , rowWidgetClass , col , NULL);

	but = XtVaCreateManagedWidget("but_ok" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("OK") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , DoConfig , cfg.X.config_shell);

	but = XtVaCreateManagedWidget("but_apply" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Apply") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , CfgCommon , cfg.X.config_shell);

	but = XtVaCreateManagedWidget("but_lim" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Limitations ...") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , PopupW , (XtPointer)PAVUK_CFGLIM);

	but = XtVaCreateManagedWidget("but_cancel" , buttonWidgetClass , cpar , 
		XtNleft_space , 15 , 
		XtNlabel , gettext("Cancel") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , PopdownW , cfg.X.config_shell);

/**** URL CFG ****/
	cpar = XtVaCreateManagedWidget("cfg_grab_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[0] , NULL);

	prow  = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.url_list = GetListWidget(
		XtVaCreateManagedWidget("url_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 250 ,
		NULL));

	cfg.X.url_entry = str_entry(pom , gettext_nop("URL: ") , XtCup_box);

	urls.listw = cfg.X.url_list;
	urls.entryw = cfg.X.url_entry;

	XtAddCallback(cfg.X.url_entry , XtNactivate , AppendToList , &urls);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &urls);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.url_list);

/**** GRABBER I CFG ****/
	cpar = XtVaCreateWidget("cfg_grab_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[1] , NULL);

	prow  = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
			XtNresizable , True ,
			XtNbox_type , XtCno_box ,
			NULL);

	cfg.X.cdir_label = path_entry(pom , gettext_nop("Cache Directory: ") ,
			XtCno_box , TRUE);

#ifdef HAVE_DBOPEN
	cfg.X.ns_cache_dir = path_entry(pom , gettext_nop("Netscape browser cache directory: ") ,
			XtCno_box , TRUE);
#endif

	cfg.X.index_name = str_entry(pom , gettext_nop("Index file name: ") ,
			XtCno_box , TRUE);

	cfg.X.store_name = str_entry(pom , gettext_nop("Store file name: ") ,
			XtCno_box , TRUE);

	cfg.X.identity = str_entry(pom , gettext_nop("Identity string: ") ,
			XtCno_box , TRUE);

#ifdef WITH_TREE
	cfg.X.browser_label = str_entry(pom , gettext("Browser: ") ,  XtCno_box);
#endif
	cfg.X.remind_cmd = str_entry(pom , gettext("Reminder command: ") ,  XtCno_box);

	cfg.X.post_cmd = str_entry(pom , gettext("Post command: ") ,  XtCno_box);

	prow =	XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,
		XtNbox_type , XtCno_box , NULL);

	pcol = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
			XtNresizable , True ,
			XtNbox_type ,  XtCframein_box ,
			NULL);

	cfg.X.retry_label = num_entry(pcol , gettext_nop("How many times retry on fail: ") ,
			XtCno_box);

	cfg.X.redir_label = num_entry(pcol , gettext_nop("How many moved links to follow: ") ,
			XtCno_box);
			
	cfg.X.reget_label = num_entry(pcol , gettext_nop("How many times to reget file: ") ,
			XtCno_box);

	cfg.X.ddays_label = num_entry(pcol , gettext_nop("Document age before syncing with server: ") ,
			XtCno_box);

	cfg.X.sleep_label = num_entry(pcol , gettext_nop("Sleep time between transfers: ") ,
			XtCno_box);
		
	XtVaCreateManagedWidget("secd_label" , labelWidgetClass , XtParent(cfg.X.sleep_label) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" sec.") ,
		NULL);

	pcol = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
			XtNresizable , True ,
			XtNbox_type ,  XtCframein_box ,
			NULL);


	cfg.X.rollback_label = num_entry(pcol , gettext_nop("Rollback amount on reget: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("bytesd_label" , labelWidgetClass , XtParent(cfg.X.rollback_label) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" bytes") ,
		NULL);

	cfg.X.bufsize = num_entry(pcol , gettext_nop("Read buffer size: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("kbytesd_label" , labelWidgetClass , XtParent(cfg.X.bufsize) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" kB") ,
		NULL);


	cfg.X.trans_quota = num_entry(pcol , gettext_nop("Transfer quota: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("kbytesd_label" , labelWidgetClass , XtParent(cfg.X.trans_quota) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" kB") ,
		NULL);

	cfg.X.file_quota = num_entry(pcol , gettext_nop("File size quota: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("kbytesd_label" , labelWidgetClass , XtParent(cfg.X.file_quota) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" kB") ,
		NULL);

#ifdef HAVE_FSTATFS
	cfg.X.fs_quota = num_entry(pcol , gettext_nop("Filesystem freespace quota: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("kbytesd_label" , labelWidgetClass , XtParent(cfg.X.fs_quota) ,
		XtNbox_type , XtCno_box , XtNlabel , gettext(" kB") ,
		NULL);
#endif
/* * */
/**** GRABBER II CFG ****/
	cpar = XtVaCreateWidget("cfg_grab_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[2] , NULL);

	prow  = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,
		XtNresizable , True ,
		XtNbox_type , XtCno_box , NULL);

	pcol = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
			XtNresizable , True ,
			XtNbox_type , XtCframein_box ,
			NULL);

	cfg.X.freget_sw = XtVaCreateManagedWidget("freget_sw" ,
		checkButtonWidgetClass , pcol ,
		XtNlabel , gettext("Whole reget when partial not supported") ,
		NULL);

	cfg.X.enc_sw = XtVaCreateManagedWidget("enc_switch" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Use gzip encoding for transfer") ,
		NULL);

	cfg.X.oldrm_sw = XtVaCreateManagedWidget("oldrm_switch" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Remove improper documents") ,
		NULL);

	cfg.X.ptime = XtVaCreateManagedWidget("preserve_time" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Preserve document modification time") ,
		NULL);

	cfg.X.preserve_perm = XtVaCreateManagedWidget("preserve_perm" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Preserve FTP document permissions") ,
		NULL);

	cfg.X.preserve_links = XtVaCreateManagedWidget("preserve_links" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Preserve FTP symbolic links") ,
		NULL);

	cfg.X.check_size = XtVaCreateManagedWidget("check_size" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Check transferred size of document") ,
		NULL);

	cfg.X.store_index = XtVaCreateManagedWidget("store_index" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Store directory URLs as index files") ,
		NULL);

	cfg.X.enable_js = XtVaCreateManagedWidget("enable_js" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Download javascript script sources") ,
		NULL);

	cfg.X.enable_info = XtVaCreateManagedWidget("enable_info" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Store info files with each document") ,
		NULL);

	cfg.X.auto_referer = XtVaCreateManagedWidget("auto_referer" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Send self URL as Referer for starting URLs") ,
		NULL);

	cfg.X.send_if_range = XtVaCreateManagedWidget("send_if_range" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Send If-Range header field when regeting") ,
		NULL);

	cfg.X.show_time = XtVaCreateManagedWidget("show_time" , 
		checkButtonWidgetClass , pcol , 
		XtNlabel , gettext("Show time of start and end of downloading") ,
		NULL);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pcol ,
		XtNbox_type , XtCno_box ,
		XtNresizable , False , NULL);

	label = XtVaCreateManagedWidget("label" , labelWidgetClass , pom2 ,
		XtNlabel , gettext("URL scheduling strategy: ") ,
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.scheduling_strategie = XtVaCreateManagedWidget("strategie" , 
			comboWidgetClass , pom2 , 
			XtNresizable , True ,
			XtNeditable , False , NULL);

	cl = ComboGetListWidget(cfg.X.scheduling_strategie);
	
	if (lst)
	{
		for (i = 0 ; i < SSTRAT_LAST ; i++) _free(lst[i].label);
		_free(lst);
	}
	lst = (ListStruct *) _malloc(SSTRAT_LAST * sizeof(ListStruct));
	for (i = 0 ; i < SSTRAT_LAST; i++)
	{
		lst[i].label = new_string(gettext(get_strategie_label(i)));
		lst[i].index = 0;
		lst[i].left_icon = None;
		lst[i].right_icon = None;
		lst[i].sensitive = True;
		lst[i].related_info = NULL;
	}

	ListChange(cl , lst , SSTRAT_LAST , FALSE);

	pcol = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , prow ,
			XtNresizable , True ,
			XtNbox_type , XtCframein_box ,
			NULL);

	cfg.X.noreloc_sw = XtVaCreateManagedWidget("reloc_sw" ,
		checkButtonWidgetClass , pcol ,
		XtNlabel , gettext("Rewrite URLs inside HTML doc") ,
		NULL);

	rg = XtVaCreateManagedWidget("rg" , radioGroupWidgetClass , pcol , NULL);

	XtAddCallback(cfg.X.noreloc_sw , XtNswitch , ToggleRwHtml , rg);

	cfg.X.url_to_local = XtVaCreateManagedWidget("url_to_local" ,
		checkButtonWidgetClass , rg ,
		XtNlabel , gettext("Rewrite URLs to local when stored locally") ,
		NULL);

	cfg.X.sel_to_local = XtVaCreateManagedWidget("sel_to_local" ,
		checkButtonWidgetClass , rg ,
		XtNlabel , gettext("Rewrite all suitable URLs to local") ,
		NULL);

	cfg.X.all_to_local = XtVaCreateManagedWidget("all_to_local" ,
		checkButtonWidgetClass , rg ,
		XtNlabel , gettext("Rewrite all URLs to local immediately") ,
		NULL);

	cfg.X.all_to_remote = XtVaCreateManagedWidget("all_to_remote" ,
		checkButtonWidgetClass , rg ,
		XtNlabel , gettext("Rewrite all URLs to remote immediately") ,
		NULL);



/**** NET CFG ****/
	cpar = XtVaCreateWidget("cfg_net_col" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNassociated_button , blabels[3] , NULL);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNbox_type , XtCno_box ,
		XtNtop_space , 15 ,
		XtNresizable , True ,
		NULL);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom2 ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , False ,
		NULL);

	cfg.X.timeout_label = num_entry(pom3 , gettext_nop("Communication timeout: ") ,
			XtCno_box);

	XtVaCreateManagedWidget("mind_label" , labelWidgetClass , XtParent(cfg.X.timeout_label) ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(" min") ,
		NULL);

	cfg.X.maxrate = float_entry(pom3 , gettext_nop("Maximal transfer rate: ") ,
			XtCno_box , 3);

	XtVaCreateManagedWidget("kbsd_label" , labelWidgetClass , XtParent(cfg.X.maxrate) ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(" kB/s") ,
		NULL);

	cfg.X.minrate = float_entry(pom3 , gettext_nop("Minimal transfer rate: ") ,
			XtCno_box , 3);

	XtVaCreateManagedWidget("kbsd_label" , labelWidgetClass , XtParent(cfg.X.minrate) ,
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext(" kB/s") ,
		NULL);

	cfg.X.local_ip = str_entry(pom3 , gettext_nop("Local interface address: ") , XtCno_box);

	cfg.X.http_headers = str_entry(pom3 , gettext_nop("Additional HTTP headers: ") , XtCno_box);

	prow = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.ftp_list = XtVaCreateManagedWidget("ftplist" , 
		checkButtonWidgetClass , prow , 
		XtNon , cfg.ftp_list ,
		XtNlabel , gettext("Use wide listing of FTP directories") ,
		NULL);
	
	prow = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.use_http11 = XtVaCreateManagedWidget("http11" , 
		checkButtonWidgetClass , prow , 
		XtNon , cfg.use_http11 ,
		XtNlabel , gettext("Use HTTP/1.1 protocol for HTTP communication") ,
		NULL);
		
	pom = XtVaCreateManagedWidget("proto_col" , multiColWidgetClass , pom3 ,
		XtNresizable , False ,
		XtNbox_type , XtCframein_box ,
		XtNlabel , gettext("Allowed protocols") ,
		NULL);

	cfg.X.http_sw = XtVaCreateManagedWidget("http_switch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.http ,
		XtNlabel , gettext("HTTP") ,
		XtNresizable , True ,
		NULL);

#ifdef USE_SSL
	cfg.X.https_sw = XtVaCreateManagedWidget("https_switch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.https ,
		XtNlabel , gettext("HTTPS") ,
		NULL);

	cfg.X.ftps_sw = XtVaCreateManagedWidget("ftps_switch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.https ,
		XtNlabel , gettext("FTPS") ,
		NULL);
#endif

	cfg.X.ftp_sw = XtVaCreateManagedWidget("ftp_switch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.ftp ,
		XtNlabel , gettext("FTP") ,
		NULL);

	cfg.X.gopher_sw = XtVaCreateManagedWidget("gopher_switch" , 
		checkButtonWidgetClass , pom , 
		XtNon , cfg.condition.gopher ,
		XtNlabel , gettext("Gopher") ,
		NULL);

	cfg.X.ftp_data_sw = XtVaCreateManagedWidget("ftp_data_sw" , radioGroupWidgetClass ,
		pom3 , XtNbox_type , XtCframeout_box , XtNjustify , XtCleft , 
		XtNlabel , gettext("FTP data connection type ") , NULL);

	XtVaCreateManagedWidget("ftp_actived" , checkButtonWidgetClass , cfg.X.ftp_data_sw ,
		XtNon , cfg.ftp_activec , XtNid , 1 ,
		XtNlabel , gettext("Active") ,
		NULL);

	XtVaCreateManagedWidget("ftp_passived" , checkButtonWidgetClass , cfg.X.ftp_data_sw , 
		XtNon , !cfg.ftp_activec , XtNid , 0 ,
		XtNlabel , gettext("Passive") ,
		NULL);


/**** PROXY CFG ****/
	cpar = XtVaCreateWidget("cfg_proxy_col" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNassociated_button , blabels[4] , NULL);

	pom4 = pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNtop_space , 10 ,
		XtNbox_type , XtCno_box ,
		XtNhomogenous , TRUE ,
		NULL);

	pom3 = XtVaCreateManagedWidget("httpp_col" , colWidgetClass , pom2 ,  
		XtNbox_type , XtCframein_box ,
		XtNresizable , True ,
		XtNlabel , gettext("HTTP proxy") ,
		NULL);

	cfg.X.http_proxyh_label = str_entry(pom3 , gettext_nop("Host: ") , XtCno_box);

	cfg.X.http_proxyp_label = num_entry(pom3 ,  gettext_nop("Port: ") , XtCno_box);
	
#ifdef USE_SSL
	pom3 = XtVaCreateManagedWidget("sslp_col" , colWidgetClass , pom2 ,  
		XtNbox_type , XtCframein_box ,
		XtNresizable , True ,
		XtNlabel , gettext("SSL proxy") ,
		NULL);

	cfg.X.ssl_proxyh_label = str_entry(pom3 , gettext("Host: ") , XtCno_box);

	cfg.X.ssl_proxyp_label = num_entry(pom3 , gettext_nop("Port: ") , XtCno_box);
#endif
	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNtop_space , 10 ,
		XtNbox_type , XtCno_box ,
		XtNhomogenous , TRUE ,
		NULL);

	pom3 = XtVaCreateManagedWidget("gopherp_col" , colWidgetClass , pom2 ,  
		XtNbox_type , XtCframein_box ,
		XtNresizable , True ,
		XtNlabel , gettext("Gopher proxy") ,
		NULL);

	cfg.X.gopher_proxyh_label = str_entry(pom3 , gettext_nop("Host: ") , XtCno_box);

	cfg.X.gopher_proxyp_label = num_entry(pom3 , gettext_nop("Port: ") , XtCno_box);
	
	cfg.X.gopher_httpgw = XtVaCreateManagedWidget("gopher_httpgw_label" , 
		checkButtonWidgetClass , pom3 ,
		XtNon , cfg.gopher_via_http ,
		XtNlabel , gettext("Gopher via HTTP proxy") ,
		NULL);

	pom3 = XtVaCreateManagedWidget("ftpp_col" , colWidgetClass , pom2 ,  
		XtNbox_type , XtCframein_box ,
		XtNresizable , True ,
		XtNlabel , gettext("FTP proxy") ,
		NULL);

	cfg.X.ftp_proxyh_label = str_entry(pom3 , gettext_nop("Host: ") , XtCno_box);

	cfg.X.ftp_proxyp_label = num_entry(pom3 , gettext_nop("Port: ") , XtCno_box);

	cfg.X.ftp_httpgw = XtVaCreateManagedWidget("ftp_httpgw_label" , 
		checkButtonWidgetClass , pom3 ,
		XtNon , cfg.ftp_via_http ,
		XtNlabel , gettext("FTP via HTTP proxy") ,
		NULL);

	cfg.X.ftp_dirtyp = XtVaCreateManagedWidget("ftp_dirtyp_label" , 
		checkButtonWidgetClass , pom3 ,
		XtNon , cfg.ftp_dirtyp ,
		XtNlabel , gettext("FTP via HTTP tunneling proxy") ,
		NULL);

	cfg.X.cache_sw = XtVaCreateManagedWidget("cache_sw" , 
		checkButtonWidgetClass , cpar , 
		XtNon , cfg.cache ,
		XtNlabel , gettext("Allow caching of documents") ,
		NULL);


/**** LANGUAGES ****/
	cpar = XtVaCreateWidget("cfg_lang_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNassociated_button , blabels[5] , NULL);

	pom = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNtop_space , 15 ,
		XtNresizable , True , NULL);

	cfg.X.langlist = GetListWidget(
		XtVaCreateManagedWidget("lang_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	pom2 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCleft_arrow ,
		XtNlabel , gettext("Append") ,
		XtNtop_space , 50 ,
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCtop , NULL);

	XtAddCallback(but , XtNactivate , AppendToLangList , NULL);

	but = XtVaCreateManagedWidget("but_delete" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCright_arrow ,
		XtNlabel , gettext("Delete") ,
		XtNbottom_space , 50 , 
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCbottom , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.langlist);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.alanglist = GetListWidget(
		XtVaCreateManagedWidget("alang_list" , scrollListWidgetClass , 
		pom3 , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	plist.sensitive = True;
	plist.left_icon = NULL;
	plist.right_icon = NULL;
	plist.related_info = NULL;

	p = iso_lang;
	ListChange(cfg.X.alanglist , NULL , 0 , True);
	if (p) while(*p)
        {
        	plist.label = *p;
	  	ListAppendItems(cfg.X.alanglist , &plist , 1);
  		p++;
	}

	cfg.X.alang_entry = str_entry(pom3 , gettext_nop("Other lang. code: ") ,
			XtCup_box);

	alang.listw = cfg.X.langlist;
	alang.entryw = cfg.X.alang_entry;

	XtAddCallback(cfg.X.alang_entry , XtNactivate , AppendToList , &alang);
	XtAddCallback(cfg.X.alanglist , XtNselect_cb , AppendToLangList , &alang);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &alang);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.langlist);

/**** Character SET  ****/
	cpar = XtVaCreateWidget("cfg_chs_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNassociated_button , blabels[6] , NULL);

	pom = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , cpar ,  
		XtNtop_space , 15 ,
		XtNresizable , True , NULL);

	cfg.X.charset_list = GetListWidget(
		XtVaCreateManagedWidget("chs_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	pom2 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCleft_arrow ,
		XtNlabel , gettext("Append") ,
		XtNtop_space , 50 ,
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCtop , NULL);

	XtAddCallback(but , XtNactivate , AppendToChsetList , NULL);

	but = XtVaCreateManagedWidget("but_delete" , objButtonWidgetClass , pom2 , 
		XtNobj_type , XtCright_arrow ,
		XtNlabel , gettext("Delete") ,
		XtNbottom_space , 50 , 
		XtNwidth , 26 , XtNheight , 26 ,
		XtNgravitation , XtCbottom , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.charset_list);

	pom3 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True , NULL);

	cfg.X.acharset_list = GetListWidget(
		XtVaCreateManagedWidget("achs_list" , scrollListWidgetClass , 
		pom3 , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	plist.sensitive = True;
	plist.left_icon = NULL;
	plist.right_icon = NULL;
	plist.related_info = NULL;

	p =  char_sets;
	ListChange(cfg.X.acharset_list , NULL , 0 , True);
	if (p) while(*p)
        {
        	plist.label = *p;
	  	ListAppendItems(cfg.X.acharset_list , &plist , 1);
  		p++;
	}

	cfg.X.acharset_entry = str_entry(pom3 , gettext_nop("Other charset id: ") ,
			XtCup_box);

	achs.listw = cfg.X.charset_list;
	achs.entryw = cfg.X.acharset_entry;

	XtAddCallback(cfg.X.acharset_entry , XtNactivate , AppendToList , &achs);
	XtAddCallback(cfg.X.acharset_list , XtNselect_cb , AppendToChsetList , &achs);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom3 ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &achs);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.charset_list);

/**** AUTH CFG ****/
	cpar = XtVaCreateWidget("cfg_auth_col" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[7] , NULL);

	pom = XtVaCreateManagedWidget("authl_label" , rowWidgetClass , cpar ,
		XtNtop_space , 15 ,
		XtNbox_type , XtCframeout_box ,
		XtNlabel , gettext("HTTP user authentification") ,
		NULL);

	pom3 =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True ,
		NULL);

	cfg.X.auth_label = str_entry(pom3 , gettext_nop("Name: ") , XtCno_box);

	cfg.X.pass_label = str_entry(pom3 , gettext_nop("Password: ") , XtCno_box);
	XtVaSetValues(cfg.X.pass_label , XtNecho , False , NULL);

	cfg.X.auth_reuse_nonce = XtVaCreateManagedWidget("reuse_nonce" , checkButtonWidgetClass ,
		pom3 , XtNlabel , gettext("Reuse HTTP Digest access nonce") , NULL);

	cfg.X.auth_sw = XtVaCreateManagedWidget("auth_box" , radioGroupWidgetClass ,
		pom , XtNbox_type , XtCframeout_box , XtNjustify , XtCleft , 
		XtNlabel , gettext("Scheme") , NULL);

	XtVaCreateManagedWidget("auth_user" , checkButtonWidgetClass , cfg.X.auth_sw ,
		XtNon , (cfg.auth_scheme == 1) , XtNid , 1 ,
		XtNlabel , gettext("User auth. scheme") ,
		NULL);

	XtVaCreateManagedWidget("auth_base" , checkButtonWidgetClass , cfg.X.auth_sw , 
		XtNon , (cfg.auth_scheme == 2) , XtNid , 2 ,
		XtNlabel , gettext("Base auth. scheme") ,
		NULL);

	XtVaCreateManagedWidget("auth_digest" , checkButtonWidgetClass ,
		cfg.X.auth_sw , 
		XtNon , (cfg.auth_scheme == 3) , XtNid , 3 ,
		XtNlabel , gettext("Digest auth. scheme") ,
		NULL);

/*** HTTP proxy auth ***/
	pom = XtVaCreateManagedWidget("proxy_authl_label" , rowWidgetClass , cpar ,
		XtNbox_type , XtCframeout_box ,
		XtNlabel , gettext("HTTP proxy user authentification") ,
		NULL);

	pom3 =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True ,
		NULL);

	cfg.X.proxy_auth_label = str_entry(pom3 , gettext_nop("Name: ") , XtCno_box);

	cfg.X.proxy_pass_label = str_entry(pom3 , gettext_nop("Password: ") , XtCno_box);

	XtVaSetValues(cfg.X.proxy_pass_label , XtNecho , False , NULL);

	cfg.X.auth_reuse_proxy_nonce = XtVaCreateManagedWidget("proxy_reuse_nonce" , checkButtonWidgetClass ,
		pom3 , XtNlabel , gettext("Reuse HTTP Digest access nonce") ,NULL);

	cfg.X.proxy_auth_sw = XtVaCreateManagedWidget("proxy_auth_box" , radioGroupWidgetClass ,
		pom , XtNbox_type , XtCframeout_box , XtNjustify , XtCleft , 
		XtNlabel , gettext("Scheme") , NULL);

	XtVaCreateManagedWidget("proxy_auth_user" , checkButtonWidgetClass ,
		cfg.X.proxy_auth_sw ,
		XtNon , (cfg.proxy_auth_scheme == 1) , XtNid , 1 ,
		XtNlabel , gettext("User auth. scheme") ,
		NULL);

	XtVaCreateManagedWidget("proxy_auth_base" , checkButtonWidgetClass ,
		cfg.X.proxy_auth_sw , 
		XtNon , (cfg.proxy_auth_scheme == 2) , XtNid , 2 ,
		XtNlabel , gettext("Base auth. scheme") ,
		NULL);

	XtVaCreateManagedWidget("proxy_auth_digest" , checkButtonWidgetClass ,
		cfg.X.proxy_auth_sw , 
		XtNon , (cfg.proxy_auth_scheme == 3) , XtNid , 3 ,
		XtNlabel , gettext("Digest auth. scheme") ,
		NULL);

	cfg.X.auth_file_label = path_entry(cpar , gettext_nop("Auth info file: ") ,
		XtCno_box , False);

	cfg.X.send_from = XtVaCreateManagedWidget("send_from" , checkButtonWidgetClass ,
		cpar , XtNlabel , gettext("Send From: header with HTTP request") ,
		NULL);

	cfg.X.from_label = str_entry(cpar , gettext_nop("E-mail address: ") , XtCno_box);

/*** LOG ***/
	cpar = XtVaCreateWidget("cfg_log_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[8] , NULL);

	pom =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNbox_type , XtCno_box ,
		XtNresizable , True ,
		NULL);

	cfg.X.gen_logname = XtVaCreateManagedWidget("unique_log" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Try to find unique name, when original log file locked") ,
		NULL);

	cfg.X.log_label = path_entry(pom , gettext_nop("Log file: ") , 
		XtCno_box , False);

	cfg.X.slog_label = path_entry(pom , gettext_nop("Shortlog file: ") ,
		XtCno_box , False);

	cfg.X.xloglen_label = num_entry(pom , gettext_nop("Log window length: ") ,
			XtCno_box);

/**** COOKIES CFG ****/
	cpar = XtVaCreateWidget("cfg_cookies_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNassociated_button , blabels[9] , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,
		XtNbox_type , XtCno_box ,
		NULL);

	cfg.X.sw_cookie_update = XtVaCreateManagedWidget("sw_cookie_update" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Update cookies") ,
		NULL);

	cfg.X.sw_cookie_send = XtVaCreateManagedWidget("sw_cookie_send" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Send cookies") ,
		NULL);
		
	cfg.X.sw_cookie_recv = XtVaCreateManagedWidget("sw_cookie_recv" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Accept cookies") ,
		NULL);

	cfg.X.cookie_check_domain = XtVaCreateManagedWidget("sw_cookie_ch" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Check cookies domain") ,
		NULL);

	cfg.X.en_cookie_max = num_entry(pom ,  gettext_nop("Cookies maximal number: ") ,
			XtCno_box);

	cfg.X.en_cookie_file = path_entry(pom , gettext_nop("Cookie file: ") ,
			XtCno_box , False);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNbox_type , XtCno_box ,
		XtNlabel , gettext("Disabled cookie domains") ,
		XtNresizable , True , NULL);

	cfg.X.cookie_domain_list = GetListWidget(
		XtVaCreateManagedWidget("hosts_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	cfg.X.cookie_domain_entry = str_entry(pom , gettext_nop("Domain: ") ,
			XtCup_box);

	domains.listw = cfg.X.cookie_domain_list;
	domains.entryw = cfg.X.cookie_domain_entry;

	XtAddCallback(cfg.X.cookie_domain_entry , XtNactivate , AppendToList , &domains);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &domains);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.cookie_domain_list);


/**** FILENAME CFG ****/
	cpar = XtVaCreateWidget("cfg_filename_col" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNassociated_button , blabels[10] , NULL);

	pom =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNlabel , gettext("Local filename conversion rules") ,
		XtNbox_type , XtCframeout_box ,
		XtNresizable , True ,
		XtNtop_space , 5 ,
		NULL);

	pom2 = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNlabel , gettext("Replace String1 with String2 in filename") ,
		XtNbox_type , XtCframeout_box ,
		XtNtop_space , 10 ,
		NULL);

	cfg.X.tr_str_s1 = str_entry(pom2 , gettext_nop("String1: ") , XtCno_box);

	cfg.X.tr_str_s2 = str_entry(pom2 , gettext_nop("String2: ") , XtCno_box);

	pom2 =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNlabel , gettext("Delete characters from filename") ,
		XtNbox_type , XtCframeout_box ,
		XtNtop_space , 10 ,
		NULL);

	cfg.X.tr_del_chr = str_entry(pom2 , gettext_nop("Character set: ") , XtCno_box);

	pom2 =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , pom ,  
		XtNlabel , gettext("Replace characters from Set1 with characters from Set2 in filename") ,
		XtNbox_type , XtCframeout_box ,
		XtNtop_space , 10 ,
		NULL);

	cfg.X.tr_chr_s1 = str_entry(pom2 , gettext_nop("Character set1: ") , XtCno_box);

	cfg.X.tr_chr_s2 = str_entry(pom2 , gettext_nop("Character set2: ") , XtCno_box);


	cfg.X.base_level_label = num_entry(pom , gettext_nop("Base level of tree: ") ,
			XtCno_box);

	XtVaSetValues(XtParent(cfg.X.base_level_label) , XtNtop_space , 10 , NULL);

/**** ADVERT CFG ****/
	cpar = XtVaCreateWidget("cfg_advert_row" , rowWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 100 ,
		XtNwidth , 100 ,
		XtNassociated_button , blabels[11] , NULL);

	pom =  XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar ,  
		XtNbox_type , XtCframeout_box ,
		XtNresizable , False ,
		XtNtop_space , 5 ,
		NULL);

	cfg.X.remove_adv = XtVaCreateManagedWidget("sw_remove_adv" , 
		checkButtonWidgetClass , pom , 
		XtNlabel , gettext("Enable removing of advertisement banners") ,
		NULL);

	cfg.X.advert_res = GetListWidget(
		XtVaCreateManagedWidget("advert_list" , scrollListWidgetClass , 
		pom , XtNresizable , True ,
		XtNwidth , 200 ,
		NULL));

	entry = str_entry(pom , gettext_nop("RE for advertisement URLs: ") ,
			XtCup_box);

	advs.listw = cfg.X.advert_res;
	advs.entryw = entry;

	XtAddCallback(entry , XtNactivate , AppendToList , &advs);

	pom2 = XtVaCreateManagedWidget("dumy_row" , rowWidgetClass , pom ,  
		XtNbox_type , XtCno_box ,
		NULL);

	but = XtVaCreateManagedWidget("but_append" , buttonWidgetClass , pom2 , 
		XtNleft_space , 15 ,
		XtNlabel , gettext("Append") ,
		XtNgravitation , XtCleft , NULL);

	XtAddCallback(but , XtNactivate , AppendToList , &advs);

	but = XtVaCreateManagedWidget("but_delete" , buttonWidgetClass , pom2 , 
		XtNright_space , 15 , 
		XtNlabel , gettext("Delete") ,
		XtNgravitation , XtCright , NULL);

	XtAddCallback(but , XtNactivate , DeleteFromList , cfg.X.advert_res);

/*** SSL ***/
#ifdef USE_SSL
	cpar = XtVaCreateWidget("cfg_ssl_col" , colWidgetClass , cb ,
		XtNbox_width , 3 ,
		XtNbox_type , XtCno_box ,
		XtNheight , 10 ,
		XtNwidth , 10 ,
		XtNassociated_button , blabels[11] , NULL);

	pom = XtVaCreateManagedWidget("dumy_col" , colWidgetClass , cpar , 
		XtNlabel , gettext("SSL client certificate") ,
		XtNbox_type , XtCframeout_box ,
		NULL);

	cfg.X.ssl_cert_passwd_en = str_entry(pom , gettext_nop("Certificate password: ") ,
			XtCno_box);

	cfg.X.ssl_cert_file_en = path_entry(pom , gettext_nop("Certificate PEM file: ") ,
			XtCno_box , False);

	cfg.X.ssl_key_file_en = path_entry(pom , gettext_nop("Certificate key file: ") ,
			XtCno_box , False);

	cfg.X.ssl_cipher_list = str_entry(pom , gettext_nop("List of preffered ciphers: ") ,
			XtCno_box);

	cfg.X.ssl_version = XtVaCreateManagedWidget("sslver" , radioGroupWidgetClass ,
		pom , XtNbox_type , XtCframeout_box , XtNjustify , XtCleft , 
		XtNlabel , gettext("SSL protocol version") , NULL);

	XtVaCreateManagedWidget("sslv23" , checkButtonWidgetClass ,
		cfg.X.ssl_version ,
		XtNon , (cfg.ssl_version == 1) , XtNid , 1 ,
		XtNlabel , gettext("SSLv23") ,
		NULL);

	XtVaCreateManagedWidget("sslv2" , checkButtonWidgetClass ,
		cfg.X.ssl_version ,
		XtNon , (cfg.ssl_version == 2) , XtNid , 2 ,
		XtNlabel , gettext("SSLv2") ,
		NULL);

	XtVaCreateManagedWidget("sslv3" , checkButtonWidgetClass ,
		cfg.X.ssl_version ,
		XtNon , (cfg.ssl_version == 3) , XtNid , 3 ,
		XtNlabel , gettext("SSLv3") ,
		NULL);

	cfg.X.unique_sslid = XtVaCreateManagedWidget("unqsslid" , checkButtonWidgetClass ,
		pom , XtNlabel , gettext("Unique ID for all SSL sessions") ,
		NULL);
#endif

	if (popup) XtPopup(cfg.X.config_shell , XtGrabNone);
}

static Widget tb_button(parent , icn , label , help , grav , mnu)
Widget parent;
char **icn;
char *label;
char *help;
int grav;
int mnu;
{
	Icon *icona;
	Widget bt;

	icona = X_XpmDataToIcon(cfg.X.dpy , icn);

	bt = XtVaCreateManagedWidget("_tb_button_" , 
		mnu ? menuButtonWidgetClass : buttonWidgetClass , parent ,
		XtNicon , icona ,
		XtNgravitation , grav , 
		XtNlabel , gettext(label) , 
		XtNhelp_text , gettext(help) , NULL);

	return bt;
}

static void build_toolbar(parent)
Widget parent;
{
	Widget row;

	row =  XtVaCreateManagedWidget("tool_row" , rowWidgetClass , parent , 
			XtNbox_width , 0 ,
			XtNbox_type , XtCno_box , NULL);

	cfg.X.bt_cfg = tb_button(row , configure_xpm , gettext_nop("Config") ,
		 gettext_nop("Popup config window") , XtCleft , TRUE);

	XtVaSetValues(cfg.X.bt_cfg , XtNmenu_name , "menu_cfg" , NULL);

	cfg.X.bt_exit = tb_button(row , exit_xpm , gettext_nop("Exit") ,
		gettext_nop("Immediately quit the program") , XtCright , FALSE);

	XtAddCallback(cfg.X.bt_exit , XtNactivate , Quit , NULL);

	cfg.X.bt_break = tb_button(row , break_xpm , gettext_nop("Break") ,
		gettext_nop("Break transfer and stop") , XtCright , FALSE);
	
	XtAddCallback(cfg.X.bt_break , XtNactivate , Break , NULL);

	XtSetSensitive(cfg.X.bt_break , FALSE);

	cfg.X.bt_stop = tb_button(row , stop_xpm , gettext_nop("Stop") ,
		gettext_nop("Finish this transfer and stop") , XtCright , FALSE);

	XtAddCallback(cfg.X.bt_stop , XtNactivate , Stop , NULL);

	XtSetSensitive(cfg.X.bt_stop , FALSE);

	cfg.X.bt_start = tb_button(row , continue_xpm , gettext_nop("Continue") ,
		gettext_nop("Continue after stop or break") , XtCright , FALSE);

	XtSetSensitive(cfg.X.bt_start , FALSE);

	XtAddCallback(cfg.X.bt_start , XtNactivate , Start , (XtPointer)FALSE);

	cfg.X.bt_rest = tb_button(row , restart_xpm , gettext_nop("Restart") ,
		gettext_nop("Start working on currently set starting URLs") , XtCright , FALSE);
		
	XtAddCallback(cfg.X.bt_rest , XtNactivate , Start , (XtPointer)TRUE);

	cfg.X.bt_bg = tb_button(row , gobg_xpm , gettext_nop("Go bg") ,
		gettext("Destroy window as soon as posible and continue on terminal") , 
		XtCleft , FALSE);

	XtAddCallback(cfg.X.bt_bg , XtNactivate , Gobg , NULL);
}

void build_interface(argc,argv)
int *argc;
char **argv;
{
	char **p;
	int i;
	char pom[1024];
	
	p = (char **) malloc((XtNumber(resource) + 1) * sizeof(char *));

	for(i = 0 ; i < XtNumber(resource) ; i++) 
	{
		p[i] = resource[i];
	}

	if (cfg.fontname)
	{
		sprintf(pom , "*.Font: %s" , cfg.fontname);
		p[i - 2] = XtNewString(pom);
		p[i - 1] = NULL;
	}
	
	cfg.X.toplevel = XtVaAppInitialize (
		&cfg.X.app_context , "Pavuk", NULL, 0, argc, argv, p , NULL);

	XtFree((char *)p);
}

#define BUILD_SH(sh , build_fnc) \
	if (sh) \
	{\
		is_up = Xt_IsUp(sh);\
		XtVaGetValues(sh , XtNx , &x , XtNy , &y , NULL);\
		XtDestroyWidget(sh);\
		sh = NULL;\
		if (is_up)\
		{\
                        build_fnc(cfg.X.toplevel , TRUE);\
                        XtMoveWidget(sh , x , y);\
		}\
		else sh = NULL;\
		_Xt_Serve;\
	}

void iface_loop()
{
	Widget col , colm = NULL , swin;
	Position x = 0 , y = 0;
	bool is_up;
	int x_restart = 0;
	bool consens = FALSE;

	cfg.done = FALSE;
	cfg.log_autoscroll = TRUE;

#ifdef GETTEXT_NLS
	last_lang = new_string(cfg.language);

	if (!last_lang)
	{
		last_lang = new_string(getenv("LC_MESSAGES"));
	}

	if (!last_lang)
	{
		last_lang = new_string(getenv("LANG"));
	}
#endif

	cfg.X.about_shell = NULL;
	cfg.X.scn_load_shell = NULL;
	cfg.X.scn_save_shell = NULL;
	cfg.X.cfg_limits = NULL;
	cfg.X.config_shell = NULL;
	cfg.X.tree_shell = NULL;
	cfg.X.cfg_sch = NULL;

	cfg.X.dpy = XtDisplay(cfg.X.toplevel);

	_restart_iface = TRUE;

	while (_restart_iface)
	{
		if ((is_up = Xt_IsUp(cfg.X.toplevel)))
			XtVaGetValues(cfg.X.toplevel , XtNx , &x , XtNy , &y , NULL);

		if (colm)
		{
			consens = XtIsSensitive(cfg.X.bt_start);
			XtUnrealizeWidget(cfg.X.toplevel);
			XtDestroyWidget(colm);
		}

		colm = XtVaCreateManagedWidget("top_col" , colWidgetClass , cfg.X.toplevel , NULL);
		build_menu(colm);
		build_toolbar(colm);

		XtSetSensitive(cfg.X.bt_start , consens);
		XtSetSensitive(cfg.X.mea_start , consens);

		swin = XtVaCreateManagedWidget("swin" , scrollWinWidgetClass ,
			colm , XtNresizable , True , NULL);

		cfg.X.logw = XtVaCreateManagedWidget("log" , logWidgetClass ,
			swin , XtNmaxlines , cfg.xlogsize , 
			XtNresizable , True , XtNbottom_grav , True , NULL);

		col = XtVaCreateManagedWidget("dummy_row" , rowWidgetClass , colm , 
				XtNbox_width , 0 ,
				XtNbox_type , XtCno_box , NULL);

		cfg.X.what_widget = XtVaCreateManagedWidget("help_label" , labelWidgetClass , col , 
			XtNspacing , 2 ,
			XtNlabel , "  " ,
			XtNresizable , True , NULL);

		cfg.X.cnt_widget = XtVaCreateManagedWidget("cnt_label" , labelWidgetClass , col , 
			XtNspacing , 2 ,
			XtNlabel , "             " ,
			NULL);

		col = XtVaCreateManagedWidget("dummy_row" , rowWidgetClass , colm , 
				XtNbox_width , 0 ,
				XtNbox_type , XtCno_box , NULL);

		cfg.X.size_widget = XtVaCreateManagedWidget("size_label" , labelWidgetClass , col ,
			XtNspacing , 2 ,
			XtNlabel , "S:                                 " ,
			NULL);

		cfg.X.s_rate = XtVaCreateManagedWidget("rate_label" , labelWidgetClass , col ,
			XtNspacing , 2 ,
			XtNlabel , "R:             " ,
			NULL);

		cfg.X.s_etime = XtVaCreateManagedWidget("etime_label" , labelWidgetClass , col ,
			XtNspacing , 2 ,
			XtNlabel , "ET:          " ,
			NULL);

		cfg.X.s_rtime = XtVaCreateManagedWidget("rtime_label" , labelWidgetClass , col ,
			XtNspacing , 2 ,
			XtNlabel , "RT:          " ,
			NULL);

		icons_load();

		if (is_up) XtMoveWidget(cfg.X.toplevel , x , y);
		XtRealizeWidget(cfg.X.toplevel);

		BUILD_SH (cfg.X.about_shell , build_about);
		BUILD_SH (cfg.X.config_shell , build_config_comm);
		BUILD_SH (cfg.X.cfg_sch , build_config_sch);
		BUILD_SH (cfg.X.cfg_limits , build_config_lim);
		BUILD_SH (cfg.X.scn_load_shell , build_scenario_loader);
		BUILD_SH (cfg.X.scn_save_shell , build_scenario_saver);

		build_tree_preview(cfg.X.toplevel , cfg.X.tree_shell ?
				Xt_IsUp(cfg.X.tree_shell) : FALSE);

		if (cfg.X.config_shell) xset_cfg_values_comm();
		if (cfg.X.cfg_limits) xset_cfg_values_lim();

		_restart_iface = FALSE;

		cfg.done = TRUE;

		if (!x_restart && cfg.run_iface)
		{
			Start(NULL , (XtPointer)TRUE , NULL);
		}

		while (cfg.xi_face && !_restart_iface && !_go_bg)
		{
		        XEvent event;
		        XtAppNextEvent(cfg.X.app_context , &event);
			XtDispatchEvent(&event);
		}
		_Xt_Serve;
		x_restart++;
	}

	XtCloseDisplay(cfg.X.dpy);

	dns_server_kill();

	if (cfg.rbreak) return;

	cfg.xi_face = FALSE;

	if (cfg.mode != cfg.prev_mode || !cfg.mode_started)
	{	
		absi_restart();
	}
	else
	{
		absi_cont();
	}
}

void iface_set_counter(text)
char *text;
{
	LabelSetLabel(cfg.X.cnt_widget , text);
}

void iface_set_size(sz,rate,etime,rtime)
char *sz;
char *rate;
char *etime;
char *rtime;
{
	char pom[30];

	sprintf(pom , "S: %s" , sz);
	LabelSetLabel(cfg.X.size_widget , pom);
	sprintf(pom , "R: %s" , rate);
	LabelSetLabel(cfg.X.s_rate , pom);
	sprintf(pom , "ET: %s" , etime);
	LabelSetLabel(cfg.X.s_etime , pom);
	sprintf(pom , "RT: %s" , rtime);
	LabelSetLabel(cfg.X.s_rtime , pom);
}

void iface_set_what(text)
char *text;
{
	if (cfg.xi_face)
	{
		LabelSetLabel(cfg.X.what_widget , text);
		_Xt_Serve
	}
	else
	{
		DEBUG_USER(" - %s\n" , text);
	}
}


#ifdef WITH_TREE
TreeList * iface_make_tree_entry(urlp)
url *urlp;
{
	TreeList *retv;
	TreeListItem i_nfo;
	char *p;

	p = url_to_urlstr(urlp , FALSE);
	i_nfo.label = p;
	i_nfo.id = 0;

	if (urlp->status & URL_PROCESSED)
	{
		i_nfo.icon = urlp->tree_nfo[0]->item->icon;
	}
	else
	{
		i_nfo.icon = cfg.icon.notprocessed;
	}
	
	retv = TreeListInsertItem(
			cfg.X.tree_widget , 
			urlp->parent_url[urlp->ref_cnt-1] ? urlp->parent_url[urlp->ref_cnt-1]->tree_nfo[0] : cfg.X.root , 
			&i_nfo);

	free(p);
	retv->item->related_info = urlp;
	retv->managed = TRUE;

	return retv;
}
#endif


#endif /* X_FACE */
