/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _url_h_
#define _url_h_

#ifdef X_FACE
#include <X11/Intrinsic.h>
#include <Nws/TreeList.h>
#include "xinterface.h"
#endif

#ifdef GTK_FACE
#include "ginterface.h"
#endif

#include "tools.h"
#include "dllist.h"

typedef struct {
	char	*host;		/*** adresa HTTP servera ***/
	unsigned short	port;		/*** port HTTP servera ***/
	char	*document;	/*** referencovany dokument ***/
	char	*searchstr;	/*** request for cgi's ***/
	char	*anchor_name;	/*** identifikator fragmentu dokumentu ***/
	char	*user;
	char	*password;
} httpurl;

typedef struct {
	char	*host;		/*** adresa FTP servera ***/
	unsigned short	port;		/*** cislo portu FTP servera ***/
	char	*user;		/*** meno pouzivatela pre pristup na dany server ***/
	char	*password;	/*** heslo pre pristup na dany server ***/
	char	*path;		/*** cesta k FTP dokumentu ***/
	char	*anchor_name;	/*** fragment HTML dokumentu ***/
	bool	dir;		/*** je dokument FTP adresar ? ***/
} ftpurl;

typedef struct {
	char *filename;		/*** cesta k dokumentu ***/
	char *anchor_name;	/*** fragment HTML dokumentu ***/
} fileurl;

typedef struct {
	char	*host;		/*** adresa GOPHER servera ***/
	unsigned short	port;		/*** cislo portu GOPHER servera ***/
	char	type;		/*** typ dokumentu ***/
	char	*selector;	/*** selektor dokumentu ***/
} gopherurl;

typedef struct {
	char	*host;		/*** adresa NNTP servera ***/ 
	unsigned short	port ;		/*** cislo portu NNTP servera ***/
	char	*news_group ;	/*** diskusna skupina ***/
	char	*article;	/*** identifikator prispevku ***/
} newsurl;

typedef struct {
	char	*mailadr;	/*** e-mailova adresa ***/
} mailurl;

typedef enum { 		/*** id for URL types ***/
	URLT_UNKNOWN ,
	URLT_BROKEN ,
	URLT_HTTP , 
	URLT_HTTPS , 
	URLT_SHTTP ,
	URLT_FTP ,
	URLT_FTPS ,
	URLT_FILE , 
	URLT_GOPHER , 
	URLT_NEWS , 
	URLT_NNTP ,
	URLT_WAIS , 
	URLT_MAILTO , 
	URLT_TELNET ,
	URLT_RLOGIN ,
	URLT_TN3270 ,
	URLT_X500 ,
	URLT_WHOIS ,
	URLT_PROSPERO ,
	URLT_JAVASCRIPT ,
	URLT_URN ,
	URLT_LDAP ,
	URLT_Z39_50S ,
	URLT_Z39_50R ,
	URLT_CID ,
	URLT_CLSID ,
	URLT_FINGER ,
	URLT_HDL ,
	URLT_ILU ,
	URLT_IOR ,
	URLT_IRC ,
	URLT_JAVA ,
	URLT_LIFN ,
	URLT_MID ,
	URLT_PATH ,
	URLT_SERVICE ,
	URLT_SNEWS ,
	URLT_STANF ,
	URLT_SMS ,
	URLT_TEL ,
	URLT_FAX ,
	URLT_MODEM ,
} protocol;

#define URL_REDIRECT		(unsigned long) (1 << 0)
#define URL_INLINE_OBJ		(unsigned long) (1 << 1)
#define URL_PROCESSED		(unsigned long) (1 << 2)
#define URL_DOWNLOADED		(unsigned long) (1 << 3)
#define URL_ERR_UNREC		(unsigned long) (1 << 4)
#define URL_MOVED		(unsigned long) (1 << 5)
#define URL_REJECTED		(unsigned long) (1 << 6)
#define URL_USER_DISABLED	(unsigned long) (1 << 7)
#define URL_NOT_FOUND		(unsigned long) (1 << 8)
#define URL_TRUNCATED		(unsigned long) (1 << 9)
#define URL_ERR_REC		(unsigned long) (1 << 10)
#define URL_STYLE		(unsigned long) (1 << 11)
#define URL_INNSCACHE		(unsigned long) (1 << 12)
#define URL_ISHTML		(unsigned long) (1 << 13)
#define URL_ISLOCAL		(unsigned long) (1 << 14)
#define URL_NORECURSE		(unsigned long) (1 << 15)
#define URL_POST		(unsigned long) (1 << 16)

typedef struct _protinfo{
	protocol	id;
	char		*dirname;
	char		*urlid;
	char		*typestr;
	int		default_port;
	bool		supported;
}protinfo;

typedef struct {			/*** properties of document ***/
	char		*type;		/*** MIME type of document ***/
	int		size;		/*** size of document ***/
	time_t		mdtm;		/*** modification time ***/
} url_prop;

typedef	union {			/***  unifikacia reprezentacie jednotlivych URL ***/ 
	    httpurl	http;
	    fileurl	file;
	    ftpurl	ftp;
	    gopherurl	gopher;
	    newsurl	news;
	    mailurl	mail;
} abs_url;

typedef struct _url {
	protocol	type;		/*** typ daneho URL ***/
	struct _url	**parent_url;	/*** pointer to array of parent URLs ***/
	struct _url	*moved_to;	/*** pointer to new URL if document was moved ***/
	unsigned short	level;		/*** tree level of document ***/
	unsigned short	ref_cnt;	/*** number of references to this URL structure ***/
	unsigned long	status;		/*** status flags of URL ***/
#ifdef WITH_TREE
#ifdef I_FACE
	url_prop	*prop;		/*** document properties***/
	GUI_TREE_RTYPE	*tree_nfo;	/*** graphical representation of tree nodes ***/
#endif
#endif /* WITH_TREE */
	abs_url		p;		/*** parsed URL infos ***/
	char		*local_name;	/*** local filename ***/
	void		*extension;	/*** url extensions ***/
} url;

extern url *parse_url(char *);
extern char *url_to_absolute_url(char * , char * , url * , char *);
extern char * encode_url(char *);
extern char * encode_searchstr(char *);
extern char * decode_url(char *);
extern url * new_url(url *);
extern char * url_to_filename(url *, int);
extern void url_changed_filename(url *);
extern char * url_to_in_filename(url *);
extern void free_deep_url(url *);
extern char *get_redirect_abs_path(url * , char *);
extern char *url_to_urlstr(url* , int);
extern char *url_to_urlstr_woauth(url*, int);
extern void url_path_abs(url *);
extern url *filename_to_url(char *);
extern void append_url_to_list(url *);
extern void append_url_list_to_list(dllist *, dllist *);
extern char * url_get_site(url *);
extern int url_get_port(url *);
extern char * url_get_pass(url *, char *);
extern char * url_get_user(url *, char *);
extern int url_get_auth_scheme(url *, char *);
extern char * url_get_path(url *);
extern char * url_get_anchor_name(url *);
extern void url_clear_anchor(url *);
extern char * url_get_search_str(url *);
extern void url_set_path(url *, char *);
extern int url_is_dir_index(url *);
extern void url_add_to_hash_tab(url *);
extern void url_remove_from_hash_tab(url *);
extern url * url_was_befor(url *);
extern void replace_url_in_list(url *, int);
extern void link_url_in_list(url *,url *);
extern int url_redirect_to(url *, url*);
extern void url_forget_filename(url *);

extern protinfo prottable[42];

#endif
