/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <errno.h>
#include <ctype.h>

#include "config.h"
#include "http.h"
#include "ftp.h"
#include "gopher.h"
#include "url.h"
#include "html.h"
#include "tools.h"
#include "authinfo.h"
#include "tr.h"
#include "dinfo.h"

/* here can you specify characters,	*/
/* which are unsafe in file names	*/
#ifdef _WIN32
#define FS_UNSAFE_CHARACTERS "\\:*?\"<>|"
#endif

/* refers to RFC 1738 */
#define UNSAFE_CHARS " <>\"#%{}|\\^~[]`+!@=&()"
#define UNSAFE_SCHARS " <>\"#%{}|\\^~[]`!@()"
#define IS_UNSAFE(c) (strchr(UNSAFE_CHARS , c ) || ((unsigned char)c > 0x7f) || ((unsigned char)c < 0x20))
#define IS_SUNSAFE(c) (strchr(UNSAFE_SCHARS , c ) || ((unsigned char)c > 0x7f) || ((unsigned char)c < 0x20))


/* for hexadicimal encoding */
static char hexa[] = "0123456789ABCDEF";
#define HEXASC2HEXNR(x) (((x) >= '0' && (x) <= '9') ? \
	((x) - '0') : (toupper(x) - 'A' + 10))

#define HEX2CHAR(x) (HEXASC2HEXNR(*(x + 1)) << 4) + HEXASC2HEXNR(*(x + 2))

protinfo prottable[] = {
	{URLT_UNKNOWN , NULL , NULL , NULL , 0 , FALSE} ,
	{URLT_BROKEN , NULL , NULL , NULL , 0 , FALSE} ,
	{URLT_HTTP , "http" , "http" , "http://" , 80 , TRUE} ,
#ifdef USE_SSL
	{URLT_HTTPS , "https" , "https" , "https://" , 443 , TRUE} ,
#else
	{URLT_HTTPS , "https" , "https" , "https://" , 443 , FALSE} ,
#endif
	{URLT_SHTTP , "shttp" , "shttp" , "shttp://" , 0 , FALSE} ,
	{URLT_FTP , "ftp" , "ftp" , "ftp://" , 21 , TRUE} ,
#ifdef USE_SSL
	{URLT_FTPS , "ftps" , "ftps" , "ftps://" , 21 , TRUE} ,
#else
	{URLT_FTPS , "ftps" , "ftps" , "ftps://" , 21 , FALSE} ,
#endif
	{URLT_FILE , NULL , "file" , "file://" , 0 , TRUE} ,
	{URLT_GOPHER , "gopher" , "gopher" , "gopher://" , 70 , TRUE} ,
	{URLT_NEWS , "news" , "news" , "news:" , 119 , FALSE} ,
	{URLT_NNTP , "nntp" , "nntp" , "nntp://" , 119 , FALSE} ,
	{URLT_WAIS , NULL , "wais" , "wais://", 0 , FALSE} ,
	{URLT_MAILTO , NULL , "mailto" , "mailto:", 25 , FALSE} ,
	{URLT_TELNET , NULL , "telnet" , "telnet://" , 21 , FALSE} ,
	{URLT_RLOGIN , NULL , "rlogin" , "rlogin://" , 513 , FALSE} ,
	{URLT_TN3270 , NULL , "tn3270" , "tn3270://" , 0 , FALSE} ,
	{URLT_X500 , NULL , "x500" , "x500://" , 0 , FALSE} ,
	{URLT_WHOIS , NULL , "whois" , "whois://" , 0 , FALSE} ,
	{URLT_PROSPERO , NULL , "prospero" , "prospero://" , 0 , FALSE} ,
	{URLT_JAVASCRIPT , NULL , "javascript" , "javascript:" , 0 , FALSE} ,
	{URLT_URN , NULL , "urn" , "urn://" , 0 , FALSE} ,
	{URLT_LDAP , NULL , "ldap" , "ldap://" , 0 , FALSE} ,
	{URLT_Z39_50S , NULL , "z39_50s" , "z39_50s://" , 0 , FALSE} ,
	{URLT_Z39_50R , NULL , "z39_50r" , "z39_50r://" , 0 , FALSE} ,
	{URLT_CID , NULL , "cid" , "cid:" , 0 , FALSE} ,
	{URLT_CLSID , NULL , "clsid" , "clsid:" , FALSE} ,
	{URLT_FINGER , NULL , "finger" , "finger:" , FALSE} ,
	{URLT_HDL , NULL , "hdl" , "hdl:" , FALSE} ,
	{URLT_ILU , NULL , "ilu" , "ilu:" , FALSE} ,
	{URLT_IOR , NULL , "ior" , "ior:" , FALSE} ,
	{URLT_IRC , NULL , "irc" , "irc:" , FALSE} ,
	{URLT_JAVA , NULL , "java" , "java:" , FALSE} ,
	{URLT_LIFN , NULL , "lifn" , "lifn:" , FALSE} ,
	{URLT_MID , NULL , "mid" , "mid:" , FALSE} ,
	{URLT_PATH , NULL , "path" , "path:" , FALSE} ,
	{URLT_SERVICE , NULL , "service" , "service:" , FALSE} ,
	{URLT_SNEWS , NULL , "snews" , "snews:" , FALSE} ,
	{URLT_STANF , NULL , "stanf" , "stanf:" , FALSE} ,
	{URLT_SMS , NULL , "sms" , "sms:" , FALSE} ,
	{URLT_TEL , NULL , "tel" , "tel:" , FALSE} ,
	{URLT_FAX , NULL , "fax" , "fax:" , FALSE} ,
	{URLT_MODEM , NULL , "modem" , "modem:" , FALSE} ,
};


/***********************************/
/* analyza jednotlivych typov URL  */
/***********************************/
url *parse_url(_urlstr)
char *_urlstr;
{
	char *p , *p3 , *p4;
	char *p2;
	char *urlstr;
	url ret_url;
	int i;

	if (strchr(_urlstr,'%') || strstr(_urlstr, "&amp;") || strstr(_urlstr, "&#38;"))
		urlstr = decode_url(_urlstr);
	else
		urlstr = new_string(_urlstr);

	ret_url.type = URLT_UNKNOWN;
	ret_url.status = 0;
	ret_url.parent_url = NULL;
	ret_url.moved_to = NULL;
	ret_url.ref_cnt = 1;
	ret_url.level = 0;
	ret_url.extension = NULL;
	ret_url.local_name = NULL;

#ifdef WITH_TREE
#ifdef I_FACE
	ret_url.prop = NULL;
	ret_url.tree_nfo = NULL;
#endif
#endif
	p = strchr(urlstr, ':');
	p2 = strchr(urlstr , '/');
	p3 = strchr(urlstr , '?');

	if (!p ||
	    (p && p2 && p3 && p>p2 && p>p3) ||
	    (p && p2 && !p3 && p>p2) ||
	    (p && !p2 && p3 && p>p3))
	{
		p2 = new_string(urlstr);
		ret_url.type = URLT_FILE;
                ret_url.p.file.anchor_name = NULL;
                p = strchr(p2 , '#');
		if (p) {*p = '\0'; p++;}
                ret_url.p.file.filename = _strtrchr(new_string(p2) , '\\' , '/');
                if (p) ret_url.p.file.anchor_name = new_string(p);

                free(p2);
		free(urlstr);

		return new_url(&ret_url);
	}

	p2 = new_string(urlstr);
	p = strchr(p2 , ':');
	if (p) *p = '\0';

	lowerstr(p2);

	for( i = 0 ; i < NUM_ELEM(prottable) ; i++) 
	{
		if (prottable[i].urlid)
		{
			if (!strcmp(prottable[i].urlid , p2))
			{
				ret_url.type = i;
				break;
			}
		}
	}

	switch (i)
	{
	    case URLT_HTTP:
	    case URLT_HTTPS:
	    {
		ret_url.type = i;

		free(p2);

		/* check for separator */
		if (strncmp(urlstr + strlen(prottable[i].urlid) , "://" , 3) != 0)
		{
			ret_url.type = URLT_FILE;
			p2 = new_string(urlstr + strlen(prottable[i].urlid) + 1);
			p3 = strchr(p2, '#');
			if (p3) {*p3 = '\0'; p3++;}
			ret_url.p.file.filename = _strtrchr(new_string(p2) , '\\' , '/');
			if (p3)
			{
				ret_url.p.file.anchor_name = new_string(p3);
			}
			else
			{
				ret_url.p.file.anchor_name = NULL;
			}
			free(p2);
			free(urlstr);
			return new_url(&ret_url);
		}

		ret_url.p.http.password = NULL;
		ret_url.p.http.user = NULL;

		/* determine hostname */
		p2 = new_string(urlstr);
		
		p3 = strchr(p2 + strlen(prottable[i].typestr) , '/');
		if (p3) *p3 = '\0';

		p = p2 + strlen(prottable[i].typestr);
		p3 = strrchr(p,':');
		p4 = strchr(p,'@');
		if ((p4 && p3 && (p3 > p4)) || (p3 && !p4)) *p3 = '\0';
		ret_url.p.http.host = new_string(p);

		free(p2);

		/* determine port number */
		ret_url.p.http.port = prottable[i].default_port;

		if (*(urlstr + strlen(prottable[i].typestr) + strlen(ret_url.p.http.host)) == ':')
		{
			p2 =  new_string(urlstr);
			p = p2 + strlen(prottable[i].typestr) + 1 + strlen(ret_url.p.http.host);
			p3 = strchr(p , '/');
			if (p3) *p3 = '\0';

			if (*p)
			{
				ret_url.p.http.port = _atoi(p);
				if (errno == ERANGE)
				{
					ret_url.p.http.port = prottable[i].default_port;
				}
			}
			
			free(p2);
		}

		/* determine document path */
		ret_url.p.http.anchor_name = NULL;
		ret_url.p.http.document = NULL;
		ret_url.p.http.searchstr = NULL;
		p2 = new_string(urlstr);
		p = strchr(p2 + strlen(prottable[i].typestr) + strlen(ret_url.p.http.host) , '/');
		if (p)
		{
			char *sstr,*astr;

			sstr = strchr(p , '?');
			astr = strchr(p , '#');

			if (sstr && astr)
			{
				*sstr = '\0';
				*astr = '\0';
				ret_url.p.http.anchor_name = new_string(astr+1);
				ret_url.p.http.searchstr = new_string(sstr+1);
			}
			else if (astr)
			{
				*astr = '\0';
				ret_url.p.http.anchor_name = new_string(astr+1);
			}
			else if (sstr)
			{
				*sstr = '\0';
				ret_url.p.http.searchstr = new_string(sstr+1);
			}

			ret_url.p.http.document = get_abs_file_path(_strtrchr(p , '\\' , '/'));
			
		} else 	ret_url.p.http.document = new_string("/");

		if ((p3 = strrchr(ret_url.p.http.host,'@')))
		{
			p = ret_url.p.http.host;
			*p3 = '\0';
			ret_url.p.http.host = p3 ? new_string(p3+1) : NULL;

			if ((p3 = strchr(p , ':')))
			{
				ret_url.p.http.user = new_n_string(p , p3-p);
				ret_url.p.http.password = *(p3+1) ? new_string(p3+1) : NULL;
			}
			else
				ret_url.p.http.user = new_string(p);
			_free(p);
		}

		free(p2);
		free(urlstr);
		lowerstr(ret_url.p.http.host);

		return new_url(&ret_url);
	    }
	    break;	
	    case URLT_FILE:
	    {
		free(p2);	
		p2 = new_string(urlstr);

		ret_url.p.file.anchor_name = NULL;
		/* check for separator */
		if (strncmp(urlstr + 4 , "://" , 3) != 0)
		{
			p = strchr(p2,'#');
			if (p) {*p = '\0' ; p++;}
			ret_url.p.file.filename = _strtrchr(new_string(p2) , '\\' , '/');
			if (p) ret_url.p.file.anchor_name = new_string(p);

			free(p2);
			free(urlstr);
			return new_url(&ret_url);
		}
		p = strchr(p2,'#');
		if (p) {*p = '\0' ; p++;}
		ret_url.p.file.filename = _strtrchr(new_string(p2 + 7) , '\\' , '/');
		if (p) ret_url.p.file.anchor_name = new_string(p);

		free(p2);
		free(urlstr);

		return new_url(&ret_url);
	    }
	    break;
	    case URLT_FTP:
	    case URLT_FTPS:
	    {
	    	ret_url.p.ftp.dir = FALSE;
		ret_url.p.ftp.host = NULL;
		ret_url.p.ftp.password = NULL;
		ret_url.p.ftp.user = NULL;
		ret_url.p.ftp.path = NULL;
		ret_url.p.ftp.anchor_name = NULL;

		free(p2);

		/* check for separator */
		if (strncmp(urlstr + strlen(prottable[ret_url.type].urlid)  , "://" , 3) != 0)
		{
			ret_url.type = URLT_FILE;
			p2 = new_string(urlstr + strlen(prottable[ret_url.type].urlid)+1);
			p3 = strchr(p2,'#');
			if (p3) {*p3 = '\0'; p3++;}
			ret_url.p.file.filename =  new_string(_strtrchr(p2 , '\\', '/' ));
			if (p3)
			{
				ret_url.p.file.anchor_name = new_string(p3);
			}
			else
			{
				ret_url.p.file.anchor_name = NULL;
			}
			free(urlstr);
			free(p2);
			return new_url(&ret_url);
		}

		p3 = strchr(urlstr,';');
		if (p3) *p3 = '\0';

		/* determine hostname */
		p2 = new_string(urlstr);
		
		p = strchr(p2 + 3 + strlen(prottable[ret_url.type].urlid) , '/');
		if (p) *p = '\0';

		p = p2+3+strlen(prottable[ret_url.type].urlid);
		p3 = strrchr(p,':');
		p4 = strchr(p,'@');
		if ((p4 && p3 && (p3 > p4)) || (p3 && !p4)) *p3 = '\0';
		ret_url.p.ftp.host = new_string(p);	
		free(p2);

		/* determine port number */
		ret_url.p.ftp.port = prottable[i].default_port;
		if (p3)
		{
			p2 =  new_string(urlstr);
			p = strchr(p2 + 4 + strlen(prottable[ret_url.type].urlid) + strlen(ret_url.p.ftp.host) , '/');
			if (p) *p = '\0';
			p = strchr(p2 + 3 + strlen(prottable[ret_url.type].urlid) + strlen(ret_url.p.ftp.host) , ':');

			if (p)
			{
				ret_url.p.ftp.port = _atoi(p+1);
				if (errno == ERANGE)
				{
					ret_url.p.ftp.port = prottable[i].default_port;
				}
			}
			
			free(p2);
		}

		/* determine document path */
		ret_url.p.ftp.path = NULL;
		p2 = new_string(urlstr);
		p = strchr(p2 + 3 + strlen(prottable[ret_url.type].urlid) + strlen(ret_url.p.ftp.host) , '/');
		if (p)
		{
			p3 = strchr(p , '#');
			if (p3) *p3 = '\0';
			ret_url.p.ftp.anchor_name = p3 ? new_string(p3+1) : NULL;
			ret_url.p.ftp.path = get_abs_file_path(_strtrchr(p , '\\' , '/'));
			
		} else 	ret_url.p.ftp.path = new_string("/");

		free(urlstr);
		free(p2);

		if ((p3 = strrchr(ret_url.p.ftp.host,'@')))
		{
			p = ret_url.p.ftp.host;
			ret_url.p.ftp.host = new_string(p3+1);
			*p3 = '\0';

			if ((p3 = strchr(p , ':')))
			{
				*p3 = '\0';
				ret_url.p.ftp.user = new_string(p);
				ret_url.p.ftp.password = new_string(p3+1);
			}
			else 
				ret_url.p.ftp.user = new_string(p);

			_free(p);
		}
		ret_url.p.ftp.dir = tl_is_dirname(ret_url.p.ftp.path) != 0;

		lowerstr(ret_url.p.ftp.host);	

		return new_url(&ret_url);

	    }
	    break;
	    case URLT_GOPHER:
	    {
		int ilen;

		free(p2);
		ret_url.p.gopher.type = '1';
		ret_url.p.gopher.selector = NULL;
		ret_url.p.gopher.host = NULL;
		ret_url.p.gopher.port = DEFAULT_GOPHER_PORT;

		/* check for separator */
		if (strncmp(urlstr + 6 , "://" , 3) != 0)
		{
			ret_url.type = URLT_FILE;
			p2 = new_string(urlstr);
			p3 = strchr(p2,'#');
			if (p3) *p3 = '\0';
			ret_url.p.file.filename = new_string(p2);
			if (p3)
			{
				ret_url.p.file.anchor_name = new_string(p3+1);
			}
			else
			{
				ret_url.p.file.anchor_name = NULL;
			}
			free(p2);
			free(urlstr);
			return new_url(&ret_url);
		}

		/* determine hostname */
		ilen = strcspn(urlstr + 9 , ":/");
		ret_url.p.gopher.host = new_n_string(urlstr + 9 , ilen);

		/* determine port number */
		ret_url.p.gopher.port = prottable[i].default_port;
		if (*(urlstr + 9 + strlen(ret_url.p.gopher.host)) == ':')
		{
			p2 =  new_string(urlstr);
			p3 = strchr(p2 + 10 + strlen(ret_url.p.gopher.host) , '/');
			if (p3) *p3 = '\0';
			p = p2 + 10 + strlen(ret_url.p.gopher.host);

			ret_url.p.gopher.port = _atoi(p);
			if (errno == ERANGE)
			{
				ret_url.p.gopher.port = prottable[i].default_port;
			}
			
			free(p2);
		}
		/* determine type && selector */

		p2 = new_string(urlstr);
		p = strchr(p2 + 9 + strlen(ret_url.p.gopher.host) , '/');
		if (p)
		{
			if (*(p+1))
			{
				ret_url.p.gopher.type = *(p+1);
				ret_url.p.gopher.selector = new_string(p+2);
			}
			else
			{
				ret_url.p.gopher.type = '1';
			}
		}

		free(p2);
		free(urlstr);
		
		lowerstr(ret_url.p.gopher.host);
		if (ret_url.p.gopher.selector == NULL)
			ret_url.p.gopher.selector = new_string("");
		return new_url(&ret_url);

	    }
	    break;
	    case URLT_SHTTP:
	    case URLT_NEWS:
	    case URLT_NNTP:
	    case URLT_WAIS:
	    case URLT_WHOIS:
	    case URLT_MAILTO:
	    case URLT_PROSPERO:
	    case URLT_TELNET:
	    case URLT_TN3270:
	    case URLT_X500:
	    case URLT_RLOGIN:
	    case URLT_JAVASCRIPT:
	    case URLT_URN:
	    case URLT_LDAP:
	    case URLT_Z39_50R:
	    case URLT_Z39_50S:
	    case URLT_CID:
	    case URLT_CLSID:
	    case URLT_FINGER:
	    case URLT_HDL:
	    case URLT_ILU:
	    case URLT_IOR:
	    case URLT_IRC:
	    case URLT_JAVA:
	    case URLT_LIFN:
	    case URLT_MID:
	    case URLT_PATH:
	    case URLT_SERVICE:
	    case URLT_SNEWS:
	    case URLT_STANF:
	    case URLT_SMS:
	    case URLT_TEL:
	    case URLT_FAX:
	    case URLT_MODEM:
	    {
		free(p2);
	    }
	    break;
	    default:
	    {
		ret_url.type = URLT_UNKNOWN;
		free(p2);	
	    }
	}

	free(urlstr);
	return new_url(&ret_url);
}

/**** presmerovanie URL na absolutne ****/
char *url_to_absolute_url(base , baset , parent , act)
char *base;
char *baset;
url *parent;
char *act;
{
	char *psp = NULL;
	url *purl = parse_url(act);
	char *pom;

	pom = _malloc(strlen(url_to_filename(parent , TRUE)) + strlen(cfg.cache_dir) + strlen(baset) + strlen(act));

	if ((parent->type == URLT_GOPHER) &&
	    cfg.gopher_proxy && cfg.gopher_via_http &&
	    !(parent->status & URL_REDIRECT) &&
	    (!strncmp(act, "//", 2)))
	{
		sprintf(pom , "gopher:%s" , act);
		psp = new_string(pom);
	}
	else if (purl->type == URLT_FILE && 
		(parent->type == URLT_FILE))
	{
		if (!(*purl->p.file.filename))
		{
			strcpy(pom,baset);
		}
		else 
		{
			if (*(purl->p.file.filename) != '/')
			{
				strcpy(pom , base);
				strcat(pom , purl->p.file.filename);

				free(purl->p.file.filename);
				purl->p.file.filename = new_string(pom);						
			}
			else
				sprintf(pom , "%s%s" , 
					prottable[purl->type].typestr ,
					purl->p.file.filename);
		}
		psp = new_string(pom);
	}
	else if ((purl->type == URLT_FILE) && 
		 (cfg.base_level == 0 || cfg.enable_info) && 
		 (parent->status & URL_REDIRECT))
	{
		char *p1,*p;
		url *pomurl;

		if (*purl->p.file.filename == '/')
			strcpy(pom , purl->p.file.filename);
		else
		{
			p = url_to_filename(parent , TRUE);
			strcpy(pom , p);
			p1 = strrchr(pom , '/');
			if (p1) *(p1+1) = '\0';
			strcat(pom, purl->p.file.filename);
		}

		p = get_abs_file_path(pom);
		pomurl = filename_to_url(p);
		if (pomurl)
		{
			_free(p);
			psp = url_to_urlstr(pomurl , TRUE);
			free_deep_url(pomurl);
			_free(pomurl);
		}
	}
	if ((!psp && purl->type == URLT_FILE) && 
		(parent->type == URLT_HTTP ||
		 parent->type == URLT_HTTPS ||
		 parent->type == URLT_FTPS ||
		 parent->type == URLT_FTP))
	{
		char *ri;
		if (*(purl->p.file.filename) == '/')
		{
			char *idx;

			strcpy(pom , base);
			idx = strfindnchr(pom , '/' , 3);
			if (idx)
				strcpy(idx - 1 , purl->p.file.filename );
			else
				strcat(pom , purl->p.file.filename );
 
			if (purl->p.file.anchor_name)
			{
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
		}
		else if (!(*purl->p.file.filename))
		{
			if (purl->p.file.anchor_name)
			{
				strcpy(pom,baset);
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
			else
			{
				strcpy(pom,base);
			}
		}
		else
		{
			strcpy(pom , base);
			ri = strrchr(pom , '/');
			if (ri)
				strcpy(ri + 1 , purl->p.file.filename);
			else
				strcat(pom , purl->p.file.filename);

			if ((strlen(purl->p.file.filename) >= strlen(cfg.index_name)) &&
			    !strcmp(cfg.index_name , purl->p.file.filename + strlen(purl->p.file.filename) - strlen(cfg.index_name)))
			{
				*(pom + strlen(pom) - strlen(cfg.index_name)) = '\0';
			}

			if (purl->p.file.anchor_name)
			{
				strcat(pom , "#");
				strcat(pom , purl->p.file.anchor_name);
			}
		}
		psp = new_string(pom);
	}
	else if (!psp)
	{
		psp = new_string(act);	
	}

	free_deep_url(purl);
	_free(purl);

	if (psp)
	{
		purl = parse_url(psp);
		url_path_abs(purl);
		if (prottable[purl->type].supported)
		{
			free(psp);
			psp = url_to_urlstr(purl , TRUE);
		}
		free_deep_url(purl);
		_free(purl);		
	}

	_free(pom);

	return psp;
}

/**************************************/
/* zakodovanie znakov v URL , ktore   */
/* nie su bezpecne alebo povolene     */
/**************************************/
char * encode_url(urlstr)
char *urlstr;
{
	unsigned char *res,*p,*r;

	if (urlstr == NULL) return NULL;

	res = _malloc(strlen(urlstr) * 3 + 1);

	for (p = urlstr , r = res ; *p ; p++ , r++)
	{
		if (IS_UNSAFE(*p)) 
		{
			*r = '%';
			r++;
			*r = hexa[*p >> 4];
			r++;
			*r = hexa[*p % 16];
		}
		else
		{
			*r = *p;
		}
	}
	*r = '\0';

	return res;
}

/*********************************************/
/* zakodovanie znakov v search stringu URL   */
/*********************************************/
char * encode_searchstr(urlstr)
char *urlstr;
{
	unsigned char *res,*p,*r;

	if (urlstr == NULL) return NULL;

	res = _malloc(strlen(urlstr) * 3 + 1);

	for (p = urlstr , r = res ; *p ; p++ , r++)
	{
		if (IS_SUNSAFE(*p)) 
		{
			*r = '%';
			r++;
			*r = hexa[*p >> 4];
			r++;
			*r = hexa[*p % 16];
		}
		else
		{
			*r = *p;
		}
	}
	*r = '\0';

	return res;
}

/*****************************************/
/* dekodovanie zakodovanych znakov z URL */
/*****************************************/
char * decode_url(urlstr)
char *urlstr;
{
	char *res,*p,*r;

	if (urlstr == NULL) return NULL;

	res = new_string(urlstr);

	for (p = urlstr , r = res ; *p ; r++ , p++)
	{
		if (*p == '%' && *(p + 1) && *(p + 2) && 
			isxdigit(*(p + 1)) && isxdigit(*(p + 2)))
		{
			*r = HEX2CHAR(p);
			p += 2;
		}
		else if (*p == '&')
		{
			if (!strncmp(p + 1,"amp;" , 4) || !strncmp(p + 1, "#38;" , 4))
				p += 4;
			else
				*r = *p;
		}
		else
		{
			*r = *p;
		}
	}
	*r = '\0';
	return res;
}

/*************************************/
/* uvolnenie pamate po strukture URL */
/*************************************/
void free_deep_url(urlp)
url *urlp;
{
	switch(urlp->type)
	{
		case URLT_FILE:
			_free(urlp->p.file.filename);
			_free(urlp->p.file.anchor_name);
			break;
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlp->p.http.host);
			_free(urlp->p.http.document);
			_free(urlp->p.http.searchstr);
			_free(urlp->p.http.anchor_name);
			_free(urlp->p.http.password);
			_free(urlp->p.http.user);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlp->p.ftp.host);
			_free(urlp->p.ftp.user);
			_free(urlp->p.ftp.password);
			_free(urlp->p.ftp.anchor_name);
			_free(urlp->p.ftp.path);
			if (urlp->extension)
			{
				_free(((ftp_url_extension*)urlp->extension)->slink);
				_free(urlp->extension);
			}
			break;
		case URLT_GOPHER:
			_free(urlp->p.gopher.host);
			_free(urlp->p.gopher.selector);
		default:
			break;
	}

	_free(urlp->parent_url);
	_free(urlp->local_name);
	
#ifdef WITH_TREE
#ifdef I_FACE
	_free(urlp->tree_nfo);

	if (urlp->prop)
	{
		_free(urlp->prop->type);
		free(urlp->prop);
	}
#endif
#endif
}

void append_url_to_list(urlp)
url *urlp;
{
	if (!prottable[urlp->type].supported)
	{
		xprintf(1 , gettext("unsupported URL type \"%s\"\n") , 
			prottable[urlp->type].urlid ? prottable[urlp->type].urlid :
			gettext("unknown"));
		return;
	}

	urlp->ref_cnt = 1;

	cfg.urlstack = dllist_append(cfg.urlstack , urlp);
	cfg.total_cnt++;

	url_add_to_hash_tab(urlp);

	if (!urlp->parent_url)
	{
		urlp->parent_url = _malloc(sizeof(url *));
		urlp->parent_url[0] = NULL;
	}

#ifdef WITH_TREE
#ifdef I_FACE
	if (cfg.xi_face)
	{
		urlp->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
		urlp->tree_nfo[0] = iface_make_tree_entry(urlp);
	}
#endif
#endif
}

void append_url_list_to_list(list, after)
dllist *list;
dllist *after;
{
	dllist *ptr;

	ptr = list;
	while(ptr)
	{
		url *urlp = (url *)ptr->data;

		urlp->ref_cnt = 1;

		if (!urlp->parent_url)
		{
			urlp->parent_url = _malloc(sizeof(url *));
			urlp->parent_url[0] = NULL;
		}

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			urlp->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
			urlp->tree_nfo[0] = iface_make_tree_entry(urlp);
		}
#endif
#endif
		ptr = ptr->next;
	}
	if (after)
		cfg.urlstack = dllist_insert_list_after(cfg.urlstack , after , list);
	else
		cfg.urlstack = dllist_concat(cfg.urlstack , list);
}


void link_url_in_list(orig , copy)
url *orig;
url *copy;
{

	if (copy->parent_url && (orig != copy->parent_url[0]))
	{
		int i;
		bool found = FALSE;

		for (i = 0 ; i < orig->ref_cnt ; i++)
			if (orig->parent_url[i] == copy->parent_url[0]) found = TRUE;

		if (!found)
		{
			orig->ref_cnt ++;

			orig->parent_url = (url **)_realloc(orig->parent_url , (orig->ref_cnt + 1) * sizeof(url *));
			orig->parent_url[orig->ref_cnt - 1] = copy->parent_url[0];
			orig->parent_url[orig->ref_cnt] = NULL;

			if ((copy->parent_url[0]) && (orig->status & URL_MOVED) && (orig->status & URL_MOVED))
			{
				url *purl = orig;
				char *fn;

				while(purl->moved_to) purl = purl->moved_to;

				if (purl->status & URL_DOWNLOADED)
				{
					fn = url_to_filename(purl , TRUE);
					rewrite_one_parent_links(copy , copy->parent_url[0] , fn);
				}
			}
#ifdef WITH_TREE
#ifdef I_FACE
			if (cfg.xi_face)
			{
				orig->tree_nfo = (GUI_TREE_RTYPE*) _realloc(orig->tree_nfo , orig->ref_cnt *sizeof(GUI_TREE_RTYPE));
				orig->tree_nfo[orig->ref_cnt - 1] = iface_make_tree_entry(orig);
			}
#endif
#endif
		}
	}
}

int url_redirect_to(src , dst)
url *src;
url *dst;
{
	url *pomurl,*pomurl2;

	src->status |= URL_MOVED;

	url_clear_anchor(dst);
	if ((pomurl = url_was_befor(dst)))
	{
		free_deep_url(dst);
		_free(dst);
		pomurl2 = pomurl;
		while (pomurl2)
		{
			if (src == pomurl2) 
			{
				src->status &= ~URL_MOVED;
				return -1;
			}
			pomurl2 = pomurl2->moved_to;
		}

		pomurl->parent_url = _realloc(pomurl->parent_url , 
				(pomurl->ref_cnt + 2) * sizeof(url *));
		pomurl->parent_url[pomurl->ref_cnt] = src;
		pomurl->parent_url[pomurl->ref_cnt+1] = NULL;
		pomurl->ref_cnt ++;

		src->moved_to = pomurl;
		src->status |= URL_MOVED;

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			pomurl->tree_nfo = (GUI_TREE_RTYPE*) _realloc(pomurl->tree_nfo , 
					(pomurl->ref_cnt) * sizeof(GUI_TREE_RTYPE));
			pomurl->tree_nfo[pomurl->ref_cnt-1] = iface_make_tree_entry(pomurl);
		}
#endif
#endif
		if ((pomurl->status & URL_MOVED) || (pomurl->status & URL_DOWNLOADED))
		{
			url *purl = pomurl;
			char *fn;

			xprintf(1 , gettext("Moved to already processed URL.\n"));

			if (pomurl->status & URL_MOVED)
			{
				while(purl->moved_to) purl = purl->moved_to;
				fn = url_to_filename(purl , TRUE);
			}
			else
				fn = url_to_filename(pomurl , TRUE);

			if (cfg.rewrite_links && (purl->status & URL_DOWNLOADED))
				rewrite_parents_links(src , fn);

		}
		
	}
	else
	{
		dst->parent_url = _malloc(2 * sizeof(url *));
		dst->parent_url[0] = src;
		dst->parent_url[1] = NULL;
		src->moved_to = dst;
		src->status |= URL_MOVED;

		url_add_to_hash_tab(dst);

#ifdef WITH_TREE
#ifdef I_FACE
		if (cfg.xi_face)
		{
			dst->tree_nfo = (GUI_TREE_RTYPE*) _malloc(sizeof(GUI_TREE_RTYPE));
			dst->tree_nfo[0] = iface_make_tree_entry(dst);
		}
#endif
#endif
	}
	return 0;
}

void url_add_to_hash_tab(urlp)
url *urlp;
{
	url_clear_anchor(urlp);

	if (!prottable[urlp->type].supported) return;
	LOCK_CFG_URLHASH
	dlhash_insert(cfg.url_hash_tbl , urlp);
	dlhash_insert(cfg.fn_hash_tbl , urlp);
	UNLOCK_CFG_URLHASH
}

void url_remove_from_hash_tab(urlp)
url *urlp;
{
	if (!prottable[urlp->type].supported) return;

	LOCK_CFG_URLHASH
	dlhash_exclude(cfg.url_hash_tbl, urlp);
	dlhash_exclude(cfg.fn_hash_tbl, urlp);
	UNLOCK_CFG_URLHASH
}

/**********************************************/
/* kopirovanie obsahu na nove miesto v pamati */
/**********************************************/
url *new_url(urlo)
url *urlo;
{
	url *res = (url *)_malloc(sizeof(url));

	memcpy(res , urlo , sizeof(url));

	return res;
}

/**********************************************/
static char *url_get_local_name(urlp)
url *urlp;
{
	char *pom = NULL;
	char *pom2 = NULL;
	char *p1,*p2;
	char *p;
	int isdinfo = FALSE;
	struct stat estat;
	char pbuf[50];

	if (cfg.store_name && cfg.mode == MODE_SINGLE && 
	     !(urlp->status & URL_INLINE_OBJ) &&
	       urlp == ((url *)cfg.urlstack->data))
	{
		return get_abs_file_path(cfg.store_name);
	}

	sprintf(pbuf, "_%d" , url_get_port(urlp));

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			pom2 = tl_str_concat(pom2 ,
				prottable[urlp->type].dirname , "/" ,
				urlp->p.http.host , pbuf , "/" ,
				urlp->p.http.document , NULL);

			if (urlp->p.http.searchstr)
			{
				pom2 = tl_str_concat(pom2 , "?",
					urlp->p.http.searchstr, NULL);
			}
			if (tl_is_dirname(pom2))
				pom2 = tl_str_append(pom2, cfg.index_name);
			break;

		case URLT_FILE:
			pom = new_string(urlp->p.file.filename);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			pom2 = tl_str_concat(pom2,
				prottable[urlp->type].dirname , "/" ,
				urlp->p.ftp.host , pbuf , "/" ,
				urlp->p.ftp.path ,
				urlp->p.ftp.dir ? "/" : NULL ,
				cfg.index_name, NULL);
			break;
		case URLT_GOPHER:
			pbuf[strlen(pbuf) + 1] = '\0';
			pbuf[strlen(pbuf)] = urlp->p.gopher.type;
			pom2 = tl_str_concat(pom2,
				prottable[URLT_GOPHER].dirname , "/" ,
				urlp->p.gopher.host , pbuf ,
				urlp->p.gopher.selector ,
				(urlp->p.gopher.type == '1') ? cfg.index_name : NULL ,
				NULL);
			break;
		default:
			return NULL;
	}

	if (pom2)
	{
		char *trs;

		if (urlp->type != URLT_FILE)
		{
			trs = tr(urlp , pom2 , &isdinfo);
			_free(pom2);
			if (tl_is_dirname(trs))
				pom = tl_str_concat(pom , cfg.cache_dir ,
					(*trs == '/' ? "" : "/") , trs,
					cfg.index_name, NULL);
			else
				pom = tl_str_concat(pom , cfg.cache_dir ,
					(*trs == '/' ? "" : "/") , trs, NULL);
			_free(trs);
		}
		else
		{
			pom = pom2;
			pom2 = NULL;
		}
	}

#ifdef FS_UNSAFE_CHARACTERS
	/* This is for automatic handling of windoze	*/
	/* filesystem unsafe characters	- \:*?"<>|	*/
	if (urlp->type != URLT_FILE && strlen(pom) != strcspn(pom , FS_UNSAFE_CHARACTERS))
	{
		if (strchr(FS_UNSAFE_CHARACTERS, '_'))
			p = tr_del_chr(pom , FS_UNSAFE_CHARACTERS);
		else
			p = tr_chr_chr(pom , FS_UNSAFE_CHARACTERS , '_');
		_free(pom);
		pom = p;
	}
#endif

	/* adjusting of filename size if required	 */
	if (urlp->type != URLT_FILE && tl_filename_needs_adjust(pom))
	{
		p = tl_adjust_filename(pom);
		_free(pom);
		pom = p;
	}

	if (!stat(pom , &estat) && S_ISDIR(estat.st_mode))
        {
                pom = tl_str_concat(pom , "/" , cfg.index_name, NULL);
        }

	if ((urlp->type != URLT_FILE) && cfg.base_level && !isdinfo)
	{
		p = get_abs_file_path(pom);
		_free(pom);
		pom = p;
		p1 = pom + strlen(cfg.cache_dir) + 
			(tl_is_dirname(cfg.cache_dir) == 0);

		if (!(p2 = strfindnchr(p1 , '/' , cfg.base_level)))
		{
			if ((p2 = strrchr(pom , '/'))) p2 ++;
		}

		if (p2)
			memmove(p1 , p2 , strlen(p2) + 1);
	}

	/* this is here for ensure, that we	*/
	/* don't have directory as filename :-)	*/
	if (tl_is_dirname(pom))
		pom = tl_str_append(pom , cfg.index_name);

	p = get_abs_file_path(pom);
	_free(pom);

	return p;
}

/******************************************************/
/* k danemu URL vytvori meno suboru v lokalnom strome */
/******************************************************/
char *url_to_filename(urlp, lockfn)
url *urlp;
int lockfn;
{
	char *p;

	LOCK_GETLFNAME
	if (!urlp->local_name && prottable[urlp->type].supported)
	{
		p = url_get_local_name(urlp);
		if (cfg.enable_info  && urlp->type != URLT_FILE &&
                	!(urlp->status & URL_REDIRECT))
		{
			char *di = dinfo_get_unique_name(urlp , p , lockfn);
			if (di)
			{
				_free(p);
				p = di;
			}
		}
		else if (!cfg.enable_info && 
			urlp->type != URLT_FILE && !(urlp->status & URL_REDIRECT))
		{
			/*** such filename have already other URL   ***/
			/*** we need to compute new unique filename ***/
			char *f;
			char *pom;
			int i;
			void *inhash;

			LOCK_CFG_URLHASH
			inhash = dlhash_find_by_key(cfg.fn_hash_tbl , p);
			UNLOCK_CFG_URLHASH
			if (inhash)
			{
				pom = _malloc(strlen(p) + 6);

				f = strrchr(p , '/');
				if (!f) f = "";
				else
				{
					*f='\0';
					f++;
				}

				i = 0;
				do
				{
					i++;
					sprintf(pom , "%s/%03d%s" , p , i , f);
					LOCK_CFG_URLHASH
					inhash = dlhash_find_by_key(cfg.fn_hash_tbl , pom);
					UNLOCK_CFG_URLHASH
				} while (inhash);

				_free(p);
				p = pom;
			}
		}
		urlp->local_name = p;
	}
	UNLOCK_GETLFNAME
	return urlp->local_name;
}

/******************************************************/
/* k danemu URL vytvori meno suboru v lokalnom strome */
/******************************************************/
void url_changed_filename(urlp)
url *urlp;
{
	_free(urlp->local_name);
	urlp->local_name = url_get_local_name(urlp);
}

/****************************************************************/
/* k danemu URL vytvori meno docasneho suboru v lokalnom strome */
/****************************************************************/
char *url_to_in_filename(urlp)
url *urlp;
{
	char *pom;
	char *p;

	if (cfg.mode == MODE_NOSTORE || cfg.mode == MODE_FTPDIR)
	{
		pom = _malloc(strlen(cfg.cache_dir) + 25);
		sprintf(pom , "%s/.in_pavuk_nostore_%d" , cfg.cache_dir ,
			getpid());
		return pom;
	}

	p = url_to_filename(urlp , TRUE);

	pom = _malloc(strlen(p) + 5);
	strcpy(pom , p);
	p = strrchr(pom , '/');
	if (!p) p = pom;
	else p++;
	memmove(p + 4 , p , strlen(p) + 1);
	strncpy(p, ".in_" , 4);
		
	return pom;
}

/************************************************/
/* zo struktury URL vytvori retazec URL + hesla */
/************************************************/
char *url_to_urlstr(urlp , wa)
url *urlp;
int wa;
{
	char *p;
	char portstr[10];
	char *retv;

	sprintf(portstr , ":%d" ,  url_get_port(urlp));
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(urlp->p.http.user ? strlen(urlp->p.http.user)+1 : 0) +
				(urlp->p.http.password ? strlen(urlp->p.http.password)+1 : 0) +
				strlen(urlp->p.http.host) +
				(urlp->p.http.port == prottable[urlp->type].default_port ? 0 : strlen(portstr) + 1) +
				strlen(urlp->p.http.document) +
				(urlp->p.http.searchstr ? strlen(urlp->p.http.searchstr)+1 : 0) +
				(urlp->p.http.anchor_name ? strlen(urlp->p.http.anchor_name)+1 : 0) + 1);
				

			sprintf(retv ,"%s%s%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				urlp->p.http.user ? urlp->p.http.user : "" ,
				urlp->p.http.password ? ":" : "" ,
				urlp->p.http.password ? urlp->p.http.password : "" ,					
				(urlp->p.http.password || urlp->p.http.user) ? "@" : "" ,
				urlp->p.http.host , 
				(urlp->p.http.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.http.document ,
				urlp->p.http.searchstr ? "?" : "" ,
				urlp->p.http.searchstr ? urlp->p.http.searchstr : "" ,
				wa && urlp->p.http.anchor_name ? "#" : "" ,
				wa && urlp->p.http.anchor_name ? urlp->p.http.anchor_name : "");

			return retv;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			retv = _malloc(strlen(prottable[URLT_FILE].typestr) +
				strlen(p) +
				((wa && urlp->p.file.anchor_name) ? strlen(urlp->p.file.anchor_name) + 1 : 0) + 1);

			if (wa && urlp->p.file.anchor_name)
				sprintf(retv ,"%s%s#%s", prottable[URLT_FILE].typestr , p ,
					urlp->p.file.anchor_name);
			else
				sprintf(retv ,"%s%s", prottable[URLT_FILE].typestr , p);
			free(p);

			return retv;
		case URLT_FTP:
		case URLT_FTPS:
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(urlp->p.ftp.user ? strlen(urlp->p.ftp.user)+1 : 0) +
				(urlp->p.ftp.password ? strlen(urlp->p.ftp.password)+1 : 0) +
				strlen(urlp->p.ftp.host) +
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? 0 : strlen(portstr)+1) +
				strlen(urlp->p.ftp.path) +
				(urlp->p.ftp.anchor_name ? strlen(urlp->p.ftp.anchor_name)+1 : 0) + 1);

			sprintf(retv , "%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				urlp->p.ftp.user ? urlp->p.ftp.user : "" ,
				urlp->p.ftp.password ? ":" : "" ,
				urlp->p.ftp.password ? urlp->p.ftp.password : "" ,					
				(urlp->p.ftp.password || urlp->p.ftp.user) ? "@" : "" ,
				urlp->p.ftp.host , 
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.ftp.path ,
				wa && urlp->p.ftp.anchor_name ? "#" : "" ,
				wa && urlp->p.ftp.anchor_name ? urlp->p.ftp.anchor_name : "");

			return retv;
		case URLT_GOPHER:
			retv = _malloc(strlen(prottable[URLT_GOPHER].typestr) +
				strlen(urlp->p.gopher.host) +
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? 0 : strlen(portstr)+1) +
				strlen(urlp->p.gopher.selector) + 2);
				

			sprintf(retv , "%s%s%s/%c%s" , prottable[URLT_GOPHER].typestr ,
				urlp->p.gopher.host ,
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.gopher.type , urlp->p.gopher.selector);
	
			return retv;
		default:
			return NULL;
	}
}


/****************************************************/
/* zo struktury URL vytvori retazec URL - bez hesla */
/****************************************************/
char *url_to_urlstr_woauth(urlp, with_auth)
url *urlp;
int with_auth;
{
	char *p,*p2,*unam = NULL,*pass = NULL;
	char *retv;
	char portstr[10];

	sprintf(portstr , ":%d" ,  url_get_port(urlp));
	
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			p = encode_url(urlp->p.http.document);
			p2 = urlp->p.http.searchstr ? encode_searchstr(urlp->p.http.searchstr) : NULL;
			if (with_auth)
			{
				pass = urlp->p.http.password ? encode_url(urlp->p.http.password) : NULL;
				unam = urlp->p.http.user ? encode_url(urlp->p.http.password) : NULL;
			}
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(unam ? strlen(unam) + 1 : 0) +
				(pass ? strlen(pass) + 1 : 0) +
				strlen(urlp->p.http.host) +
				(urlp->p.http.port == prottable[urlp->type].default_port ? 0 : 1 + strlen(portstr)) +
				strlen(p) +
				(p2 ? strlen(p2) + 1 : 0) + 
				(urlp->p.http.anchor_name ? strlen(urlp->p.http.anchor_name) + 1 : 0) + 1);

			sprintf(retv ,"%s%s%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				unam ? unam : "" ,
				pass ? ":" : "" ,
				pass ? pass : "" ,
				(pass || unam) ? "@" : "" ,
				urlp->p.http.host ,
 				(urlp->p.http.port == prottable[urlp->type].default_port ? "" : portstr) ,
				p ,
				p2 ? "?" : "" ,
				p2 ? p2 : "" ,
				urlp->p.http.anchor_name ? "#" : "" ,
				urlp->p.http.anchor_name ? urlp->p.http.anchor_name : "");
			_free(p);
			_free(p2);
			_free(pass);
			_free(unam);
			return retv;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				strlen(p) + 
				(urlp->p.file.anchor_name ? strlen(urlp->p.file.anchor_name) + 1 : 0) + 1);

			if (urlp->p.file.anchor_name)
				sprintf(retv ,"%s%s#%s", prottable[URLT_FILE].typestr , p ,
					urlp->p.file.anchor_name);
			else
				sprintf(retv ,"%s%s", prottable[URLT_FILE].typestr , p);
			_free(p);

			return retv;
		case URLT_FTP:
		case URLT_FTPS:
			p = encode_url(urlp->p.ftp.path);
			if (with_auth)
			{
				pass = urlp->p.ftp.password ? encode_url(urlp->p.ftp.password) : NULL;
				unam = urlp->p.ftp.user ? encode_url(urlp->p.ftp.user) : NULL;
			}
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				(pass ? strlen(pass) + 1 : 0) +
				(unam ? strlen(unam) + 1 : 0) +
				strlen(urlp->p.ftp.host) +
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? 0 : 1 + strlen(portstr)) +
				strlen(p) +
				(urlp->p.ftp.anchor_name ? strlen(urlp->p.ftp.anchor_name) + 1 : 0) + 1);

			sprintf(retv , "%s%s%s%s%s%s%s%s%s%s", prottable[urlp->type].typestr ,
				unam ? unam : "" ,
				pass ? ":" : "" ,
				pass ? pass : "" ,
				(pass || unam) ? "@" : "" ,
				urlp->p.ftp.host , 
				(urlp->p.ftp.port == prottable[urlp->type].default_port ? "" : portstr) , 
				p ,
				urlp->p.ftp.anchor_name ? "#" : "" ,
				urlp->p.ftp.anchor_name ? urlp->p.ftp.anchor_name : "");
			_free(p);
			_free(pass);
			_free(unam);
			return retv;
		case URLT_GOPHER:
			p = encode_url(urlp->p.gopher.selector);
			retv = _malloc(strlen(prottable[urlp->type].typestr) +
				strlen(urlp->p.gopher.host) +
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? 0 : strlen(portstr) + 1) +
				+ strlen(p) + 2);
			sprintf(retv , "%s%s%s/%c%s" , prottable[urlp->type].typestr ,
				urlp->p.gopher.host ,
				(urlp->p.gopher.port == prottable[urlp->type].default_port ? "" : portstr) ,
				urlp->p.gopher.type , p);
			_free(p);
			return retv;
		default:
			return NULL;
	}
}


/********************************************************/
/* z URL vrati adresu servera pre dokument		*/
/********************************************************/
char *url_get_site(urlr)
url *urlr;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			return urlr->p.http.host;
		case URLT_FTP:
		case URLT_FTPS:
			return urlr->p.ftp.host;
		case URLT_GOPHER:
			return urlr->p.gopher.host;
		default: return NULL;
	}
}

int url_get_port(urlr)
url *urlr;
{
	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        return urlr->p.http.port;
                case URLT_FTP:
                case URLT_FTPS:
                        return urlr->p.ftp.port;
                case URLT_GOPHER:
                        return urlr->p.gopher.port;
                default: return 0;
	}
}

char *url_get_path(urlr)
url *urlr;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			return urlr->p.http.document;
		case URLT_FTP:
		case URLT_FTPS:
			return urlr->p.ftp.path;
		case URLT_GOPHER:
			return urlr->p.gopher.selector;
		case URLT_FILE:
			return urlr->p.file.filename;
		default: return NULL;
	}
}

void url_set_path(urlr, path)
url *urlr;
char *path;
{
	switch(urlr->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlr->p.http.document);
			urlr->p.http.document = new_string(path);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlr->p.ftp.path);
			urlr->p.ftp.path = new_string(path);
			break;
		case URLT_GOPHER:
			_free(urlr->p.gopher.selector);
			urlr->p.gopher.selector = new_string(path);
			break;
		case URLT_FILE:
			_free(urlr->p.file.filename);
			urlr->p.file.filename = new_string(path);
			break;
		default: return;
	}
	url_changed_filename(urlr);
}

char * url_get_pass(urlr , realm)
url *urlr;
char *realm;
{
	char *pass = NULL;
	authinfo *ai;

	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        pass = urlr->p.http.password;
			break;
                case URLT_FTP:
                case URLT_FTPS:
                        pass = urlr->p.ftp.password;
			break;
                default: return NULL;
	}

	if (!pass)
	{
		ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
					  url_get_port(urlr) , url_get_path(urlr) , realm);
		if (ai) pass = ai->pass;
	}

	if (!pass)
	{
		pass = cfg.passwd_auth;
	}

	return pass;
}

char * url_get_user(urlr , realm)
url *urlr;
char *realm;
{
	char *user = NULL;
	authinfo *ai;

	switch(urlr->type)
	{
                case URLT_HTTP:
                case URLT_HTTPS:
                        user = urlr->p.http.user;
			break;
                case URLT_FTP:
                case URLT_FTPS:
                        user = urlr->p.ftp.user;
                       	break;
                default: return NULL;
	}

	if (!user)
	{
		ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
					  url_get_port(urlr) , url_get_path(urlr) , realm);
		if (ai) user = ai->user;
	}

	if (!user)
	{
		user = cfg.name_auth;
	}
	
	return user;
}

int url_get_auth_scheme(urlr , realm)
url *urlr;
char *realm;
{
	authinfo *ai;
	int scheme = cfg.auth_scheme;

	ai = authinfo_match_entry(urlr->type , url_get_site(urlr) , 
				  url_get_port(urlr) , url_get_path(urlr) , realm);
	if (ai) scheme = ai->type;

	return scheme;
}

char * url_get_anchor_name(urlp)
url *urlp;
{
	char *anchor;

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			anchor = urlp->p.http.anchor_name;
			break;
		case URLT_FTP:
		case URLT_FTPS:
			anchor = urlp->p.ftp.anchor_name;
			break;
		case URLT_FILE:
			anchor = urlp->p.file.anchor_name;
			break;
		default:
			anchor = NULL;
			break;
	}

	return anchor;
}

void url_clear_anchor(urlp)
url *urlp;
{
	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			_free(urlp->p.http.anchor_name);
			break;
		case URLT_FTP:
		case URLT_FTPS:
			_free(urlp->p.ftp.anchor_name);
			break;
		case URLT_FILE:
			_free(urlp->p.file.anchor_name);
			break;
		default:
			break;
	}
}

char * url_get_search_str(urlp)
url *urlp;
{
	char *sstr;

	switch(urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			sstr = urlp->p.http.searchstr;
			break;
		default:
			sstr = NULL;
			break;
	}

	return sstr;
}

int url_is_dir_index(urlp)
url *urlp;
{
	return ((urlp->type == URLT_HTTP || urlp->type == URLT_HTTPS) &&
		tl_is_dirname(urlp->p.http.document)) ||
		((urlp->type == URLT_FTP || urlp->type == URLT_FTPS) && urlp->p.ftp.dir);

}

/**************************************************/
/* absolutna cesta k dokumentu z lokalneho stromu */
/* ktory je referencovany relativne		  */
/**************************************************/
char *get_redirect_abs_path(rurl , fstr)
url *rurl;
char *fstr;
{
	char *pom , *p , *p1;
	
	pom = new_string(url_to_filename(rurl , TRUE));
	p = strrchr(pom , '/');

	p1 = realloc(pom , strlen(fstr) + (p - pom) + 2);
	strcpy(p1 + (p - pom) + 1 , fstr);

	p = get_abs_file_path(p1);
	free(p1);
	
	return p;
}

void url_path_abs(urlp)
url *urlp;
{
	char *p;

	switch (urlp->type)
	{
		case URLT_HTTP:
		case URLT_HTTPS:
			p = get_abs_file_path(urlp->p.http.document);
			free(urlp->p.http.document);
			urlp->p.http.document = p;
			break;
		case URLT_FTP:
		case URLT_FTPS:
			p = get_abs_file_path(urlp->p.ftp.path);
			free(urlp->p.ftp.path);
			urlp->p.ftp.path = p;
			break;
		case URLT_FILE:
			p = get_abs_file_path(urlp->p.file.filename);
			free(urlp->p.file.filename);
			urlp->p.file.filename = p;
			break;
		default:
			break;
	}
}

url *filename_to_url(ifn)
char *ifn;
{
	int cdln = strlen(cfg.cache_dir);
	if (*ifn != '/') return NULL;

	if (cfg.enable_info)
	{
		url *nurl = dinfo_get_url_for_filename(ifn);

		if (nurl) return nurl;
	}

	if (!strncmp(ifn , cfg.cache_dir , cdln))
	{
		char *p;
		int i;
		url *nurl = _malloc(sizeof(url));
		char *fn = new_string(ifn);

		p = fn + cdln;
		p += (*p == '/');
		
		nurl->status = 0;
		nurl->level = 0;
		nurl->parent_url = NULL;
		nurl->moved_to = NULL;
		nurl->extension = NULL;
		nurl->local_name = new_string(ifn);

#ifdef WITH_TREE
#ifdef I_FACE
		nurl->prop = NULL;
		nurl->tree_nfo = NULL;
#endif
#endif

		for (i = 0 ; i < NUM_ELEM(prottable) ; i++)
		{
			if (prottable[i].dirname && 
			    !strncmp(p , prottable[i].dirname , 
			    	     strlen(prottable[i].dirname)))
			{
				char *p2,*p3;

				nurl->type = prottable[i].id;
				nurl->parent_url = NULL;
				p += strlen(prottable[i].dirname) + 1;

				if (!p)
				{
					free(nurl);
					free(fn);
					return NULL;
				}

				switch (nurl->type)
				{
				    case URLT_HTTP:
				    case URLT_HTTPS:
					nurl->p.http.password = NULL;
					nurl->p.http.user = NULL;
					nurl->p.http.anchor_name = NULL;
					nurl->p.http.searchstr = NULL;
					nurl->p.http.port = prottable[i].default_port;
					if ((p2 = strchr(p , '/')))
					{
						int p2_len = strlen(p2);
						int idx_len = strlen(cfg.index_name);

						if (idx_len <= p2_len &&
						    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
						    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '/') || idx_len == p2_len))
						{
							*(p2 + p2_len - idx_len) = '\0';
						}

						p3 = strchr(p2 , '?');
						if (p3)
						{
							*p3 = '\0';
							nurl->p.http.searchstr = new_string(p3+1);
						}
						nurl->p.http.document = new_string(p2);
						*p2 = '\0';
						p2 = strrchr(p , '_');
						if (p2)
						{
							p2++;
							nurl->p.http.port = _atoi(p2);
							if (errno == ERANGE)
							{
								nurl->p.http.host = 
									new_string(p);
								nurl->p.http.port = prottable[i].default_port;
							}
							else
							{
								nurl->p.http.host = 
									new_n_string(p , p2 - p - 1);
							}
						}
						else nurl->p.http.host = new_string(p);
					}
					else
					{
						free(nurl);
						free(fn);
						return NULL;
					}
					break;
				    case URLT_GOPHER:
					nurl->p.gopher.port = prottable[i].default_port;
					if ((p2 = strchr(p , '/')))
					{
						int p2_len = strlen(p2);
						int idx_len = strlen(cfg.index_name);

						p2++;
						nurl->p.gopher.type = *p2;

						if (idx_len <= p2_len &&
						    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
						    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '1') || idx_len == p2_len))
						{
							*(p2 + p2_len - idx_len) = '\0';
						}
						nurl->p.gopher.selector = 
							new_string(p2 + 1);
						*p2 = '\0';
						p2 = strrchr(p , '_');
						if (p2)
						{
							p2++;
							nurl->p.gopher.port = _atoi(p2);
							if (errno == ERANGE)
							{
								nurl->p.gopher.host = 
									new_string(p);
								nurl->p.gopher.port = prottable[i].default_port;
							}
							else
							{
								nurl->p.gopher.host = 
									new_n_string(p , p2 - p - 1);
							}
						}
						else nurl->p.gopher.host = new_string(p);
					}
					else
					{
						free(nurl);
						free(fn);
						return NULL;
					}
					break;
				    case URLT_FTP:
				    case URLT_FTPS:
					nurl->p.ftp.port = prottable[i].default_port;
					nurl->p.ftp.password = NULL;
					nurl->p.ftp.user = NULL;
					nurl->p.ftp.dir = FALSE;
					nurl->p.ftp.anchor_name = NULL;
					if ((p2 = strchr(p , '/')))
					{
						int p2_len = strlen(p2);
						int idx_len = strlen(cfg.index_name);

						if (idx_len <= p2_len &&
						    !strcmp((p2 + p2_len - idx_len) , cfg.index_name) && 
						    ((p2_len > idx_len && *(p2 + p2_len - idx_len - 1) == '/') || idx_len == p2_len))
						{
							*(p2 + p2_len - idx_len) = '\0';
							nurl->p.ftp.dir = TRUE;
						}
						nurl->p.ftp.path = new_string(p2);
						*p2 = '\0';
						p2 = strrchr(p , '_');
						if (p2)
						{
							p2++;
							nurl->p.ftp.port = _atoi(p2);
							if (errno == ERANGE)
							{
								nurl->p.ftp.host = 
									new_string(p);
								nurl->p.ftp.port = prottable[i].default_port;
							}
							else
							{
								nurl->p.ftp.host = 
									new_n_string(p , p2 - p - 1);
							}
						}
						else nurl->p.ftp.host = new_string(p);
					}
					else
					{
						free(nurl);
						free(fn);
						return NULL;
					}
					break;
				    case URLT_BROKEN:
				    case URLT_UNKNOWN:
				    case URLT_FILE:
				    case URLT_SHTTP:
				    case URLT_NEWS:
				    case URLT_NNTP:
				    case URLT_WAIS:
				    case URLT_WHOIS:
				    case URLT_MAILTO:
				    case URLT_PROSPERO:
				    case URLT_TELNET:
				    case URLT_TN3270:
				    case URLT_X500:
				    case URLT_RLOGIN:
				    case URLT_JAVASCRIPT:
				    case URLT_URN:
				    case URLT_LDAP:
				    case URLT_Z39_50R:
				    case URLT_Z39_50S:
				    case URLT_CID:
				    case URLT_CLSID:
				    case URLT_FINGER:
				    case URLT_HDL:
				    case URLT_ILU:
				    case URLT_IOR:
				    case URLT_IRC:
				    case URLT_JAVA:
				    case URLT_LIFN:
				    case URLT_MID:
				    case URLT_PATH:
				    case URLT_SERVICE:
				    case URLT_SNEWS:
				    case URLT_STANF:
				    case URLT_SMS:
				    case URLT_TEL:
				    case URLT_FAX:
				    case URLT_MODEM:
				    default:
				        free(nurl);
				        nurl = NULL;
				    	break;
				}
				free(fn);
				return nurl;
			}
		}
		free(nurl);
	}
	return NULL;
}

/****************************************/
/* zisti ci bol dokument referencovany  */ 
/* v predchadzajucich cykloch		*/
/****************************************/
url *url_was_befor(urlp)
url *urlp;
{
	url *ret;

	if (!prottable[urlp->type].supported) return NULL;

	LOCK_CFG_URLHASH
	ret = (url *)dlhash_find(cfg.url_hash_tbl , urlp);
	UNLOCK_CFG_URLHASH

	return ret;
}

void url_forget_filename(urlp)
url *urlp;
{
	url_remove_from_hash_tab(urlp);
	_free(urlp->local_name);
	url_add_to_hash_tab(urlp);
}

