/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <time.h>

#include "config.h"
#include "schedule.h"
#include "mode.h"

/************************************************/
/* naplanovanie vykonania programu v danom case */
/* pri aktualnej konfiguracii			*/
/************************************************/
int at_schedule()
{
	char *tf;
	char *p,*op;
	char pcmd[PATH_MAX];
	char cmd[PATH_MAX];
	char tform[3] = "%s";
	bool xi_save;

	strcpy(cmd , cfg.sched_cmd ? cfg.sched_cmd : AT_CMD);

	tf = tmpnam(NULL);

	p = cmd;
	op = pcmd;
	*op = '\0';

	while(*p)
	{
		if (*p == '%')
		{
			p++;
			switch (*p)
			{
				case 'f':
					strcat(op , tf);
					break;
				case 't':
					strftime(op , 10 , "%H:%M" , cfg.time);
					break;
				default:
					tform[1] = *p;
					strftime(op , 10 , tform , cfg.time);
			}
			p++;
			while(*op) op++;
		}
		else
		{
			*op = *p;
			op++;
			p++;
			*op = '\0';
		}
	}
#ifdef I_FACE
	xi_save = cfg.xi_face;
	cfg.xi_face = FALSE;
#endif
	cfg_dump_cmd(tf);
#ifdef I_FACE
	cfg.xi_face = xi_save;
#endif

	if (system(pcmd))
	{
		xperror(pcmd);
		if (unlink(tf))
			xperror(tf);
		return -1;
	}

	if (unlink(tf))
		xperror(tf);

	return 0;
}
