/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <limits.h>
#include <time.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#include "config.h"
#include "url.h"
#include "doc.h"
#include "tools.h"
#include "html.h"
#include "http.h"
#include "ftp.h"
#include "myssl.h"
#include "abstract.h"
#include "recurse.h"
#include "mime.h"
#include "robots.h"
#include "mode.h"
#include "times.h"
#include "stats.h"
#include "errcode.h"
#include "cookie.h"

extern void make_clean_dir(url *);
extern void short_log(doc *, url *);
static void dump_ftp_list(dllist *);

#ifdef I_FACE
#define SETNEXTURL	\
			short_log(docu , urlr);\
			if (!(urlr->status & URL_DOWNLOADED)) cfg.fail_cnt++;\
			if (cfg.xi_face)\
				icons_set_for_doc(docu);\
			_free(pstr);\
			_free(docu->mime);\
			_free(docu->type_str);\
			_free(docu->contents);\
			_free(docu->etag);\
			if (!cfg.auth_reuse_nonce)\
			{\
				if (docu->auth_digest) http_digest_deep_free(docu->auth_digest);\
				docu->auth_digest = NULL;\
			}\
                        if (!cfg.auth_reuse_proxy_nonce)\
                        {\
                                if (docu->auth_proxy_digest) http_digest_deep_free(docu->auth_proxy_digest);\
                                docu->auth_proxy_digest = NULL;\
                        }\
                        return docu->errcode;
#else
#define SETNEXTURL	\
			short_log(docu , urlr);\
			if (!(urlr->status & URL_DOWNLOADED)) cfg.fail_cnt++;\
			_free(pstr);\
			_free(docu->mime);\
			_free(docu->type_str);\
			_free(docu->contents);\
			_free(docu->etag);\
			if (!cfg.auth_reuse_nonce)\
			{\
				if (docu->auth_digest) http_digest_deep_free(docu->auth_digest);\
				docu->auth_digest = NULL;\
			}\
                        if (!cfg.auth_reuse_proxy_nonce)\
                        {\
                                if (docu->auth_proxy_digest) http_digest_deep_free(docu->auth_proxy_digest);\
                                docu->auth_proxy_digest = NULL;\
                        }\
			return docu->errcode;
#endif

static void reschedule_url(urlp)
url *urlp;
{
	DEBUG_MISC(gettext("Rescheduling locked URL as no. %d\n") , cfg.total_cnt);
	LOCK_CFG_URLSTACK
	cfg.urlstack = dllist_append(cfg.urlstack , urlp);
	cfg.total_cnt++;
	LOCK_CFG_URLSTACK
}

static void run_post_command(docp)
doc *docp;
{
	char pom[3*PATH_MAX];
	char *urlstr;

	DEBUG_MISC(gettext("Running post-processing command\n"));
	urlstr = url_to_urlstr_woauth(docp->doc_url, TRUE);
	sprintf(pom , "%s \'%s\' %d \'%s\'" , cfg.post_cmd , 
		url_to_filename(docp->doc_url, FALSE),
		docp->is_html ? 1 : 0 , urlstr);
	_free(urlstr);

	system(pom);
}

int process_document(docu , check_lim)
doc *docu;
int check_lim;
{
	url *urlr;
	dllist *pom;
	int pokus = 0;
	int nreget=0 , nredir=0;
	time_t atm;
	char cpom[512];
	int num_auth,num_proxy_auth;
	char *pstr = NULL;
	int store_stat;
	struct stat estat;

	urlr = docu->doc_url;

	num_auth = cfg.auth_reuse_nonce ? 1 : 0;
	num_proxy_auth = cfg.auth_reuse_proxy_nonce ? 1 : 0;

	pokus = 0;
	nredir = 0;
	nreget = 0;

	docu->check_limits = check_lim;

	_Xt_Serve

	if (docu->check_limits)
		docu->check_limits = (urlr->parent_url[0] != NULL);

	while (!cfg.stop && !cfg.rbreak)
	{
		docu->errcode = ERR_NOERROR;
		docu->mime = NULL;
		docu->type_str = NULL;
		docu->doc_url = urlr;
		docu->dtime = 0L;
		docu->contents = NULL;
		docu->is_chunked = FALSE;
		docu->read_chunksize = FALSE;
		docu->read_trailer = FALSE;
		pstr = url_to_urlstr(urlr , FALSE);

		if (pokus) xprintf(1 , gettext("retry no. %d\n"),pokus);

#ifdef I_FACE
		if (cfg.xi_face)
		{
			sprintf(cpom , "%d(%d)/%d" , docu->doc_nr, cfg.fail_cnt, cfg.total_cnt);
			iface_set_counter(cpom);

			iface_set_url(pstr);

			iface_set_what("");
		}
#endif
		xprintf(1 , gettext("URL: %5d(%d) of %5d  %s\n") , docu->doc_nr, 
				cfg.fail_cnt, cfg.total_cnt , pstr);

		if (docu->check_limits)
		{
			if (urlr->status & URL_PROCESSED)
			{
				xprintf(1 , gettext("Already processed\n"));
				docu->errcode = ERR_PROCESSED;
				SETNEXTURL;
			}

			if (urlr->status & URL_USER_DISABLED)
			{
				xprintf(1 , gettext("Disallowed by user\n"));
				docu->errcode = ERR_UDISABLED;
				SETNEXTURL;
			}


			if (!prottable[urlr->type].supported || 
			    (urlr->parent_url[0] &&
				(urlr->type == URLT_FTP || urlr->type == URLT_FTPS) && urlr->p.ftp.dir &&
				!cfg.condition.ftpdir) ||
			    (urlr->parent_url[0] && !url_append_condition(urlr , docu->doc_nr)))
			{ 
				xprintf(1 , gettext("Disallowed by rules\n"));

				urlr->status |= URL_REJECTED;
				docu->errcode = ERR_RDISABLED;
				SETNEXTURL;
			}

		      	iface_set_what(gettext("Checking \"robots.txt\""));

			if (!check_robots(urlr))
			{
				xprintf(1 , gettext("Disallowed by \"robots.txt\"\n"));

				urlr->status |= URL_REJECTED;
				docu->errcode = ERR_RDISABLED;
				SETNEXTURL;
			}
		}
	
		if (cfg.mode == MODE_FTPDIR && 
			(urlr->type != URLT_FTP && urlr->type != URLT_FTPS))
		{
			xprintf(1 , gettext("This URL type is not supported with ftpdir mode\n"));

			urlr->status |= URL_REJECTED;
			docu->errcode = ERR_RDISABLED;
			SETNEXTURL;
		}

		_Xt_Serve

		if (cfg.mode == MODE_SYNC)
		{
			char *pp = url_to_filename(urlr , TRUE);

			if (!stat(pp , &estat) && !S_ISDIR(estat.st_mode))
			{
				atm = time(NULL) - 86400 * cfg.ddays;
				if (estat.st_mtime < atm)
					docu->dtime = estat.st_mtime;
				else
				{
					xprintf(1 , gettext("No transfer - file not expired\n"));

					urlr->status |= URL_REJECTED;
					docu->errcode = ERR_RDISABLED;
					SETNEXTURL;
				}
				urlr->status |= URL_ISLOCAL;
				docu->origsize = estat.st_size;
			}
		}

		if (cfg.show_time)
		{
			atm = time(NULL);
			strftime(cpom , sizeof(cpom) , "%H:%M:%S" , localtime(&atm));		
			xprintf(1 , gettext("Starting time :  %s\n") , cpom);
		}

#ifdef I_FACE
		if (!cfg.stop && !cfg.rbreak)
		{
#endif

		_Xt_Serve

		if ((urlr->type == URLT_FTP || urlr->type == URLT_FTP) &&
		    urlr->extension && 
		    ((ftp_url_extension *)urlr->extension)->type == FTP_TYPE_L &&
		    ((ftp_url_extension *)urlr->extension)->slink)
		{
			ftp_make_symlink(urlr);
			urlr->status |= URL_PROCESSED;
			docu->errcode = ERR_NOERROR;
			SETNEXTURL;
		}

		iface_set_what(gettext("Starting download"));

		if (doc_download(docu,/*(cfg.prepurlstr && cfg.mode == MODE_SYNC)*/ FALSE, FALSE))
		{
			if (cfg.show_time)
			{
				atm = time(NULL);
				strftime(cpom , sizeof(cpom) , "%H:%M:%S" , localtime(&atm));
				xprintf(1 , gettext("Ending time :    %s\n") , cpom);
			}

			_Xt_Serve

			doc_remove_lock(docu);

			report_error(docu , gettext("download"));
			_free(docu->contents);

			if (((nreget < cfg.nreget) &&
				(docu->errcode == ERR_HTTP_TRUNC || 
				 docu->errcode == ERR_FTP_TRUNC)) ||
				(nredir < cfg.nredir && 
				    docu->errcode == ERR_HTTP_REDIR) ||
				(docu->errcode == ERR_HTTP_AUTH) ||
				(docu->errcode == ERR_HTTP_PROXY_AUTH))
			{
				if (docu->errcode == ERR_HTTP_REDIR)
				{
					urlr->status |= URL_PROCESSED;
					if (urlr->moved_to->status & URL_PROCESSED)
					{
						SETNEXTURL;
					}
					else
					{
#ifdef I_FACE
						if (cfg.xi_face)
							icons_set_for_doc(docu);
#endif
						urlr = urlr->moved_to;
					}
				}
				if (docu->errcode == ERR_HTTP_TRUNC)
				{
					urlr->status |= URL_TRUNCATED;
					_free(docu->etag);

					docu->etag = get_mime_param_val_str("ETag:" , docu->mime);
					if (!docu->etag) docu->etag = get_mime_param_val_str("Content-Location:" , docu->mime);
					if (!docu->etag) docu->etag = get_mime_param_val_str("Last-Modified" , docu->mime);
				}

				if (docu->errcode == ERR_HTTP_AUTH ||
				    docu->errcode == ERR_HTTP_PROXY_AUTH)
				{
					int proxy_auth;
					http_digest_info *digest;

					if ((digest = http_digest_parse(docu->mime , urlr , &proxy_auth)))
					{
						if (proxy_auth)
						{
							if ((num_proxy_auth < 2) &&
								cfg.http_proxy_pass && 
								cfg.http_proxy_user)
							{
								num_proxy_auth++;
								if (docu->auth_proxy_digest)
									http_digest_deep_free((http_digest_info *)docu->auth_proxy_digest);
								docu->auth_proxy_digest = digest;
							}
							else
							{
								if (docu->auth_proxy_digest)
									http_digest_deep_free((http_digest_info *)docu->auth_proxy_digest);
								http_digest_deep_free(digest);
								docu->auth_proxy_digest = NULL;
								urlr->status |= URL_ERR_REC;
								SETNEXTURL;
							}
						}
						else
						{
							if ((num_auth < 2) && 
								url_get_pass(urlr , digest->realm) && 
								url_get_user(urlr , digest->realm))
							{
								num_auth++;
								if (docu->auth_digest)
									http_digest_deep_free((http_digest_info *)docu->auth_digest);
								docu->auth_digest = digest;
							}
							else
							{
								if (docu->auth_digest)
									http_digest_deep_free((http_digest_info *)docu->auth_digest);
								http_digest_deep_free(digest);
								docu->auth_digest = NULL;
								urlr->status |= URL_ERR_REC;
								SETNEXTURL;
							}
						}
					}
					else
					{
						urlr->status |= URL_PROCESSED;
						urlr->status |= URL_ERR_REC;
						SETNEXTURL;
					}
				}

				_free(docu->mime);
				_free(docu->type_str);

				nreget += (docu->errcode == ERR_HTTP_TRUNC || 
					   docu->errcode == ERR_FTP_TRUNC) &&
					   cfg.mode != MODE_SREGET;
				nredir +=  docu->errcode == ERR_HTTP_REDIR;
				_free(pstr);
				continue;
			}

			if (docu->errcode == ERR_FTP_UNKNOWN ||
			    docu->errcode == ERR_FTP_CONNECT ||
			    docu->errcode == ERR_FTP_DATACON ||
			    docu->errcode == ERR_FTPS_CONNECT ||
			    docu->errcode == ERR_FTPS_DATASSLCONNECT ||
			    docu->errcode == ERR_HTTP_UNKNOWN ||
			    docu->errcode == ERR_HTTP_CONNECT ||
			    docu->errcode == ERR_HTTP_SNDREQ ||
			    docu->errcode == ERR_HTTP_SERV ||
			    docu->errcode == ERR_HTTP_TIMEOUT ||
			    docu->errcode == ERR_READ ||
			    docu->errcode == ERR_ZERO_SIZE ||
			    docu->errcode == ERR_GOPHER_CONNECT ||
			    docu->errcode == ERR_LOW_TRANSFER_RATE)
			{
				urlr->status |= URL_ERR_REC;
				pokus ++;
				/*** novy pokus len ak to ma zmysel !!!! ***/
				if (pokus >= cfg.nretry)
				{
					urlr->status |= URL_PROCESSED;
					SETNEXTURL;
				}
				_free(pstr);
				_free(docu->mime);
				_free(docu->type_str);
				continue;
			}
			else if (docu->errcode == ERR_LOCKED)
			{
				if ((docu->doc_nr) == cfg.total_cnt)
				{
					xprintf(1 , gettext("last document locked -> sleeping for 5 seconds\n"));
					my_sleep(5);
				}
				reschedule_url(urlr);
				SETNEXTURL;
			}
			else if (docu->errcode == ERR_BIGGER ||
				 docu->errcode == ERR_SMALLER ||
				 docu->errcode == ERR_NOMIMET || 
				 docu->errcode == ERR_OUTTIME ||
				 docu->errcode == ERR_SCRIPT_DISABLED)
			{
				urlr->status |= URL_PROCESSED;
				urlr->status |= URL_ERR_REC;
				SETNEXTURL;

			}
			else
			{
				/*** remove improper documents if required ***/
				if ((cfg.remove_old && cfg.mode == MODE_SYNC) &&
				    (((docu->errcode == ERR_FTP_GET ||
				       docu->errcode == ERR_FTP_BDIR ||
				       docu->errcode == ERR_FTP_NODIR) && 
				      docu->ftp_respc == 550) ||
				     docu->errcode == ERR_HTTP_NFOUND ||
				     docu->errcode == ERR_HTTP_GONE))
				{
					doc_remove(docu->doc_url);
				}


				urlr->status |= URL_ERR_UNREC;
				urlr->status |= URL_PROCESSED;

				SETNEXTURL;
			}
		}

		_Xt_Serve

		if (urlr->status & URL_TRUNCATED)
			urlr->status &= ~URL_TRUNCATED;

		if (urlr->status & URL_ERR_REC)
			urlr->status &= ~URL_ERR_REC;
		

		if (cfg.recv_cookies && docu->mime)
		{
			int i;
			char *cookie_field;

			for (i = 0 ; (cookie_field = get_mime_n_param_val_str("Set-Cookie:" , docu->mime , i)) ; i++)
			{
				cookie_insert_field(cookie_field , urlr);
				_free(cookie_field);
			}
		}

		_Xt_Serve

		if (cfg.update_cookies)
		{
			cookie_update_ns(FALSE);
		}

		if (cfg.show_time)
		{
			atm = time(NULL);
			strftime(cpom , sizeof(cpom) , "%H:%M:%S" , localtime(&atm));
			xprintf(1 , gettext("Ending time :    %s\n") , cpom);
		}

		report_error(docu, gettext("download"));	

		_Xt_Serve

		if (docu->contents)
		{
			if (docu->is_html)
			{
				int len;
				char *newcont;

				iface_set_what(gettext("Relocating HTML document"));

				if (cfg.rewrite_links && (!cfg.all_to_local || cfg.sel_to_local))
					relocate_html_doc(docu);

				_Xt_Serve

				if (cfg.mode != MODE_SREGET)
				{
					iface_set_what(gettext("Searching for links"));

					pom = html_get_all_links(docu ,
						cfg.mode == MODE_SINGLE ,
						cfg.mode == MODE_FTPDIR);

					if (cfg.mode != MODE_FTPDIR &&
						!(docu->doc_url->status & URL_NORECURSE))
					{
#ifdef WITH_TREE
#ifdef _GTK_FEATURES_1_2
						if (cfg.xi_face)
							gtk_clist_freeze(GTK_CLIST(cfg.gtk.tree_widget));
#endif
#ifdef X_FACE
						if (cfg.xi_face)
							TreeListDontDoLayout(cfg.X.tree_widget);
#endif
#endif
						cat_links_to_url_list(pom);
#ifdef WITH_TREE
#ifdef _GTK_FEATURES_1_2
						if (cfg.xi_face)
							gtk_clist_thaw(GTK_CLIST(cfg.gtk.tree_widget));
#endif
#ifdef X_FACE
						if (cfg.xi_face)
							TreeListDoLayout(cfg.X.tree_widget);
#endif
#endif
					}
					else if (cfg.mode == MODE_FTPDIR)
					{
						dump_ftp_list(pom);
					}
				}

				_Xt_Serve

				if (cfg.rewrite_links && !cfg.all_to_remote &&
					cfg.mode != MODE_FTPDIR)
				{
					len = html_remote_to_local_links(&newcont, docu, 
						cfg.all_to_local, cfg.sel_to_local);
					_free(docu->contents);
					docu->contents = newcont;
					docu->size = len;
				}
			}

			store_stat = 0;

			if ((docu->doc_url->type != URLT_FILE) && 
				!(docu->doc_url->status & URL_REDIRECT) &&
				 (cfg.mode != MODE_NOSTORE) && 
				 (cfg.mode != MODE_FTPDIR))
			{
				iface_set_what(gettext("Storing document"));

				store_stat = doc_store(docu, TRUE);

				if (store_stat)
				{
					xprintf(1 , gettext("Store failed\n"));
					urlr->status &= ~URL_ERR_REC;
				}
			}

			_Xt_Serve

			if (cfg.post_cmd)
				run_post_command(docu);

			doc_remove_lock(docu);

			if ((cfg.mode != MODE_NOSTORE) &&
				(docu->doc_url->type !=  URLT_FILE) && 
				!(docu->doc_url->status & URL_REDIRECT) &&
				!(docu->doc_url->status & URL_ISLOCAL) &&
				docu->doc_url->parent_url)
			{
				if (cfg.rewrite_links && !store_stat && !cfg.all_to_local && !cfg.sel_to_local && !cfg.all_to_remote)
				{
					iface_set_what(gettext("Rewriting links inside parent documents"));
					rewrite_parents_links(docu->doc_url , NULL);
				}
			}
		}
		else
		{
			if (cfg.post_cmd)
				run_post_command(docu);

			doc_remove_lock(docu);
			if ((cfg.mode != MODE_NOSTORE) &&
				(docu->doc_url->type !=  URLT_FILE) && 
				!(docu->doc_url->status & URL_REDIRECT) &&
				!(docu->doc_url->status & URL_ISLOCAL) &&
				docu->doc_url->parent_url)
			{
				if (cfg.rewrite_links && !cfg.all_to_local && !cfg.sel_to_local && !cfg.all_to_remote)
				{
					iface_set_what(gettext("Rewriting links inside parent documents"));
					rewrite_parents_links(docu->doc_url , NULL);
				}
			}
		}

		urlr->status |= URL_DOWNLOADED;
		urlr->status |= URL_PROCESSED;
		SETNEXTURL;
#ifdef I_FACE
	}
#endif
	}
	return ERR_UNKNOWN;
}

static void dump_ftp_list(urllst)
dllist *urllst;
{
	dllist *ptr = urllst;

	while(ptr)
	{
		url *urlp = (url *) ptr->data;

		if (!(urlp->status & URL_INLINE_OBJ) && 
		    (urlp->type == URLT_FTP || urlp->type == URLT_FTPS))
		{
			char *p,*pp;

			p = url_get_path(urlp);
			pp = strrchr(p , '/');
			if (pp)
			{
				pp ++;
				if (!*pp)
				{
					while(pp > p && *pp != '/') pp--;
					pp++;
				}
				if (urlp->extension)
				{
					ftp_url_extension *fe = urlp->extension;

					if (fe->type == FTP_TYPE_F)
						xprintf(1 , gettext("\t%s    (%d bytes)\n") , pp , fe->size);
					else if (fe->type == FTP_TYPE_L)
						xprintf(1 , "\t%s    -> %s\n" , pp , fe->slink);
					else if (fe->type == FTP_TYPE_D)
						xprintf(1 , "\t%s/\n" , pp , fe->slink);
				}
				else
					xprintf(1 , "\t%s\n" , pp);
			}
		}
		free_deep_url(urlp);
		free(urlp);
		ptr = dllist_remove_entry(ptr , ptr);
	}
}

void save_global_connection_data(infop, docp)
global_connection_info *infop;
doc *docp;
{
	/*** preserve FTP control connection ***/
	if (docp->ftp_control)
	{
		infop->ftp_con.proto = docp->doc_url->type;
		infop->ftp_con.control = docp->ftp_control;
		infop->ftp_con.host = url_get_site(docp->doc_url);
		infop->ftp_con.port = url_get_port(docp->doc_url);
		infop->ftp_con.user = url_get_user(docp->doc_url, NULL);
		infop->ftp_con.passwd = url_get_pass(docp->doc_url, NULL);
#ifdef USE_SSL
		infop->ftp_con.control_ssl_con = docp->ftp_control_ssl_con;
		infop->ftp_con.control_ssl_bio = docp->ftp_control_ssl_bio;
		infop->ftp_con.control_ssl_ctx = docp->ftp_control_ssl_ctx;
#endif
	}
	else
	{
		infop->ftp_con.control = NULL;
		infop->ftp_con.port = 0;
		infop->ftp_con.host = NULL;
		infop->ftp_con.user = NULL;
		infop->ftp_con.passwd = NULL;
#ifdef USE_SSL
		infop->ftp_con.control_ssl_con = NULL;
		infop->ftp_con.control_ssl_bio = NULL;
		infop->ftp_con.control_ssl_ctx = NULL;
#endif
	}

	/*** preserve SSL connection ***/
#ifdef USE_SSL
	if (docp->ssl_con)
	{
		infop->ssl_con.ssl_con = docp->ssl_con;
		infop->ssl_con.ssl_ctx = docp->ssl_ctx;
		infop->ssl_con.ssl_method = docp->ssl_method;
	}
	else
	{
		infop->ssl_con.ssl_con = NULL;
		infop->ssl_con.ssl_ctx = NULL;
		infop->ssl_con.ssl_method = NULL;
	}
#endif
	/*** preserve HTTP connection infos ***/
	if (cfg.auth_reuse_nonce)
		infop->http_con.auth_digest = (http_digest_info *) docp->auth_digest;
	else
		infop->http_con.auth_digest = NULL;

	if (cfg.auth_reuse_proxy_nonce)
		infop->http_con.auth_proxy_digest = (http_digest_info *) docp->auth_proxy_digest;
	else
		infop->http_con.auth_proxy_digest = NULL;

	if (docp->datasock)
	{
		infop->http_con.connection = docp->datasock;
		infop->http_con.proto = docp->doc_url->type;
		infop->http_con.port = url_get_port(docp->doc_url);
		infop->http_con.host = url_get_site(docp->doc_url);
	}
	else
	{
		infop->http_con.connection = NULL;
		infop->http_con.proto = docp->doc_url->type;
		infop->http_con.port = 0;
		infop->http_con.host = NULL;
	}
}

void restore_global_connection_data(infop, docp)
global_connection_info *infop;
doc *docp;
{
	if (infop->ftp_con.control)
	{
		char *pass = url_get_pass(docp->doc_url, NULL);
		char *user = url_get_user(docp->doc_url, NULL);
		char *host = url_get_site(docp->doc_url);
		unsigned short port = url_get_port(docp->doc_url);

		if ((docp->doc_url->type == URLT_FTP || docp->doc_url->type == URLT_FTPS) &&
		    infop->ftp_con.proto == docp->doc_url->type &&
		    infop->ftp_con.port == port &&
		    !strcmp(infop->ftp_con.host, host) &&
		    ((pass && infop->ftp_con.passwd &&
			!strcmp(pass , infop->ftp_con.passwd)) ||
			(!pass && !infop->ftp_con.passwd)) &&
		    ((user && infop->ftp_con.user &&
			!strcmp(user , infop->ftp_con.user)) ||
			(!user && !infop->ftp_con.user)))
		{
			docp->ftp_control = infop->ftp_con.control;
#ifdef USE_SSL
			docp->ftp_control_ssl_con = infop->ftp_con.control_ssl_con;
			docp->ftp_control_ssl_bio = infop->ftp_con.control_ssl_bio;
			docp->ftp_control_ssl_ctx = infop->ftp_con.control_ssl_ctx;
#endif
		}
		else
		{
#ifdef USE_SSL
			if (infop->ftp_con.control_ssl_con)
			{
				bufio_sslwrite(infop->ftp_con.control , "QUIT\r\n" , 6, infop->ftp_con.control_ssl_con);
				SSL_set_shutdown(infop->ftp_con.control_ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
				SSL_free(infop->ftp_con.control_ssl_con);
				SSL_CTX_free(infop->ftp_con.control_ssl_ctx);
			}
			else
#endif
				bufio_write(infop->ftp_con.control , "QUIT\r\n" , 6);
			shutdown(bufio_getfd(infop->ftp_con.control) , 2);
			bufio_close(infop->ftp_con.control);
			infop->ftp_con.control = NULL;
		}
	}
#ifdef USE_SSL
	if (infop->ssl_con.ssl_con)
	{
		docp->ssl_con = infop->ssl_con.ssl_con;
		docp->ssl_ctx = infop->ssl_con.ssl_ctx;
		docp->ssl_method = infop->ssl_con.ssl_method;
	}
#endif
	if (cfg.auth_reuse_nonce && infop->http_con.auth_digest && 
		(docp->doc_url->type == URLT_HTTP || docp->doc_url->type == URLT_HTTPS))
	{
		if (!strcmp(infop->http_con.auth_digest->site , 
				url_get_site(docp->doc_url)) &&
			infop->http_con.auth_digest->port == 
			 url_get_port(docp->doc_url))
		{
			docp->auth_digest = infop->http_con.auth_digest;
		}
		else
		{
			http_digest_deep_free(infop->http_con.auth_digest);
			infop->http_con.auth_digest = NULL;
		}
	}

	if (cfg.auth_reuse_proxy_nonce)
		docp->auth_proxy_digest = infop->http_con.auth_proxy_digest;
	else
	{
		if (infop->http_con.auth_proxy_digest)
			http_digest_deep_free(infop->http_con.auth_proxy_digest);
		infop->http_con.auth_proxy_digest = NULL;
	}

	if (infop->http_con.connection)
	{
		char *host = url_get_site(docp->doc_url);
		unsigned short port = url_get_port(docp->doc_url);

		if (infop->http_con.proto == docp->doc_url->type &&
		    infop->http_con.port == port &&
		    !strcmp(infop->http_con.host, host))
		{
			docp->datasock = infop->http_con.connection;
		}
		else
		{
			shutdown(bufio_getfd(infop->http_con.connection), 2);
			bufio_close(infop->http_con.connection);
			infop->http_con.connection = NULL;
		}
	}
}

void kill_global_connection_data(infop)
global_connection_info *infop;
{
	/**** close FTP control connection ****/
	if (infop->ftp_con.control)
	{
#ifdef USE_SSL
		if (infop->ftp_con.control_ssl_con)
		{
			bufio_sslwrite(infop->ftp_con.control , "QUIT\r\n" , 6 , infop->ftp_con.control_ssl_con);
			SSL_set_shutdown(infop->ftp_con.control_ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
			SSL_free(infop->ftp_con.control_ssl_con);
			SSL_CTX_free(infop->ftp_con.control_ssl_ctx);
			shutdown(bufio_getfd(infop->ftp_con.control) , 2);
			bufio_close(infop->ftp_con.control);
			infop->ftp_con.control = NULL;
		}
		else
#endif
		{
			bufio_write(infop->ftp_con.control , "QUIT\r\n" , 6);
			shutdown(bufio_getfd(infop->ftp_con.control) , 2);
			bufio_close(infop->ftp_con.control);
			infop->ftp_con.control = NULL;
		}
	}
	/*** close preserved SSL connection ***/
#ifdef USE_SSL
	if (infop->ssl_con.ssl_con)
	{
		SSL_set_shutdown(infop->ssl_con.ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
		SSL_free(infop->ssl_con.ssl_con);
		SSL_CTX_free(infop->ssl_con.ssl_ctx);
	}
#endif
	if (infop->http_con.auth_digest)
		http_digest_deep_free(infop->http_con.auth_digest);
	if (infop->http_con.auth_proxy_digest)
		http_digest_deep_free(infop->http_con.auth_proxy_digest);

	if (infop->http_con.connection)
	{
		shutdown(bufio_getfd(infop->http_con.connection), 2);
		bufio_close(infop->http_con.connection);
	}
}

void init_global_connection_data(infop)
global_connection_info *infop;
{
	infop->ftp_con.proto = URLT_FTP;
	infop->ftp_con.port = 0;
	infop->ftp_con.host = NULL;
	infop->ftp_con.user = NULL;
	infop->ftp_con.passwd = NULL;
	infop->ftp_con.control = NULL;
#ifdef USE_SSL
	infop->ftp_con.control_ssl_con = NULL;
	infop->ftp_con.control_ssl_ctx = NULL;
	infop->ftp_con.control_ssl_bio = NULL;
	infop->ssl_con.ssl_con = NULL;
	infop->ssl_con.ssl_ctx = NULL;
	infop->ssl_con.ssl_method = NULL;
#endif
	infop->http_con.auth_digest = NULL;
	infop->http_con.auth_proxy_digest = NULL;
	infop->http_con.connection = NULL;
	infop->http_con.host = NULL;
	infop->http_con.proto = URLT_HTTP;
	infop->http_con.port = 0;
}

/*********************************************/
/* rekurzivne prechadzanie stromu dokumentov */
/*********************************************/

void recurse(is_restart)
int is_restart;
{
	static int docnr = 0;
	global_connection_info con_info;

	if (is_restart)
		docnr = 1;

	if (cfg.urlstack == NULL) return ;

	init_global_connection_data(&con_info);

/**** obsluzenie vsetkych URL v zozname ****/
	while(cfg.urlstack && !cfg.stop)
	{
		doc docu;
		url *urlp;

		urlp = (url *)cfg.urlstack->data;

		LOCK_CFG_URLSTACK
		if (cfg.urlstack)
			cfg.urlstack = dllist_remove_entry(cfg.urlstack , cfg.urlstack);
		else
			break;
		UNLOCK_CFG_URLSTACK

		doc_init(&docu , urlp);
		docu.doc_nr = docnr;
		restore_global_connection_data(&con_info, &docu);

		if (process_document(&docu , TRUE))
		{
			char *infn,*fn;
			fn = url_to_filename(docu.doc_url , FALSE);
			infn = url_to_in_filename(docu.doc_url);
			if (access(fn, F_OK) && access(infn, F_OK))
			{
				make_clean_dir(docu.doc_url);
				url_forget_filename(docu.doc_url);
			}
			_free(infn);
		}

		save_global_connection_data(&con_info, &docu);

		if (docu.errcode == ERR_QUOTA_FS || 
		    docu.errcode == ERR_QUOTA_TRANS ||
		    docu.errcode == ERR_QUOTA_TIME ||
		    cfg.rbreak)
		{
			LOCK_CFG_URLSTACK
			cfg.urlstack = dllist_prepend(cfg.urlstack , urlp);
			UNLOCK_CFG_URLSTACK
			break;
		}

		if (!cfg.rbreak) 
		{
			docnr++;
		}
	}
#ifdef I_FACE
        if (cfg.xi_face)
        {
		char cpom[256];

		iface_set_what(gettext("Done"));
		sprintf(cpom , "%d/%d" , docnr , cfg.total_cnt);
		iface_set_counter(cpom);
	}
#endif
	cfg.stop = FALSE;
	cfg.rbreak = FALSE;

	kill_global_connection_data(&con_info);

	if (cfg.update_cookies)
	{
		cookie_update_ns(TRUE);
	}

	if (!cfg.rbreak && !cfg.stop && cfg.stats_file)
	{
		stats_fill_spage(cfg.stats_file, NULL);
	}
}

void get_urls_to_resume(dirname)
char *dirname;
{
	DIR *dir;
	struct dirent *dent;
	char next_dir[PATH_MAX];
	struct stat estat;
	url *purl;

	if (!(dir = opendir(dirname)))
	{
		xperror(dirname);
		return;
	}

	iface_set_what(gettext("Searching for files to resume"));

	while((dent = readdir(dir)))
	{
		_Xt_Serve

		sprintf(next_dir , "%s/%s" , dirname , dent->d_name);
		if (!strcmp(dent->d_name , ".")) continue;
		if (!strcmp(dent->d_name , "..")) continue;		
		if (stat(next_dir , &estat))
		{
			xperror(next_dir);
			continue;
		}

		if (S_ISDIR(estat.st_mode))
		{
                        if (!strcmp(dent->d_name , ".pavuk_info") && cfg.enable_info)
				continue;

			get_urls_to_resume(next_dir);
		}
		else if (!strncmp(".in_" , dent->d_name , 4))
		{
			xprintf(1 , gettext("Adding %s to resume list\n") , next_dir);
			sprintf(next_dir , "%s/%s" , dirname , dent->d_name + 4);
			if ((purl = filename_to_url(next_dir)))
			{
				append_url_to_list(purl);
			}
		}

#ifdef I_FACE
		if (cfg.xi_face)
		{
			if (cfg.rbreak || cfg.stop)
			{
				closedir(dir);
				return;
			}
		}
#endif
	}

	closedir(dir);
}

void get_urls_to_synchronize(dirname , list)
char *dirname;
dllist **list;
{
	DIR *dir;
	struct dirent *dent;
	char next_dir[PATH_MAX];
	struct stat estat;
	url *purl;


	if (!(dir = opendir(dirname)))
	{
		xperror(dirname);
		return;
	}

	iface_set_what(gettext("Searching for documents to synchronize"));

	while((dent = readdir(dir)))
	{
		_Xt_Serve

		sprintf(next_dir , "%s/%s" , dirname , dent->d_name);
		if (!strcmp(dent->d_name , ".")) continue;
		if (!strcmp(dent->d_name , "..")) continue;		
		if (stat(next_dir , &estat))
		{
			xperror(next_dir);
			continue;
		}

		if (S_ISDIR(estat.st_mode))
		{
                        if (!strcmp(dent->d_name , ".pavuk_info") && cfg.enable_info)
				continue;

			get_urls_to_synchronize(next_dir, list);
		}
		else if (!strncmp(".in_" , dent->d_name , 4))
		{
			xprintf(1 , gettext("Adding %s to sync list\n") , next_dir);
			sprintf(next_dir , "%s/%s" , dirname , dent->d_name + 4);
			if ((purl = filename_to_url(next_dir)))
			{
				/*
				append_url_to_list(purl);
				*/
				*list = dllist_prepend(*list, purl);
			}
		}
		else
		{
			if ((purl = filename_to_url(next_dir)))
			{
				xprintf(1 , gettext("Adding %s to sync list\n") , next_dir);
				/*
				append_url_to_list(purl);
				*/
				*list = dllist_prepend(*list, purl);
			}
		}

#ifdef I_FACE
		if (cfg.xi_face)
		{
			if (cfg.rbreak || cfg.stop)
			{
				closedir(dir);
				return;
			}
		}
#endif
	}

	closedir(dir);
}

