/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <errno.h>
#include <unistd.h>
#include <time.h>
#include <limits.h>
#include <pwd.h>
#include <signal.h>

#include "config.h"
#include "recurse.h"
#include "http.h"
#include "ftp.h"
#include "update_links.h"
#include "mode.h"
#include "url.h"
#include "dns.h"
#include "ainterface.h"
#include "times.h"
#include "schedule.h"
#include "dlhash_tools.h"
#include "nscache.h"
#include "log.h"
#include "authinfo.h"
#include "cookie.h"
#include "net.h"

#define STDOUT 	1

_config_struct cfg;

void pavuk_quit(signum)
int signum;
{
	printf(gettext("QUIT signal catched\n"));
#ifdef I_FACE
	cfg.xi_face = FALSE;
#endif
	cfg.rbreak = TRUE;
	cfg.stop = TRUE;
}

static void init_values(argc , argv)
int argc;
char **argv;
{
	char *d;
	int i;
	uid_t uid;
	time_t __time = time(NULL);
	char pom[PATH_MAX];
	struct hostent *hp = NULL;
	struct passwd *pwstruct;

	memset(&cfg, '\0' , sizeof(cfg));
	init_locale_env();

#ifdef _GTK_FEATURES_1_2
	cfg.path_to_home = new_string(g_get_home_dir());
#else
	cfg.path_to_home = new_string(getenv("HOME"));
#endif

#ifdef HAVE_TZSET
	tzset();
#endif

#ifdef I_FACE
	cfg.done = FALSE;
#endif
	cfg.prg_path = argv[0];
	cfg.urlstack = NULL;
	cfg.urls_in_dir = NULL;
	cfg.prepurlstr = NULL;
	cfg.total_cnt = 0;
	cfg.time = new_tm(localtime(& __time));
	cfg.time->tm_year += 1900;
	cfg.fail_cnt = 0;

	cfg_setup_default();

#ifdef GETTEXT_NLS
#ifdef GETTEXT_DEFAULT_CATALOG_DIR
	cfg.msgcatd = new_string(GETTEXT_DEFAULT_CATALOG_DIR);
#endif
#endif

	_INIT_NLS;

#ifdef SOCKS
#ifdef SOCKS5
	LIBPREFIX(init)(argv[0]);
#else
	SOCKSinit(argv[0]);
#endif
#endif

	cfg.url_hash_tbl = dlhash_new(HASH_TBL_SIZE , url_key_func , str_hash_func , str_comp_func);
	dlhash_set_free_func(cfg.url_hash_tbl, url_free_func , free);
	cfg.fn_hash_tbl = dlhash_new(HASH_TBL_SIZE , fn_key_func , str_hash_func , str_comp_func);
	dlhash_set_free_func(cfg.fn_hash_tbl, NULL , NULL);

	if (!(d = getenv("USER")))
	{
		uid = getuid();
		if ((pwstruct = getpwuid(uid)))
			d = new_string(pwstruct->pw_name);
	}
	else d = new_string(d);

	if (gethostname(pom,sizeof(pom)))  
	{
		perror("gethostname");
	}
	else
	{
		cfg.local_host = new_string(pom);
		hp = gethostbyname(pom);
	}

	if (hp)
	{
		if(d) sprintf(pom , "%s@%s" , d , hp->h_name);
		else sprintf(pom , "pavuk@%s" , hp->h_name);
	}
	else
	{
		if (d) sprintf(pom , "%s@unknown.sk" , d);
		else strcpy(pom , "pavuk@unknown.sk");
	}

	_free(d);
	cfg.from = new_string(pom);

	cfg_load_setup();

#ifdef I_FACE
	cfg.xi_face = FALSE;
	cfg.stop = FALSE;
	cfg.rbreak = FALSE;
	for (i = 1; i < argc ; i++)
	{
		/*** load preferences ***/
		if (!strcasecmp(argv[i] , "-prefs"))
			cfg.use_prefs = TRUE;
		else if (!strcasecmp(argv[i] , "-noprefs"))
			cfg.use_prefs = FALSE;
		/**** bude treba vytvorit interface X-windows ****/
		else if (!strcasecmp(argv[i] , "-X"))
			cfg.xi_face = TRUE;
	}
	if (cfg.use_prefs && cfg.xi_face)
		cfg_load_pref();
#endif

	_INIT_NLS;

/*** this parameters have to be resolved before each other ***/
	for (i = 1; i < argc ; i++)
	{
		if (!strcasecmp(argv[i] , "-scenario"))
		{
			i++;
			if (i < argc)
			{
				cfg.scenario = new_string(argv[i]);
			}
			else
			{
				printf(gettext("Not enough number of parameters \"-scenario\"\n"));
				usage(argv[0]);
			}
		}
		if (!strcasecmp(argv[i] , "-scndir"))
		{
			i++;
			if (i < argc)
			{
				cfg.scndir = new_string(argv[i]);
			}
			else
			{
				printf(gettext("Not enough number of parameters \"-scndir\"\n"));
				usage(argv[0]);
			}
		}
#ifdef I_FACE
		if (!strcasecmp(argv[i] , "-gui_font"))
		{
			i++;
			if (i < argc)
			{
				cfg.fontname = new_string(argv[i]);
			}
			else
			{
				printf(gettext("Not enough number of parameters \"-scenario\"\n"));
				usage(argv[0]);
			}
		}
#endif
#ifdef GETTEXT_NLS
		else if (!strcasecmp(argv[i] , "-msgcat"))
		{
			i++;
			if (i < argc)
			{
				cfg.msgcatd = new_string(argv[i]);
			}
			else
			{
				printf(gettext("Not enough number of parameters \"-msgcat\"\n"));
				usage(argv[0]);
			}
					
		}
		if (!strcasecmp(argv[i] , "-language"))
		{
			i++;
			if (i < argc)
			{
				cfg.language = new_string(argv[i]);
			}
			else
			{
				printf(gettext("Not enough number of parameters \"-scenario\"\n"));
				usage(argv[0]);
			}
		}
#endif
	}


	_INIT_NLS;

/*** load scenario if required ***/
	if (cfg.scenario)
	{
		if (!cfg.scndir)
		{
			printf(gettext("WARNING: Scenario \"%s\" can't be loaded - scenario dir not set\n") , cfg.scenario);
		}
		else
		{
			sprintf(pom , "%s/%s" , cfg.scndir , cfg.scenario);
			if (cfg_load(pom))
			{
				printf(gettext("WARNING: Scenario loading failed (%s)\n") , pom);
			}
		}
	}


	_INIT_NLS;

#ifdef I_FACE
	/**** ak treba vytvor xinterface ****/
	if (cfg.xi_face)
	{
		dns_serv_start();
		build_interface(&argc,argv);
	}
#endif

	cfg_setup_cmdln(argc , argv);

	cfg.local_ip_addr.s_addr = INADDR_ANY;
	if (cfg.local_ip)
	{
		if (net_host_to_in_addr(cfg.local_ip , &cfg.local_ip_addr))
		{
			xperror(cfg.local_ip);
		}
	}

	if (cfg.cache_dir)
	{
		d = cfg.cache_dir;
		cfg.cache_dir = get_abs_file_path(cfg.cache_dir);
		free(d);
	}
	else
	{
		getcwd(pom , sizeof(pom));
		cfg.cache_dir = new_string(pom);
	}

	if (cfg.subdir)
	{
		d = cfg.subdir;
		cfg.subdir = get_abs_file_path(cfg.subdir);
		free(d);
		if (tl_is_dirname(cfg.subdir))
			*(cfg.subdir + strlen(cfg.subdir) - 1) = '\0';
	}

	cfg.prev_mode = cfg.mode;

	if (cfg.save_scn)
	{
		if (cfg.scndir)
		{
			sprintf(pom , "%s/%s" , cfg.scndir , cfg.save_scn);
			cfg_dump(pom);
		}
		else
		{
			printf(gettext("WARNING: scndir not specified - saving to current directory\n"));
			cfg_dump(cfg.save_scn);
		}
		pavuk_do_at_exit();
		exit(0);
	}

	if (cfg.cookie_file)
		cookie_read_ns(cfg.cookie_file);

	if (cfg.auth_file)
		authinfo_load(cfg.auth_file);

	log_start(cfg.logfile);

#ifdef HAVE_DBOPEN
	if (cfg.ns_cache_dir)
		ns_cache_open_db(cfg.ns_cache_dir);
#endif

	if (!cfg.sched_cmd)
		cfg.sched_cmd = new_string(AT_CMD);

	if (cfg.schtime)
	{
		_free(cfg.time);
		cfg.time = new_tm(localtime(&cfg.schtime));
	}

	if (!cfg.index_name)
	{
		cfg.index_name = new_string("_._.html");
	}

	if (cfg.bgmode)
	{
		pid_t ppid;

		ppid = fork();
		if (ppid < 0)
		{
			xperror("fork");
			xprintf(1 , gettext("Unable to fork pavuk to background - running in foreground\n"));
		}
		else if (ppid != 0)
		{
			xprintf(0 , gettext("Pavuk will run at backround as PID %d\n") , ppid);
			_exit(0);
		}
	}
}

static void read_urls(filename)
char *filename;
{
	bufio *fd;
	char lnbuf[4096];
	int n;
	bool isstdin;


	isstdin = !strcmp(cfg.urls_file , "-");

	DEBUG_MISC(gettext("reading URLs from file - %s\n") , filename); 
	if (isstdin)
		fd = bufio_fdopen(0);
	else
		fd = bufio_open(filename , O_BINARY | O_RDONLY);

	if (!fd)
	{
		xperror(filename);
		return;
	}

	while((n = bufio_readln(fd , lnbuf , sizeof(lnbuf))) > 0)
	{
		strip_nl(lnbuf);
		if (!strcmp(lnbuf , ".")) break;

		cfg.prepurlstr = dllist_append(cfg.prepurlstr , new_string(lnbuf));
	}

	if (n < 0)
		xperror("reading stdin");

	if (isstdin)
		bufio_free(fd);
	else
		bufio_close(fd);
}

int main(argc , argv)
int argc;
char **argv;
{
	time_t __time = time(NULL);

	init_values(argc , argv);

	if (cfg.urls_file)
	{
		read_urls(cfg.urls_file);
		_free(cfg.urls_file);
	}

/**** spustenie algoritmu alebo rozhrania ****/
#ifdef I_FACE
	if (cfg.xi_face)
	{

		cfg.prev_mode = cfg.mode;
		cfg.mode_started = FALSE;

		iface_loop();
	}
	else
#endif
	{
		signal(SIGQUIT , pavuk_quit);
		signal(SIGPIPE , SIG_IGN);

		if (cfg.schtime)
		{
			cfg.schtime = (time_t)0;
			if (at_schedule())
			{
				xprintf(0 , gettext("Error scheduling\n"));
			}
		}
		else 
		{
			if (cfg.reschedh)
			{
				__time += 3600 * cfg.reschedh;
				_free(cfg.time);
				cfg.time = new_tm(localtime(&__time));
				at_schedule();
			}
			absi_restart();
		}
	}

	log_start(NULL);
	pavuk_do_at_exit();
	return cfg.fail_cnt;
}

