/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _lfname_h_
#define _lfname_h_

#ifdef HAVE_REGEX
#ifdef HAVE_REGEX_H
#include <regex.h>
#else
#ifdef HAVE_V8_REGEX
#ifndef NSUBEXP
#include <regexp.h>
#endif
#endif
#endif
#endif

#include "url.h"

typedef enum {
	LFNAME_UNKNOWN ,
#ifdef HAVE_REGEX
	LFNAME_REGEX ,
#endif
	LFNAME_FNMATCH ,
} lfname_type;

typedef struct {
	lfname_type	type;
#ifdef HAVE_POSIX_REGEX
	regex_t 	preg;
	regmatch_t	*pmatch;
#endif
#ifdef HAVE_V8_REGEX
	regexp		*preg;
#endif
#ifdef HAVE_GNU_REGEX
	struct re_pattern_buffer preg;
	struct re_registers pmatch;
#endif
	char		*matchstr;
	char		*transstr;
} lfname;

extern lfname *lfname_new(lfname_type , char * , char *);
extern void lfname_free(lfname *);
extern char *lfname_get_by_url(url * , char * , lfname *);
extern int lfname_match(lfname *, char *);
extern int lfname_check_pattern(lfname_type , char *);

#endif

