/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <utime.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#include "config.h"
#include "tools.h"
#include "url.h"
#include "doc.h"
#include "condition.h"
#include "html.h"
#include "css.h"
#include "ftp.h"
#include "re.h"
#include "errcode.h"

#define NARAZNIK	4096
#define MEXPAND(sv)	\
{\
	int psize = 100 + (sv) + html_doc->size + r - (p - html_doc->contents);\
	if (sz < psize)\
	{\
		sz = psize + NARAZNIK;\
		result = _realloc(result , sz);\
	}\
}

#define SEXPAND(sv)	\
	if ((ssz - (sr + (sv) + NARAZNIK)) < 0)\
	{\
		ssz += NARAZNIK + sv;\
		stack = _realloc(stack , ssz);\
	}

/************************************************************/
/* tabulka znamych znaciek a atributov ktore sa spracovavaju*/
/************************************************************/
html_tag linky[94] =
{
	{"HEAD" ,
		{{"PROFILE" , LINK_INLINE | LINK_DOWNLD} ,
		{NULL , 0}}},
	{"BODY" , 
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"TABLE" , 
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"TH" , 
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"TD" , 
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"IMG" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"LOWSRC" , LINK_INLINE | LINK_DOWNLD},
		 {"LONGDESC" , LINK_DOWNLD},
		 {"USEMAP" , LINK_DOWNLD | LINK_INLINE},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"INPUT" ,
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"USEMAP" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"FRAME" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"LONGDESC" , LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"IFRAME" , 
		{{"SRC" , LINK_DOWNLD},
		 {"LONGDESC" , LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"APPLET" , 
		{{"CODEBASE" , 0},
		 {"STYLE" , LINK_STYLE},
		 {NULL , 0}}},
	{"SCRIPT" , 
		{{"SRC" , LINK_SCRIPT | LINK_DOWNLD},
		 {NULL , 0}}},
	{"SOUND" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"BGSOUND" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"EMBED" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"AREA" , 
		{{"HREF" , LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"BASE" , 
		{{"HREF" , 0},
		 {NULL , LINK_REMOVE}}},
	{"FIG" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"OVERLAY" , 
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"A" , 
		{{"HREF", LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE},
		 {NULL , 0}}},
	{"LINK" , 
		{{"HREF" , LINK_DOWNLD | LINK_INLINE},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"FORM" , 
		{{"ACTION" , 0},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"LAYER" , 
		{{"SRC" , LINK_DOWNLD} ,
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"META" , 
		{{"CONTENT" , LINK_DOWNLD},
		 {NULL , 0}}},
	{"INS" , 
		{{"CITE" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"DEL" , 
		{{"CITE" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"Q" , 
		{{"CITE" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"SPAN" , 
		{{"HREF" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"DIV" , 
		{{"HREF" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"OBJECT" ,
		{{"DATA" , LINK_INLINE | LINK_DOWNLD},
		 {"USEMAP" , LINK_INLINE | LINK_DOWNLD} ,
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"LAYER" ,
		{{"SRC" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"ADDRESS" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"BLOCKQUTE" ,
		{{"CITE" , LINK_INLINE | LINK_DOWNLD},
		 {"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"CENTER" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H1" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H2" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H3" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H4" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H5" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"H6" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"HR" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"ISINDEX" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"P" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"PRE" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"NOSCRIPT" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"DIR" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"DL" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"DT" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"DD" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"LI" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"MENU" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"OL" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"UL" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"CAPTION" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"COLGROUP" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"COL" ,
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"THEAD" ,
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"TFOOT" ,
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"TBODY" ,
		{{"BACKGROUND" , LINK_INLINE |  LINK_DOWNLD} , 
		 {"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"FORM" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"FIELDSET" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"BUTTON" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"LEGEND" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"LABEL" ,
		{{"STYLE" , LINK_STYLE} ,
		{NULL , 0}}},
	{"SELECT" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"OPTGROUP" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"OPTION" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"TEXTAREA" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"BDO" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"BR" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"FONT" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"MAP" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"SUB" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"SUP" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"ABBR" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"ACRONYM" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"CITE" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"CODE" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"DFN" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"EM" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"KBD" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"SAMP" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"STRONG" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"VAR" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"B" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"BIG" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"I" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"S" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"SMALL" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"STRIKE" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"TT" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"U" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"FRAMESET" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"NOFRAMES" ,
		{{"STYLE" , LINK_STYLE} ,
		 {NULL , 0}}},
	{"CSOBJ" ,
		{{"HT" , LINK_INLINE | LINK_DOWNLD} ,
		 {NULL , 0}}},
};


/**** makro zistujuce ci znak je LWS ****/
#define IS_SEP(p) (((p) == '\n') || ((p) == ' ') || ((p) == '\t') || ((p) == '\r') || ((p) == '>'))

/**** deklaracie statickych funkcii ****/
#if NeedFunctionPrototypes
static void replace_url_in_stack(char *,char * , char * , int);
static int html_to_absolute_links(char **,doc *);
#else
static void replace_url_in_stack();
static int html_to_absolute_links();
#endif

/*******************************************************/
/* zo znacky vytiahne hodnodu specifikovaneho atributu */
/*******************************************************/
char *get_url_from_tag(tag,link_attrib)
char *tag;
char *link_attrib;
{
	char *p;
	char *retval = NULL;
	char *attrstart=NULL;
	char *attrend=NULL;
	int llen = strlen(link_attrib);
	bool was_sep = TRUE;

	for (p = tag ; *p ; p++)
	{
		if (was_sep && !attrstart && !strncasecmp(link_attrib , p , llen) && 
			(isspace(*(p+llen)) || (*(p+llen) == '=')))
		{
			attrstart = p+llen;

			while(*attrstart)
			{
				if (isspace(*attrstart) || (*attrstart == '='))
					attrstart++;
				else
					break;
			}
			if (*attrstart == '\"' || *attrstart == '\'')
			{
				if (!(attrend = strchr(attrstart+1 , *attrstart)))
					attrend = attrstart+strlen(attrstart);
				attrstart++;
			}
			else
			{
				attrend=attrstart;
				while(*attrend && !isspace(*attrend) &&
				      *attrend != '\"' && *attrend != '\'') attrend++;
			}
			break;
		}
		was_sep = isspace(*p) != 0;
		if (*p == '\"' || *p == '\'')
		{
			if (!(p = strchr(p+1 , *p)))
				break;
		}
	}
	if (attrstart)
	{ 
		retval = new_n_string(attrstart , attrend - attrstart);
		omit_chars(retval , "\t\n\r");
	}
	return retval;
}

/*** look if tag contains specified element ***/
static int tag_co_elem(tag , elem)
char *tag;
char *elem;
{
	char *p;
	int ilen;

	p = tag;	

	while(*p)
	{
		p += strcspn(p , "= \t\r\n");
		ilen = strspn(p , "= \t\r\n");

		if (ilen && !strncasecmp(p , elem , ilen))
			return TRUE;

		p += ilen;
	}

	return FALSE;
}

/****************************************************************/
/* V HTML dokumente najde vsetky podporovane URL splnajuce	*/
/* obmedzujuce podmienky					*/
/****************************************************************/ 
dllist *html_get_all_links(html_doc , only_inline , no_limits)
doc *html_doc;
int only_inline;
int no_limits;
{
	char *stack;
	int ssz,sr;
	char *p,*idx;
	char *psp;
	bool imgstart = FALSE;
	bool scriptstart = FALSE;
	bool commentstart = FALSE;
	bool stylestart = (bool)((html_doc->doc_url->status & URL_STYLE) != 0);
	dllist *retval = NULL;
	dllist *prev_a = NULL;
	url *purl;
	int i = 0 , j = 0;
	char *base,*baset;

	DEBUG_PROCS("html_get_all_links()");
	/**** nastavenie zakladneho URL dokumentu ****/

	baset = url_to_urlstr(html_doc->doc_url , FALSE);
	base = new_string(baset);
	if ((p = strrchr(baset, '#')))
		*p = '\0';
	DEBUG_HTML("BASE URL - %s\n", base);

	if ((p = strrchr(base, '?')))
		*p = '\0';
	if (!tl_is_dirname(base))
	{
		p = strrchr(base , '/');
		if (p) *(p + 1) = '\0';
	}

	ssz = 2 * NARAZNIK;
	sr = 0;
	stack = _malloc(ssz);

	/**** prechazame cely dokument po znakoch ****/
	for(p = html_doc->contents ; (p - html_doc->contents) < html_doc->size ; p++)
	{
		if (stylestart)
		{
			if (!strncasecmp(p , "</STYLE", 7) || (!*(p+1) && 
				((html_doc->doc_url->status & URL_STYLE) != 0)))
			{
				dllist *pv;

				stylestart = FALSE;
				stack[sr] = '\0';
				pv = css_get_all_links(html_doc , stack , base , baset , no_limits);
				retval = dllist_concat(retval , pv);

				continue;
			}

			stack[sr] = *p;
			sr++;
			SEXPAND(1);
			continue;
		}

		if (commentstart)
		{
			if (!strncmp(p , "-->" , 3))
				commentstart = FALSE;
			continue;
		}

		/**** zacina znacka ****/
		if (*p == '<')
		{
			imgstart = FALSE;

			if (!strncasecmp(p , "</A>" , 4))
				prev_a = NULL;

			if (!strncasecmp(p , "<STYLE" , 6))
			{
				stylestart = TRUE;
				continue;
			}

			if (!strncmp(p , "<!--" , 4))
			{
				commentstart = TRUE;
				continue;
			}

			if (scriptstart)
			{
				if (!strncasecmp(p , "</SCRIPT" , 8))
				{
					scriptstart = FALSE;
					continue;
				}
			}
			
			p++;

			/**** zisti ci je to niektora znacka z tabulky ****/
			for (i = 0 ; i < NUM_ELEM(linky) ; i++)
			{
				if (!strncasecmp(p , linky[i].tag , strlen(linky[i].tag)) 
					&& IS_SEP(*(p + strlen(linky[i].tag))))
				{
					p += strlen(linky[i].tag) - 1;
					sr = 0;
					imgstart = TRUE;
					break;
				}
			}

			sr = 0;
			if (imgstart) continue;
			p--;
		}
		/**** je koniec znacky ****/
		if (*p == '>' && imgstart)
		{
			/* zarad image */
			imgstart = FALSE;
			stack[sr] = '\0';

			if (!strcasecmp(linky[i].tag , "SCRIPT") &&
				!tag_co_elem(stack , "SRC"))
			{
				scriptstart = TRUE;
			}

			/**** vyber URL zo znacky ****/
			/* !!! inline !!! */
			for(j = 0 ; !scriptstart && linky[i].attribs[j].attrib ; j++)
			{
				if (linky[i].attribs[j].stat & LINK_DISABLED)
					continue;

				if (linky[i].attribs[j].stat & LINK_STYLE)
				{
					dllist *pv;

					stylestart = FALSE;
					stack[sr] = '\0';

					pv = css_get_all_links(html_doc , stack , base , baset , no_limits);

					retval = dllist_concat(retval , pv);

					continue;
				}

				psp = get_url_from_tag(stack,linky[i].attribs[j].attrib);

				if (psp)
				{
					/**** nove zakladne URL ****/
					if (!strcasecmp(linky[i].tag,"BASE") && 
					    !strcasecmp(linky[i].attribs[j].attrib,"HREF") && psp)
					{
						purl = parse_url(psp);

						if (!prottable[purl->type].supported)
						{
							xprintf(1, gettext_nop("Unsupported BASE URL -  %s (probably bad handled)\n"), psp);
							_free(base);
							base = new_string(psp);
						}
						else if ((purl->type == URLT_FILE) && 
							(html_doc->doc_url->type == URLT_HTTP ||
							 html_doc->doc_url->type == URLT_HTTPS ||
							 html_doc->doc_url->type == URLT_FTPS ||
							 html_doc->doc_url->type == URLT_FTP))
						{
							char *pom = _malloc(strlen(base) + strlen(purl->p.file.filename) + 2);

							if (*(purl->p.file.filename) == '/')
							{
								strcpy(pom , base);
								idx = strfindnchr(pom , '/' , 3);
								if (idx)
									strcpy(idx + 1 , 
										purl->p.file.filename );
								else
								{
									strcat(pom , "/");
									strcat(pom , 
										purl->p.file.filename );
								}
							}
							else
							{
				
								sprintf(pom , "%s%s" , base ,
									purl->p.file.filename);
							}
							free_deep_url(purl);
							free(purl);
							purl = parse_url(pom);
							_free(pom);
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}
						else
						{
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}
						if ((idx = strrchr(base, '?')))
							*idx = '\0';
						if (!tl_is_dirname(base))
						{
							idx = strrchr(base , '/');
							if (idx) *(idx+1) = '\0';
						}
						DEBUG_HTML("NEW BASE URL - %s\n", base);
						free_deep_url(purl);
						free(purl);
					}
					else if ((linky[i].attribs[j].stat & LINK_DOWNLD) &&
						 (!only_inline || (only_inline && linky[i].attribs[j].stat & LINK_INLINE)) &&
						 (!(linky[i].attribs[j].stat & LINK_SCRIPT) || (cfg.enable_js && (linky[i].attribs[j].stat & LINK_SCRIPT))))
					{
						char *pom = NULL;

						if (!strcmp(linky[i].tag, "META") && !strcmp(linky[i].attribs[j].attrib, "CONTENT"))
						{
							char *pp = get_url_from_tag(psp, "URL");
							if (pp)
							{
								pom = url_to_absolute_url(base , baset , html_doc->doc_url, pp);
								_free(pp);
							}
						}
						else
							pom = url_to_absolute_url(base , baset , 
								html_doc->doc_url , psp);

						if (!strcmp(linky[i].tag , "A") && 
							!strcmp(linky[i].attribs[j].attrib , "HREF"))
								prev_a = NULL;

						if (pom)
						{
							_free(psp);
							psp = pom;

							purl = parse_url(psp);
							purl->parent_url = (url **)_malloc(2 * sizeof(url *));
							purl->parent_url[0] = html_doc->doc_url;
							purl->parent_url[1] = NULL;
							purl->level = html_doc->doc_url->level + 1;
							if (linky[i].attribs[j].stat & LINK_INLINE) 
								purl->status |= URL_INLINE_OBJ;
							url_path_abs(purl);


							if ((cfg.mode == MODE_SYNC) && cfg.prepurlstr && (purl->type == URLT_FILE))
							{
								url *pomurl = filename_to_url(purl->p.file.filename);
								if (pomurl)
								{
									free_deep_url(purl);
									_free(purl);
									purl = pomurl;
								}
							}

							/**** previous URL refer to server side map 
							      (not handled) ****/
							if (prev_a && !strcasecmp(linky[i].tag,"IMG") &&
							    tag_co_elem(stack , "ISMAP"))
							{
								DEBUG_HTML("Removing server image map\n");
								free_deep_url((url *)prev_a->data);
								retval = dllist_remove_entry(retval , prev_a);
								prev_a = NULL;
							}

							/**** splna URL obmedzujuce podmienky ****/
							if (no_limits || url_append_condition(purl, 0))
							{
								DEBUG_HTML("Accepting URL - %s\n", psp);
								if (purl->type == URLT_FTP || purl->type == URLT_FTPS)
								{
									char *pext = get_url_from_tag(stack , "PAVUKEXT");

									if (pext)
									{
										purl->extension = ftp_parse_ftpinf_ext(pext);
										if (((ftp_url_extension *)purl->extension)->type == FTP_TYPE_D)
											purl->p.ftp.dir = TRUE;
										_free(pext);
									}
								}
								/**** pridanie do zoznamu ****/
								retval = dllist_append(retval , purl);
								if (!strcmp(linky[i].tag , "A") &&
									!strcmp(linky[i].attribs[j].attrib , "HREF"))
										prev_a = dllist_last(retval);
							}
							else
							{
								DEBUG_HTML("Rejecting URL - %s\n", psp);
								free_deep_url(purl);
								free(purl);
							}
						}
					}
					_free(psp);
				}
			}
			imgstart = FALSE;
			continue;
		}
		/**** vkladanie znakov na zasobnik ak bol zaciatok podporovanej znacky ****/
		if (imgstart)
		{
			stack[sr] = *p;
			sr++;
			SEXPAND(1);
		}
	}
	_Xt_Serve;

	free(base);
	free(baset);
	free(stack);
	DEBUG_PROCE("html_get_all_links()");
	return retval;
}

/************************************************/
/* spojenie dvoch zoznamov URL do jedneho 	*/
/************************************************/

void cat_links_to_url_list(l1)
dllist *l1;
{
	dllist *p = l1;
	url *same;
	dllist *reg = NULL,*inl = NULL;

	while (p)
	{
		if (url_append_condition((url *)p->data , 0))
		{
			url_clear_anchor((url *)p->data);
			if ((same = url_was_befor((url *)p->data)))
			{
				link_url_in_list(same , (url *)p->data);
				free_deep_url((url *)p->data);
				_free((url *)p->data);
			}
			else
			{
				cfg.total_cnt++;
				url_add_to_hash_tab((url*)p->data);
				switch (cfg.scheduling_strategie)
				{
					case SSTRAT_DO_SIRKY:
					case SSTRAT_DO_HLBKY:
						reg = dllist_append(reg , p->data);
					break;
					case SSTRAT_DO_SIRKY_I:
					case SSTRAT_DO_HLBKY_I:
						if (((url *)p->data)->status & URL_INLINE_OBJ)
							inl = dllist_append(inl , p->data);
						else
							reg = dllist_append(reg , p->data);
					break;
					default:
					break;
				}
			}
		}
		else
		{
			free_deep_url((url *)p->data);
			_free((url *)p->data);
		}

		p = p->next;
	}
	dllist_free_all(l1);

	LOCK_CFG_URLSTACK
	switch (cfg.scheduling_strategie)
	{
		case SSTRAT_DO_SIRKY:
		case SSTRAT_DO_SIRKY_I:
			if (reg || inl)
				append_url_list_to_list(
					dllist_concat(inl , reg) , NULL);
		break;
		case SSTRAT_DO_HLBKY:
		case SSTRAT_DO_HLBKY_I:
			if (reg || inl)
				append_url_list_to_list(
					dllist_concat(inl , reg) , cfg.urlstack);
		break;
		default:
		break;
	}
	UNLOCK_CFG_URLSTACK
}


/************************************************/
/* prepisanie hodnoty atributu znacky na mieste	*/
/*************************************i**********/
static void replace_url_in_stack(tag , link_attrib , urlin , pare)
char *tag;
char *link_attrib;
char *urlin;
int pare;
{
	char *pom;
	char *p;
	char *attrstart=NULL;
	char *pattrstart=NULL;
	char *attrend=NULL;
	int llen = strlen(link_attrib);
	bool was_sep = TRUE;

	for (p = tag ; *p ; p++)
	{
		if (was_sep && !attrstart && !strncasecmp(link_attrib , p , llen) && 
			(isspace(*(p+llen)) || (*(p+llen) == '=')))
		{
			pattrstart = attrstart = p+llen;

			while(*attrstart)
			{
				if (isspace(*attrstart) || (*attrstart == '='))
					attrstart++;
				else
					break;
			}
			if (*attrstart == '\"' || *attrstart == '\'')
			{
				if (!(attrend = strchr(attrstart+1 , *attrstart)))
					attrend = attrstart+strlen(attrstart);
				attrstart++;
			}
			else
			{
				attrend=attrstart;
				while(*attrend && !isspace(*attrend) &&
				      *attrend != '\"' && *attrend != '\'') attrend++;
			}
			break;
		}
		was_sep = isspace(*p) != 0;
		if (*p == '\"' || *p == '\'')
		{
			if (!(p = strchr(p+1 , *p)))
				break;
		}
	}
	if (attrstart)
	{ 
		pom = (*attrend == '\'' || *attrend == '\"') ? 
			new_string(attrend + 1) : new_string(attrend);

		if (!pare)
			strcpy(pattrstart , "=\"");
		else
			strcpy(pattrstart , "=");
		strcat(pattrstart , urlin);
		if (!pare)
			strcat(pattrstart , "\"");

		strcat(pattrstart , pom);
			
		_free(pom);
	}
	return;
}

/****************************************************************/
/* prepisanie relativnych URL v HTML dokumente na absolutne 	*/
/****************************************************************/
static int html_to_absolute_links(content , html_doc)
char **content;
doc *html_doc;
{
	char *stack;
	int ssz,sr;
	char *p;
	bool tagstart = FALSE;
	bool scriptstart = FALSE;
	bool commentstart = FALSE;
	bool stylestart = (bool)((html_doc->doc_url->status & URL_STYLE) != 0);
	char *result;
	int sz,r;
	url *purl;
	char *psp;
	int i = 0 , j = 0,l;
	char *base,*idx,*baset;
	bool is_adver;

	DEBUG_PROCS("html_to_absolute_links()");
	sz = html_doc->size + NARAZNIK;
	result = _malloc(sz);
	r = 0;

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	baset = url_to_urlstr(html_doc->doc_url , FALSE);
	base = new_string(baset);
	if ((p = strrchr(baset, '#')))
		*p = '\0';

	if ((p = strrchr(base, '?')))
		*p = '\0';
	if (!tl_is_dirname(base))
	{
		p = strrchr(base , '/');
		if (p) *(p + 1) = '\0';
	}

	for (p = html_doc->contents  ; (p - html_doc->contents) < html_doc->size ; p++)
	{
		if (stylestart)
		{
			if (!strncasecmp(p , "</STYLE", 7) || (!*(p+1) && 
				((html_doc->doc_url->status & URL_STYLE) != 0)))
			{
				stylestart = FALSE;

				stack[sr] = *p;
				stack[sr+1] = '\0';

				psp = css_to_absolute_links(html_doc , stack , base , baset);
				l = strlen(psp);
				MEXPAND(l);
				strcpy(result + r , psp);
				r += l;

				_free(psp);
				continue;
			}

			SEXPAND(1);
			stack[sr] = *p;
			sr++;
			
			continue;
		}


		if (commentstart)
		{
			if (!strncmp(p , "-->" , 3))
				commentstart = FALSE;
			
			result[r] = *p;
			r++;
			continue;
		}

		if (*p == '<')
		{
			if (tagstart)
			{
				stack[sr] = '\0';

				l = strlen(stack);
				MEXPAND(l);
				strcpy(result + r , stack);
				r += l;
			}

			tagstart = FALSE;

			if (!strncasecmp(p , "<STYLE" , 6))
			{
				stylestart = TRUE;
				sr = 0;
			}

			if (!strncmp(p , "<!--" , 4))
			{
				commentstart = TRUE;
			}

			if (scriptstart)
			{
				if (!strncasecmp(p , "</SCRIPT" , 8))
				{
					scriptstart = FALSE;
				}
			}

			p++;

			for (i = 0 ; i < NUM_ELEM(linky) ; i++)
			{
				if (!strncasecmp(p , linky[i].tag , strlen(linky[i].tag))
				 	&& IS_SEP(*(p + strlen(linky[i].tag))))
				{
					sr = 0;
					strcpy(stack , "<");
					sr++;
					l = strlen(linky[i].tag);
					strncpy(stack + sr , p , l);
					sr += l;
					p += l - 1;
					tagstart = TRUE;

					break;
				}
			}
			if (tagstart) continue;
			p--;
		}
		if (*p == '>' && tagstart)
		{
			stack[sr] = '\0';
			is_adver = FALSE;

			if (!strcasecmp(linky[i].tag , "SCRIPT") &&
				!tag_co_elem(stack , "SRC"))
			{
				scriptstart = TRUE;
			}

			for(j = 0 ; !scriptstart && linky[i].attribs[j].attrib ; j++)
			{

				psp = get_url_from_tag(stack,linky[i].attribs[j].attrib);

				if (psp)
				{
					if (linky[i].attribs[j].stat & LINK_STYLE)
					{
						char *stylestr;

						stylestr = css_to_absolute_links(html_doc , psp , base , baset);
						l = strlen(stylestr);
						SEXPAND(l);
						replace_url_in_stack(stack ,
							linky[i].attribs[j].attrib ,
							stylestr , FALSE);
						_free(stylestr);
						_free(psp);
						continue;
					}

					if (!strcasecmp(linky[i].tag,"BASE"))
					{
						purl = parse_url(psp);

						if (!prottable[purl->type].supported)
						{
							xprintf(1, gettext_nop("Unsupported BASE URL -  %s (probably bad handled)\n"), psp);
							_free(base);
							base = new_string(psp);
						}
						else if ((purl->type == URLT_FILE) && 
							(html_doc->doc_url->type == URLT_HTTP ||
							 html_doc->doc_url->type == URLT_HTTPS ||
							 html_doc->doc_url->type == URLT_FTPS ||
							 html_doc->doc_url->type == URLT_FTP))
						{
							char *pom = _malloc(strlen(base) + strlen(purl->p.file.filename) + 2);
	
							if (*(purl->p.file.filename) == '/')
							{
								strcpy(pom , base);
								idx = strfindnchr(pom , '/' , 3);
								if (idx)
									strcpy(idx , 
										purl->p.file.filename );
								else
								{
									strcat(pom , "/");
									strcat(pom , 
										purl->p.file.filename );
								}
							}
							else
							{
								sprintf(pom , "%s%s" , base ,
									purl->p.file.filename);
							}

							free_deep_url(purl);
							free(purl);
							purl = parse_url(pom);
							_free(pom);
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}
						else
						{
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}

						if ((idx = strrchr(base, '?')))
							*idx = '\0';
						if (!tl_is_dirname(base))
						{
							idx = strrchr(base , '/');
							if (idx) *(idx+1) = '\0';
						}
						free(psp);
						free_deep_url(purl);
						free(purl);
						strcpy(result + r , "<!-- ");
						while(result[r])r++;
						strcat(stack , "> --");
						
						continue;
					} 
					else
					{
						if (!strcmp(linky[i].tag, "META") && 
						    !strcmp(linky[i].attribs[j].attrib, "CONTENT"))
						{
							char *pom = get_url_from_tag(psp, "URL");
							if (pom)
							{
								char *pp = url_to_absolute_url(base , baset , html_doc->doc_url, pom);
								_free(pom);
								pom = _malloc(strlen(psp) + strlen(pp) + 1);
								strcpy(pom , psp);
								_free(psp);
								replace_url_in_stack(pom , "URL" , pp, TRUE);
								psp = pom;
							}
						}
						else
						{
							char *pom = url_to_absolute_url(base , baset , 
								html_doc->doc_url , psp);
					
							if (pom)
							{
								DEBUG_HTML("Rewriting URL - %s -> %s\n" , psp , pom);
								free(psp);
								psp = pom;
							}
						}

						l = strlen(psp);

						SEXPAND(l);
						replace_url_in_stack(stack ,
							linky[i].attribs[j].attrib , psp , FALSE);
#ifdef HAVE_REGEX
						if (cfg.remove_adv && cfg.advert_res)
						{
							dllist *ptr = cfg.advert_res;

							while(ptr)
							{
								if (re_pmatch((re_entry *)ptr->data , psp))
								{
									DEBUG_HTML("Removing advert URL - %s\n" , psp);
									is_adver = TRUE;
									break;
								}
								ptr = ptr->next;
							}
						}
#endif

						_free(psp);
					}
				}
			}

			if (is_adver)
			{
				strcpy(result + r , "adv<!-- Removed by pavuk ");
				r += 25;
			}
			l = strlen(stack);
			MEXPAND(l);
			strcpy(result + r , stack);
			r += l;
			if (result[r - 1] != '>') {result[r] = '>'; r++;}
			if (is_adver)
			{
				strcpy(result + r , " -->");
				r += 4;
			}
			tagstart = FALSE;
			continue;
		}
		if (tagstart)
		{
			stack[sr] = *p;
			sr++;
			SEXPAND(1);
		}else
		{
			result[r] = *p;
			r++;
		}
	}
	result[r] = '\0';
	free(stack);
	free(base);
	free(baset);
	*content = result;
	DEBUG_PROCE("html_to_absolute_links()");
	return (r);
}

/************************************************/
/* prepisanie relativnych  URL dokumentu 	*/
/************************************************/
void relocate_html_doc(docu)
doc *docu;
{
	int s;
	char *p;

	if (docu->doc_url->type != URLT_HTTP && 
#ifdef USE_SSL
	    docu->doc_url->type != URLT_HTTPS && 
	    docu->doc_url->type != URLT_FTPS && 
#endif
	    docu->doc_url->type != URLT_FTP &&
	    docu->doc_url->type != URLT_GOPHER) return;

	if ((docu->doc_url->status & URL_REDIRECT)) return;

	s = html_to_absolute_links(&p , docu);

	free(docu->contents);
	docu->contents = p;
	docu->size = s;

}


/****************************************************************/
/* prepisanie vzdialenych URL v HTML dokumente na lokalne	*/
/****************************************************************/
int html_remote_to_local_links(contentout , html_doc , all , sel)
char **contentout;
doc *html_doc;
int all;
int sel;
{
	char *stack;
	int ssz,sr;
	char pom[4096];
	char *p;
	int sz,r;
	bool tagstart = FALSE;
	bool commentstart = FALSE;
	bool scriptstart = FALSE;
	bool stylestart = (bool)((html_doc->doc_url->status & URL_STYLE) != 0);
	char *result;
	char *psp;
	int i=0,j=0,link_idx=0,l;
	char *act_name = url_to_filename(html_doc->doc_url , TRUE);
	char *anchor;
	char *base = NULL,*idx,*baset = NULL;

	DEBUG_PROCS("html_remote_to_local_links()");
	sz = NARAZNIK + html_doc->size;
	r = 0;
        result = _malloc(sz);

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	if (all || sel)
	{
		baset = url_to_urlstr(html_doc->doc_url , FALSE);
		base = new_string(baset);
		if ((p = strrchr(baset, '#')))
			*p = '\0';

		if ((p = strrchr(base, '?')))
			*p = '\0';
		if (!tl_is_dirname(base))
		{
			p = strrchr(base , '/');
			if (p) *(p + 1) = '\0';
		}
	}

	for (p = html_doc->contents  ; (p - html_doc->contents) < html_doc->size ; p++)
	{
		if (stylestart)
		{
			if (!strncasecmp(p , "</STYLE", 7) || (!*(p+1) && 
				((html_doc->doc_url->status & URL_STYLE) != 0)))
			{
				stylestart = FALSE;

				stack[sr] = *p;
				sr ++;
				stack[sr] = '\0';

				psp = css_remote_to_local_links(html_doc , stack , all , sel , base , baset);
				l = strlen(psp);
				MEXPAND(l);
				strcpy(result + r , psp);
				r += l;

				_free(psp);
				continue;
			}

			stack[sr] = *p;
			sr++;
			SEXPAND(1);

			continue;
		}

		if (commentstart)
		{
			if (!strncmp(p , "-->" , 3))
				commentstart = FALSE;
			
			result[r] = *p;
			r++;
			result[r] = '\0';
			continue;
		}

		if (*p == '<')
		{
			if (tagstart)
			{
				stack[sr] = '\0';

				l = strlen(stack);
				MEXPAND(l);
				strcpy(result + r , stack);
				r += l;
			}

			tagstart = FALSE;

			if (!strncasecmp(p , "<STYLE" , 6))
			{
				sr = 0;
				stylestart = TRUE;
			}

			if (!strncmp(p , "<!--" , 4))
			{
				commentstart = TRUE;
			}

			if (scriptstart)
			{
				if (!strncasecmp(p , "</SCRIPT" , 8))
				{
					scriptstart = FALSE;
				}
			}

			p++;

			for (i = 0 ; i < NUM_ELEM(linky) ; i++)
			{
				if (!strncasecmp(p , linky[i].tag , strlen(linky[i].tag))
				 	&& IS_SEP(*(p + strlen(linky[i].tag))))
				{
					strcpy(result + r , "<");
					l = strlen(linky[i].tag);
					strncpy(result + r + 1 , p ,l);

					MEXPAND(l);
					r += l + 1;

					p += l - 1;
					sr = 0;
					tagstart = TRUE;
					link_idx = i;
					break;
				}
			}
			if (tagstart) continue;

			p--;
		}
		if (*p == '>' && tagstart)
		{
			stack[sr] = '\0';

			if (!strcasecmp(linky[i].tag , "SCRIPT") &&
				!tag_co_elem(stack , "SRC"))
			{
				scriptstart = TRUE;
			}

			for(j = 0 ; !scriptstart && linky[link_idx].attribs[j].attrib ; j++)
			{
				psp = get_url_from_tag(stack,linky[link_idx].attribs[j].attrib);

				if (linky[link_idx].attribs[j].stat & LINK_STYLE)
				{

					if (psp)
					{
						char *stylestr;

						stylestr = css_remote_to_local_links(html_doc , psp , all , sel , base , baset);
						l = strlen(stylestr);
						SEXPAND(l);
						replace_url_in_stack(stack , 
							linky[link_idx].attribs[j].attrib ,
							stylestr , FALSE);
						_free(stylestr);
						_free(psp);
					}
					continue;
				}

				if (psp)
				{
					if (!strcasecmp(linky[i].tag,"BASE"))
					{
						url *purl = parse_url(psp);

						if (!prottable[purl->type].supported)
						{
							xprintf(1, gettext_nop("Unsupported BASE URL -  %s (probably bad handled)\n"), psp);
							_free(base);
							base = new_string(psp);
						}
						else if ((purl->type == URLT_FILE) && 
							(html_doc->doc_url->type == URLT_HTTP ||
							 html_doc->doc_url->type == URLT_HTTPS ||
							 html_doc->doc_url->type == URLT_FTPS ||
							 html_doc->doc_url->type == URLT_FTP))
						{
							if (*(purl->p.file.filename) == '/')
							{
								strcpy(pom , base);
								idx = strfindnchr(pom , '/' , 3);
								if (idx)
									strcpy(idx , 
										purl->p.file.filename );
								else
								{
									strcat(pom , "/");
									strcat(pom , 
										purl->p.file.filename );
								}
							}
							else
							{
								sprintf(pom , "%s%s" , base ,
									purl->p.file.filename);
							}

							free_deep_url(purl);
							free(purl);
							purl = parse_url(pom);
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}
						else
						{
							free(base);
							base = url_to_urlstr(purl , FALSE);
						}
						if ((idx = strrchr(base, '?')))
							*idx = '\0';
						if (!tl_is_dirname(base))
						{
							idx = strrchr(base , '/');
							if (idx) *(idx+1) = '\0';
						}
						free(psp);
						free_deep_url(purl);
						free(purl);
						strcpy(result + r - 5 , "<!-- BASE");
						while(result[r])r++;
						strcat(stack , " --");

						tagstart = FALSE;
						continue;
					} 
					else
					{
						char *metasave = NULL;
						url *urlp = NULL;
						url *purl;
						struct stat estat;
						char *fn;

						if (!strcmp(linky[i].tag, "META") &&
						    !strcmp(linky[i].attribs[j].attrib, "CONTENT"))
						{
							metasave = psp;
							psp = get_url_from_tag(psp, "URL");
						}
						if (psp)
						{
							urlp = parse_url(psp);
							if (all && urlp->type == URLT_FILE)
							{
								fn = url_to_absolute_url(base , baset ,
									html_doc->doc_url , psp);
								_free(psp);
								psp = fn;
								free_deep_url(urlp);
								_free(urlp);
								urlp = parse_url(psp);
							}
							anchor = url_get_anchor_name(urlp);

							/** for better performance with info files **/
							if ((purl = url_was_befor(urlp)))
								fn = url_to_filename(purl , TRUE);
							else
								fn = url_to_filename(urlp , FALSE);
	
							if (((all || (sel && purl)) && fn) || (!sel && 
								(((urlp->type != URLT_FILE) && fn && 
								((!access(fn , R_OK) && !stat(fn , &estat)) ||
								 !strcmp(act_name , fn))))))
							{
								if (all  || (sel && purl) ||
									(!sel && ((!access(fn , R_OK) && !S_ISDIR(estat.st_mode)) || !strcmp(act_name , fn))))
								{
									char *relfn = get_relative_path(act_name , fn);

									/* workaround for -sel_to_local && -nostore_index */
									if (sel && !cfg.store_index)
									{
										char *slp = strrchr(relfn , '/');
										if (!slp) slp = relfn;
										else slp++;
										if (!strcmp(slp , cfg.index_name)) *slp = '\0';
									}

									if (anchor)
										sprintf(pom,"%s#%s" , relfn , anchor);	
									else strcpy(pom,relfn);
									DEBUG_HTML("Rewriting URL - %s -> %s\n", psp , pom);
	
									free(relfn);
								}
								else if (!sel)
								{
									sprintf(pom , "%s/%s" , fn , cfg.index_name);
	
									if (!stat(pom , &estat) &&
										!S_ISDIR(estat.st_mode))
									{
										char *relfn = get_relative_path(act_name , pom);

										if (anchor)
											sprintf(pom,"%s#%s" , relfn , anchor);
										else strcpy(pom,relfn);

										free(relfn);
									}
									else
									{
										strcpy(pom , psp);
									}
									DEBUG_HTML("Rewriting URL - %s -> %s\n", psp , pom);
								}
								if (metasave)
								{
									if (psp)
									{
										psp = _malloc(strlen(metasave) + strlen(pom) + 1);
										strcpy(psp, metasave);
										_free(metasave);
										replace_url_in_stack(psp , "URL" , pom, TRUE);
										strcpy(pom, psp);
																				_free(psp);

									}
									else
									{
										strcpy(pom, metasave);
										_free(metasave);
									}
								}
								l = strlen(pom);
								SEXPAND(l);
								replace_url_in_stack(stack , 
									linky[link_idx].attribs[j].attrib , pom , FALSE);
							}
						}
						if (urlp) free_deep_url(urlp);
						_free(urlp);
					}
					_free(psp);
				}
			}
			l = strlen(stack);
			MEXPAND(l);
			strcpy(result + r ,  stack);
                        r += l;
			if (result[r - 1] != '>') {result[r] = '>'; r++;}

			tagstart = FALSE;
			continue;
		}
		if (tagstart)
		{
			stack[sr] = *p;
			sr++;
			SEXPAND(1);
		}else
		{
			result[r] = *p;
			r++;
		}
	}
	result[r] = '\0';
	_free(stack);
	*contentout = result;
	DEBUG_PROCE("html_remote_to_local_links()");
	return (r);
}

/********************************************************/
/* prepisanie specifickeho URL v HTML dokumente na ine	*/
/********************************************************/
static int html_change_url(contentout , html_doc , url_old , url_new)
char **contentout;
doc *html_doc;
url *url_old;
char *url_new;
{
	char *stack;
	int sr,ssz;
	char *oldfn,*pfn;
	char *p;
	int sz,r,i,j,l;
	int link_idx = 0;
	bool commentstart = FALSE;
	bool scriptstart = FALSE;
	bool tagstart = FALSE;
	bool stylestart = (bool)((html_doc->doc_url->status & URL_STYLE) != 0);
	char *result;
	char *psp;
	url *purl;
	char *anchor;

	DEBUG_PROCS("html_change_url()");
	sz = NARAZNIK + html_doc->size;
	r = 0;
        result = _malloc(sz);

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	oldfn = url_to_urlstr(url_old , FALSE);

	for (p = html_doc->contents  ; (p - html_doc->contents) < html_doc->size ; p++)
	{
		if (stylestart)
		{
			if (!strncasecmp(p , "</STYLE", 7) || (!*(p+1) && 
				((html_doc->doc_url->status & URL_STYLE) != 0)))
			{
				stylestart = FALSE;

				stack[sr] = *p;
				sr++;
				stack[sr] = '\0';

				psp = css_change_url(html_doc , stack ,  url_old , url_new);
				l = strlen(psp);
				MEXPAND(l);
				strcpy(result + r , psp);
				r += l;

				_free(psp);
				continue;
			}

			stack[sr] = *p;
			sr++;
			SEXPAND(1);
			
			continue;
		}

		if (commentstart)
		{
			if (!strncmp(p , "-->" , 3))
				commentstart = FALSE;
			
			result[r] = *p;
			r++;
			result[r] = '\0';
			continue;
		}

		if (*p == '<')
		{
			if (tagstart)
			{
				stack[sr] = '\0';
				l = strlen(stack);
				MEXPAND(l);
				strcpy(result + r , stack);
				r += l;
			}

			tagstart = FALSE;

			if (!strncasecmp(p , "<STYLE" , 6))
			{
				stylestart = TRUE;
			}

			if (!strncmp(p , "<!--" , 4))
			{
				commentstart = TRUE;
			}

			if (scriptstart)
			{
				if (!strncasecmp(p , "</SCRIPT" , 8))
				{
					scriptstart = FALSE;
				}
			}

			p++;

			for (i = 0 ; i < NUM_ELEM(linky) ; i++)
			{
				if (!strncasecmp(p , linky[i].tag , strlen(linky[i].tag))
				 	&& IS_SEP(*(p + strlen(linky[i].tag))))
				{
					strcpy(result + r , "<");
					l = strlen(linky[i].tag);
					strncpy(result + r + 1 , p , l);

					MEXPAND(l);
					r += l + 1;

					p += l - 1;
					sr = 0;
					tagstart = TRUE;
					link_idx = i;
					break;
				}
			}
			if (tagstart) continue;

			p--;
		}

		if (*p == '>' && tagstart)
		{
			stack[sr] = '\0';

			if (!strcasecmp(linky[i].tag , "SCRIPT") &&
				!tag_co_elem(stack , "SRC"))
			{
				scriptstart = TRUE;
			}

			for(j = 0 ; !scriptstart && linky[link_idx].attribs[j].attrib ; j++)
			{
				psp = get_url_from_tag(stack,linky[link_idx].attribs[j].attrib);
				if (psp)
				{
					char *metasave = NULL;

					if (linky[link_idx].attribs[j].stat & LINK_STYLE)
					{
						char *stylestr;

						stylestr = css_change_url(html_doc , psp ,  url_old , url_new);
						l = strlen(stylestr);
						SEXPAND(l);
						replace_url_in_stack(stack , 
							linky[link_idx].attribs[j].attrib ,
							stylestr , FALSE);

						_free(stylestr);
						continue;
					}

					if (!strcmp(linky[i].tag, "META") &&
					    !strcmp(linky[i].attribs[j].attrib, "CONTENT"))
					{
						metasave = psp;
						psp = get_url_from_tag(psp, "URL");
					}
					if (psp)
					{
					    pfn = NULL;
					    purl = parse_url(psp);
					    anchor = url_get_anchor_name(purl);

					    if (purl && (purl->type != URLT_FILE) && (pfn = url_to_urlstr(purl , FALSE)))
					    {
						if (!strcmp(pfn , oldfn))
						{
							char pom[4096];
							char *ppom;

							if (anchor)
							{
								sprintf(pom , "%s#%s" , url_new , anchor);
								ppom = pom;
							}
							else
								ppom = url_new;

							if (metasave)
							{
								char *pp = malloc(strlen(ppom) + strlen(metasave));
								strcpy(pp , metasave);
								replace_url_in_stack(pp , "URL" , ppom , TRUE);
								strcpy(pom , pp);
								_free(pp);
								ppom = pom;
							}
								
							l = strlen(ppom);
							SEXPAND(l);
							DEBUG_HTML("Rewriting URL - %s -> %s\n", psp , ppom);
							replace_url_in_stack(stack , 
								linky[link_idx].attribs[j].attrib , ppom , FALSE);
						}
					    }
					    free_deep_url(purl);
					    free(purl);
					    free(psp);
					    _free(pfn);
					}
					_free(metasave);
				}
			}
			l = strlen(stack);
                        MEXPAND(l);
                        strcpy(result + r ,  stack);
                        r += l;
			if (result[r - 1] != '>') {result[r] = '>'; r++;}
			tagstart = FALSE;
			continue;
		}
		if (tagstart)
		{
			stack[sr] = *p;
			sr++;
		}else
		{
			result[r] = *p;
			r++;
		}
	}
	result[r] = '\0';
	*contentout = result;
	free(stack);
	free(oldfn);
	DEBUG_PROCE("html_change_url()");
	return (r);
}


/****************************************************************/
/* nacitanie dokumentu z ktoreho bol URL referencovane ,	*/
/* prepisanie vzdialeneho odkazu na relativny lokalny a spatne	*/
/* ulozenie							*/
/****************************************************************/
void rewrite_one_parent_links(doc_url , parent_url , dst_name)
url *doc_url;
url *parent_url;
char *dst_name;
{
	char pom[PATH_MAX];
	char *fnamep;
	char *rfn;
	char *savetmp,*p;
	int sock,len;
	doc pdoc;
	char *newcont;
        struct stat estat;
	struct utimbuf ut;
	int perm;
        url dum;

	DEBUG_PROCS("rewrite_one_parent_links()");
	if (!parent_url || !(parent_url->status & URL_DOWNLOADED)) return;

	/*** parent document was not stored ***/
        if (!cfg.store_index && url_is_dir_index(parent_url)) return;

	fnamep = url_to_filename(parent_url , FALSE);
        if (stat(fnamep , &estat) == 0)
        {
                if (S_ISDIR(estat.st_mode))
                {
                        xprintf(1 , gettext("Can't work on directory\n"));
			return;
                }
        }
	else
	{
		xperror("stat");
		return;
	}

	perm = estat.st_mode;
	ut.actime = estat.st_atime;
	ut.modtime = estat.st_mtime;

	memset(&dum, 0, sizeof(url));
	dum.type = URLT_FILE;
	dum.p.file.filename = fnamep;
	dum.status &= ~URL_REDIRECT;
	doc_init(&pdoc, &dum);
	pdoc.report_size = FALSE;

	if (doc_download(&pdoc , TRUE , TRUE))
	{
		doc_remove_lock(&pdoc);
		if (pdoc.errcode) report_error(&pdoc , gettext("rewrite parent"));
		_free(dum.local_name);
		return;
	}

	if (pdoc.errcode) report_error(&pdoc , gettext("rewrite parent"));

	_free(pdoc.mime);

	if (dst_name)
	{
		if  (!access(dst_name , R_OK) && !stat(dst_name , &estat))
		{
			if (!S_ISDIR(estat.st_mode))
			{
				rfn = get_relative_path(fnamep , dst_name);

				len = html_change_url(&newcont , &pdoc , doc_url , rfn);

				free(rfn);

				free(pdoc.contents);

				pdoc.contents = newcont;
				pdoc.size = len;
			}
		}
	}

	len = html_remote_to_local_links(&newcont , &pdoc , FALSE , FALSE);

	strcpy(pom , fnamep);
	p = strrchr(pom , '/');
	if (p)
		sprintf(p + 1 , "_*%d" , getpid());
	else
		sprintf(pom , "%s/_*%d" ,pom , getpid());

	savetmp = new_string(pom);	
	rename(fnamep , savetmp);

	_free(dum.local_name);

	if ((sock = open(fnamep , O_BINARY | O_CREAT | O_TRUNC | O_WRONLY , S_IWUSR | S_IRUSR | S_IRGRP | S_IROTH)) < 0)
	{
		xperror(fnamep);
		rename(savetmp , fnamep);
		doc_remove_lock(&pdoc);
		free(savetmp);
		free(newcont);
		free(pdoc.contents);
		return;
	}
	if (write(sock , newcont , len) != len)
	{
		xperror(fnamep);
		close(sock);
		rename(savetmp , fnamep);
		doc_remove_lock(&pdoc);
		free(savetmp);
		free(newcont);
		free(pdoc.contents);
		return;
	}
	close(sock);
	doc_remove_lock(&pdoc);
	utime(fnamep , &ut);
	chmod(fnamep , perm);
	unlink(savetmp);
	free(savetmp);
	free(newcont);
	free(pdoc.contents);
	DEBUG_PROCE("rewrite_one_parent_links()");
}

void rewrite_parents_links(doc_url , dst_name)
url *doc_url;
char *dst_name;
{
	int i;
	char *fn = NULL;

	if ((doc_url->status & URL_MOVED) && !dst_name) return;
	
	for (i = 0; i < doc_url->ref_cnt ; i++)
	{
		if (!doc_url->parent_url[i]) continue;

		if (doc_url->parent_url[i]->status & URL_MOVED)
		{
			fn = dst_name ? dst_name : url_to_filename(doc_url , FALSE);

			rewrite_parents_links(doc_url->parent_url[i] , fn);
		}
		else
		{
			rewrite_one_parent_links(doc_url , doc_url->parent_url[i] , dst_name);
		}
	}
}

