/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>

#include "config.h"

#ifdef GTK_FACE

#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>

#include "gaccel.h"

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gtkscalendar.h"
#include "gtkmulticol.h"

#include "tools.h"
#include "uconfig.h"
#include "ainterface.h"
#include "ginterface.h"
#include "schedule.h"
#include "recurse.h"
#include "html.h"
#include "icons.h"
#include "lfname.h"
#include "log.h"
#include "stats.h"
#include "dns.h"

#include "lang.h"
#include "charset.h"
#include "mimetype.h"

#include "icons/configure.xpm"
#include "icons/gobg.xpm"
#include "icons/exit.xpm"
#include "icons/stop.xpm"
#include "icons/break.xpm"
#include "icons/continue.xpm"
#include "icons/restart.xpm"
#include "icons/break_small.xpm"
#include "icons/close_small.xpm"
#include "icons/continue_small.xpm"
#include "icons/maximize_small.xpm"
#include "icons/minimize_small.xpm"
#include "icons/restart_small.xpm"
#include "icons/stop_small.xpm"
#include "icons/ok.xpm"
#include "icons/cancel.xpm"
#include "icons/schedule.xpm"
#include "icons/append.xpm"
#include "icons/apply.xpm"
#include "icons/browse.xpm"
#include "icons/clear.xpm"
#include "icons/common.xpm"
#include "icons/delete.xpm"
#include "icons/limit.xpm"
#include "icons/modify.xpm"
#include "icons/save.xpm"

#include "pavuk_logo.xpm"

#ifndef MAX
#define MAX(x,y) ((x) > (y) ? (x) : (y))
#endif

#define PAVUK_ABOUT	0
#define PAVUK_CFGCOMM	1
#define PAVUK_CFGSCH	2
#define PAVUK_CFGLIM	3
#define PAVUK_TREE	4
#define PAVUK_SCNLD	5
#define PAVUK_SCNSV	6

typedef struct {
	GtkWidget *list;
	GtkWidget *entry;
} listanfo;

#define SET_LIST(w,l) \
{\
	char **p = l;\
	gtk_clist_freeze(GTK_CLIST(w));\
	gtk_clist_clear(GTK_CLIST(w));\
        if (p) while(*p)\
        {\
		gtk_clist_append(GTK_CLIST(w) , p);\
  		p++;\
	}\
	gtk_clist_thaw(GTK_CLIST(w));\
}

#ifndef _GTK_FEATURES_1_2
static char *en_month_names[] = {
	gettext_nop("January") ,
	gettext_nop("February") ,
	gettext_nop("March") ,
	gettext_nop("April") ,
	gettext_nop("May") ,
	gettext_nop("June") ,
	gettext_nop("July") ,
	gettext_nop("August") ,
	gettext_nop("September") ,
	gettext_nop("October") ,
	gettext_nop("November") ,
	gettext_nop("December")
};

static char *en_day_names[] = {
	gettext_nop("Sun") ,
	gettext_nop("Mon"),
	gettext_nop("Tue") ,
	gettext_nop("Wed") ,
	gettext_nop("Thu") ,
	gettext_nop("Fri") ,
	gettext_nop("Sat") ,
};
#endif /* _GTK_FEATURES_1_2 */

static void build_about(int);
static void build_config_comm(int);
static void build_config_sch(int);
static void build_config_lim(int);
static void build_tree_preview(int);
static void build_scenario_loader(int);
static void build_scenario_saver(int);
static GtkWidget *tab_add_entry(GtkWidget *, char *, guint, guint, guint);

extern char *get_strategie_label(int);
extern void gauthinfo_run();

static bool _restart_iface = TRUE;
static bool _go_bg = FALSE;
static char *last_lang = NULL;
static GtkWidget *main_window_hide = NULL;
static GtkWidget *mini_toolbar = NULL;

#ifdef _GTK_FEATURES_1_2
static GtkTargetEntry dragtypes[] = {
	{"STRING",                        0,      0},
	{"text/plain",                    0,      0},
	{"application/x-rootwin-drop",    0,      1}};
#endif


#ifndef _GTK_FEATURES_1_2
static char *strip_uline(str)
char *str;
{
	static char pom[512];
	char *p;

	for(p = pom ; *str ; str++)
	{
		if (*str != '_')
		{
			*p = *str;
			p++;
		}
	}

	*p = '\0';

	return pom;
}
#endif

#ifdef DEBUG
static void set_debug_level_mi()
{
	int i;
	GList *ch = GTK_MENU_SHELL(cfg.gtk.debug_level_m)->children;

	for (i = 0 ; cfg_debug_levels[i].id ; i++)
	{
		if (ch)
		{
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(ch->data) ,
				(cfg.debug_level & cfg_debug_levels[i].id) != 0);
			ch = ch->next;
		}
	}
}
#endif

#ifdef _GTK_FEATURES_1_2
/*** DROP SIGNAL HANDLER ***/
static void window_drop_url(widget , context , x , y , seldata , info , time , data)
GtkWidget *widget;
GdkDragContext *context;
gint x;
gint y;
GtkSelectionData *seldata;
guint info;
guint time;
gpointer data;
{
	gchar *p;
	gchar *drag_url;
	gchar *p_seldata;

	if (!seldata || !seldata->data) 
	{
		gtk_drag_finish(context, FALSE, FALSE, time);
		return;
	}

	p_seldata = (gchar *) seldata->data;

	/* strip away '\n' */
	p = strchr(p_seldata , '\n');
	if (p)
		drag_url = new_n_string(p_seldata , p - p_seldata); 	
	else
		drag_url = new_string(p_seldata);

	if (cfg.gtk.config_shell)
	{
		gtk_clist_append(GTK_CLIST(cfg.gtk.url_list) , &drag_url);
	}

	cfg.prepurlstr = dllist_append(cfg.prepurlstr, new_string(drag_url));

#ifdef DEBUG
	if (cfg.debug)
		xprintf(0 , gettext("Dropped URL : %s\n") , drag_url);
#endif

	_free(drag_url);

	gtk_drag_finish(context, TRUE, FALSE, time);
}

#endif

GtkWidget *menu_item(field)
gchar *field;
{
#ifndef _GTK_FEATURES_1_2
	return gtk_menu_item_new_with_label(strip_uline(field));
#else
	GtkWidget *item,*label;
	guint accelerator_key;
 
	item = gtk_menu_item_new();

	label = gtk_accel_label_new(field);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_container_add(GTK_CONTAINER(item) , label);
	gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(label), item);
	gtk_widget_show(label);

	accelerator_key = 
		gtk_label_parse_uline(GTK_LABEL(label), field);

	if (accelerator_key != GDK_VoidSymbol)
	{
		gtk_widget_add_accelerator(item,
			"activate_item",
			cfg.gtk.accel_group,
			accelerator_key,
			GDK_MOD1_MASK,
			GTK_ACCEL_LOCKED);
	}

	return item;
#endif
}

gint no_destroy(widget , event , data)
GtkWidget *widget;
GdkEvent *event;
gpointer data;
{
	if (!_go_bg)
	{
		gtk_widget_hide(GTK_WIDGET(data));
		return (TRUE);
	} 
	else return (FALSE);
}


Icon *load_pmap(pmap)
char **pmap;
{
	GdkWindow *win = GTK_WIDGET(cfg.gtk.toplevel)->window;
	Icon *icon = malloc(sizeof(Icon));

	icon->pixmap = gdk_pixmap_create_from_xpm_d(win , &icon->shape , NULL , pmap);

	return icon;
}

GtkWidget *pixmap_button(pm , alticon , label)
char **pm;
char *alticon;
char *label;
{
	GtkWidget *btn;
	GtkWidget *pixmap=NULL;
	Icon *icon;

	btn = gtk_button_new();

	if (alticon)
	{
		GdkPixmap *pm;
		GdkBitmap *mask;

		pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(cfg.gtk.toplevel)->window , &mask , NULL , alticon);

		if (pm)
		{
			pixmap = gtk_pixmap_new(pm , mask);
		}
	}
	if (!pixmap)
	{
		icon = load_pmap(pm);

		pixmap = gtk_pixmap_new(icon->pixmap , icon->shape);
		_free(icon);
	}

	if (label)
	{
		GtkWidget *box;
		GtkWidget *lbl;

		box = gtk_hbox_new(FALSE , 1);
		gtk_container_add(GTK_CONTAINER(btn) , box);
		gtk_widget_show(box);

		gtk_box_pack_start(GTK_BOX(box) , pixmap , TRUE , TRUE , 0);
		gtk_misc_set_alignment(GTK_MISC(pixmap) , 1.0 , 0.5);
		gtk_widget_show(pixmap);

		lbl = gtk_label_new(label);
		gtk_misc_set_alignment(GTK_MISC(lbl) , 0.0 , 0.5);
		gtk_box_pack_start(GTK_BOX(box) , lbl , TRUE , TRUE , 0);
		gtk_widget_show(lbl);
		
	}
	else
	{
		gtk_container_add(GTK_CONTAINER(btn) , pixmap);
		gtk_widget_show(pixmap);
	}

	return btn;
}

static void DeMiniaturize(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_hide(GTK_WIDGET(mini_toolbar));
	gtk_widget_show(GTK_WIDGET(main_window_hide));

}

static void Miniaturize(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_window_set_policy(GTK_WINDOW(cfg.gtk.toplevel) ,
		FALSE , TRUE , TRUE);
	gtk_widget_show(GTK_WIDGET(mini_toolbar));
	gtk_widget_hide(GTK_WIDGET(main_window_hide));

	_Xt_Serve
}

static void ResetCfg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	cfg_setup_default();

	cfg.xi_face = TRUE;

	if (cfg.gtk.cfg_limits)
		xset_cfg_values_lim();
	if (cfg.gtk.config_shell)
		xset_cfg_values_comm();

	if (cfg.use_prefs)
		cfg_dump_pref();
}

static void Save_rc(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char pom[PATH_MAX];

	sprintf(pom , "%s/.pavukrc" , cfg.path_to_home);
	cfg_dump(pom);
}

#ifdef GETTEXT_NLS
static void ChangeLang(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (!cfg.done) return;

	if (last_lang && func_data && !strcmp(last_lang , func_data)) return;
	else if (!last_lang && !func_data) return;

	if (!func_data)
		unsetenv("LC_MESSAGES");
	
	cfg.language = (char *)func_data;
	_INIT_NLS

	_free(last_lang);
	last_lang = new_string((char *)func_data);

	_restart_iface = TRUE;
	gtk_main_quit();
}
#endif

static void PopdownW(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *w = (GtkWidget *) func_data;

	gtk_widget_hide(w);
}

static void CfgLimits(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (!xget_cfg_values_lim())
	{
		if (cfg.use_prefs)
			cfg_dump_pref();
	}
}

static void CfgCommon(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (!xget_cfg_values_comm())
	{
		if (cfg.use_prefs)
			cfg_dump_pref();
	}
}

static void PopdownWC(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *w = (GtkWidget *) func_data;
	int rv = 0;

	if (w == cfg.gtk.cfg_limits)
		rv = xget_cfg_values_lim();
	if (w == cfg.gtk.config_shell)
		rv = xget_cfg_values_comm();

	if (!rv)
	{
		gtk_widget_hide(w);
		if (cfg.use_prefs)
			cfg_dump_pref();
	}
	else
		gdk_beep();
}

static void PopupW(object , func_data)
GtkObject *object;
gpointer func_data;
{
	int which = (int) func_data;

	switch (which)
	{
	    case PAVUK_ABOUT:
		build_about(TRUE);
		break;
	    case PAVUK_CFGCOMM:
		build_config_comm(TRUE);
		xset_cfg_values_comm();
		break;
	    case PAVUK_CFGSCH:
		build_config_sch(TRUE);
	    	{
	    		time_t t = time(NULL);
	    		struct tm *ltime = localtime(&t);

			ltime->tm_year += 1900;

#ifdef _GTK_FEATURES_1_2
			gtk_calendar_select_month(GTK_CALENDAR(cfg.gtk.calendar) , ltime->tm_mon , ltime->tm_year);
			gtk_calendar_select_day(GTK_CALENDAR(cfg.gtk.calendar) , ltime->tm_mday);
#else
	    		gtk_scalendar_set_date(GTK_SCALENDAR(cfg.gtk.calendar) , 
	    			ltime->tm_mday , ltime->tm_mon , ltime->tm_year);

	    		gtk_option_menu_set_history(GTK_OPTION_MENU(cfg.gtk.month_combo) ,
	    			ltime->tm_mon);

	    		gtk_spin_button_set_value(GTK_SPIN_BUTTON(cfg.gtk.year_label) , (gfloat)ltime->tm_year);
#endif /* _GTK_FEATURES_1_2 */

			gtk_spin_button_set_value(GTK_SPIN_BUTTON(cfg.gtk.hour_label) , (gfloat)ltime->tm_hour);
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(cfg.gtk.min_label) , (gfloat)ltime->tm_min);
			gtk_entry_set_text(GTK_ENTRY(cfg.gtk.sched_cmd) , cfg.sched_cmd);
	    	}
		break;
	    case PAVUK_CFGLIM:
		build_config_lim(TRUE);
		xset_cfg_values_lim();
		break;
	    case PAVUK_TREE:
		build_tree_preview(TRUE);
		break;
	    case PAVUK_SCNLD:
		build_scenario_loader(TRUE);
		break;
	    case PAVUK_SCNSV:
		build_scenario_saver(TRUE);
		break;
	    default:
		xprintf(1 , gettext("Unknown window to popup"));
	}
}

static void ClearLog(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_clear(GTK_CLIST(cfg.gtk.logw));
}

static void ListDeleteSelected(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *w = (GtkWidget *)func_data;

	gtk_clist_freeze(GTK_CLIST(w));

	if(GTK_CLIST(w)->selection)
	{
		gtk_clist_remove(GTK_CLIST(w) , 
			GPOINTER_TO_INT(GTK_CLIST(w)->selection->data));
	}

	gtk_clist_thaw(GTK_CLIST(w));
}

static void ListInsertEntry(object , func_data)
GtkObject *object;
gpointer func_data;
{
	listanfo *lnfo = (listanfo *)func_data;
	char *p;

	p = gtk_entry_get_text(GTK_ENTRY(lnfo->entry));

	if (p && *p)
	{
		gtk_clist_append(GTK_CLIST(lnfo->list) , &p);
	}
	else gdk_beep();
}

static void ListModifyEntry(object , func_data)
GtkObject *object;
gpointer func_data;
{
	listanfo *lnfo = (listanfo *)func_data;
	char *p;

	p = gtk_entry_get_text(GTK_ENTRY(lnfo->entry));

	if (p && *p && GTK_CLIST(lnfo->list)->selection)
	{
		int row = GPOINTER_TO_INT(GTK_CLIST(lnfo->list)->selection->data);
		gtk_clist_set_text(GTK_CLIST(lnfo->list) , row , 0 , p);
	}
	else gdk_beep();
}

static void ListClear(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_freeze(GTK_CLIST(func_data));
	gtk_clist_clear(GTK_CLIST(func_data));
	gtk_clist_thaw(GTK_CLIST(func_data));
}

static void ListCopyToEntry(object , row , col , event , func_data)
GtkObject *object;
int row;
int col;
GdkEvent *event;
gpointer func_data;
{
	GtkWidget *entry = (GtkWidget *)func_data;
	char *p = NULL;

	if (GTK_CLIST(object)->selection)
	{
		gtk_clist_get_text(GTK_CLIST(object) , row , 0 , &p); 
	}

	if (p && entry) gtk_entry_set_text(GTK_ENTRY(entry) , p);
}

static void ListInsertList(object , func_data)
GtkObject *object;
gpointer func_data;
{
	listanfo *lnfo = (listanfo *)func_data;
	GList *dlist = GTK_CLIST(lnfo->entry)->selection;
	char *p;

	if (!dlist) gdk_beep();

        while(dlist)
        {
		gtk_clist_get_text(GTK_CLIST(lnfo->entry) ,
			GPOINTER_TO_INT(dlist->data), 0 , &p); 

		gtk_clist_append(GTK_CLIST(lnfo->list) , &p);
                dlist = dlist->next;
        }
}

static void LangListInsertList(object , func_data)
GtkObject *object;
gpointer func_data;
{
	listanfo *lnfo = (listanfo *)func_data;
	GList *dlist = GTK_CLIST(lnfo->entry)->selection;
	char *p;
	char pom[3] = {'\0','\0','\0'};

	if (!dlist) gdk_beep();

        while(dlist)
        {
		gtk_clist_get_text(GTK_CLIST(lnfo->entry) ,
			GPOINTER_TO_INT(dlist->data), 0 , &p); 

		strncpy(pom , p , 2);
		p = pom;
		gtk_clist_append(GTK_CLIST(lnfo->list) , &p);
                dlist = dlist->next;
        }

}

static void ToggleBool(object , func_data)
GtkObject *object;
gpointer func_data;
{
	bool *v = (bool *) func_data;

	if (GTK_IS_CHECK_MENU_ITEM(object))
		*v = GTK_CHECK_MENU_ITEM(object)->active;

	if (GTK_IS_TOGGLE_BUTTON(object) || GTK_IS_CHECK_BUTTON(object))
		*v = GTK_TOGGLE_BUTTON(object)->active;
}

static void AppendURLCB(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *p = gtk_entry_get_text(GTK_ENTRY(func_data));

	if (!p || !*p)
	{
		gdk_beep();
		return;
	}

	if (cfg.gtk.config_shell)
	{
		gtk_clist_append(GTK_CLIST(cfg.gtk.url_list) , &p);
	}
	cfg.prepurlstr = dllist_append(cfg.prepurlstr, new_string(p));

	if (cfg.mode_started)
	{
		if (!append_starting_url(p))
		{
			gdk_beep();
		}
	}
	gtk_entry_select_region(GTK_ENTRY(func_data) , 0 , strlen(p));
}

static void AppendURL(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *append_url_tl = NULL;

	if (!append_url_tl)
	{
		GtkWidget *label,*box,*ptab,*button,*entry;

		append_url_tl = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(append_url_tl), gettext("Pavuk: Append URL"));
		gtk_signal_connect(GTK_OBJECT(append_url_tl), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &append_url_tl);

		box = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(append_url_tl), box);
		gtk_widget_show(box);

		ptab = gtk_hbox_new(FALSE, 5);
		gtk_box_pack_start(GTK_BOX(box), ptab, TRUE , TRUE , 2);
		gtk_widget_show(ptab);

		label = gtk_label_new(gettext("New URL:"));
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_box_pack_start(GTK_BOX(ptab), label, FALSE , FALSE, 2);
		gtk_widget_show(label);

		entry = gtk_entry_new();
		gtk_box_pack_start(GTK_BOX(ptab), entry, TRUE , TRUE, 2);
		gtk_signal_connect(GTK_OBJECT(entry) , "activate" , 
			GTK_SIGNAL_FUNC(AppendURLCB) , 
			(gpointer)entry);
		gtk_widget_show(entry);

		label = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(box), label, TRUE , TRUE , 2);
		gtk_widget_show(label);

		ptab = gtk_hbutton_box_new();
		gtk_box_pack_start(GTK_BOX(box), ptab, FALSE , FALSE, 2);
		gtk_widget_show(ptab);

		button = pixmap_button(append_xpm , NULL , gettext("Append"));
		gtk_container_add(GTK_CONTAINER(ptab), button);
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(AppendURLCB) , 
			(gpointer)entry);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		gtk_widget_show(button);

		button = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
#ifdef _GTK_FEATURES_1_2
{
		GtkAccelGroup *accel_group;
		accel_group = gtk_accel_group_new();

		gtk_widget_add_accelerator(button , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

		gtk_window_add_accel_group(GTK_WINDOW(append_url_tl) , accel_group);
}
#endif
		gtk_container_add(GTK_CONTAINER(ptab), button);
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)append_url_tl);
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_show(button);
	}
	gtk_widget_show(append_url_tl);
	if (GTK_WIDGET_REALIZED(append_url_tl))
		gdk_window_raise(append_url_tl->window);
}

static void OpenURL(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_notebook_set_page(GTK_NOTEBOOK(cfg.gtk.cb_comcfg) , 0);
}

static void FetchURL(widget, selection_data, data)
GtkWidget *widget;
GtkSelectionData *selection_data;
gpointer data;
{
	char *p,*cb_url;

	if (selection_data->length <= 0)
	{
		gdk_beep();
		return;
	}

	p = strchr(selection_data->data , '\n');

	if (p)
		cb_url = new_n_string(selection_data->data , p - (char *)selection_data->data); 	
	else
		cb_url = new_n_string(selection_data->data , selection_data->length);

	if (cfg.gtk.config_shell)
	{
		gtk_clist_append(GTK_CLIST(cfg.gtk.url_list) , &cb_url);
	}

	cfg.prepurlstr = dllist_append(cfg.prepurlstr, new_string(cb_url));

#ifdef DEBUG
	if (cfg.debug)
		xprintf(0 , gettext("Fetched URL from clipboard : %s\n") , cb_url);
#endif

	_free(cb_url);
}

static void FetchCBUrl(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GdkAtom atom;

	atom = gdk_atom_intern ("TEXT", FALSE);

	gtk_selection_convert(GTK_WIDGET(object), GDK_SELECTION_PRIMARY, atom, 
		GDK_CURRENT_TIME);
}

static void Quit(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (!_go_bg && !_restart_iface)
	{
		if (cfg.use_prefs)
			cfg_dump_pref();

		gaccel_save_keys();

		pavuk_do_at_exit();
        	gtk_exit(0);
	}
}

static void SwitchMode(object , func_data)
GtkObject *object;
gpointer func_data;
{
	cfg.mode = (int) func_data;

	if (cfg.done && cfg.mode_started)
	{
		if (cfg.mode != cfg.prev_mode)
		{
			gtk_widget_set_sensitive(cfg.gtk.bt_start , FALSE);
			gtk_widget_set_sensitive(cfg.gtk.mea_start , FALSE);
			gtk_widget_set_sensitive(cfg.gtk.mtb_start , FALSE);
		}
		else
		{
			gtk_widget_set_sensitive(cfg.gtk.bt_start,TRUE);
			gtk_widget_set_sensitive(cfg.gtk.mea_start,TRUE);
			gtk_widget_set_sensitive(cfg.gtk.mtb_start,TRUE);
		}
	}
}

static void Start(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (cfg.processing)
	{
		gdk_beep();
		return;
	}

	gtk_widget_set_sensitive(cfg.gtk.bt_rest,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_rest,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_rest,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.bt_start,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_start,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_start,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.bt_stop,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mea_stop,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_stop,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.bt_break,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mea_break,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_break,TRUE);

#ifdef WITH_TREE
	gtk_label_set(GTK_LABEL(cfg.gtk.tree_help) , "");
#endif

	cfg.processing = TRUE;
	
	if (func_data || cfg.mode != cfg.prev_mode || !cfg.mode_started)
	{
		absi_restart();
	}
	else
	{
		absi_cont();
	}

	cfg.processing = FALSE;

	gdk_beep ();

	gtk_widget_set_sensitive(cfg.gtk.bt_rest,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mea_rest,TRUE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_rest,TRUE);
	if (cfg.urlstack)
	{
		gtk_widget_set_sensitive(cfg.gtk.bt_start,TRUE);
		gtk_widget_set_sensitive(cfg.gtk.mea_start,TRUE);
		gtk_widget_set_sensitive(cfg.gtk.mtb_start,TRUE);
	}
	gtk_widget_set_sensitive(cfg.gtk.bt_stop,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_stop,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_stop,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.bt_break,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_break,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mtb_break,FALSE);

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;
}

static void Stop(object , func_data)
GtkObject *object;
gpointer func_data;
{
	cfg.stop = TRUE;
}

static void Break(object , func_data)
GtkObject *object;
gpointer func_data;
{
	cfg.rbreak = TRUE;
	cfg.stop = TRUE;
	errno = EINTR;

	_X_EscLoop();
}

static void Gobg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	cfg.stop = TRUE;
	_go_bg = TRUE;

	if (cfg.use_prefs)
		cfg_dump_pref();

	gaccel_save_keys();

	gtk_main_quit();
}

#ifdef WITH_TREE

#ifdef _GTK_FEATURES_1_2
#define TREE_GET_URL ((url *) gtk_ctree_node_get_row_data(GTK_CTREE(cfg.gtk.tree_widget) ,\
	 (GtkCTreeNode *)(GTK_CLIST(cfg.gtk.tree_widget)->selection->data)))
#define TEST_URL_NODE (GTK_CLIST(cfg.gtk.tree_widget)->selection && TREE_GET_URL)
#else
#define TREE_GET_URL ((url *) gtk_object_get_user_data(GTK_OBJECT(cfg.gtk.selected_node)))
#define TEST_URL_NODE (cfg.gtk.selected_node && TREE_GET_URL)
#endif

void SelectTreeNode(object , func_data)
GtkObject *object;
gpointer func_data;
{
#ifndef _GTK_FEATURES_1_2
	GList* selected_list = GTK_TREE_SELECTION(GTK_TREE(object));
	
	cfg.gtk.selected_node = selected_list ? GTK_WIDGET(selected_list->data) : NULL;
#endif

	gtk_label_set(GTK_LABEL(cfg.gtk.tree_help) , " ");	
}

static void LaunchBrowser(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char pom[2048];
	char *p;
	url *urlp;

	if (!cfg.browser || !TEST_URL_NODE)
	{
		gdk_beep();
		return;
	}

	urlp = TREE_GET_URL;

	p = new_string(url_to_filename(urlp , TRUE));

	if (access(p,R_OK))
	{
		free(p);
		p = url_to_urlstr(urlp , FALSE);
	}

	sprintf(pom , "%s %s &" , cfg.browser , p);
	system(pom);

	free(p);
}

static void Propert(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char pom[4096];
	url_prop *prp;
	url *urlp;
	char *p;
	char *p1;

	if (!TEST_URL_NODE)
	{
		gdk_beep();
		return;
	}

	urlp = TREE_GET_URL;

	prp = urlp->prop;

	p = url_to_urlstr(urlp , FALSE);
	sprintf(pom, gettext("URL: %s\n"), p);
	_free(p);
	p = g_strdup(pom);

	p1 = g_strconcat(p , gettext("Status: ") , NULL);
	_free(p);
	p = p1;

	if (!(urlp->status & URL_PROCESSED))
	{
		p1 = g_strconcat(p , gettext("not processed yet\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_INNSCACHE)
	{
		p1 = g_strconcat(p , gettext("loaded from NS cache\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_REDIRECT)
	{
		p1 = g_strconcat(p , gettext("loaded from local URL tree\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_MOVED)
	{
		p1 = g_strconcat(p , gettext("moved to another URL\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_NOT_FOUND)
	{
		p1 = g_strconcat(p , gettext("URL not found on remote server\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_TRUNCATED)
	{
		p1 = g_strconcat(p , gettext("truncated\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_DOWNLOADED)
	{
		p1 = g_strconcat(p , gettext("downloaded OK\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_REJECTED)
	{
		p1 = g_strconcat(p , gettext("rejected by rules\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_USER_DISABLED)
	{
		p1 = g_strconcat(p , gettext("disabled by user\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_ERR_REC)
	{
		p1 = g_strconcat(p , gettext("probably recoverable error\n") , NULL);
		_free(p);
		p = p1;
	}
	else if (urlp->status & URL_ERR_UNREC)
	{
		p1 = g_strconcat(p , gettext("unrecoverable error\n") , NULL);
		_free(p);
		p = p1;
	}
	else
	{
		p1 = g_strconcat(p , gettext("unknown\n") , NULL);
		_free(p);
		p = p1;
	}


	if (urlp->moved_to)
	{
		char *ps = url_to_urlstr(urlp->moved_to , FALSE);

		sprintf(pom, gettext("Moved to URL: %s\n"), ps);
		_free(ps);
		p1 = g_strconcat(p , pom , NULL);
		_free(p);
		p = p1;
	}

	if (prp)
	{
		if (prp->type)
			sprintf(pom , gettext("Type: %s\n"), gettext(prp->type));
		else
			sprintf(pom , gettext("Type: unknown\n"));

		p1 = g_strconcat(p , pom , NULL);
		_free(p);
		p = p1;

		sprintf(pom , gettext("Size: %d\n") , prp->size);
		p1 = g_strconcat(p , pom , NULL);
		_free(p);
		p = p1;

		if (prp->mdtm)
		{
			struct tm *lt = localtime(&prp->mdtm);
			strftime(pom, sizeof(pom), 
				gettext("Modification time: %a, %d %b %Y %H:%M:%S %Z\n") , lt);
			p1 = g_strconcat(p , pom , NULL);
			_free(p);
			p = p1;
		}
	}

	if (urlp->local_name)
	{
		sprintf(pom , gettext("Local filename: %s\n"), urlp->local_name);
		p1 = g_strconcat(p , pom , NULL);
		_free(p);
		p = p1;
	}

	if (urlp->ref_cnt)
	{
		int i;
		char *us;

		p1 = g_strconcat(p , gettext("Parent URLs:\n") , NULL);
		_free(p);
		p = p1;
		for(i = 0; i < urlp->ref_cnt ; i++)
		{
			if (urlp->parent_url[i])
			{
				us = url_to_urlstr(urlp->parent_url[i], FALSE);
				sprintf(pom , "      %s\n" , us);
				free(us);
				p1 = g_strconcat(p , pom , NULL);
				_free(p);
				p = p1;
			}
		}
	}

	if (!p) p = "";

	gtk_label_set(GTK_LABEL(cfg.gtk.tree_help) , p);
	g_free(p);
}

void item_set_disabled(widget , disabled)
#ifdef _GTK_FEATURES_1_2
GtkCTreeNode *widget;
#else
GtkWidget *widget ;
#endif
gboolean disabled;
{
	static GtkStyle* disabled_style = NULL;
	static GtkStyle* normal_style = NULL;
#ifndef _GTK_FEATURES_1_2
	GtkWidget *pom;
	GList *chlist;
#endif
	if (!disabled_style)
	{
#ifdef _GTK_FEATURES_1_2
		normal_style = gtk_ctree_node_get_cell_style(
				GTK_CTREE(cfg.gtk.tree_widget), widget, 0);
		if (!normal_style) normal_style =
			gtk_widget_get_style(cfg.gtk.tree_widget);
#else
		normal_style = gtk_widget_get_style(widget);
#endif
		disabled_style = normal_style ? gtk_style_copy(normal_style) :
				gtk_style_new();

		disabled_style->fg[GTK_STATE_NORMAL] = 
			disabled_style->fg[GTK_STATE_INSENSITIVE];
		disabled_style->bg[GTK_STATE_NORMAL] = 
			disabled_style->bg[GTK_STATE_INSENSITIVE];
		disabled_style->base[GTK_STATE_NORMAL] = 
			disabled_style->base[GTK_STATE_INSENSITIVE];
	}

#ifdef _GTK_FEATURES_1_2
	gtk_ctree_node_set_cell_style(GTK_CTREE(cfg.gtk.tree_widget), widget, 0,
		disabled ? disabled_style : normal_style);
#else
	gtk_widget_set_style(widget ,
		disabled ? disabled_style : normal_style);

	pom = GTK_BIN(widget)->child;

	for (chlist = GTK_BOX(pom)->children ; chlist ; chlist = chlist->next)
	{
		pom = ((struct _GtkBoxChild *)chlist->data)->widget;
		gtk_widget_set_style(pom ,
			disabled ? disabled_style : normal_style);
	}
#endif
}


static void DisableURL(object , func_data)
GtkObject *object;
gpointer func_data;
{
	url *urlp;
	int i;

	if (!TEST_URL_NODE)
	{
		gdk_beep();
		return;
	}

	urlp = TREE_GET_URL;

	urlp->status |= URL_USER_DISABLED;

	for (i = 0 ; i < urlp->ref_cnt ; i++)
		item_set_disabled(urlp->tree_nfo[i] , TRUE);
}

static void EnableURL(object , func_data)
GtkObject *object;
gpointer func_data;
{
	url *urlp;
	int i;

	if (!TEST_URL_NODE)
	{
		gdk_beep();
		return;
	}

	urlp = TREE_GET_URL;

	urlp->status &= ~URL_USER_DISABLED;

	for (i = 0 ; i < urlp->ref_cnt ; i++)
		item_set_disabled(urlp->tree_nfo[i] , FALSE);

	if (urlp->status & URL_PROCESSED)
	{
		urlp->status &= ~URL_PROCESSED;

		LOCK_CFG_URLSTACK
		cfg.urlstack = dllist_append(cfg.urlstack, urlp);
		cfg.total_cnt++;
		UNLOCK_CFG_URLSTACK
	}
}

static void DownloadThisURL(object , func_data)
GtkObject *object;
gpointer func_data;
{
	url *urlp;
	doc docu;
	global_connection_info con_info;

	if (!TEST_URL_NODE || cfg.processing)
	{
		gdk_beep();
		return;
	}

	urlp = TREE_GET_URL;

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;

	cfg.processing = TRUE;

	doc_init(&docu, urlp);
	process_document(&docu , FALSE);

	init_global_connection_data(&con_info);
	save_global_connection_data(&con_info, &docu);
	kill_global_connection_data(&con_info);

	cfg.processing = FALSE;

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;

	iface_set_what("Done");
}

static gint tree_list_events (widget , event)
GtkWidget *widget;
GdkEvent  *event;
{
	GdkEventButton *bevent;
	url *urlp;

#ifndef _GTK_FEATURES_1_2
	GtkWidget *event_widget;

	event_widget = gtk_get_event_widget (event);

	if (!GTK_IS_TREE_ITEM(event_widget)) return FALSE;
#endif

	if (!TEST_URL_NODE) return FALSE;

	switch (event->type)
	{
	    case GDK_BUTTON_PRESS:
		bevent = (GdkEventButton *) event;
		if (bevent->button == 3)
		{
			urlp = TREE_GET_URL;

			if (!urlp)
			{
				gtk_widget_set_sensitive(cfg.gtk.me_disable_url , FALSE);
				gtk_widget_set_sensitive(cfg.gtk.me_enable_url , FALSE);
				gtk_widget_set_sensitive(cfg.gtk.me_browse_url , FALSE);
				gtk_widget_set_sensitive(cfg.gtk.me_prop_url , FALSE);
				gtk_widget_set_sensitive(cfg.gtk.me_download_url , FALSE);
			}
			else
			{
				gtk_widget_set_sensitive(cfg.gtk.me_browse_url , TRUE);
				gtk_widget_set_sensitive(cfg.gtk.me_prop_url , TRUE);

				if (urlp->status & URL_PROCESSED && !(urlp->status & URL_USER_DISABLED))
				{
					gtk_widget_set_sensitive(cfg.gtk.me_disable_url , FALSE);
					gtk_widget_set_sensitive(cfg.gtk.me_enable_url , FALSE);
					gtk_widget_set_sensitive(cfg.gtk.me_download_url ,
						(urlp->status & URL_REJECTED) || 
						(urlp->status & URL_TRUNCATED) ||
						(urlp->status & URL_ERR_REC));
				}
				else
				{
					gtk_widget_set_sensitive(cfg.gtk.me_disable_url , 
						!(urlp->status & URL_USER_DISABLED));
					gtk_widget_set_sensitive(cfg.gtk.me_enable_url , 
						(urlp->status & URL_USER_DISABLED));
					gtk_widget_set_sensitive(cfg.gtk.me_download_url ,
						cfg.processing ? FALSE :
						!(urlp->status & URL_USER_DISABLED));
				}
			}
			gtk_menu_popup(GTK_MENU(cfg.gtk.tmenu), NULL, NULL, NULL, NULL, 3, bevent->time);
		}
		break;
	    default:
		break;
	}

	return FALSE;
}

#endif /* WITH_TREE */

static void build_about(popup)
int popup;
{
	GtkWidget *col,*button,*frame,*label,*pixmap,*row;
	static Icon *icon = NULL;
	char pom[1024];

	if (cfg.gtk.about_shell)
	{
		if (popup)
		{
			gtk_widget_show_all(cfg.gtk.about_shell);
			if (GTK_WIDGET_REALIZED(cfg.gtk.about_shell))
				gdk_window_raise(cfg.gtk.about_shell->window);
		}
		return;
	}


	cfg.gtk.about_shell = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(cfg.gtk.about_shell) , gettext("Pavuk: About"));
	gtk_container_border_width(GTK_CONTAINER(cfg.gtk.about_shell) , 3);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.about_shell), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.about_shell);

	col = gtk_vbox_new(0 , 5);
	gtk_container_add(GTK_CONTAINER(cfg.gtk.about_shell), col);
	gtk_widget_show(col);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_container_add(GTK_CONTAINER(col), frame);

	row = gtk_hbox_new(0 ,10);
	gtk_widget_show(row);
	gtk_container_add(GTK_CONTAINER(frame) , row);

	if (!icon) icon = load_pmap(pavuk_logo_xpm);
	pixmap = gtk_pixmap_new(icon->pixmap , icon->shape);
	gtk_container_add(GTK_CONTAINER(row) , pixmap);
	gtk_widget_show(pixmap);

	sprintf(pom , gettext("Pavuk %s\n \nan automatic WEB file grabber\n \nBy Stefan Ondrejicka\n \n(ondrej@idata.sk)\n \nURL : http://www.idata.sk/~ondrej/pavuk/\n ") , VERSION);

	label = gtk_label_new (pom);
	gtk_misc_set_padding(GTK_MISC(label) , 15 , 15);
	gtk_container_add(GTK_CONTAINER(row), label);
	gtk_widget_show(label);

	button = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
	gtk_container_add(GTK_CONTAINER(col), button);
#ifdef _GTK_FEATURES_1_2
{
	GtkAccelGroup *accel_group;
	accel_group = gtk_accel_group_new();

	gtk_widget_add_accelerator(button , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

	gtk_window_add_accel_group(GTK_WINDOW(cfg.gtk.about_shell) , accel_group);
}
#endif
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)cfg.gtk.about_shell);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);


	if (popup) gtk_widget_show(cfg.gtk.about_shell);

}

#ifdef _GTK_FEATURES_1_2
static void toolbar_set(object , data)
GtkObject *object;
gpointer data;
{
	gtk_toolbar_set_style(GTK_TOOLBAR(cfg.gtk.toolbar) , 
			(GtkToolbarStyle)data);

	gtk_widget_queue_resize(GTK_WIDGET(cfg.gtk.toolbar)->parent);
}

static void toolbar_onoff(object , data)
GtkObject *object;
gpointer data;
{
	GtkWidget *w;

	w = GTK_WIDGET(cfg.gtk.toolbar)->parent;

	if (GTK_WIDGET_VISIBLE(w))
		gtk_widget_hide(w);
	else
		gtk_widget_show(w);
}

#endif

#ifdef DEBUG
static void switch_debug_level(w , data)
GtkWidget *w;
gpointer data;
{
	int dl = (int) data;

	if (GTK_CHECK_MENU_ITEM(w)->active)
		cfg.debug_level |= dl;
	else
		cfg.debug_level &= ~dl;
}

static void toggle_debug(w , data)
GtkWidget *w;
gpointer data;
{
	cfg.debug = GTK_CHECK_MENU_ITEM(w)->active;

	gtk_widget_set_sensitive(cfg.gtk.debug_level_mi , cfg.debug);
	gtk_widget_set_sensitive(cfg.gtk.debug_level_m , cfg.debug);
}

static void set_debug_level(w , data)
GtkWidget *w;
gpointer data;
{
	int l = (int) data;
	cfg.debug_level = l;
	set_debug_level_mi();
}

#endif

static void build_menu(parent)
GtkWidget *parent;
{
	GtkWidget *mbar,*menu,*mbb,*mi,*hbox , *lbox;
	GSList *rg;
	GtkWidget *smenu, *button;
	int i;

	lbox = gtk_hbox_new(FALSE, 1);
	gtk_widget_show(lbox);

	button = pixmap_button(minimize_small_xpm , cfg.gtk.bt_icon_mtb , NULL);
	gtk_box_pack_end(GTK_BOX(lbox) , button , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(Miniaturize), 
		(gpointer) parent);
	gtk_widget_show(button);

	mbar = gtk_menu_bar_new();
	gtk_box_pack_start(GTK_BOX(lbox) , mbar , TRUE , TRUE , 1);
	gtk_widget_show (mbar);

#ifdef _GTK_FEATURES_1_2
	cfg.gtk.accel_group = gtk_accel_group_new ();

	hbox = gtk_handle_box_new ();
	gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(hbox) , GTK_SHADOW_NONE);
	gtk_box_pack_start(GTK_BOX(parent) , hbox , FALSE , TRUE , 0);
	gtk_widget_show(hbox);
	gtk_container_add (GTK_CONTAINER (hbox), lbox);
#else
	gtk_box_pack_start(GTK_BOX(parent) , lbox , FALSE , TRUE , 1);
#endif


/*** FILE MENU ***/

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);
#endif

	mi = menu_item(gettext("Open _URL ..."));
	gaccel_bind_widget("file/open_url" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGCOMM);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(OpenURL) , 
			(gpointer)NULL);

	mi = menu_item(gettext("Append URL ..."));
	gaccel_bind_widget("file/open_url" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(AppendURL) , 
			(gpointer)NULL);

	mi = menu_item(gettext("Fetch URL from Clipboard"));
	gaccel_bind_widget("file/fetch_url" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" ,
			GTK_SIGNAL_FUNC(FetchCBUrl) ,
			(gpointer)NULL);
	gtk_signal_connect(GTK_OBJECT(mi), "selection_received",
			GTK_SIGNAL_FUNC(FetchURL), 
			(gpointer)NULL);

	mi = menu_item(gettext("Schedule ..."));
	gaccel_bind_widget("file/schedule" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGSCH);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	mi = menu_item(gettext("Load scenario ..."));
	gaccel_bind_widget("file/load_scn" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_SCNLD);

	mi = menu_item(gettext("Save scenario ..."));
	gaccel_bind_widget("file/save_scn" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_SCNSV);

	mi = menu_item(gettext("Save settings to ~/.pavukrc"));
	gaccel_bind_widget("file/save_pavukrc" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Save_rc) , 
			(gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	mi = menu_item(gettext("Auth. info editor ..."));
	gaccel_bind_widget("file/auth_edit" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(gauthinfo_run) , 
			(gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	mi = menu_item(gettext("E_xit"));
	gaccel_bind_widget("file/exit" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Quit) , 
			(gpointer)NULL);

	mbb = menu_item(gettext("_File"));
	gtk_widget_show(mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

/*** VIEW MENU ***/
	menu = gtk_menu_new();
	gtk_widget_realize(menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif

#ifdef WITH_TREE
	mi = menu_item(gettext("Document _Tree ..."));
	gaccel_bind_widget("view/doc_tree" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_TREE);
#endif

	mi = menu_item(gettext("Status page ..."));
	gaccel_bind_widget("view/status_page" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(stats_show), (gpointer)NULL);

	mi = menu_item(gettext("Clear log window"));
	gaccel_bind_widget("view/clear_log" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(ClearLog) , 
			(gpointer)NULL);

	mbb = menu_item(gettext("_View"));
	gtk_widget_show(mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

/*** MODE MENU ***/

	menu = gtk_menu_new();
	gtk_widget_realize(menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif

	rg = NULL;

	mi = gtk_radio_menu_item_new_with_label(rg , gettext("normal recurse"));
	gaccel_bind_widget("mode/normal_recurse" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_NORMAL);
	cfg.gtk.modegr[MODE_NORMAL] = mi;

	mi = gtk_radio_menu_item_new_with_label(rg , gettext("synchronize"));
	gaccel_bind_widget("mode/synchronize" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_SYNC);
	cfg.gtk.modegr[MODE_SYNC] = mi;


	mi = gtk_radio_menu_item_new_with_label(rg , gettext("single page"));
	gaccel_bind_widget("mode/single_page" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_SINGLE);
	cfg.gtk.modegr[MODE_SINGLE] = mi;

	mi = gtk_radio_menu_item_new_with_label(rg , gettext("update local links"));
	gaccel_bind_widget("mode/update_local" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_LNUPD);
	cfg.gtk.modegr[MODE_LNUPD] = mi;

	mi = gtk_radio_menu_item_new_with_label(rg , gettext("resume files"));
	gaccel_bind_widget("mode/resume_files" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_RESUME);
	cfg.gtk.modegr[MODE_RESUME] = mi;

	mi = gtk_radio_menu_item_new_with_label(rg , gettext("unlimited reget"));
	gaccel_bind_widget("mode/unlimited_reget" , "toggle" , mi, NULL);
	rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)MODE_SREGET);
	cfg.gtk.modegr[MODE_SREGET] = mi;

        mi = gtk_radio_menu_item_new_with_label(rg , gettext("transfer but don't store"));
	gaccel_bind_widget("mode/nostore" , "toggle" , mi, NULL);
        rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
        gtk_menu_append(GTK_MENU(menu) , mi);
        gtk_widget_show(mi);
        gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
                        GTK_SIGNAL_FUNC(SwitchMode) , 
                        (gpointer)MODE_NOSTORE);
        cfg.gtk.modegr[MODE_NOSTORE] = mi;

        mi = gtk_radio_menu_item_new_with_label(rg , gettext("reminder"));
	gaccel_bind_widget("mode/reminder" , "toggle" , mi, NULL);
        rg = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM(mi));
        gtk_menu_append(GTK_MENU(menu) , mi);
        gtk_widget_show (mi);
        gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
                        GTK_SIGNAL_FUNC(SwitchMode) , 
                        (gpointer)MODE_REMIND);
        cfg.gtk.modegr[MODE_REMIND] = mi;

        mi = gtk_radio_menu_item_new_with_label(rg , gettext("list ftp directory"));
	gaccel_bind_widget("mode/ftpdir" , "toggle" , mi, NULL);
        rg = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM(mi));
        gtk_menu_append(GTK_MENU(menu) , mi);
        gtk_widget_show (mi);
        gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
                        GTK_SIGNAL_FUNC(SwitchMode) , 
                        (gpointer)MODE_FTPDIR);
        cfg.gtk.modegr[MODE_FTPDIR] = mi;

	mbb = menu_item(gettext("_Mode"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(cfg.gtk.modegr[cfg.mode]) , TRUE);

/*** CONFIG MENU ***/

	cfg.gtk.cfg_menu = menu = gtk_menu_new();
	gtk_widget_realize(menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif

	mi = menu_item(gettext("C_ommon ..."));
	gaccel_bind_widget("config/common_cfg" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGCOMM);

	mi = menu_item(gettext("_Limitations ..."));
	gaccel_bind_widget("config/limit_cfg" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGLIM);

	mi = menu_item(gettext("Reset configuration"));
	gaccel_bind_widget("config/reset_cfg" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(ResetCfg) , 
			(gpointer)NULL);

#ifdef _GTK_FEATURES_1_2
/*** toolbar menu ***/
	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	mi = menu_item(gettext("Toolbar"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	smenu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi), smenu);
	gtk_widget_show(menu);

	mi = menu_item(gettext("Toggle toolbar"));
	gaccel_bind_widget("config/tb_toggle" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(smenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			(GtkSignalFunc) toolbar_onoff,
			(gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(smenu) , mi);
	gtk_widget_show(mi);

	rg = NULL;

#define TBSET_ME(label , tb_style)\
	mi = gtk_radio_menu_item_new_with_label(rg , gettext(label));\
	rg = gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (mi));\
	gtk_menu_append(GTK_MENU(smenu) , mi);\
	gtk_widget_show (mi);\
	gtk_signal_connect(GTK_OBJECT(mi), "activate",\
			(GtkSignalFunc) toolbar_set,\
			(gpointer)tb_style);

	TBSET_ME(gettext_nop("Both") , GTK_TOOLBAR_BOTH);
	gaccel_bind_widget("config/tb_both" , "activate" , mi, NULL);
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , TRUE);
	TBSET_ME(gettext_nop("Icons only") , GTK_TOOLBAR_ICONS);
	gaccel_bind_widget("config/tb_icons" , "activate" , mi, NULL);
	TBSET_ME(gettext_nop("Text only") , GTK_TOOLBAR_TEXT);
	gaccel_bind_widget("config/tb_text" , "activate" , mi, NULL);
/*** toolbar menu end ***/
#endif

#ifdef GETTEXT_NLS
{
	static char **al = NULL;

	if (al || (al = get_available_languages()))
	{
		mi = gtk_menu_item_new();
		gtk_menu_append(GTK_MENU(menu) , mi);
		gtk_widget_show(mi);

		mi = gtk_menu_item_new_with_label(gettext("Language"));
		gtk_menu_append(GTK_MENU(menu) , mi);
		gtk_widget_show(mi);

		smenu = gtk_menu_new();
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi), smenu);

		rg = NULL;
		mi = gtk_radio_menu_item_new_with_label(rg , "en");
		gaccel_bind_widget("lang/en" , "activate" , mi, NULL);
		rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
		gtk_menu_append(GTK_MENU(smenu) , mi);
		gtk_widget_show(mi);
		if (!last_lang)
		{
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , TRUE);
		}

		gtk_signal_connect(GTK_OBJECT(mi) , "activate" ,
			GTK_SIGNAL_FUNC(ChangeLang) ,
			(gpointer)"C");

		for (i = 0; al[i] ; i++)
		{
			gchar idstr[256];

			mi = gtk_radio_menu_item_new_with_label(rg , al[i]);
			sprintf(idstr , "lang/%s" , al[i]);
			gaccel_bind_widget(idstr , "activate" , mi, NULL);
			rg = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi));
			gtk_menu_append(GTK_MENU(smenu) , mi);
			gtk_widget_show(mi);
			if (last_lang && !strcmp(al[i] , last_lang))
			{
				gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , TRUE);
			}

			gtk_signal_connect(GTK_OBJECT(mi) , "activate" ,
				GTK_SIGNAL_FUNC(ChangeLang) ,
				(gpointer)al[i]);
		}
	}
}
#endif

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

#ifdef DEBUG
	cfg.gtk.debug_level_mi = mi = menu_item(gettext("Debug level"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_widget_set_sensitive(mi, cfg.debug);

	cfg.gtk.debug_level_m = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi), cfg.gtk.debug_level_m);

	for(i = 0; cfg_debug_levels[i].id ; i++)
	{
		mi = gtk_check_menu_item_new_with_label(gettext(cfg_debug_levels[i].label));
		gtk_menu_append(GTK_MENU(cfg.gtk.debug_level_m) , mi);
		gtk_widget_show(mi);
		gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(switch_debug_level),
			(gpointer)cfg_debug_levels[i].id);
	}
	set_debug_level_mi();

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(cfg.gtk.debug_level_m) , mi);
	gtk_widget_show(mi);

	mi = gtk_menu_item_new_with_label(gettext("All"));
	gtk_menu_append(GTK_MENU(cfg.gtk.debug_level_m) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(set_debug_level),
			(gpointer)0xffffffff);

	mi = gtk_menu_item_new_with_label(gettext("None"));
	gtk_menu_append(GTK_MENU(cfg.gtk.debug_level_m) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi), "activate",
			GTK_SIGNAL_FUNC(set_debug_level),
			(gpointer)0);

	cfg.gtk.me_debug = mi = gtk_check_menu_item_new_with_label(gettext("Debug"));
	gaccel_bind_widget("config/debug" , "toggle" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(toggle_debug) , 
			(gpointer)&cfg.debug);

	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , cfg.debug);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif


	mi = gtk_check_menu_item_new_with_label(gettext("Log window autoscroll"));
	gaccel_bind_widget("config/log_sroll" , "toggle" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , cfg.log_autoscroll);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" ,
			GTK_SIGNAL_FUNC(ToggleBool) ,
			(gpointer) &cfg.log_autoscroll);

	mi = gtk_check_menu_item_new_with_label(gettext("Use preferences"));
	gaccel_bind_widget("config/use_pref" , "toggle" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , cfg.use_prefs);
	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" ,
			GTK_SIGNAL_FUNC(ToggleBool) ,
			(gpointer) &cfg.use_prefs);

	cfg.gtk.me_quiet = mi = gtk_check_menu_item_new_with_label(gettext("Quiet"));
	gaccel_bind_widget("config/quiet" , "toggle" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(mi) , cfg.quiet);

	gtk_signal_connect(GTK_OBJECT(mi) , "toggled" , 
			GTK_SIGNAL_FUNC(ToggleBool) , 
			(gpointer)&cfg.quiet);


	mbb = menu_item(gettext("_Config"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

/*** ACTION MENU ***/

	menu = gtk_menu_new();
	gtk_widget_realize(menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif

	mi = menu_item(gettext("_Restart"));
	gaccel_bind_widget("action/restart" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	cfg.gtk.mea_rest = mi;

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Start) , 
			(gpointer)TRUE);

	mi = menu_item(gettext("Co_ntinue"));
	gaccel_bind_widget("action/continue" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	cfg.gtk.mea_start = mi;

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Start) , 
			(gpointer)FALSE);

	mi = menu_item(gettext("Sto_p"));
	gaccel_bind_widget("action/stop" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	cfg.gtk.mea_stop = mi;

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Stop) , 
			(gpointer)NULL);

	mi = menu_item(gettext("_Break"));
	gaccel_bind_widget("action/break" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
	cfg.gtk.mea_break = mi;

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Break) , 
			(gpointer)NULL);

	mbb = menu_item(gettext("_Action"));
	gtk_widget_show(mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

	gtk_widget_set_sensitive(cfg.gtk.mea_start,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_stop,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.mea_break,FALSE);

/*** HELP MENU ***/

	menu = gtk_menu_new();
	gtk_widget_realize(menu);

#ifdef _GTK_FEATURES_1_2
	mi = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);
#endif

	mi = menu_item(gettext("About ..."));
	gaccel_bind_widget("help/about" , "activate" , mi, NULL);
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show(mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_ABOUT);

	mbb = menu_item(gettext("_Help"));
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mbb));
	gtk_widget_show(mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);
}

static void SaveScn(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename (
			GTK_FILE_SELECTION(cfg.gtk.scn_save_shell));

	if (fn && *fn)
	{
		cfg_dump(fn);
		gtk_widget_hide(cfg.gtk.scn_save_shell);
	}
	else gdk_beep();
}

static void build_scenario_saver(popup)
int popup;
{
	if (cfg.gtk.scn_save_shell)
	{
		if (popup)
		{
			 gtk_widget_show_all(cfg.gtk.scn_save_shell);
			if (GTK_WIDGET_REALIZED(cfg.gtk.scn_save_shell))
				gdk_window_raise(cfg.gtk.scn_save_shell->window);
		}
		return;
	}

	cfg.gtk.scn_save_shell = gtk_file_selection_new(gettext("Pavuk: Scenario saver"));

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.scn_save_shell), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.scn_save_shell);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION (cfg.gtk.scn_save_shell)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(SaveScn), 
		cfg.gtk.scn_save_shell);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION (cfg.gtk.scn_save_shell)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(PopdownW), 
		cfg.gtk.scn_save_shell);

	if (popup) gtk_widget_show(cfg.gtk.scn_save_shell);
}

static void LoadScn(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename (
			GTK_FILE_SELECTION(cfg.gtk.scn_load_shell));

	if (fn && *fn)
	{
		if (cfg_load(fn))
			gdk_beep();
		else
		{
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(cfg.gtk.modegr[cfg.mode]) , TRUE);

			if (!cfg.processing)
			{
				gtk_widget_set_sensitive(cfg.gtk.bt_start,FALSE);
				gtk_widget_set_sensitive(cfg.gtk.mea_start,FALSE);
				gtk_widget_set_sensitive(cfg.gtk.mtb_start,FALSE);

				free_all();
				cfg.total_cnt = 0;
				cfg.urlstack = NULL;
				cfg.mode_started = FALSE;
			}


			if (cfg.gtk.cfg_limits)
				xset_cfg_values_lim();
			if (cfg.gtk.config_shell)
				xset_cfg_values_comm();
#ifdef DEBUG
			set_debug_level_mi();
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(cfg.gtk.me_debug) , cfg.debug);
#endif
			gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(cfg.gtk.me_quiet) , cfg.quiet);

			gtk_widget_hide(cfg.gtk.scn_load_shell);
		}
	} else gdk_beep();
}

static void build_scenario_loader(popup)
int popup;
{
	if (cfg.gtk.scn_load_shell)
	{
		if (popup)
		{
			gtk_widget_show_all(cfg.gtk.scn_load_shell);
			if (GTK_WIDGET_REALIZED(cfg.gtk.scn_load_shell))
				gdk_window_raise(cfg.gtk.scn_load_shell->window);
		}
		return;
	}

	cfg.gtk.scn_load_shell = gtk_file_selection_new(gettext("Pavuk: Scenario loader"));

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.scn_load_shell), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.scn_load_shell);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(cfg.gtk.scn_load_shell)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(LoadScn), 
		cfg.gtk.scn_load_shell);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(cfg.gtk.scn_load_shell)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(PopdownW), 
		cfg.gtk.scn_load_shell);

	if (popup) gtk_widget_show(cfg.gtk.scn_load_shell);
}

GtkWidget *_get_label_child(w)
GtkWidget *w;
{
	GtkWidget *rv = NULL;
	GList *chlist;

	for (chlist = GTK_BOX(w)->children ; chlist ; chlist = chlist->next)
	{
		if (GTK_IS_LABEL(((struct _GtkBoxChild *)chlist->data)->widget))
		{
			rv = ((struct _GtkBoxChild *)chlist->data)->widget;
			break;
		}
	}
	return rv;
}

#if defined _GTK_FEATURES_1_2 && defined WITH_TREE

static void DumpTree(tree , node , data)
GtkCTree *tree;
GtkCTreeNode *node;
gpointer data;
{
	url *urlp = (url *)gtk_ctree_node_get_row_data(tree, node);

	if (urlp)
	{
		int i;
		char *p;
		FILE *f = (FILE *)data;
		GtkCTreeRow *row = (GtkCTreeRow *)node->list.data;

		for (i = 2 ; i < row->level ; i++)
			fprintf(f , "    ");

		p = url_to_urlstr(urlp, FALSE);
		fprintf(f , "%s\n" , p);
		_free(p);
	}
}

static void StoreTreeOK(w , fdata)
GtkWidget *w;
gpointer fdata;
{
	char *p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fdata));
	FILE *f;

	if (!p || !*p)
	{
		gdk_beep();
		return;
	}

	if (!(f = fopen(p , "wb+")))
	{
		xperror(p);
		return;
	}

	gtk_ctree_pre_recursive(GTK_CTREE(cfg.gtk.tree_widget) , cfg.gtk.root ,
		GTK_CTREE_FUNC(DumpTree) , f);

	fclose(f);

	gtk_widget_destroy(GTK_WIDGET(fdata));
}

static void StoreTree()
{
	static GtkWidget *fsw = NULL;
	
	if (!fsw)
	{
		fsw = gtk_file_selection_new(gettext("Pavuk: Store tree"));
		gtk_signal_connect(GTK_OBJECT(fsw), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &fsw);

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fsw)->ok_button),
			"clicked", GTK_SIGNAL_FUNC(StoreTreeOK), fsw);

		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fsw)->cancel_button),
			"clicked", GTK_SIGNAL_FUNC(PopdownW), fsw);
	}

	gtk_widget_show(fsw);
	if (GTK_WIDGET_REALIZED(fsw))
		gdk_window_raise(fsw->window);
}
#endif

static void build_tree_preview(popup)
int popup;
{
#ifdef WITH_TREE
	GtkWidget *col , *swin , *frame , *mi,*bbox;
	static GtkWidget *cbutton = NULL;
	static GtkWidget *sbutton = NULL;

	if (cfg.gtk.tree_shell)
	{
		gtk_window_set_title(GTK_WINDOW(cfg.gtk.tree_shell) , gettext("Pavuk: URL tree preview"));
		gtk_label_set(GTK_LABEL(_get_label_child(GTK_BUTTON(cbutton)->child)) , gettext("Cancel"));
		gtk_label_set(GTK_LABEL(_get_label_child(GTK_BUTTON(sbutton)->child)) , gettext("Store tree ..."));
		gtk_label_set(GTK_LABEL(GTK_BIN(cfg.gtk.me_prop_url)->child) , gettext("Properties"));
		gtk_label_set(GTK_LABEL(GTK_BIN(cfg.gtk.me_browse_url)->child) , gettext("Launch browser"));
		gtk_label_set(GTK_LABEL(GTK_BIN(cfg.gtk.me_disable_url)->child) , gettext("Disable URL"));
		gtk_label_set(GTK_LABEL(GTK_BIN(cfg.gtk.me_enable_url)->child) , gettext("Enable URL"));
		gtk_label_set(GTK_LABEL(GTK_BIN(cfg.gtk.me_download_url)->child) , gettext("Download URL"));
		gtk_label_set(GTK_LABEL(cfg.gtk.tree_help) , "");
#ifdef _GTK_FEATURES_1_2
		gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.tree_widget), 0 , 
				gettext("URL tree"));
#endif

		if (popup)
		{
			gtk_widget_show_all(cfg.gtk.tree_shell);
			if (GTK_WIDGET_REALIZED(cfg.gtk.tree_shell))
				gdk_window_raise(cfg.gtk.tree_shell->window);
		}
		return;
	}

	cfg.gtk.tree_shell = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_border_width(GTK_CONTAINER(cfg.gtk.tree_shell), 3);
	gtk_window_set_title(GTK_WINDOW(cfg.gtk.tree_shell) , gettext("Pavuk: URL tree preview"));
	gtk_widget_realize(cfg.gtk.tree_shell);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.tree_shell), "delete_event",
		GTK_SIGNAL_FUNC(no_destroy), cfg.gtk.tree_shell);
 
	col = gtk_vbox_new(0,5);
	gtk_container_add(GTK_CONTAINER(cfg.gtk.tree_shell), col);
	gtk_widget_show(col);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(swin , 500 , 400);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show(swin);
	gtk_container_add(GTK_CONTAINER(col), swin);

#ifdef _GTK_FEATURES_1_2

	cfg.gtk.tree_widget = gtk_ctree_new(1, 0);
	gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.tree_widget), 0 , 
		gettext("URL tree"));
	gtk_clist_column_titles_show(GTK_CLIST(cfg.gtk.tree_widget));
	gtk_clist_set_row_height(GTK_CLIST(cfg.gtk.tree_widget) ,
		MAX(cfg.gtk.tree_widget->style->font->ascent +
			cfg.gtk.tree_widget->style->font->descent + 1 ,
			MAX_PIX_HEIGHT));
	gtk_clist_set_column_width(GTK_CLIST(cfg.gtk.tree_widget), 0, 500);
	gtk_clist_set_selection_mode(GTK_CLIST(cfg.gtk.tree_widget),
		GTK_SELECTION_SINGLE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.tree_widget), 0 , TRUE);
	gtk_ctree_set_line_style(GTK_CTREE(cfg.gtk.tree_widget),
		GTK_CTREE_LINES_DOTTED);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.tree_widget), "button_press_event",
			(GtkSignalFunc) tree_list_events,
			cfg.gtk.tree_widget);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.tree_widget), "select_row",
			(GtkSignalFunc) SelectTreeNode,
			(gpointer)NULL);
	gtk_container_add(GTK_CONTAINER(swin),
			cfg.gtk.tree_widget);

	cfg.gtk.tv_accel_group = gtk_accel_group_new ();
#else
	cfg.gtk.tree_widget = gtk_tree_new();
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.tree_widget), "event",
			(GtkSignalFunc)tree_list_events,
			cfg.gtk.tree_widget);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.tree_widget), "selection_changed",
			(GtkSignalFunc) SelectTreeNode,
			(gpointer)NULL);

	gtk_container_add(GTK_CONTAINER(swin) , cfg.gtk.tree_widget);
#endif
	gtk_widget_show(cfg.gtk.tree_widget);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show(swin);
	gtk_container_add(GTK_CONTAINER(col), swin);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
#ifdef _GTK_FEATURES_1_2
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(swin), frame);
#else
	gtk_container_add(GTK_CONTAINER(swin), frame);
#endif

	cfg.gtk.tree_help = gtk_label_new("   ");
	gtk_label_set_justify(GTK_LABEL(cfg.gtk.tree_help), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment(GTK_MISC(cfg.gtk.tree_help) , 0.0 , 0.0);
	gtk_misc_set_padding(GTK_MISC(cfg.gtk.tree_help) , 3, 3);
	gtk_widget_show(cfg.gtk.tree_help);
	gtk_container_add(GTK_CONTAINER(frame), cfg.gtk.tree_help);	

	bbox = gtk_hbutton_box_new();
	gtk_box_pack_start(GTK_BOX(col), bbox , FALSE, FALSE, 0);
	gtk_widget_show(bbox);

#ifdef _GTK_FEATURES_1_2
	sbutton = pixmap_button(save_xpm , NULL , gettext("Store tree ..."));
	gtk_container_add(GTK_CONTAINER(bbox), sbutton);
	gtk_signal_connect(GTK_OBJECT(sbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(StoreTree) , 
			(gpointer)NULL);
	GTK_WIDGET_SET_FLAGS(sbutton, GTK_CAN_DEFAULT);
	gtk_widget_show(sbutton);
#endif

	cbutton = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
#ifdef _GTK_FEATURES_1_2
{
	GtkAccelGroup *accel_group;
	accel_group = gtk_accel_group_new();

	gtk_widget_add_accelerator(cbutton , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

	gtk_window_add_accel_group(GTK_WINDOW(cfg.gtk.tree_shell) , accel_group);
}
#endif
	gtk_container_add(GTK_CONTAINER(bbox), cbutton);
	gtk_signal_connect(GTK_OBJECT(cbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)cfg.gtk.tree_shell);
	GTK_WIDGET_SET_FLAGS(cbutton, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(cbutton);
	gtk_widget_show(cbutton);

	cfg.gtk.tmenu = gtk_menu_new();
	gtk_widget_realize(cfg.gtk.tmenu);

	cfg.gtk.me_prop_url = mi = gtk_menu_item_new_with_label(gettext("Properties"));
	gaccel_bind_widget("tree/properties" , "activate" , mi, cfg.gtk.tv_accel_group);
	gtk_menu_append(GTK_MENU(cfg.gtk.tmenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Propert) , 
                        (gpointer)NULL);

	cfg.gtk.me_browse_url = mi = gtk_menu_item_new_with_label(gettext("Launch browser"));
	gaccel_bind_widget("tree/launch" , "activate" , mi, cfg.gtk.tv_accel_group);
	gtk_menu_append(GTK_MENU(cfg.gtk.tmenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(LaunchBrowser) , 
                        (gpointer)NULL);

	cfg.gtk.me_disable_url = mi = gtk_menu_item_new_with_label(gettext("Disable URL"));
	gaccel_bind_widget("tree/disable" , "activate" , mi, cfg.gtk.tv_accel_group);
	gtk_menu_append(GTK_MENU(cfg.gtk.tmenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(DisableURL) ,
                        (gpointer)NULL);

	cfg.gtk.me_enable_url = mi = gtk_menu_item_new_with_label(gettext("Enable URL"));
	gaccel_bind_widget("tree/enable" , "activate" , mi, cfg.gtk.tv_accel_group);
	gtk_menu_append(GTK_MENU(cfg.gtk.tmenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(EnableURL) , 
                        (gpointer)NULL);

	cfg.gtk.me_download_url = mi = gtk_menu_item_new_with_label(gettext("Download URL"));
	gaccel_bind_widget("tree/download" , "activate" , mi, cfg.gtk.tv_accel_group);
	gtk_menu_append(GTK_MENU(cfg.gtk.tmenu) , mi);
	gtk_widget_show(mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(DownloadThisURL) , 
                        (gpointer)NULL);

	if (popup) gtk_widget_show(cfg.gtk.tree_shell);
#endif	
}

static void Schedule(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *p;

	cfg.time->tm_hour = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cfg.gtk.hour_label));
	cfg.time->tm_min = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cfg.gtk.min_label));

#ifdef _GTK_FEATURES_1_2
	gtk_calendar_get_date(GTK_CALENDAR(cfg.gtk.calendar) , 
			&cfg.time->tm_year , &cfg.time->tm_mon , &cfg.time->tm_mday);
#else
	cfg.time->tm_mday = GTK_SCALENDAR(cfg.gtk.calendar)->day;
	cfg.time->tm_mon = GTK_SCALENDAR(cfg.gtk.calendar)->month;
	cfg.time->tm_year = GTK_SCALENDAR(cfg.gtk.calendar)->year;
#endif

	_free(cfg.sched_cmd);
	p = gtk_entry_get_text(GTK_ENTRY(cfg.gtk.sched_cmd));
	if (p && *p)
		cfg.sched_cmd = new_string(p);

	cfg.reschedh = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(cfg.gtk.resched));

	if (!at_schedule())
	{
		gtk_widget_hide(cfg.gtk.cfg_sch);
		return;
	}
	xprintf(1 , gettext("Error scheduling\n"));
	gdk_beep();

}

#ifndef _GTK_FEATURES_1_2
static void CalendarChangeYear(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *cal = (GtkWidget *)func_data;

	gtk_scalendar_set_date(GTK_SCALENDAR(cal) , -1 , -1 , 
		(int)GTK_ADJUSTMENT(object)->value);	
}

static void CalendarChangeMonth(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *cal = (GtkWidget *)func_data;
	int month = (int)gtk_object_get_user_data(object);

	gtk_scalendar_set_date(GTK_SCALENDAR(cal) , -1 , month , -1);	
}
#endif /* _GTK_FEATURES_1_2 */

static GtkWidget *time_sel_new(calendar , hour_entry , min_entry , month_combo , year_entry)
GtkWidget **calendar;
GtkWidget **hour_entry;
GtkWidget **min_entry;
GtkWidget **month_combo;
GtkWidget **year_entry;
{
	GtkWidget *col , *frame , *brow , *label;
	GtkAdjustment *adj;
	
	col = gtk_vbox_new(0,10);
	gtk_widget_show(col);

#ifdef _GTK_FEATURES_1_2
	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(col), frame, FALSE, FALSE, 5);

	*calendar = gtk_calendar_new();
	gtk_widget_show(*calendar);
	gtk_container_add(GTK_CONTAINER(frame), *calendar);
	gtk_calendar_display_options(GTK_CALENDAR(*calendar) ,
			GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES);
	*year_entry = NULL;
	*month_combo = NULL;

#else
{
	int i;
	static char *mnames[12] = {NULL};
	static char *dnames[7];
	GtkWidget *mmenu , * mi;

	brow = gtk_hbox_new (0,5);
	gtk_widget_show(brow);
	gtk_box_pack_start(GTK_BOX(col), brow, FALSE, FALSE, 0);

	*month_combo = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(brow), *month_combo, TRUE, TRUE, 5);

	adj = (GtkAdjustment *) gtk_adjustment_new(0.0 , 0.0 , 10000.0 , 1.0 , 10.0 , 0.0);
	*year_entry = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_show(*year_entry);
	gtk_box_pack_start(GTK_BOX(brow) , *year_entry , TRUE , TRUE , 5);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(col), frame, FALSE, FALSE, 5);

	if (!mnames[0] || _restart_iface)
	{
		bool clr = (mnames[0] != NULL);

		for(i = 0 ; i < 7 ; i++)
		{
			if (clr) _free(dnames[i]);
			dnames[i] = new_string(gettext(en_day_names[i]));
		}

		for(i = 0 ; i < 12 ; i++)
		{
			if (clr) _free(mnames[i]);
			mnames[i] = new_string(gettext(en_month_names[i]));
		}
	}

	*calendar = gtk_scalendar_new(dnames , mnames);
	gtk_scalendar_show_month_label(GTK_SCALENDAR(*calendar) , FALSE);
	gtk_widget_show(*calendar);
	gtk_container_add(GTK_CONTAINER(frame), *calendar);

	gtk_signal_connect(GTK_OBJECT(adj) , "value_changed" , 
		GTK_SIGNAL_FUNC(CalendarChangeYear) , 
		(gpointer)*calendar);

	mmenu = gtk_menu_new();

	for(i = 0 ; i < 12 ; i++)
	{
		mi = gtk_menu_item_new_with_label(mnames[i]);
		gtk_object_set_user_data(GTK_OBJECT(mi) , (gpointer)i);
		gtk_menu_append(GTK_MENU(mmenu), mi);
		gtk_widget_show(mi);
		gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(CalendarChangeMonth) , 
			(gpointer)*calendar);
	}

	gtk_option_menu_set_menu(GTK_OPTION_MENU(*month_combo), mmenu);
	gtk_widget_show(*month_combo);
}
#endif /* _GTK_FEATURES_1_2 */

	brow = gtk_hbox_new (0,5);
	gtk_widget_show(brow);
	gtk_box_pack_start(GTK_BOX(col), brow, FALSE, FALSE, 4);

	label = gtk_label_new(gettext("Time: "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(brow), label , FALSE , FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new(0.0 , 0.0 , 23.0 , 1.0 , 5.0 , 0.0);
	*hour_entry = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_show(*hour_entry);
	gtk_box_pack_start(GTK_BOX(brow), *hour_entry , FALSE, FALSE, 0);

	label = gtk_label_new(gettext(" : "));
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(brow), label , FALSE , FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new(0.0 , 0.0 , 59.0 , 1.0 , 5.0 , 0.0);
	*min_entry = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_show(*min_entry);
	gtk_box_pack_start(GTK_BOX(brow), *min_entry , FALSE, FALSE, 0);

	return col;
}

/**** SCHEDULER CFG ****/
static void build_config_sch(popup)
int popup;
{
	GtkWidget *col , *brow , *button , *sep , *label , *ptab;

	if (cfg.gtk.cfg_sch)
	{
		if (popup)
		{
			gtk_widget_show_all(cfg.gtk.cfg_sch);
			if (GTK_WIDGET_REALIZED(cfg.gtk.cfg_sch))
				gdk_window_raise(cfg.gtk.cfg_sch->window);
		}
		return;
	}

	cfg.gtk.cfg_sch = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_border_width(GTK_CONTAINER(cfg.gtk.cfg_sch), 3);
	gtk_window_set_title(GTK_WINDOW(cfg.gtk.cfg_sch) , gettext("Pavuk: Scheduler"));
	gtk_widget_realize(cfg.gtk.cfg_sch);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.cfg_sch), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.cfg_sch);

	col = time_sel_new(&cfg.gtk.calendar , &cfg.gtk.hour_label , &cfg.gtk.min_label , 
			   &cfg.gtk.month_combo , &cfg.gtk.year_label);
	gtk_container_add(GTK_CONTAINER(cfg.gtk.cfg_sch), col);
	gtk_widget_show(col);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_start(GTK_BOX(col), sep , FALSE, TRUE, 3);

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(col), ptab , FALSE, TRUE, 1);
	gtk_widget_show(ptab);
	
	cfg.gtk.sched_cmd = tab_add_entry(ptab, 
			gettext("Scheduling command: "), 0 , 0 , FALSE);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_start(GTK_BOX(col), sep , FALSE, TRUE, 3);

	brow = gtk_hbox_new (0,5);
	gtk_widget_show(brow);
	gtk_box_pack_start(GTK_BOX(col), brow, FALSE, TRUE, 1);

	label = gtk_label_new(gettext("Reschedule after ")); 
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(brow), label , TRUE, TRUE, 4);

	cfg.gtk.resched = gtk_spin_button_new(
		(GtkAdjustment *)gtk_adjustment_new(0.0 , 0.0 , 10000.0 , 1.0 , 5.0 , 0.0) ,
		10.0 , 0.0);
	gtk_widget_show(cfg.gtk.resched);
	gtk_box_pack_start(GTK_BOX(brow), cfg.gtk.resched , TRUE, TRUE, 4);

	label = gtk_label_new(gettext(" hours")); 
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(brow), label , TRUE, TRUE, 4);

	brow = gtk_hbutton_box_new();
	gtk_box_pack_end(GTK_BOX(col), brow , FALSE, TRUE, 4);
	gtk_hbutton_box_set_spacing_default(1);
	gtk_widget_show(brow);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(brow) , GTK_BUTTONBOX_SPREAD);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_end(GTK_BOX(col), sep , FALSE, TRUE, 4);

	button = pixmap_button(schedule_xpm , NULL , gettext("OK"));
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(Schedule) , 
			(gpointer)NULL);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);

	button = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
#ifdef _GTK_FEATURES_1_2
{
	GtkAccelGroup *accel_group;
	accel_group = gtk_accel_group_new();

	gtk_widget_add_accelerator(button , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

	gtk_window_add_accel_group(GTK_WINDOW(cfg.gtk.cfg_sch) , accel_group);
}
#endif
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)cfg.gtk.cfg_sch);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	if (popup) gtk_widget_show(cfg.gtk.cfg_sch);
}


static GtkWidget * tab_add_entry(table , label , col , row , passw)
GtkWidget *table;
char *label;
guint col;
guint row;
guint passw;
{
	GtkWidget *entry , *labelw;

	labelw = gtk_label_new(label);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0 , 0.5);
	gtk_table_attach(GTK_TABLE(table), labelw , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK , GTK_FILL,  2 , 5);
	gtk_widget_show(labelw);

	entry = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(table), entry , col + 1, col + 2 , row , row + 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL,  2 , 5);
#ifdef _GTK_FEATURES_1_2
	if (passw)
		gtk_entry_set_visibility(GTK_ENTRY(entry) , FALSE);
#endif
	gtk_widget_show(entry);

	return entry;
}

static GtkWidget * tab_add_numentry(table , label , col , row , max_val)
GtkWidget *table;
char *label;
guint col;
guint row;
guint max_val;
{
	GtkWidget *entry , *labelw;
	GtkAdjustment *adj;

	labelw = gtk_label_new(label);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0 , 0.5);
	gtk_table_attach(GTK_TABLE(table), labelw , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK , GTK_FILL,  2 , 5);
	gtk_widget_show(labelw);

	adj = (GtkAdjustment *) gtk_adjustment_new (0.0, 0.0, (float)max_val, 1.0,
					5.0, 0.0);

	entry = gtk_spin_button_new(adj , 0 , 0);
	gtk_table_attach(GTK_TABLE(table), entry , col + 1, col + 2 , row , row + 1 ,
			0 , GTK_FILL,  2 , 5);
	gtk_widget_set_usize(entry , gdk_string_width(entry->style->font, "000000000") , -1);
	gtk_widget_show(entry);

	return entry;
}

static void SetFileEntry(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gchar *p;

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(
			gtk_widget_get_toplevel(GTK_WIDGET(object))));

	gtk_entry_set_text(GTK_ENTRY(func_data) , p);

	gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(object)));
}

static void DestroyW(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_destroy(GTK_WIDGET(func_data));
}

static void GetFile(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *fs;
	gchar *p;

	fs = gtk_file_selection_new(gettext("Pavuk: Get File"));

	p = gtk_entry_get_text(GTK_ENTRY(func_data));
	
	if (p && p[0]) gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs) , p);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(SetFileEntry), 
		func_data);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(DestroyW), 
		fs);

	gtk_widget_show(fs);
}

static void GetDir(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *fs;
	gchar *p;

	fs = gtk_file_selection_new(gettext("Pavuk: Get Directory"));

	gtk_widget_set_sensitive(GTK_FILE_SELECTION(fs)->file_list , FALSE);

	p = gtk_entry_get_text(GTK_ENTRY(func_data));
	
	if (p && p[0]) gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs) , p);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(SetFileEntry), 
		func_data);

	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(fs)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(DestroyW), 
		fs);

	gtk_widget_show(fs);
}

static GtkWidget * tab_add_path_entry(table , label , col , row , dir)
GtkWidget *table;
char *label;
guint col;
guint row;
int dir;
{
	GtkWidget *entry , *labelw , *pom , *button , *box;

	box = gtk_hbox_new(0 , 0);
	gtk_widget_show(box);
	gtk_table_attach(GTK_TABLE(table), box , col , col + 1 , row , row + 1 ,
			GTK_FILL | GTK_SHRINK , GTK_FILL,  2 , 5);

	labelw = gtk_label_new(label);
	gtk_box_pack_start(GTK_BOX(box) , labelw , FALSE , TRUE , 0);
	gtk_misc_set_alignment(GTK_MISC(labelw) , 0.0 , 0.5);
	gtk_widget_show(labelw);

	pom = gtk_hbox_new(FALSE , 0);
	gtk_widget_show(pom);
	gtk_table_attach(GTK_TABLE(table), pom , col + 1, col + 2 , row , row + 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL,  2 , 5);

	entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(pom) , entry , TRUE , TRUE , 0);
	gtk_widget_show(entry);

	button = pixmap_button(browse_xpm , NULL , gettext("Browse ..."));
	gtk_box_pack_end(GTK_BOX(pom) , button , FALSE , TRUE , 2);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
		dir ? GTK_SIGNAL_FUNC(GetDir) : GTK_SIGNAL_FUNC(GetFile) , 
		(gpointer)entry);
	
	return entry;
}

static GtkWidget * new_edit_list(list , entry , label , dbutton , mbutton , cbutton , abutton , connect_entry)
GtkWidget **list;
GtkWidget **entry;
char *label;
GtkWidget **dbutton;
GtkWidget **mbutton;
GtkWidget **cbutton;
GtkWidget **abutton;
gboolean connect_entry;
{
	GtkWidget *swin , *box , *brow , *button;
	listanfo *p = NULL;

	box = gtk_table_new(3 , 1 , FALSE);
	gtk_widget_show(box);

	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults(GTK_TABLE(box), swin , 0 , 1, 0, 1);
	gtk_widget_show(swin);

	*list = gtk_clist_new(1);
	gtk_clist_set_selection_mode(GTK_CLIST(*list), GTK_SELECTION_BROWSE);
#ifdef _GTK_FEATURES_1_2
	gtk_clist_set_reorderable(GTK_CLIST(*list) , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(*list) , 0 , TRUE);
#endif
	gtk_container_add(GTK_CONTAINER(swin), *list);
	gtk_widget_show(*list);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_table_attach(GTK_TABLE(box), brow , 0, 1, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_FILL, 2 , 5);
	gtk_widget_show(brow);

	*entry = tab_add_entry(brow , label , 0 , 0 , FALSE);

	if (connect_entry)
		gtk_signal_connect(GTK_OBJECT(*list) , "select_row" , 
			GTK_SIGNAL_FUNC(ListCopyToEntry) , 
			(gpointer) *entry);

	brow = gtk_hbutton_box_new();
	gtk_table_attach(GTK_TABLE(box), brow , 0, 1, 2, 3,
			GTK_EXPAND | GTK_FILL, GTK_FILL, 2 , 5);
	gtk_hbutton_box_set_spacing_default(1);
	gtk_widget_show(brow);

	gtk_button_box_set_layout(GTK_BUTTON_BOX(brow) , GTK_BUTTONBOX_SPREAD);

	button = pixmap_button(append_xpm , NULL ,gettext("Append"));
	gtk_container_border_width(GTK_CONTAINER(button), 0);
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_widget_show(button);

	if (!abutton)
	{
		p = g_malloc(sizeof(listanfo));

		p->list = *list;
		p->entry = *entry;

		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) p);

		gtk_signal_connect(GTK_OBJECT(*entry) , "activate" ,
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) p);
	}
	else *abutton = button;

	button = pixmap_button(modify_xpm , NULL , gettext("Modify"));
	gtk_container_border_width(GTK_CONTAINER(button), 0);
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_widget_show(button);

	if (!mbutton)
	{
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListModifyEntry) , 
			(gpointer) p);
	}
	else *mbutton = button;

	button = pixmap_button(clear_xpm , NULL , gettext("Clear"));
	gtk_container_border_width(GTK_CONTAINER(button), 0);
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_widget_show(button);

	if (!cbutton)
	{
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListClear) , 
			(gpointer) *list);
	}
	else *cbutton = button;

	button = pixmap_button(delete_xpm , NULL , gettext("Delete"));
	gtk_container_border_width(GTK_CONTAINER(button), 0);
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_widget_show(button);

	if (!dbutton)
	{
		gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) *list);
	}
	else *dbutton = button;

	return box;
}


static void limtab_tree(notebook)
GtkWidget *notebook;
{
	GtkWidget *label , *box , *col , *ptab;

	box = gtk_vbox_new(FALSE , 2);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Tree"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box , label);

	ptab = gtk_table_new(4 , 3 , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , GTK_FILL , GTK_FILL , 2);
	gtk_widget_show(ptab);
	
	cfg.gtk.cgi_sw = gtk_check_button_new_with_label(
		gettext("Download cgi-generated pages"));
	gtk_widget_show(cfg.gtk.cgi_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.cgi_sw , 0 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.ftpd_sw = gtk_check_button_new_with_label(
		gettext("Recurse through FTP directory"));
	gtk_widget_show(cfg.gtk.ftpd_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.ftpd_sw , 0 , 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.robots_sw = gtk_check_button_new_with_label(
		gettext("Allow \"robots.txt\""));
	gtk_widget_show(cfg.gtk.robots_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.robots_sw , 0 , 2 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.leaves_sw = gtk_check_button_new_with_label(
		gettext("Don't leave starting site"));
	gtk_widget_show(cfg.gtk.leaves_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.leaves_sw , 2 , 4 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.leaved_sw = gtk_check_button_new_with_label(
		gettext("Don't leave starting directory"));
	gtk_widget_show(cfg.gtk.leaved_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.leaved_sw , 2 , 4 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.ftp_html = gtk_check_button_new_with_label(
		gettext("Process HTML files downloaded over FTP"));
	gtk_widget_show(cfg.gtk.ftp_html);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.ftp_html , 2 , 4 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.maxdoc_label = tab_add_numentry(ptab , 
		gettext("Max. count of documents: ") , 0 , 3 , INT_MAX);

	cfg.gtk.maxlev_label = tab_add_numentry(ptab , 
		gettext("Max. depth of tree: ") , 0 , 4 , USHRT_MAX);

	cfg.gtk.leave_level = tab_add_numentry(ptab , 
		gettext("Max. levels to leave from starting site: ") , 0 , 5 , USHRT_MAX);

	cfg.gtk.maxsize_label = tab_add_numentry(ptab , 
		gettext("Max. document size: ") , 2 , 3 , INT_MAX);

	cfg.gtk.min_size = tab_add_numentry(ptab , 
		gettext("Min. document size: ") , 2 , 4 , INT_MAX);

	cfg.gtk.site_level = tab_add_numentry(ptab , 
		gettext("Max. site levels to leave from starting site: ") , 2 , 5 , INT_MAX);

	ptab = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , GTK_FILL , GTK_FILL , 2);
	gtk_widget_show(ptab);

	cfg.gtk.subdir_label = tab_add_path_entry(ptab , 
		gettext("Working subdirectory :") , 0 , 0 , TRUE);

	cfg.gtk.en_uexit = tab_add_entry(ptab , 
		gettext("User condition script: ") , 0 , 1 , FALSE);

	ptab = gtk_frame_new(gettext("Wildcard patterns"));
	gtk_box_pack_start(GTK_BOX(box) , ptab , GTK_FILL , GTK_FILL , 2);
	gtk_widget_show(ptab);

	col = gtk_table_new(4 , 2 , FALSE);
	gtk_container_add(GTK_CONTAINER(ptab) , col);
	gtk_widget_show(col);

	cfg.gtk.pattern_label = tab_add_entry(col , 
		gettext("Documents matching pattern: ") , 0 , 0 , FALSE);

	cfg.gtk.skip_pattern = tab_add_entry(col , 
		gettext("skip: ") , 2 , 0 , FALSE);

	cfg.gtk.url_pattern_label = tab_add_entry(col , 
		gettext("URL matching pattern: ") , 0 , 1 , FALSE);

	cfg.gtk.skip_url_pattern = tab_add_entry(col , 
		gettext("skip: ") , 2 , 1 , FALSE);

#ifdef HAVE_REGEX
	ptab = gtk_frame_new(gettext("RE patterns"));
	gtk_box_pack_start(GTK_BOX(box) , ptab , GTK_FILL , GTK_FILL , 2);
	gtk_widget_show(ptab);

	col = gtk_table_new(4 , 2 , FALSE);
	gtk_container_add(GTK_CONTAINER(ptab) , col);
	gtk_widget_show(col);

	cfg.gtk.rpattern = tab_add_entry(col , 
		gettext("Documents matching pattern: ") , 0 , 0 , FALSE);

	cfg.gtk.skip_rpattern = tab_add_entry(col , 
		gettext("skip: ") , 2 , 0 , FALSE);

	cfg.gtk.url_rpattern = tab_add_entry(col , 
		gettext("URL matching pattern: ") , 0 , 1 , FALSE);

	cfg.gtk.url_skip_rpattern = tab_add_entry(col , 
		gettext("skip: ") , 2 , 1 , FALSE);
#endif
}

static void limtab_hosts(notebook)
GtkWidget *notebook;
{
	GtkWidget *brow , *label , *box , *col, *ptab;

	box = gtk_table_new (2 , 2 , FALSE);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Hosts"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box , label);

	col = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(col);
	gtk_table_attach(GTK_TABLE(box), col , 0 , 1 , 0 , 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  5 , 5);

	cfg.gtk.hosts_sw = gtk_check_button_new_with_label(
		gettext("Allow / Disallow sites"));
	gtk_widget_show(cfg.gtk.hosts_sw);
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.hosts_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	
	brow = new_edit_list(&cfg.gtk.hosts_list , &cfg.gtk.hosts_entry ,
		gettext("Site: ") , NULL , NULL , NULL , NULL , TRUE);

	gtk_table_attach(GTK_TABLE(col), brow , 0 , 1 , 1 , 2 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  5 , 5);

	col = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(col);
	gtk_table_attach(GTK_TABLE(box), col , 1 , 2 , 0 , 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  5 , 5);

	cfg.gtk.domain_sw = gtk_check_button_new_with_label(
		gettext("Allow / Disallow domains"));
	gtk_widget_show(cfg.gtk.domain_sw);
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.domain_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = new_edit_list(&cfg.gtk.domain_list , &cfg.gtk.domain_entry ,
		gettext("Domain: ") , NULL , NULL , NULL , NULL , TRUE);

	gtk_table_attach(GTK_TABLE(col), brow , 0 , 1 , 1 , 2 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  5 , 5);

#ifdef HAVE_REGEX
	ptab = gtk_frame_new(gettext("IP address RE patterns"));
	gtk_table_attach(GTK_TABLE(box), ptab , 0 , 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	gtk_widget_show(ptab);

	col = gtk_table_new(4 , 1 , FALSE);
	gtk_container_add(GTK_CONTAINER(ptab) , col);
	gtk_widget_show(col);

	cfg.gtk.aip = tab_add_entry(col , 
		gettext("Server IP address matching pattern: ") , 0 , 0 , FALSE);

	cfg.gtk.skipip = tab_add_entry(col , 
		gettext("skip: ") , 2 , 0 , FALSE);
#endif
}

static void limtab_docs(notebook)
GtkWidget *notebook;
{
	GtkWidget *brow , *label , *box , *col;

	box = gtk_table_new(1 , 2 , FALSE);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("Documents"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box , label);

	col = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(col);
	gtk_table_attach(GTK_TABLE(box), col , 0 , 1 , 0 , 1 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  5 , 5);

	cfg.gtk.sufix_sw = gtk_check_button_new_with_label(
		gettext("Allow / Disallow suffix"));
	gtk_widget_show(cfg.gtk.sufix_sw);
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.sufix_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	
	brow = new_edit_list(&cfg.gtk.sufixlist , &cfg.gtk.sufix_label ,
		gettext("Suffix: ") , NULL , NULL , NULL , NULL , TRUE);

	gtk_table_attach(GTK_TABLE(col), brow , 0 , 1 , 1 , 2 ,
			GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND ,  5 , 5);

	col = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(col);
	gtk_table_attach(GTK_TABLE(box), col , 1 , 2 , 0 , 1 ,
			GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND ,  5 , 5);

	cfg.gtk.prefix_sw = gtk_check_button_new_with_label(
		gettext("Allow / Disallow prefix"));
	gtk_widget_show(cfg.gtk.prefix_sw);
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.prefix_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = new_edit_list(&cfg.gtk.prefixlist , &cfg.gtk.prefix_label ,
		gettext("Prefix: ") , NULL , NULL , NULL , NULL , TRUE);

	gtk_table_attach(GTK_TABLE(col), brow , 0 , 1 , 1 , 2 ,
			GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND ,  5 , 5);

}

static void limtab_mime(notebook)
GtkWidget *notebook;
{
	GtkWidget *brow , *label , *box , *swin , *button , *col , *ptab , *arrow;
	GtkWidget *dbutton , *abutton , *cbutton , *mbutton;
	static listanfo p;
	static listanfo e;

	box = gtk_table_new(3 , 1 , FALSE);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("MIME types"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box , label);

	brow = gtk_table_new(1 , 3 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add(GTK_CONTAINER(box), brow);

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(ptab);
	gtk_table_attach_defaults(GTK_TABLE(brow), ptab , 0 , 1, 0, 1);

	cfg.gtk.mime_sw = gtk_check_button_new_with_label(
		gettext("Allow / Disallow MIME type"));
	gtk_widget_show(cfg.gtk.mime_sw);
	gtk_table_attach(GTK_TABLE(ptab), cfg.gtk.mime_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  10 , 5);


	swin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults(GTK_TABLE(ptab), swin , 0 , 1 , 1 , 2);
/*
	gtk_table_attach(GTK_TABLE(ptab), swin , 0 , 1 , 1 , 2 ,
			GTK_FILL | GTK_EXPAND , GTK_FILL | GTK_EXPAND ,  10 , 10);
*/
	gtk_widget_show(swin);

	cfg.gtk.amimelist = gtk_clist_new(1);
#ifdef _GTK_FEATURES_1_2
	gtk_clist_set_reorderable(GTK_CLIST(cfg.gtk.amimelist) , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.amimelist) , 0 , TRUE);
#endif
	gtk_clist_set_selection_mode(GTK_CLIST(cfg.gtk.amimelist), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(swin), cfg.gtk.amimelist);
	gtk_widget_show(cfg.gtk.amimelist);


	col = gtk_vbox_new(FALSE , 20);
	gtk_widget_show(col);
	gtk_table_attach(GTK_TABLE(brow), col , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  10 , 10);

	arrow = gtk_arrow_new(GTK_ARROW_RIGHT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add(GTK_CONTAINER(col), button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.amimelist);

	arrow = gtk_arrow_new(GTK_ARROW_LEFT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add(GTK_CONTAINER(col), button);


	col = new_edit_list(&cfg.gtk.mimelist , &cfg.gtk.mimet_entry ,
		gettext("Other MIME type: ") , &dbutton , &mbutton , &cbutton , &abutton , FALSE);
	gtk_table_attach_defaults(GTK_TABLE(brow), col , 2 , 3 , 0, 1);

	gtk_signal_connect(GTK_OBJECT(dbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.amimelist);

	e.list = cfg.gtk.amimelist;
	e.entry	= cfg.gtk.mimet_entry;

	gtk_signal_connect(GTK_OBJECT(abutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.mimet_entry) , "activate" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(mbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListModifyEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListClear) , 
			(gpointer) cfg.gtk.amimelist);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.amimelist) , "select_row" , 
			GTK_SIGNAL_FUNC(ListCopyToEntry) , 
			(gpointer) cfg.gtk.mimet_entry);

	p.entry = cfg.gtk.mimelist;
	p.list = cfg.gtk.amimelist;

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertList) , 
			(gpointer) &p);

	SET_LIST(cfg.gtk.mimelist , mimetypes);
}

static void limtab_time(notebook)
GtkWidget *notebook;
{
	GtkWidget *tbox, *box , *col , *label , *frame;

	tbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(tbox);
	label = gtk_label_new(gettext("Time"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), tbox , label);

	box = gtk_hbox_new(FALSE , 5);
	gtk_widget_show(box);
	gtk_box_pack_start(GTK_BOX(tbox), box , FALSE, FALSE, 4);
	frame = gtk_frame_new(gettext("Lower document time limit"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box), frame , FALSE, FALSE, 4);

	col = time_sel_new(&cfg.gtk.btime_cal , &cfg.gtk.btime_h_entry ,
			   &cfg.gtk.btime_min_entry , 
			   &cfg.gtk.btime_mon , &cfg.gtk.btime_yentry);
	gtk_container_add(GTK_CONTAINER(frame) , col);

	cfg.gtk.btime_sw = gtk_check_button_new_with_label(
		gettext("Check if doc. time newer than this"));
	gtk_widget_show(cfg.gtk.btime_sw);
	gtk_box_pack_start(GTK_BOX(col), cfg.gtk.btime_sw , FALSE, FALSE, 4);

	frame = gtk_frame_new(gettext("Upper document time limit"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box), frame , FALSE, FALSE, 4);

	col = time_sel_new(&cfg.gtk.etime_cal , &cfg.gtk.etime_h_entry , 
			   &cfg.gtk.etime_min_entry ,
			   &cfg.gtk.etime_mon , &cfg.gtk.etime_yentry);
	gtk_container_add(GTK_CONTAINER(frame) , col);

	cfg.gtk.etime_sw = gtk_check_button_new_with_label(
		gettext("Check if doc. time older than this"));
	gtk_widget_show(cfg.gtk.etime_sw);
	gtk_box_pack_start(GTK_BOX(col), cfg.gtk.etime_sw , FALSE, FALSE, 4);	

	frame = gtk_table_new(3 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(tbox), frame , FALSE, FALSE, 4);
	gtk_widget_show(frame);

	cfg.gtk.max_time = tab_add_numentry(frame , 
		gettext("Maximal allowed time of downloading: ") , 0 , 0 , INT_MAX);

	label = gtk_label_new(gettext(" min"));
	gtk_table_attach (GTK_TABLE(frame), label , 2 , 3 , 0 , 1,
		GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);
}

static void limtab_html(notebook)
GtkWidget *notebook;
{
	GtkWidget *box , *label , *frame , *check;
	int i,j;
	char pom[100];

	frame = gtk_frame_new(gettext("Select allowed HTML tags and attributes"));
	gtk_widget_show(frame);
	label = gtk_label_new(gettext("HTML"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame , label);


	cfg.gtk.html_tags = box = gtk_multicol_new (10);
	gtk_multicol_set_number_of_rows(GTK_MULTICOL(cfg.gtk.html_tags) , 14);
	gtk_widget_show(box);
	gtk_container_add(GTK_CONTAINER(frame) , box);

	for (i = 0 ; i < NUM_ELEM(linky) ; i++)
	{
		for(j = 0 ; linky[i].attribs[j].attrib ; j++)
		{
			if (!(linky[i].attribs[j].stat & LINK_STYLE))
			{
				sprintf(pom , gettext("%s of %s") ,
					linky[i].attribs[j].attrib , linky[i].tag);

				check = gtk_check_button_new_with_label(pom);
				gtk_object_set_user_data(GTK_OBJECT(check) , 
					(gpointer)&linky[i].attribs[j].stat);
				gtk_widget_show(check);
				gtk_container_add(GTK_CONTAINER(box) , check);
			}
		}
	}
}

/*** LIMITS CFG ***/
static void build_config_lim(popup)
int popup;
{
	GtkWidget *col , *brow , *button , *notebook;

	if (cfg.gtk.cfg_limits)
	{
		if (popup)
		{
	 		gtk_widget_show_all(cfg.gtk.cfg_limits);
			if (GTK_WIDGET_REALIZED(cfg.gtk.cfg_limits))
				gdk_window_raise(cfg.gtk.cfg_limits->window);
		}
		return;
	}

	cfg.gtk.cfg_limits = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_border_width (GTK_CONTAINER (cfg.gtk.cfg_limits), 3);
	gtk_window_set_title(GTK_WINDOW(cfg.gtk.cfg_limits) , gettext("Pavuk: Limits config"));
	gtk_widget_realize (cfg.gtk.cfg_limits);
	gtk_signal_connect (GTK_OBJECT (cfg.gtk.cfg_limits), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.cfg_limits);

	col = gtk_table_new (2 , 1 , FALSE);
	gtk_container_add (GTK_CONTAINER (cfg.gtk.cfg_limits), col);
	gtk_widget_show (col);

	notebook = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook) , TRUE);
	gtk_table_attach_defaults (GTK_TABLE (col), notebook , 0 , 1, 0, 1);
	gtk_widget_show (notebook);

	limtab_tree(notebook);
	
	limtab_hosts(notebook);
	
	limtab_docs(notebook);
	
	limtab_mime(notebook);

	limtab_time(notebook);

	limtab_html(notebook);

	brow = gtk_hbutton_box_new ();
	gtk_table_attach (GTK_TABLE (col), brow , 0, 1, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_FILL, 2 , 5);
	gtk_hbutton_box_set_spacing_default (1);
	gtk_widget_show (brow);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (brow) , GTK_BUTTONBOX_SPREAD);

	button = pixmap_button(ok_xpm , NULL , gettext("OK"));
	gtk_container_add (GTK_CONTAINER (brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownWC) , 
			(gpointer)cfg.gtk.cfg_limits);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
	gtk_widget_show (button);

	button = pixmap_button(apply_xpm , NULL , gettext("Apply"));
	gtk_container_add (GTK_CONTAINER (brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(CfgLimits) , 
			(gpointer)cfg.gtk.config_shell);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show (button);

	button = pixmap_button(common_xpm , NULL , gettext("Common ..."));
	gtk_container_add (GTK_CONTAINER (brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGCOMM);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show (button);

	button = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
#ifdef _GTK_FEATURES_1_2
{
	GtkAccelGroup *accel_group;
	accel_group = gtk_accel_group_new();

	gtk_widget_add_accelerator(button , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

	gtk_window_add_accel_group(GTK_WINDOW(cfg.gtk.cfg_limits) , accel_group);
}
#endif
	gtk_container_add (GTK_CONTAINER (brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)cfg.gtk.cfg_limits);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show (button);

	if (popup) gtk_widget_show(cfg.gtk.cfg_limits);

	xset_cfg_values_lim();
}


/*** URL ***/
static void cfgtab_url(notebook)
GtkWidget *notebook;
{
	GtkWidget *label , *box;

	box = new_edit_list(&cfg.gtk.url_list , &cfg.gtk.url_entry ,
		gettext("URL: ") , NULL , NULL , NULL , NULL , TRUE);

#ifdef _GTK_FEATURES_1_2
	/*** DRAG'N'DROP ***/
  	gtk_drag_dest_set(box , GTK_DEST_DEFAULT_ALL,
			dragtypes , NUM_ELEM(dragtypes) - 1 ,
               		GDK_ACTION_COPY | GDK_ACTION_MOVE);
  	gtk_signal_connect(GTK_OBJECT(box) ,
			"drag_data_received" ,
			GTK_SIGNAL_FUNC(window_drop_url),
			NULL);
#endif

	label = gtk_label_new (gettext("URL"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);
	
}


/*** GRABER I ***/
static void cfgtab_graberI(notebook)
GtkWidget *notebook;
{
	GtkWidget *brow , *label , *box , *frame , *ptab;

	box = gtk_vbox_new (FALSE , 1);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Grabber I"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);

	cfg.gtk.cdir_label = tab_add_path_entry(brow , gettext("Cache Directory: ") ,
			0 , 0 , TRUE);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);

	cfg.gtk.index_name = tab_add_entry(brow , gettext("Index file name: ") ,
			0 , 0 , FALSE);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);

	cfg.gtk.store_name = tab_add_entry(brow , gettext("Store file name: ") ,
			0 , 0 , FALSE);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);

	cfg.gtk.identity = tab_add_entry(brow , gettext("Identity string: ") ,
			0 , 0 , FALSE);

#ifdef HAVE_DBOPEN
	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);

	cfg.gtk.ns_cache_dir = tab_add_path_entry(brow , gettext("Netscape browser cache directory: ") ,
			0 , 0 , TRUE);
#endif

#ifdef WITH_TREE
	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);
	cfg.gtk.browser_label = tab_add_entry(brow , gettext("Browser: ") , 0 , 0 , FALSE);
#endif

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);
	cfg.gtk.remind_cmd = tab_add_entry(brow , gettext("Reminder command: ") , 0 , 0 , FALSE);

	brow = gtk_table_new(1 , 2 , FALSE);
	gtk_box_pack_start (GTK_BOX (box), brow , FALSE, TRUE, 1);
	gtk_widget_show (brow);
	cfg.gtk.post_cmd = tab_add_entry(brow , gettext("Post command: ") , 0 , 0 , FALSE);

/*********/
	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_box_pack_start (GTK_BOX (box), frame , FALSE, TRUE, 1);

	ptab = gtk_table_new (5 , 6 , FALSE);
	gtk_container_add (GTK_CONTAINER (frame), ptab);
	gtk_widget_show(ptab);

	cfg.gtk.retry_label = tab_add_numentry(ptab , 
		gettext("How many times retry on fail: ") , 0 , 0 , USHRT_MAX);

	cfg.gtk.redir_label = tab_add_numentry(ptab , 
		gettext("How many moved links to follow: ") , 0 , 1 , USHRT_MAX);

	cfg.gtk.reget_label = tab_add_numentry(ptab , 
		gettext("How many times to reget file: ") , 0 , 2 , USHRT_MAX);

	cfg.gtk.ddays_label = tab_add_numentry(ptab , 
		gettext("Document age before syncing with server: ") , 0 , 3 , USHRT_MAX);

	cfg.gtk.bufsize = tab_add_numentry(ptab , 
		gettext("Read buffer size: ") , 0 , 4 , 10000);
	gtk_adjustment_clamp_page(
		GTK_ADJUSTMENT(GTK_SPIN_BUTTON(cfg.gtk.bufsize)->adjustment) ,
		1.0 , 1024.0);

	label = gtk_label_new(gettext(" kB"));
	gtk_table_attach (GTK_TABLE (ptab), label , 2 , 3 , 4 , 5,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);


	cfg.gtk.sleep_label = tab_add_numentry(ptab , 
		gettext("Sleep time between transfers: ") , 3 , 0 , INT_MAX);

	label = gtk_label_new(gettext(" sec."));
	gtk_table_attach (GTK_TABLE (ptab), label , 5 , 6 , 0 , 1,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);


	cfg.gtk.rollback_label = tab_add_numentry(ptab , 
		gettext("Rollback amount on reget: ") , 3 , 1 , INT_MAX);

	label = gtk_label_new(gettext(" bytes"));
	gtk_table_attach (GTK_TABLE (ptab), label , 5 , 6 , 1 , 2,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);

	cfg.gtk.trans_quota = tab_add_numentry(ptab , 
		gettext("Transfer quota: ") , 3 , 2 , INT_MAX);

	label = gtk_label_new(gettext(" kB"));
	gtk_table_attach (GTK_TABLE (ptab), label , 5 , 6 , 2 , 3,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);

	cfg.gtk.file_quota = tab_add_numentry(ptab , 
		gettext("File size quota: ") , 3 , 3 , INT_MAX);

	label = gtk_label_new(gettext(" kB"));
	gtk_table_attach (GTK_TABLE (ptab), label , 5 , 6 , 3 , 4,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);

#if defined HAVE_FSTATFS || HAVE_FSTATVFS
	cfg.gtk.fs_quota = tab_add_numentry(ptab , 
		gettext("Filesystem freespace quota: ") , 3 , 4 , INT_MAX);

	label = gtk_label_new(gettext(" kB"));
	gtk_table_attach (GTK_TABLE (ptab), label , 5 , 6 , 4 , 5,
			GTK_SHRINK , GTK_FILL, 2 , 2);
	gtk_widget_show(label);
#endif

}

/*** GRABER II ***/
static void HtmlswSens(w , data)
GtkWidget *w;
gpointer data;
{
	gboolean act = GTK_TOGGLE_BUTTON(w)->active;

	gtk_widget_set_sensitive(cfg.gtk.all_to_local , act);
	gtk_widget_set_sensitive(cfg.gtk.sel_to_local , act);
	gtk_widget_set_sensitive(cfg.gtk.url_to_local , act);
	gtk_widget_set_sensitive(cfg.gtk.all_to_remote , act);
}

static void cfgtab_graberII(notebook)
GtkWidget *notebook;
{
	GtkWidget *brow , *label , *frame , *ptab , *brow2;
	GtkWidget *menu, *mi;
	GSList *rg;
	int i;

	brow = gtk_hbox_new(FALSE , 5);
	gtk_widget_show(brow);
	label = gtk_label_new (gettext("Grabber II"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), brow , label);

	frame = gtk_frame_new(gettext("HTML document URL rewriting"));
	gtk_widget_show(frame);
	gtk_box_pack_start (GTK_BOX (brow), frame , FALSE, TRUE, 1);
	
	brow2 = gtk_vbox_new(0 , 1);
	gtk_widget_show(brow2);
	gtk_container_add(GTK_CONTAINER(frame) , brow2);

	cfg.gtk.noreloc_sw = gtk_check_button_new_with_label(
		gettext("Rewrite URLs inside HTML doc."));
	gtk_widget_show(cfg.gtk.noreloc_sw);
	gtk_box_pack_start (GTK_BOX (brow2), cfg.gtk.noreloc_sw, FALSE, TRUE, 2);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.noreloc_sw) , "toggled" ,
		GTK_SIGNAL_FUNC(HtmlswSens) , NULL);

	rg = NULL;
	cfg.gtk.url_to_local = gtk_radio_button_new_with_label( rg ,
		gettext("Rewrite URLs to local when stored locally"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(cfg.gtk.url_to_local));
	gtk_widget_show(cfg.gtk.url_to_local);
	gtk_box_pack_start (GTK_BOX (brow2), cfg.gtk.url_to_local, FALSE, TRUE, 1);

	cfg.gtk.sel_to_local = gtk_radio_button_new_with_label(rg ,
		gettext("Rewrite all suitable URLs to local"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(cfg.gtk.sel_to_local));
	gtk_widget_show(cfg.gtk.sel_to_local);
	gtk_box_pack_start (GTK_BOX (brow2), cfg.gtk.sel_to_local, FALSE, TRUE, 1);

	cfg.gtk.all_to_local = gtk_radio_button_new_with_label(rg ,
		gettext("Rewrite all URLs to local immediately"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(cfg.gtk.all_to_local));
	gtk_widget_show(cfg.gtk.all_to_local);
	gtk_box_pack_start (GTK_BOX (brow2), cfg.gtk.all_to_local, FALSE, TRUE, 1);

	cfg.gtk.all_to_remote = gtk_radio_button_new_with_label( rg ,
		gettext("Rewrite all URLs to remote immediately"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(cfg.gtk.all_to_remote));
	gtk_widget_show(cfg.gtk.all_to_remote);
	gtk_box_pack_start (GTK_BOX (brow2), cfg.gtk.all_to_remote, FALSE, TRUE, 1);

/***/
	frame = gtk_frame_new(gettext("Misc settings"));
	gtk_widget_show(frame);
	gtk_box_pack_start (GTK_BOX (brow), frame, FALSE , TRUE, 1);

	brow = gtk_vbox_new(0 , 1);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);
	
	cfg.gtk.ptime = gtk_check_button_new_with_label(
		gettext("Preserve document modification time"));
	gtk_widget_show(cfg.gtk.ptime);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.ptime, FALSE, TRUE, 1);

	cfg.gtk.preserve_perm = gtk_check_button_new_with_label(
		gettext("Preserve FTP document permissions"));
	gtk_widget_show(cfg.gtk.preserve_perm);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.preserve_perm, FALSE, TRUE, 1);

	cfg.gtk.preserve_links = gtk_check_button_new_with_label(
		gettext("Preserve FTP symbolic links"));
	gtk_widget_show(cfg.gtk.preserve_links);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.preserve_links, FALSE, TRUE, 1);

	cfg.gtk.freget_sw = gtk_check_button_new_with_label(
		gettext("Whole reget when partial not supported"));
	gtk_widget_show(cfg.gtk.freget_sw);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.freget_sw, FALSE, TRUE, 1);


	cfg.gtk.enc_sw = gtk_check_button_new_with_label(
		gettext("Use gzip encoding for transfer"));
	gtk_widget_show(cfg.gtk.enc_sw);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.enc_sw, FALSE, TRUE, 1);

	cfg.gtk.oldrm_sw = gtk_check_button_new_with_label(
		gettext("Remove improper documents"));
	gtk_widget_show(cfg.gtk.oldrm_sw);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.oldrm_sw, FALSE, TRUE, 1);

	cfg.gtk.check_size = gtk_check_button_new_with_label(
		gettext("Check transferred size of document"));
	gtk_widget_show(cfg.gtk.check_size);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.check_size , FALSE, TRUE, 1);

	cfg.gtk.store_index = gtk_check_button_new_with_label(
		gettext("Store directory URLs as index files"));
	gtk_widget_show(cfg.gtk.store_index);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.store_index , FALSE, TRUE, 1);

	cfg.gtk.enable_js = gtk_check_button_new_with_label(
		gettext("Download javascript script sources"));
	gtk_widget_show(cfg.gtk.enable_js);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.enable_js , FALSE, TRUE, 1);

	cfg.gtk.enable_info = gtk_check_button_new_with_label(
		gettext("Store info files with each document"));
	gtk_widget_show(cfg.gtk.enable_info);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.enable_info , FALSE, TRUE, 1);

	cfg.gtk.auto_referer = gtk_check_button_new_with_label(
		gettext("Send self URL as Referer for starting URLs"));
	gtk_widget_show(cfg.gtk.auto_referer);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.auto_referer , FALSE, TRUE, 1);

	cfg.gtk.send_if_range = gtk_check_button_new_with_label(
		gettext("Send If-Range header field when regeting"));
	gtk_widget_show(cfg.gtk.send_if_range);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.send_if_range , FALSE, TRUE, 1);

	cfg.gtk.show_time = gtk_check_button_new_with_label(
		gettext("Show time of start and end of downloading"));
	gtk_widget_show(cfg.gtk.show_time);
	gtk_box_pack_start (GTK_BOX (brow), cfg.gtk.show_time , FALSE, TRUE, 1);

	ptab = gtk_table_new (2 , 1 , FALSE);
	gtk_box_pack_start (GTK_BOX (brow), ptab , FALSE, FALSE, 1);
	gtk_widget_show(ptab);

	label = gtk_label_new(gettext("URL scheduling strategy: "));
	gtk_table_attach (GTK_TABLE (ptab), label , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  1 , 1);
	gtk_widget_show(label);

	cfg.gtk.scheduling_strategie = gtk_option_menu_new();

	menu = gtk_menu_new();

	for (i = 0 ; i < SSTRAT_LAST ; i++)
	{
		mi = gtk_menu_item_new_with_label(get_strategie_label(i));
		gtk_object_set_user_data(GTK_OBJECT(mi) , (gpointer)i);
		gtk_menu_append (GTK_MENU (menu), mi);
		gtk_widget_show(mi);
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (cfg.gtk.scheduling_strategie), menu);

	gtk_table_attach (GTK_TABLE (ptab), cfg.gtk.scheduling_strategie ,
			1 , 2 , 0 , 1 , GTK_FILL , GTK_FILL,  1 , 1);
	gtk_widget_show(cfg.gtk.scheduling_strategie);
}


/*** NET ***/
static void cfgtab_net(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *brow , *box , *frame, *label , *rb;
	GSList *rg;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Net"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	col = gtk_table_new(7 , 3 , FALSE);
	gtk_widget_show(col);
	gtk_container_add (GTK_CONTAINER (box), col);

	frame = gtk_frame_new(gettext("Allowed protocols"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(3 , 2 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);

	cfg.gtk.http_sw = gtk_check_button_new_with_label(gettext("HTTP"));
	gtk_widget_show(cfg.gtk.http_sw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.http_sw , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.ftp_sw = gtk_check_button_new_with_label(gettext("FTP"));
	gtk_widget_show(cfg.gtk.ftp_sw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.ftp_sw  , 0 , 1 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.gopher_sw = gtk_check_button_new_with_label(gettext("Gopher"));
	gtk_widget_show(cfg.gtk.gopher_sw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.gopher_sw , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

#ifdef USE_SSL
	cfg.gtk.https_sw = gtk_check_button_new_with_label(gettext("HTTPS"));
	gtk_widget_show(cfg.gtk.https_sw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.https_sw , 1 , 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.ftps_sw = gtk_check_button_new_with_label(gettext("FTPS"));
	gtk_widget_show(cfg.gtk.ftps_sw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.ftps_sw , 2 , 3 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);
#endif

	frame = gtk_frame_new(gettext("FTP data connection type "));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(2 , 1 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);

	rb = gtk_radio_button_new_with_label(NULL , gettext("Active"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_table_attach (GTK_TABLE (brow), rb , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	cfg.gtk.ftpmodegr[1] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("Passive"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_table_attach (GTK_TABLE (brow), rb , 0 , 1 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	cfg.gtk.ftpmodegr[0] = rb;

	label = gtk_label_new(gettext("Communication timeout: "));
	gtk_table_attach (GTK_TABLE (col), label , 0 , 1 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	cfg.gtk.timeout_label = gtk_spin_button_new(
		(GtkAdjustment *)gtk_adjustment_new(0.0 , 0.0 , 9999 , 1.0 , 10.0 , 0.0) ,
		0, 0);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.timeout_label , 1, 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL ,  2 , 5);
	gtk_widget_show (cfg.gtk.timeout_label);

	label = gtk_label_new(gettext(" min."));
	gtk_table_attach (GTK_TABLE (col), label , 2 , 3 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	label = gtk_label_new(gettext("Maximal transfer rate: "));
	gtk_table_attach (GTK_TABLE (col), label , 0 , 1 , 3 , 4 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	cfg.gtk.maxrate = gtk_spin_button_new(
		(GtkAdjustment *)gtk_adjustment_new(0.0 , 0.0 , 1000000.0 , 1.0 , 10.0 , 0.0) ,
		0, 3);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.maxrate , 1, 2 , 3 , 4 ,
			GTK_FILL , GTK_FILL ,  2 , 5);
	gtk_widget_show (cfg.gtk.maxrate);

	label = gtk_label_new(gettext(" kB/s"));
	gtk_table_attach (GTK_TABLE (col), label , 2 , 3 , 3 , 4 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	label = gtk_label_new(gettext("Minimal transfer rate: "));
	gtk_table_attach (GTK_TABLE (col), label , 0 , 1 , 4 , 5 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	cfg.gtk.minrate = gtk_spin_button_new(
		(GtkAdjustment *)gtk_adjustment_new(0.0 , 0.0 , 1000000.0 , 1.0 , 10.0 , 0.0) ,
		0, 3);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.minrate , 1, 2 , 4 , 5 ,
			GTK_FILL , GTK_FILL ,  2 , 5);
	gtk_widget_show (cfg.gtk.minrate);

	label = gtk_label_new(gettext(" kB/s"));
	gtk_table_attach (GTK_TABLE (col), label , 2 , 3 , 4 , 5 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show(label);

	label = gtk_label_new(gettext("Local interface address: "));
	gtk_table_attach(GTK_TABLE(col), label , 0 , 1 , 5 , 6 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show(label);

	cfg.gtk.local_ip = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.local_ip , 1, 3 , 5 , 6 ,
			GTK_FILL , GTK_FILL ,  2 , 5);
	gtk_widget_show(cfg.gtk.local_ip);

	label = gtk_label_new(gettext("Additional HTTP headers: "));
	gtk_table_attach (GTK_TABLE (col), label , 0 , 1 , 6 , 7 ,
			GTK_FILL , GTK_FILL,  2 , 5);
	gtk_misc_set_alignment(GTK_MISC(label) , 0.0 , 0.5);
	gtk_widget_show (label);

	cfg.gtk.http_headers = gtk_entry_new();
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.http_headers , 1, 3 , 6 , 7 ,
			GTK_FILL , GTK_FILL ,  2 , 5);
	gtk_widget_show (cfg.gtk.http_headers);

	cfg.gtk.ftp_list = gtk_check_button_new_with_label(
		gettext("Use wide listing of FTP directories"));
	gtk_widget_show(cfg.gtk.ftp_list);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.ftp_list, 0 , 3 , 7 , 8 ,
			GTK_FILL , GTK_FILL ,  5 , 5);

	cfg.gtk.use_http11 = gtk_check_button_new_with_label(
		gettext("Use HTTP/1.1 protocol for HTTP communication"));
	gtk_widget_show(cfg.gtk.use_http11);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.use_http11, 0 , 3 , 8 , 9 ,
			GTK_FILL , GTK_FILL ,  5 , 5);
}


/*** PROXY ***/
static void cfgtab_proxy(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *brow , *label , *box , *frame;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Proxy"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);


	col = gtk_table_new(3 , 2 , FALSE);
	gtk_widget_show(col);
	gtk_container_add (GTK_CONTAINER (box), col);

	frame = gtk_frame_new(gettext("HTTP proxy"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 0 , 1 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(2 , 2 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);


	cfg.gtk.http_proxyh_label = tab_add_entry(brow , 
		gettext("Host: ") , 0 , 0 , FALSE);

	cfg.gtk.http_proxyp_label = tab_add_numentry(brow , 
		gettext("Port: ") , 0 , 1 , USHRT_MAX);

#ifdef USE_SSL
	frame = gtk_frame_new(gettext("SSL proxy"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(2 , 2 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);


	cfg.gtk.ssl_proxyh_label = tab_add_entry(brow , 
		gettext("Host: ") , 0 , 0 , FALSE);

	cfg.gtk.ssl_proxyp_label = tab_add_numentry(brow , 
		gettext("Port: ") , 0 , 1 , USHRT_MAX);

#endif

	frame = gtk_frame_new(gettext("Gopher proxy"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 0 , 1 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(3 , 2 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);


	cfg.gtk.gopher_proxyh_label = tab_add_entry(brow , 
		gettext("Host: ") , 0 , 0 , FALSE);

	cfg.gtk.gopher_proxyp_label = tab_add_numentry(brow , 
		gettext("Port: ") , 0 , 1 , USHRT_MAX);


	cfg.gtk.gopher_httpgw = gtk_check_button_new_with_label(
		gettext("Gopher via HTTP proxy"));
	gtk_widget_show(cfg.gtk.gopher_httpgw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.gopher_httpgw , 0 , 2 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);


	frame = gtk_frame_new(gettext("FTP proxy"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 1 , 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	brow = gtk_table_new(4 , 2 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (frame), brow);


	cfg.gtk.ftp_proxyh_label = tab_add_entry(brow , 
		gettext("Host: ") , 0 , 0 , FALSE);

	cfg.gtk.ftp_proxyp_label = tab_add_numentry(brow , 
		gettext("Port: ") , 0 , 1 , USHRT_MAX);

	cfg.gtk.ftp_httpgw = gtk_check_button_new_with_label(
		gettext("FTP via HTTP proxy"));
	gtk_widget_show(cfg.gtk.ftp_httpgw);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.ftp_httpgw , 0 , 2 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.ftp_dirtyp = gtk_check_button_new_with_label(
		gettext("FTP via HTTP tunneling proxy"));
	gtk_widget_show(cfg.gtk.ftp_dirtyp);
	gtk_table_attach (GTK_TABLE (brow), cfg.gtk.ftp_dirtyp , 0 , 2 , 3 , 4 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cfg.gtk.cache_sw = gtk_check_button_new_with_label(
		gettext("Allow caching of documents"));
	gtk_widget_show(cfg.gtk.cache_sw);
	gtk_table_attach (GTK_TABLE (col), cfg.gtk.cache_sw, 0 , 1 , 2 , 3 ,
			GTK_FILL , GTK_FILL ,  5 , 5);
}


/*** LANGUAGES ***/
static void cfgtab_lang(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *brow , *box , *swin , *button , *label , *arrow;
	GtkWidget *dbutton , *abutton , *cbutton, *mbutton;
	static listanfo p;
	static listanfo e;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Languages"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	brow = gtk_table_new(1 , 3 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (box), brow);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults (GTK_TABLE (brow), swin , 0 , 1, 0, 1);
	gtk_widget_show (swin);

	cfg.gtk.langlist = gtk_clist_new (1);
#ifdef _GTK_FEATURES_1_2
	gtk_clist_set_reorderable(GTK_CLIST(cfg.gtk.langlist) , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.langlist) , 0 , TRUE);
#endif
	gtk_clist_set_selection_mode (GTK_CLIST (cfg.gtk.langlist), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(swin), cfg.gtk.langlist);
	gtk_widget_show (cfg.gtk.langlist);

	col = gtk_vbox_new(FALSE , 20);
	gtk_widget_show(col);
	gtk_table_attach (GTK_TABLE (brow), col , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  10 , 10);


	arrow = gtk_arrow_new(GTK_ARROW_RIGHT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add (GTK_CONTAINER (col), button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.langlist);

	arrow = gtk_arrow_new(GTK_ARROW_LEFT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add (GTK_CONTAINER (col), button);

	col = new_edit_list(&cfg.gtk.alanglist , &cfg.gtk.alang_entry ,
		gettext("Other lang. code: ") , &dbutton , &mbutton , &cbutton , &abutton , FALSE);
	gtk_table_attach_defaults (GTK_TABLE (brow), col , 2 , 3 , 0, 1);

	gtk_signal_connect(GTK_OBJECT(dbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.langlist);

	e.entry = cfg.gtk.alang_entry;
	e.list = cfg.gtk.langlist;

	gtk_signal_connect(GTK_OBJECT(abutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.alang_entry) , "activate" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(mbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListModifyEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListClear) , 
			(gpointer) cfg.gtk.langlist);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.langlist) , "select_row" , 
			GTK_SIGNAL_FUNC(ListCopyToEntry) , 
			(gpointer) cfg.gtk.alang_entry);

	p.entry = cfg.gtk.alanglist;
	p.list = cfg.gtk.langlist;

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(LangListInsertList) , 
			(gpointer) &p);

	SET_LIST(cfg.gtk.alanglist , iso_lang);
}

/*** CHARACTER-SET ***/
static void cfgtab_charset(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *brow , *box , *swin , *button , *label , *arrow;
	GtkWidget *dbutton , *abutton , *mbutton , *cbutton;
	static listanfo p;
	static listanfo e;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Character Sets"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	brow = gtk_table_new(1 , 3 , FALSE);
	gtk_widget_show(brow);
	gtk_container_add (GTK_CONTAINER (box), brow);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_table_attach_defaults (GTK_TABLE (brow), swin , 0 , 1, 0, 1);
	gtk_widget_show (swin);

	cfg.gtk.charset_list = gtk_clist_new (1);
#ifdef _GTK_FEATURES_1_2
	gtk_clist_set_reorderable(GTK_CLIST(cfg.gtk.charset_list) , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.charset_list) , 0 , TRUE);
#endif
	gtk_clist_set_selection_mode (GTK_CLIST (cfg.gtk.charset_list), GTK_SELECTION_BROWSE);
	gtk_container_add(GTK_CONTAINER(swin), cfg.gtk.charset_list);
	gtk_widget_show (cfg.gtk.charset_list);

	col = gtk_vbox_new(FALSE , 20);
	gtk_widget_show(col);
	gtk_table_attach (GTK_TABLE (brow), col , 1 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  10 , 10);


	arrow = gtk_arrow_new(GTK_ARROW_RIGHT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add (GTK_CONTAINER (col), button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.charset_list);

	arrow = gtk_arrow_new(GTK_ARROW_LEFT , GTK_SHADOW_OUT);
	gtk_widget_show(arrow);
	button = gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button) , arrow);
	gtk_widget_show(button);
	gtk_widget_set_usize(button , 25 , 25);
	gtk_container_add (GTK_CONTAINER (col), button);

	col = new_edit_list(&cfg.gtk.acharset_list , &cfg.gtk.acharset_entry ,
		gettext("Other Charset code: ") , &dbutton , &mbutton , &cbutton , &abutton , FALSE);
	gtk_table_attach_defaults (GTK_TABLE (brow), col , 2 , 3 , 0, 1);

	gtk_signal_connect(GTK_OBJECT(dbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListDeleteSelected) , 
			(gpointer) cfg.gtk.charset_list);

	e.entry = cfg.gtk.acharset_entry;
	e.list = cfg.gtk.charset_list;

	gtk_signal_connect(GTK_OBJECT(abutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.acharset_entry) , "activate" , 
			GTK_SIGNAL_FUNC(ListInsertEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(mbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListModifyEntry) , 
			(gpointer) &e);

	gtk_signal_connect(GTK_OBJECT(cbutton) , "clicked" , 
			GTK_SIGNAL_FUNC(ListClear) , 
			(gpointer) cfg.gtk.charset_list);

	gtk_signal_connect(GTK_OBJECT(cfg.gtk.charset_list) , "select_row" , 
			GTK_SIGNAL_FUNC(ListCopyToEntry) , 
			(gpointer) cfg.gtk.acharset_entry);

	p.entry = cfg.gtk.acharset_list;
	p.list = cfg.gtk.charset_list;

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(ListInsertList) , 
			(gpointer) &p);

	SET_LIST(cfg.gtk.acharset_list , char_sets);
}


/*** AUTH ***/
static void cfgtab_auth(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *label , *box , *frame , *ptab ,
		*cpom , *rb;
	GSList *rg;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Auth"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	col = gtk_table_new(5 , 2 , FALSE);
	gtk_widget_show(col);
	gtk_container_add (GTK_CONTAINER (box), col);

	frame = gtk_frame_new(gettext("HTTP user authentification"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 0 , 2 , 0 , 1 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	ptab = gtk_table_new(3 , 3 , FALSE);
	gtk_widget_show(ptab);
	gtk_container_add (GTK_CONTAINER (frame), ptab);

	cfg.gtk.auth_label = tab_add_entry(ptab , 
		gettext("Name: ") , 0 , 0 , FALSE);

	cfg.gtk.pass_label = tab_add_entry(ptab , 
		gettext("Password: ") , 0 , 1 , TRUE);

	cfg.gtk.auth_reuse_nonce = gtk_check_button_new_with_label(
		gettext("Reuse HTTP Digest access nonce"));
	gtk_widget_show(cfg.gtk.auth_reuse_nonce);
	gtk_table_attach (GTK_TABLE (ptab), cfg.gtk.auth_reuse_nonce , 0 , 2 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	frame = gtk_frame_new(gettext("Scheme"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (ptab), frame , 2 , 3 , 0 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cpom = gtk_vbox_new(TRUE , 5);
	gtk_widget_show(cpom);
	gtk_container_add (GTK_CONTAINER (frame), cpom);

	rb = gtk_radio_button_new_with_label(NULL , gettext("User auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.http_schgr[0] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("Base auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.http_schgr[1] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("Digest auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.http_schgr[2] = rb;

	frame = gtk_frame_new(gettext("HTTP proxy user authentification"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (col), frame , 0 , 2 , 1 , 2 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	ptab = gtk_table_new(3 , 3 , FALSE);
	gtk_widget_show(ptab);
	gtk_container_add (GTK_CONTAINER (frame), ptab);

	cfg.gtk.proxy_auth_label = tab_add_entry(ptab , 
		gettext("Name: ") , 0 , 0 , FALSE);

	cfg.gtk.proxy_pass_label = tab_add_entry(ptab , 
		gettext("Password: ") , 0 , 1 , TRUE);

	cfg.gtk.auth_reuse_proxy_nonce = gtk_check_button_new_with_label(
		gettext("Reuse HTTP Digest access nonce"));
	gtk_widget_show(cfg.gtk.auth_reuse_proxy_nonce);
	gtk_table_attach (GTK_TABLE (ptab), cfg.gtk.auth_reuse_proxy_nonce , 0 , 2 , 2 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);
	
	frame = gtk_frame_new(gettext("Scheme"));
	gtk_widget_show(frame);
	gtk_table_attach (GTK_TABLE (ptab), frame , 2 , 3 , 0 , 3 ,
			GTK_FILL , GTK_FILL,  5 , 5);

	cpom = gtk_vbox_new(TRUE , 5);
	gtk_widget_show(cpom);
	gtk_container_add (GTK_CONTAINER (frame), cpom);

	rb = gtk_radio_button_new_with_label(NULL , gettext("User auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.httpp_schgr[0] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("Base auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.httpp_schgr[1] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("Digest auth. scheme"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add (GTK_CONTAINER (cpom), rb);
	cfg.gtk.httpp_schgr[2] = rb;

	cfg.gtk.send_from = gtk_check_button_new_with_label(gettext("Send From: header with HTTP request"));
	gtk_table_attach(GTK_TABLE (col), cfg.gtk.send_from , 0 , 2 , 3 , 4 ,
		GTK_FILL , GTK_FILL,  5 , 5);
	gtk_widget_show(cfg.gtk.send_from);

	cfg.gtk.from_label = tab_add_entry(col , 
		gettext("E-mail address: ") , 0 , 4 , FALSE);

}

static void cfgtab_ssl(notebook)
GtkWidget *notebook;
{
#ifdef USE_SSL
	GtkWidget *label , *box , *frame , *ptab , *rb, *hbox;
	GSList *rg;

	box = gtk_vbox_new(0,5);
	gtk_widget_show(box);
	label = gtk_label_new(gettext("SSL"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box , label);

	frame = gtk_frame_new(gettext("SSL client certificate"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, TRUE, 5);

	ptab = gtk_table_new(4 , 2 , FALSE);
	gtk_widget_show(ptab);
	gtk_container_add(GTK_CONTAINER(frame), ptab);

	cfg.gtk.ssl_cert_passwd_en = tab_add_entry(ptab , 
		gettext("Certificate password: ") , 0 , 0 , TRUE);

	cfg.gtk.ssl_cert_file_en = tab_add_path_entry(ptab , 
		gettext("Certificate PEM file: ") , 0 , 1 , FALSE);

	cfg.gtk.ssl_key_file_en = tab_add_path_entry(ptab , 
		gettext("Certificate key file: ") , 0 , 2 , FALSE);

	cfg.gtk.ssl_cipher_list = tab_add_entry(ptab , 
		gettext("List of preffered ciphers: ") , 0 , 3 , FALSE);

	hbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(box), hbox, FALSE, TRUE, 5);
	gtk_widget_show(hbox);

	frame = gtk_frame_new(gettext("SSL protocol version"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(hbox), frame, FALSE, TRUE, 5);

	ptab = gtk_vbox_new(FALSE, 2);
	gtk_container_add(GTK_CONTAINER(frame), ptab);
	gtk_widget_show(ptab);

	rb = gtk_radio_button_new_with_label(NULL , gettext("SSLv23"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add(GTK_CONTAINER(ptab), rb);
	cfg.gtk.ssl_version[0] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("SSLv2"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add(GTK_CONTAINER(ptab), rb);
	cfg.gtk.ssl_version[1] = rb;

	rb = gtk_radio_button_new_with_label(rg , gettext("SSLv3"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(rb));
	gtk_widget_show(rb);
	gtk_container_add(GTK_CONTAINER(ptab), rb);
	cfg.gtk.ssl_version[2] = rb;

	ptab = gtk_vbox_new(FALSE, 2);
	gtk_box_pack_start(GTK_BOX(hbox), ptab, FALSE, TRUE, 5);
	gtk_widget_show(ptab);

	cfg.gtk.unique_sslid = gtk_check_button_new_with_label(gettext("Unique ID for all SSL sessions"));
	gtk_box_pack_start(GTK_BOX(ptab), cfg.gtk.unique_sslid, FALSE, TRUE, 5);
	gtk_widget_show(cfg.gtk.unique_sslid);
#endif
}

/*** LOG ***/
static void cfgtab_log(notebook)
GtkWidget *notebook;
{
	GtkWidget *col , *label , *box;

	box = gtk_vbox_new (0,5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Log"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	col = gtk_table_new(2 , 4 , FALSE);
	gtk_container_add (GTK_CONTAINER (box), col);
	gtk_widget_show(col);

	cfg.gtk.gen_logname = gtk_check_button_new_with_label(gettext("Try to find unique name, when original log file locked"));
	gtk_table_attach(GTK_TABLE(col), cfg.gtk.gen_logname, 0 , 2 , 0 , 1 , GTK_FILL , GTK_FILL , 1 , 1);
	gtk_widget_show(cfg.gtk.gen_logname);

	cfg.gtk.log_label = tab_add_path_entry(col , 
		gettext("Log file: ") , 0 , 1 , FALSE);

	cfg.gtk.slog_label = tab_add_path_entry(col ,
		gettext("Shortlog file: ") , 0 , 2 , FALSE);

	cfg.gtk.xloglen_label = tab_add_numentry(col , 
		gettext("Log window length: ") , 0 , 3 , INT_MAX);

}

/*** COOKIES ***/
static void cfgtab_cookies(notebook)
GtkWidget *notebook;
{
	GtkWidget *label , *box , *tbox , *hbox, *pom , *frame;
	GtkAdjustment *adj;

	tbox = gtk_hbox_new (0,5);
	gtk_widget_show(tbox);

	hbox = gtk_vbox_new (0,5);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(tbox) , hbox , TRUE , TRUE , 0);

	cfg.gtk.sw_cookie_update = 
		gtk_check_button_new_with_label(gettext("Update cookies"));
	gtk_widget_show(cfg.gtk.sw_cookie_update);
	gtk_box_pack_start(GTK_BOX(hbox) , cfg.gtk.sw_cookie_update , FALSE , FALSE , 0);

	cfg.gtk.sw_cookie_send = 
		gtk_check_button_new_with_label(gettext("Send cookies"));
	gtk_widget_show(cfg.gtk.sw_cookie_send);
	gtk_box_pack_start(GTK_BOX(hbox) , cfg.gtk.sw_cookie_send , FALSE , FALSE , 0);

	cfg.gtk.sw_cookie_recv = 
		gtk_check_button_new_with_label(gettext("Accept cookies"));
	gtk_widget_show(cfg.gtk.sw_cookie_recv);
	gtk_box_pack_start(GTK_BOX(hbox) , cfg.gtk.sw_cookie_recv , FALSE , FALSE , 0);

	cfg.gtk.cookie_check_domain = 
		gtk_check_button_new_with_label(gettext("Check cookies domain"));
	gtk_widget_show(cfg.gtk.cookie_check_domain);
	gtk_box_pack_start(GTK_BOX(hbox) , cfg.gtk.cookie_check_domain , FALSE , FALSE , 0);

	box = gtk_hbox_new(0,5);
	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(hbox) , box , FALSE , FALSE , 0);

	pom = gtk_label_new(gettext("Cookies maximal number: "));
	gtk_widget_show(pom);
	gtk_box_pack_start(GTK_BOX(box) , pom , FALSE , FALSE , 0);

	adj = (GtkAdjustment *) gtk_adjustment_new(0.0 , 0.0 , 10000.0 , 1.0 , 10.0 , 0.0);
	cfg.gtk.en_cookie_max = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_show(cfg.gtk.en_cookie_max);
	gtk_box_pack_start(GTK_BOX(box) , cfg.gtk.en_cookie_max , TRUE , FALSE , 0);

	box = gtk_hbox_new(0,5);
	gtk_widget_show(box);
	gtk_box_pack_start(GTK_BOX(hbox) , box , FALSE , FALSE , 0);

	pom = gtk_label_new(gettext("Cookie file: "));
	gtk_widget_show(pom);
	gtk_box_pack_start(GTK_BOX(box) , pom , FALSE , FALSE , 0);

	cfg.gtk.en_cookie_file = gtk_entry_new();
	gtk_widget_show(cfg.gtk.en_cookie_file);
	gtk_box_pack_start(GTK_BOX(box) , cfg.gtk.en_cookie_file , TRUE , TRUE , 0);

	pom = pixmap_button(browse_xpm , NULL , gettext("Browse ..."));
	gtk_widget_show(pom);
	gtk_box_pack_start(GTK_BOX(box) , pom , FALSE , TRUE , 0);

	gtk_signal_connect(GTK_OBJECT(pom) , "clicked" , 
			GTK_SIGNAL_FUNC(GetFile) , 
			(gpointer)cfg.gtk.en_cookie_file);

	frame = gtk_frame_new(gettext("Disabled cookie domains"));
	gtk_widget_show(frame);
	gtk_box_pack_end(GTK_BOX(tbox) , frame , TRUE , TRUE , 5);

	box = new_edit_list(&cfg.gtk.cookie_domain_list , &cfg.gtk.cookie_domain_entry ,
                gettext("Domain: ") , NULL , NULL , NULL , NULL , TRUE);
	gtk_container_add (GTK_CONTAINER (frame), box);

	label = gtk_label_new (gettext("Cookies"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tbox , label);

}

static void RulesSelectRow(w , func_data)
GtkWidget *w;
gpointer func_data;
{
	gchar *p;

#ifdef HAVE_REGEX
	 gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , 
		GPOINTER_TO_INT(GTK_CLIST(cfg.gtk.rules_list)->selection->data),
		0 , &p);

	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cfg.gtk.ptrn_fnmatch) , (*p == 'F'));
#endif

	 gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , 
		GPOINTER_TO_INT(GTK_CLIST(cfg.gtk.rules_list)->selection->data),
		1 , &p);
	gtk_entry_set_text(GTK_ENTRY(cfg.gtk.mpt_entry) , p);
	
	 gtk_clist_get_text(GTK_CLIST(cfg.gtk.rules_list) , 
		GPOINTER_TO_INT(GTK_CLIST(cfg.gtk.rules_list)->selection->data),
		2 , &p);
	gtk_entry_set_text(GTK_ENTRY(cfg.gtk.rule_entry) , p);
}

static void RulesAppend(w , func_data)
GtkWidget *w;
gpointer func_data;
{
	gchar *p[3];

	p[1] = gtk_entry_get_text(GTK_ENTRY(cfg.gtk.mpt_entry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(cfg.gtk.rule_entry));

#ifdef HAVE_REGEX
	p[0] = GTK_TOGGLE_BUTTON(cfg.gtk.ptrn_fnmatch)->active ? "F" : "R";

	if (!lfname_check_pattern(GTK_TOGGLE_BUTTON(cfg.gtk.ptrn_fnmatch)->active ?
		LFNAME_FNMATCH : LFNAME_REGEX , p[1]))
	{
		gdk_beep();
		return;
	}
#else
	p[0] = "F";
#endif


	if (p[1] && p[2] && *p[1] && *p[2])
		gtk_clist_append(GTK_CLIST(cfg.gtk.rules_list) , p);
	else
		gdk_beep();
}

static void RulesModify(w , func_data)
GtkWidget *w;
gpointer func_data;
{
	gchar *p[3];
	int row;

        if (!GTK_CLIST(cfg.gtk.rules_list)->selection)
        {
                gdk_beep();
                return;
        }

	row = GPOINTER_TO_INT(GTK_CLIST(cfg.gtk.rules_list)->selection->data);

	p[1] = gtk_entry_get_text(GTK_ENTRY(cfg.gtk.mpt_entry));
	p[2] = gtk_entry_get_text(GTK_ENTRY(cfg.gtk.rule_entry));

#ifdef HAVE_REGEX
	p[0] = GTK_TOGGLE_BUTTON(cfg.gtk.ptrn_fnmatch)->active ? "F" : "R";

	if (!lfname_check_pattern(GTK_TOGGLE_BUTTON(cfg.gtk.ptrn_fnmatch)->active ?
		LFNAME_FNMATCH : LFNAME_REGEX , p[1]))
	{
		gdk_beep();
		return;
	}
#else
	p[0] = "F";
#endif

	if (p[1] && p[2] && *p[1] && *p[2])
	{
		gtk_clist_set_text(GTK_CLIST(cfg.gtk.rules_list) , row , 0 , p[0]);
		gtk_clist_set_text(GTK_CLIST(cfg.gtk.rules_list) , row , 1 , p[1]);
		gtk_clist_set_text(GTK_CLIST(cfg.gtk.rules_list) , row , 2 , p[2]);
	}
	else
		gdk_beep();
}

static void cfgtab_filename(notebook)
GtkWidget *notebook;
{
	GtkWidget *label , *box , *frame , *ptab , *hbox , *swin , *button , *bbox;

	hbox = gtk_hbox_new (FALSE,5);
	gtk_widget_show(hbox);
	label = gtk_label_new (gettext("Filename"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), hbox , label);

	frame = gtk_frame_new(gettext("Local filename conversion rules"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(hbox) , frame , TRUE , FALSE , 5);

	box = gtk_vbox_new (FALSE,5);
	gtk_widget_show(box);
	gtk_container_add (GTK_CONTAINER (frame), box);

	frame = gtk_frame_new(gettext("Replace String1 with String2 in filename"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box) , frame , TRUE , FALSE , 5);

	ptab = gtk_table_new(2 , 2 , FALSE);
	gtk_container_add (GTK_CONTAINER (frame), ptab);
	gtk_widget_show(ptab);

	cfg.gtk.tr_str_s1 = tab_add_entry(ptab , 
		gettext("String1: ") , 0 , 0 , FALSE);

	cfg.gtk.tr_str_s2 = tab_add_entry(ptab , 
		gettext("String2: ") , 0 , 1 , FALSE);

	frame = gtk_frame_new(gettext("Delete characters from filename"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box) , frame , TRUE , FALSE , 5);

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_container_add (GTK_CONTAINER (frame), ptab);
	gtk_widget_show(ptab);

	cfg.gtk.tr_del_chr = tab_add_entry(ptab , 
		gettext("Character set: ") , 0 , 0 , FALSE);

	frame = gtk_frame_new(gettext("Replace chars from Set1 with chars from Set2 in filename"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(box) , frame , TRUE , FALSE , 5);

	ptab = gtk_table_new(2 , 2 , FALSE);
	gtk_container_add (GTK_CONTAINER (frame), ptab);
	gtk_widget_show(ptab);

	cfg.gtk.tr_chr_s1 = tab_add_entry(ptab , 
		gettext("Character set1: ") , 0 , 0 , FALSE);

	cfg.gtk.tr_chr_s2 = tab_add_entry(ptab , 
		gettext("Character set2: ") , 0 , 1 , FALSE);

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , TRUE , TRUE , 5);
	gtk_widget_show(ptab);

	cfg.gtk.base_level_label = tab_add_numentry(ptab , 
		gettext("Base level of tree: ") , 0 , 0 , USHRT_MAX);

	frame = gtk_frame_new(gettext("Local filename mapping rules"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(hbox) , frame , TRUE , TRUE , 5);
	
	box = gtk_vbox_new(0,5);
	gtk_widget_show(box);
	gtk_container_add (GTK_CONTAINER (frame), box);

	swin = gtk_scrolled_window_new(NULL , NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box) , swin , TRUE , TRUE , 5);
	gtk_widget_show (swin);

	cfg.gtk.rules_list = gtk_clist_new(3);
	gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.rules_list) , 0 , gettext("Type"));
	gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.rules_list) , 1 , gettext("Match pattern"));
	gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.rules_list) , 2 , gettext("Rule"));
	gtk_clist_column_titles_show(GTK_CLIST(cfg.gtk.rules_list));
#ifdef _GTK_FEATURES_1_2
	gtk_clist_set_reorderable(GTK_CLIST(cfg.gtk.rules_list) , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.rules_list) , 0 , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.rules_list) , 1 , TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.rules_list) , 2 , TRUE);
#endif
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.rules_list) , "select_row" ,
		GTK_SIGNAL_FUNC(RulesSelectRow) , NULL);
	gtk_container_add(GTK_CONTAINER(swin), cfg.gtk.rules_list);
	gtk_widget_show(cfg.gtk.rules_list);

#ifdef HAVE_REGEX
{
	GSList *rg = NULL;

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , FALSE , TRUE , 2);
	gtk_widget_show(ptab);

	cfg.gtk.ptrn_fnmatch = 
		gtk_radio_button_new_with_label(NULL , gettext("wildcard pattern"));
	rg = gtk_radio_button_group(GTK_RADIO_BUTTON(cfg.gtk.ptrn_fnmatch));
	gtk_widget_show(cfg.gtk.ptrn_fnmatch);
	gtk_table_attach(GTK_TABLE(ptab) , cfg.gtk.ptrn_fnmatch , 0 , 1 , 0 , 1 ,
		GTK_FILL , GTK_FILL , 2 , 2);

	cfg.gtk.ptrn_regex = 
		gtk_radio_button_new_with_label(rg , gettext("RE pattern"));
	gtk_widget_show(cfg.gtk.ptrn_regex);
	gtk_table_attach(GTK_TABLE(ptab) , cfg.gtk.ptrn_regex , 1 , 2 , 0 , 1 ,
		GTK_FILL , GTK_FILL , 2 , 2);
}
#endif

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , FALSE , TRUE , 2);
	gtk_widget_show(ptab);

	cfg.gtk.mpt_entry = tab_add_entry(ptab , 
		gettext("Matching pattern: ") , 0 , 0 , FALSE);

	ptab = gtk_table_new(2 , 1 , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , ptab , FALSE , TRUE , 2);
	gtk_widget_show(ptab);

	cfg.gtk.rule_entry = tab_add_entry(ptab , 
		gettext("Construction rule: ") , 0 , 0 , FALSE);

	bbox = gtk_hbutton_box_new();
	gtk_widget_show(bbox);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox) , GTK_BUTTONBOX_SPREAD);
	gtk_box_pack_start(GTK_BOX(box) , bbox , FALSE , TRUE , 5);

	button = pixmap_button(append_xpm , NULL , gettext("Append"));
	gtk_container_add(GTK_CONTAINER(bbox) , button);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(RulesAppend), NULL);

	button = pixmap_button(modify_xpm , NULL , gettext("Modify"));
	gtk_container_add(GTK_CONTAINER(bbox) , button);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(RulesModify), NULL);

	button = pixmap_button(clear_xpm , NULL , gettext("Clear"));
	gtk_container_add(GTK_CONTAINER(bbox) , button);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ListClear), cfg.gtk.rules_list);

	button = pixmap_button(delete_xpm , NULL , gettext("Delete"));
	gtk_container_add(GTK_CONTAINER(bbox) , button);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ListDeleteSelected), cfg.gtk.rules_list);
}

static void cfgtab_advert(notebook)
GtkWidget *notebook;
{
	GtkWidget *hbox, *vbox, *label, *box, *entry;

	hbox = gtk_hbox_new(FALSE,5);
	gtk_widget_show(hbox);
	label = gtk_label_new(gettext("Advertisement"));
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), hbox , label);

	vbox = gtk_vbox_new(FALSE ,1);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE , 1);
	gtk_widget_show(vbox);

	cfg.gtk.remove_adv = gtk_check_button_new_with_label(gettext("Enable removing of advertisement banners"));
	gtk_box_pack_start(GTK_BOX(vbox), cfg.gtk.remove_adv, FALSE, FALSE , 1);
	gtk_widget_show(cfg.gtk.remove_adv);

	box = new_edit_list(&cfg.gtk.advert_res , &entry ,
                gettext("RE for advertisement URLs: ") , NULL , NULL , NULL , NULL , TRUE);
	gtk_box_pack_start(GTK_BOX(vbox), box, TRUE, TRUE , 1);

}

/*** COMMON CFG ***/
static void build_config_comm(popup)
int popup;
{
	GtkWidget *col , *brow , *button , *notebook;

	if (cfg.gtk.config_shell)
	{
		if (popup)
		{
		 	gtk_widget_show_all(cfg.gtk.config_shell);
			if (GTK_WIDGET_REALIZED(cfg.gtk.config_shell))
				gdk_window_raise(cfg.gtk.config_shell->window);
		}
		return;
	}

	cfg.gtk.config_shell = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_border_width(GTK_CONTAINER(cfg.gtk.config_shell), 3);
	gtk_window_set_title(GTK_WINDOW(cfg.gtk.config_shell) , gettext("Pavuk: Common config"));
	gtk_widget_realize(cfg.gtk.config_shell);
	gtk_signal_connect(GTK_OBJECT(cfg.gtk.config_shell), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.config_shell);

	col = gtk_table_new(2 , 1 , FALSE);
	gtk_container_add(GTK_CONTAINER(cfg.gtk.config_shell), col);
	gtk_widget_show(col);

	cfg.gtk.cb_comcfg = notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook) , TRUE);
	gtk_table_attach_defaults(GTK_TABLE(col), notebook , 0 , 1, 0, 1);
	gtk_widget_show(notebook);

	cfgtab_url(notebook);
	
	cfgtab_graberI(notebook);

	cfgtab_graberII(notebook);
	
	cfgtab_net(notebook);

	cfgtab_proxy(notebook);

	cfgtab_lang(notebook);

	cfgtab_charset(notebook);

	cfgtab_auth(notebook);

	cfgtab_ssl(notebook);

	cfgtab_log(notebook);

	cfgtab_cookies(notebook);

	cfgtab_filename(notebook);

	cfgtab_advert(notebook);

	brow = gtk_hbutton_box_new();
	gtk_table_attach(GTK_TABLE(col), brow , 0, 1, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_FILL, 2 , 5);
	gtk_hbutton_box_set_spacing_default(1);
	gtk_widget_show(brow);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(brow) , GTK_BUTTONBOX_SPREAD);

	button = pixmap_button(ok_xpm , NULL , gettext("OK"));
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownWC) , 
			(gpointer)cfg.gtk.config_shell);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);
	gtk_widget_show(button);

	button = pixmap_button(apply_xpm , NULL , gettext("Apply"));
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(CfgCommon) , 
			(gpointer)cfg.gtk.config_shell);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	button = pixmap_button(limit_xpm , NULL , gettext("Limitations ..."));
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopupW) , 
			(gpointer)PAVUK_CFGLIM);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	button = pixmap_button(cancel_xpm , NULL , gettext("Cancel"));
#ifdef _GTK_FEATURES_1_2
{
	GtkAccelGroup *accel_group;
	accel_group = gtk_accel_group_new();

	gtk_widget_add_accelerator(button , "clicked" , accel_group ,
			GDK_Escape , 0 , GTK_ACCEL_VISIBLE);

	gtk_window_add_accel_group(GTK_WINDOW(cfg.gtk.config_shell) , accel_group);
}
#endif
	gtk_container_add(GTK_CONTAINER(brow), button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(PopdownW) , 
			(gpointer)cfg.gtk.config_shell);
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	if (popup) gtk_widget_show(cfg.gtk.config_shell);

	xset_cfg_values_comm();
}

static GtkWidget * toolbar_button(parent , label , help , pmap , cb , cb_data , alticon)
GtkWidget *parent;
char *label;
char *help;
char **pmap;
GtkSignalFunc cb;
gpointer cb_data;
char *alticon;
{
	GtkWidget *button = NULL;
	GtkWidget *pixmap = NULL;
	Icon *icon;

	if (alticon)
	{
		GdkPixmap *pm;
		GdkBitmap *mask;

		pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(cfg.gtk.toplevel)->window , &mask , NULL , alticon);

		if (pm)
		{
			pixmap = gtk_pixmap_new(pm , mask);
		}
	}
	if (pmap && !pixmap)
	{
		icon = load_pmap(pmap);

		pixmap = gtk_pixmap_new(icon->pixmap , icon->shape);
		free(icon);
	}

	button = gtk_toolbar_append_item(GTK_TOOLBAR(parent) , label , 
		help , "" , pixmap , cb  , cb_data);

	return button;
}

static void build_toolbar(parent)
GtkWidget *parent;
{
	GtkWidget *row , *hbox;

	cfg.gtk.toolbar = row = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL , 
						 GTK_TOOLBAR_BOTH);

#ifdef _GTK_FEATURES_1_2

	gtk_toolbar_set_button_relief(GTK_TOOLBAR(row) , GTK_RELIEF_NONE);

	hbox = gtk_handle_box_new ();
	gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(hbox) , GTK_SHADOW_NONE);
	gtk_box_pack_start(GTK_BOX(parent) , hbox , FALSE , TRUE , 0);
	gtk_widget_show(hbox);
	gtk_container_add (GTK_CONTAINER (hbox), row);
#else
	gtk_box_pack_start(GTK_BOX(parent) , row , FALSE , TRUE , 1);
#endif

	gtk_toolbar_set_space_size (GTK_TOOLBAR (row), 10);
	gtk_widget_show (row);

	cfg.gtk.bt_cfg = toolbar_button(row , gettext("Config") ,
			gettext("Popup config window") , configure_xpm ,
			GTK_SIGNAL_FUNC(PopupW) , (gpointer)PAVUK_CFGCOMM,
			cfg.gtk.bt_icon_cfg);

	gtk_toolbar_append_space (GTK_TOOLBAR(row));  

	cfg.gtk.bt_bg = toolbar_button(row , gettext("Go bg") , 
			gettext("Destroy window as soon as posible and continue on terminal") ,
			gobg_xpm , GTK_SIGNAL_FUNC(Gobg) , NULL,
			cfg.gtk.bt_icon_gobg);

	cfg.gtk.bt_rest = toolbar_button(row , gettext("Restart") ,
			gettext("Start working on currently set starting URLs") ,
			restart_xpm , GTK_SIGNAL_FUNC(Start) , (gpointer)TRUE,
			cfg.gtk.bt_icon_rest);

	cfg.gtk.bt_start = toolbar_button(row , gettext("Continue") ,
			gettext("Continue after stop or break") , continue_xpm ,
			GTK_SIGNAL_FUNC(Start) , (gpointer)FALSE,
			cfg.gtk.bt_icon_cont);

	gtk_toolbar_append_space (GTK_TOOLBAR(row));  

	cfg.gtk.bt_stop = toolbar_button(row , gettext("Stop") ,
			gettext("Finish this transfer and stop") , stop_xpm ,
			GTK_SIGNAL_FUNC(Stop) , (gpointer)NULL,
			cfg.gtk.bt_icon_stop);

	cfg.gtk.bt_break = toolbar_button(row , gettext("Break") ,
			gettext("Break transfer and stop") ,  break_xpm ,
			GTK_SIGNAL_FUNC(Break) , (gpointer)NULL,
			cfg.gtk.bt_icon_brk);

	gtk_toolbar_append_space (GTK_TOOLBAR(row));  

	cfg.gtk.bt_exit = toolbar_button(row , gettext("Exit") ,
			gettext("Immediately quit the program") , exit_xpm ,
			GTK_SIGNAL_FUNC(Quit) , (gpointer)NULL,
			cfg.gtk.bt_icon_exit);

	gtk_widget_set_sensitive(cfg.gtk.bt_start,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.bt_stop,FALSE);
	gtk_widget_set_sensitive(cfg.gtk.bt_break,FALSE);

}

void build_interface(argc,argv)
int *argc;
char **argv;
{
#ifdef _GTK_FEATURES_1_2
	char *p;
	char gtkrc[PATH_MAX];

	/* Parse the file ~/.pavuk-gtkrc. This makes Pavuk themeable :) */
	if ((p = getenv ("HOME")))
	{
		sprintf (gtkrc, "%s/.%s-gtkrc", p , PACKAGE);
		gtk_rc_add_default_file (gtkrc);
	}
#endif

	gtk_init (argc, &argv);
	gaccel_init();
	gaccel_load_keys();
}





#define BUILD_SH(sh , build_fnc) \
	if (sh) \
	{\
		gdk_window_get_position(GTK_WIDGET(sh)->window , &x , &y);\
		is_up = GTK_WIDGET_VISIBLE (sh);\
		gtk_widget_destroy(sh);\
		if (is_up)\
		{\
			build_fnc(TRUE);\
			gtk_widget_set_uposition(sh , x , y);\
		}\
		else sh = NULL;\
		_Xt_Serve;\
	}


void iface_loop()
{
	GtkWidget *col, *lbox, *frame;
	GtkWidget *sep, *tb, *hbox , *swin;
	GtkStyle *default_style;
	GdkFont *font;
	guint x;
	guint y;
	gboolean is_up;
	guint x_restart = 0;
	bool consens = FALSE;

	cfg.done = FALSE;
	cfg.log_autoscroll = TRUE;

	if (cfg.fontname && (font = gdk_font_load(cfg.fontname)))
	{
		default_style = gtk_widget_get_default_style();
		default_style->font = font;
	}

#ifdef GETTEXT_NLS
	last_lang = new_string(cfg.language);
	
	if (!last_lang)
	{
		last_lang = new_string(getenv("LC_MESSAGES"));
	}

	if (!last_lang)
	{
		last_lang = new_string(getenv("LANG"));
	}
#endif

	cfg.gtk.toplevel = NULL;
	cfg.gtk.about_shell = NULL;
	cfg.gtk.scn_load_shell = NULL;
	cfg.gtk.scn_save_shell = NULL;
	cfg.gtk.cfg_limits = NULL;
	cfg.gtk.config_shell = NULL;
	cfg.gtk.tree_shell = NULL;
	cfg.gtk.cfg_sch = NULL;
	
	while (_restart_iface && !_go_bg)
	{
		if (cfg.gtk.toplevel)
		{
			consens = GTK_WIDGET_SENSITIVE(cfg.gtk.bt_start);
			gdk_window_get_position(GTK_WIDGET(cfg.gtk.toplevel)->window , &x , &y);\
			is_up = TRUE;
			gtk_widget_destroy(cfg.gtk.toplevel);
		} else is_up = FALSE;

		cfg.gtk.toplevel = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(cfg.gtk.toplevel) ,
			FALSE , TRUE , FALSE);

#ifdef _GTK_FEATURES_1_2
		/*** DRAG'N'DROP ***/
  		gtk_drag_dest_set(cfg.gtk.toplevel, GTK_DEST_DEFAULT_ALL,
				dragtypes , NUM_ELEM(dragtypes) ,
                     		GDK_ACTION_COPY | GDK_ACTION_MOVE);
  		gtk_signal_connect(GTK_OBJECT(cfg.gtk.toplevel) ,
				"drag_data_received" ,
				GTK_SIGNAL_FUNC(window_drop_url),
				NULL);
#endif

		gtk_signal_connect (GTK_OBJECT (cfg.gtk.toplevel), "destroy",
			GTK_SIGNAL_FUNC(Quit), NULL);

		if (is_up) gtk_widget_set_uposition(cfg.gtk.toplevel , x , y);

		gtk_widget_realize(cfg.gtk.toplevel);
		gtk_container_border_width (GTK_CONTAINER (cfg.gtk.toplevel), 0);
		gtk_window_set_title(GTK_WINDOW(cfg.gtk.toplevel) , "Pavuk");

		col = gtk_vbox_new (FALSE , 0);
		gtk_container_add (GTK_CONTAINER (cfg.gtk.toplevel), col);
		gtk_widget_show (col);

		main_window_hide = gtk_vbox_new (FALSE , 0);
		gtk_box_pack_start(GTK_BOX(col) , main_window_hide , TRUE , TRUE , 0);
		gtk_widget_show(main_window_hide);

		BUILD_SH (cfg.gtk.about_shell , build_about);
		BUILD_SH (cfg.gtk.config_shell , build_config_comm);
		BUILD_SH (cfg.gtk.cfg_sch , build_config_sch);
		BUILD_SH (cfg.gtk.cfg_limits , build_config_lim);
		BUILD_SH (cfg.gtk.scn_load_shell , build_scenario_loader);
		BUILD_SH (cfg.gtk.scn_save_shell , build_scenario_saver);

		build_tree_preview(cfg.gtk.tree_shell ? 
			GTK_WIDGET_VISIBLE (cfg.gtk.tree_shell) : FALSE);

		build_menu(main_window_hide);

		gaccel_window_activate(cfg.gtk.accel_group , cfg.gtk.toplevel);
		if (!x_restart)
			gaccel_window_activate(cfg.gtk.tv_accel_group , cfg.gtk.tree_shell);

		sep = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(main_window_hide) , sep , FALSE , TRUE , 1);
		gtk_widget_show (sep);

		build_toolbar(main_window_hide);

		gtk_widget_set_sensitive(cfg.gtk.bt_start , consens);
		gtk_widget_set_sensitive(cfg.gtk.mea_start , consens);

		cfg.gtk.logw = gtk_clist_new(1);
		gtk_clist_set_column_title(GTK_CLIST(cfg.gtk.logw) , 0 , gettext("Log"));
		gtk_clist_column_titles_show(GTK_CLIST(cfg.gtk.logw));
		gtk_widget_set_usize(cfg.gtk.logw , -1 , 150);
#ifdef _GTK_FEATURES_1_2
		gtk_clist_set_column_auto_resize(GTK_CLIST(cfg.gtk.logw) , 0 , TRUE);

		swin = gtk_scrolled_window_new(NULL , NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (swin),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start(GTK_BOX(main_window_hide) , swin , TRUE , TRUE , 1);
		gtk_widget_show (swin);
		gtk_container_add(GTK_CONTAINER(swin) , cfg.gtk.logw);
		cfg.gtk.logvadj = GTK_RANGE(GTK_SCROLLED_WINDOW(swin)->vscrollbar)->adjustment;
#else
		gtk_clist_set_column_width (GTK_CLIST(cfg.gtk.logw) , 0 , 800);
		cfg.gtk.logvadj = GTK_RANGE(GTK_CLIST(cfg.gtk.logw)->vscrollbar)->adjustment;
		gtk_box_pack_start(GTK_BOX(main_window_hide) , cfg.gtk.logw , TRUE , TRUE , 1);
#endif
		gtk_widget_show(cfg.gtk.logw);

/*** mini toolbar ***/
		mini_toolbar = gtk_hbox_new(0,5);
		gtk_box_pack_start(GTK_BOX(col) , mini_toolbar , FALSE , TRUE , 1);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_box_pack_start(GTK_BOX(mini_toolbar), frame, TRUE , TRUE , 4);

		cfg.gtk.minitb_label = gtk_entry_new();
		gtk_widget_show(cfg.gtk.minitb_label);
		gtk_widget_set_usize(cfg.gtk.minitb_label, 400, -1);
		gtk_entry_set_editable(GTK_ENTRY(cfg.gtk.minitb_label), FALSE);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.minitb_label);


		tb = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL , 
						 GTK_TOOLBAR_ICONS);

#ifdef _GTK_FEATURES_1_2
		gtk_toolbar_set_button_relief(GTK_TOOLBAR(tb) , GTK_RELIEF_NONE);
#endif
		gtk_box_pack_end(GTK_BOX(mini_toolbar) , tb , FALSE , FALSE , 1);
		gtk_toolbar_set_space_size (GTK_TOOLBAR (tb), 2);
		gtk_widget_show (tb);

		cfg.gtk.mtb_rest = toolbar_button(tb , NULL ,
			gettext("Restart") , restart_small_xpm ,
			GTK_SIGNAL_FUNC(Start) , (gpointer)TRUE ,
			cfg.gtk.bt_icon_rest_s);

		cfg.gtk.mtb_start = toolbar_button(tb , NULL ,
			gettext("Continue") , continue_small_xpm ,
			GTK_SIGNAL_FUNC(Start) , (gpointer)FALSE ,
			cfg.gtk.bt_icon_cont_s);

		cfg.gtk.mtb_stop = toolbar_button(tb , NULL ,
			gettext("Stop") , stop_small_xpm ,
			GTK_SIGNAL_FUNC(Stop) , (gpointer)NULL,
			cfg.gtk.bt_icon_stop_s);

		cfg.gtk.mtb_break = toolbar_button(tb , NULL ,
			gettext("Break") , break_small_xpm ,
			GTK_SIGNAL_FUNC(Break) , (gpointer)NULL ,
			cfg.gtk.bt_icon_brk_s);

		toolbar_button(tb , NULL ,
			gettext("Show whole main window") , maximize_small_xpm ,
			GTK_SIGNAL_FUNC(DeMiniaturize) , (gpointer)col,
			cfg.gtk.bt_icon_mtb_s);

		toolbar_button(tb , NULL ,
			gettext("Quit") , close_small_xpm ,
			GTK_SIGNAL_FUNC(Quit) , (gpointer)NULL,
			cfg.gtk.bt_icon_exit_s);

		gtk_widget_set_sensitive(cfg.gtk.mtb_start,FALSE);
		gtk_widget_set_sensitive(cfg.gtk.mtb_stop,FALSE);
		gtk_widget_set_sensitive(cfg.gtk.mtb_break,FALSE);
/*** end mini toolbar ***/
#ifdef _GTK_FEATURES_1_2
		lbox = gtk_handle_box_new ();
		gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(lbox) , GTK_SHADOW_NONE);
		gtk_box_pack_start(GTK_BOX(col) , lbox , FALSE , TRUE , 0);
		gtk_widget_show(lbox);

		hbox = gtk_vbox_new(FALSE , 1);
		gtk_container_add (GTK_CONTAINER (lbox), hbox);
		gtk_widget_show(hbox);
#else
		hbox = col;
#endif
		lbox = gtk_hbox_new(FALSE,1);
		gtk_box_pack_start(GTK_BOX(hbox) , lbox , FALSE , TRUE , 1);
		gtk_widget_show (lbox);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.what_widget = gtk_label_new("                                              ");
		gtk_widget_show(cfg.gtk.what_widget);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.what_widget);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.cnt_widget = gtk_label_new("            ");
		gtk_widget_show(cfg.gtk.cnt_widget);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.cnt_widget);

		lbox = gtk_hbox_new(FALSE,1);
		gtk_box_pack_start(GTK_BOX(hbox) , lbox , FALSE , TRUE , 1);
		gtk_widget_show (lbox);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.size_widget = gtk_label_new("                  ");
		gtk_misc_set_alignment(GTK_MISC(cfg.gtk.size_widget) , 0.0 , 0.5);
		gtk_widget_show(cfg.gtk.size_widget);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.size_widget);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.s_rate = gtk_label_new("          ");
		gtk_misc_set_alignment(GTK_MISC(cfg.gtk.s_rate) , 0.0 , 0.5);
		gtk_widget_show(cfg.gtk.s_rate);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.s_rate);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.s_etime = gtk_label_new("            ");
		gtk_misc_set_alignment(GTK_MISC(cfg.gtk.s_etime) , 0.0 , 0.5);
		gtk_widget_show(cfg.gtk.s_etime);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.s_etime);

		frame = gtk_frame_new(NULL);
		gtk_widget_show(frame);
		gtk_container_add (GTK_CONTAINER (lbox), frame);

		cfg.gtk.s_rtime = gtk_label_new("            ");
		gtk_misc_set_alignment(GTK_MISC(cfg.gtk.s_rtime) , 0.0 , 0.5);
		gtk_widget_show(cfg.gtk.s_rtime);
		gtk_container_add (GTK_CONTAINER (frame), cfg.gtk.s_rtime);

		gtk_signal_connect (GTK_OBJECT (cfg.gtk.toplevel), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cfg.gtk.toplevel);

		gtk_widget_show (cfg.gtk.toplevel);

		icons_load();

		cfg.done = TRUE;

		_restart_iface = FALSE;

		if (cfg.gtk.config_shell)
			xset_cfg_values_comm();
		if (cfg.gtk.cfg_limits)
			xset_cfg_values_lim();

		if (!x_restart && cfg.run_iface)
		{
			Start(NULL , (gpointer)TRUE);
		}

		gtk_main ();
		
		x_restart ++;
		cfg.done = FALSE;
	}

	if (cfg.rbreak) return;

	if (cfg.gtk.toplevel)	gtk_widget_destroy(cfg.gtk.toplevel);
	if (cfg.gtk.about_shell) gtk_widget_destroy(cfg.gtk.about_shell);
	if (cfg.gtk.scn_load_shell) gtk_widget_destroy(cfg.gtk.scn_load_shell);
	if (cfg.gtk.scn_save_shell) gtk_widget_destroy(cfg.gtk.scn_save_shell);
	if (cfg.gtk.cfg_limits) gtk_widget_destroy(cfg.gtk.cfg_limits);
	if (cfg.gtk.config_shell) gtk_widget_destroy(cfg.gtk.config_shell);
	if (cfg.gtk.tree_shell) gtk_widget_destroy(cfg.gtk.tree_shell);
	if (cfg.gtk.cfg_sch) gtk_widget_destroy(cfg.gtk.cfg_sch);

	_Xt_Serve;
	my_sleep(2);
	_Xt_Serve;
	
	cfg.xi_face = FALSE;

	XCloseDisplay(gdk_display);

	dns_server_kill();

	if (cfg.mode != cfg.prev_mode || !cfg.mode_started)
	{	
		absi_restart();
	}
	else
	{
		absi_cont();
	}

	/*** required, because of some gtk atexit() hanged functions ***/
	pavuk_do_at_exit();
	_exit(cfg.fail_cnt);
}

void iface_set_counter(text)
char *text;
{
	gtk_label_set(GTK_LABEL(cfg.gtk.cnt_widget) , text);

	_Xt_Serve
}

void iface_set_what(text)
char *text;
{

	if (cfg.xi_face)
	{
		gtk_label_set(GTK_LABEL(cfg.gtk.what_widget) , text);
		_Xt_Serve
	}
	else
	{
		DEBUG_USER(" - %s\n" , text);
	}
}

void iface_set_size(sz , rate , etime , rtime)
char *sz;
char *rate;
char *etime;
char *rtime;
{
	char pom[40];

	sprintf(pom , "S: %s" , sz);
	gtk_label_set(GTK_LABEL(cfg.gtk.size_widget) , pom);
	sprintf(pom , "R: %s" , rate);
	gtk_label_set(GTK_LABEL(cfg.gtk.s_rate) , pom);
	sprintf(pom , "ET: %s" , etime);
	gtk_label_set(GTK_LABEL(cfg.gtk.s_etime) , pom);
	sprintf(pom , "RT: %s" , rtime);
	gtk_label_set(GTK_LABEL(cfg.gtk.s_rtime) , pom);

	_Xt_Serve
}

void iface_set_url(str)
char *str;
{
	if (GTK_WIDGET_VISIBLE(mini_toolbar) && !GTK_WIDGET_VISIBLE(main_window_hide))
		gtk_window_set_policy(GTK_WINDOW(cfg.gtk.toplevel) ,
			FALSE , TRUE , FALSE);

	gtk_entry_set_text(GTK_ENTRY(cfg.gtk.minitb_label) , str);
}

#ifdef WITH_TREE

#ifdef _GTK_FEATURES_1_2
GUI_TREE_RTYPE iface_make_tree_entry(urlp)
url *urlp;
{
	GtkCTreeNode *retv;
	GtkCTreeNode *parent;
	GdkBitmap *shape;
	GdkPixmap *pixmap;
	gchar *text[1];


	if (urlp->parent_url[urlp->ref_cnt-1] &&
	    urlp->parent_url[urlp->ref_cnt-1]->tree_nfo &&
	    urlp->parent_url[urlp->ref_cnt-1]->tree_nfo[0])
		parent = (GtkCTreeNode *) urlp->parent_url[urlp->ref_cnt-1]->tree_nfo[0];
	else
		parent = (GtkCTreeNode *) cfg.gtk.root;

	g_return_val_if_fail(parent != NULL, NULL);

	if (urlp->status & URL_PROCESSED)
	{
		gchar *text;
		guint8 sp;
		GdkPixmap *p;
		GdkBitmap *m;
		gboolean il,ex;
	
		gtk_ctree_get_node_info(GTK_CTREE(cfg.gtk.tree_widget) ,
			urlp->tree_nfo[0] , &text , &sp , &p , &m , 
			&pixmap , &shape, &il ,&ex);
	}
	else
	{
	 	pixmap = cfg.icon.notprocessed->pixmap;
		shape = cfg.icon.notprocessed->shape;
	}
	
	text[0] = url_to_urlstr(urlp , FALSE);

	retv = gtk_ctree_insert_node(GTK_CTREE(cfg.gtk.tree_widget) , parent ,
			NULL , text , 8 ,
			pixmap , shape , pixmap , shape , FALSE, TRUE);

	_free(text[0]);

	gtk_ctree_node_set_row_data(GTK_CTREE(cfg.gtk.tree_widget) , retv , (gpointer)urlp);

	_Xt_Serve

	return retv;		
}
#else
GUI_TREE_RTYPE iface_make_tree_entry(urlp)
url *urlp;
{
	GtkWidget *retv;
	GtkWidget* subtree = NULL;
	GtkWidget* pmap;
	GtkWidget* label;
	GtkWidget* row_box;
	char *p;


	if (urlp->parent_url[urlp->ref_cnt-1]) 
		subtree = GTK_TREE_ITEM_SUBTREE(urlp->parent_url[urlp->ref_cnt-1]->tree_nfo[0]);
	else
		subtree = GTK_TREE_ITEM_SUBTREE(cfg.gtk.root);

	if(!subtree)
	{
		subtree = gtk_tree_new();
		gtk_signal_connect (GTK_OBJECT (subtree), "event",
			(GtkSignalFunc) tree_list_events,
			subtree);
		gtk_signal_connect(GTK_OBJECT(subtree), "selection_changed",
			(GtkSignalFunc) SelectTreeNode,
			(gpointer)NULL);
		gtk_tree_item_set_subtree(
			GTK_TREE_ITEM((urlp->parent_url[urlp->ref_cnt - 1] ? 
				urlp->parent_url[urlp->ref_cnt - 1]->tree_nfo[0] : cfg.gtk.root)), subtree);
		gtk_widget_show(subtree);
	}


	retv = gtk_tree_item_new();
	gtk_object_set_user_data(GTK_OBJECT(retv) , (gpointer)urlp);
	gtk_tree_append(GTK_TREE(subtree) , retv);
	gtk_widget_show(retv);

	row_box = gtk_hbox_new(FALSE , 2);
	gtk_widget_show(row_box);
	gtk_container_add(GTK_CONTAINER(retv) , row_box);

	if (urlp->status & URL_PROCESSED)
	{
		GtkWidget *pbox;
		GtkPixmap *ppmap = NULL;
		GList *chlist;

		pbox = GTK_BIN(urlp->tree_nfo[0])->child;

		for (chlist = GTK_BOX(pbox)->children ; chlist ; chlist = chlist->next)
		{
			if (GTK_IS_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget))
			{
				ppmap = GTK_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget);
				break;
			}

		}
		if (ppmap)
			pmap = gtk_pixmap_new(ppmap->pixmap , ppmap->mask);
		else
			pmap = gtk_pixmap_new(cfg.icon.notprocessed->pixmap , 
				cfg.icon.notprocessed->shape);
	}
	else
		pmap = gtk_pixmap_new(cfg.icon.notprocessed->pixmap , 
			cfg.icon.notprocessed->shape);

	gtk_widget_show(pmap);
	gtk_box_pack_start(GTK_BOX(row_box) , pmap , FALSE , FALSE , 0);

	p = url_to_urlstr(urlp , FALSE);
	label = gtk_label_new(p);
	free(p);
	gtk_widget_show(label);
	gtk_label_set_justify(GTK_LABEL(label) , GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(row_box) , label , FALSE , FALSE , 0);
	
	_Xt_Serve

	return retv;
}
#endif
#endif


#endif

