/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"

#ifdef _GTK_FEATURES_1_2

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "gaccel.h"

GSList *gaccel_list = NULL;

void gaccel_init()
{
}

gaccel	*gaccel_new(name, sigid)
gchar *name;
gchar *sigid;
{
	gaccel *retv = _malloc(sizeof(gaccel));

	retv->name = new_string(name);
	retv->sigid = new_string(sigid);
	retv->widget = NULL;
	retv->modifier_mask = 0;
	retv->accelerator_key = 0;
	retv->accel_group = NULL;

	gaccel_list = g_slist_append(gaccel_list , retv);

	return retv;
}

gaccel	*gaccel_parse_str(str)
guchar *str;
{
	gaccel *retv = NULL;
	char *p1,*p2,*p3,*p;
	GdkModifierType modifier_mask;
	guint accelerator_key;

	if (!str) return NULL;

	p = new_string(str);

	p1 = get_1qstr(p);
	p2 = get_1qstr(NULL);
	p3 = get_1qstr(NULL);

	gtk_accelerator_parse(p3 , &accelerator_key , &modifier_mask);

	if (p1 && p2 && p3 && accelerator_key != 0)
	{
		retv = _malloc(sizeof(gaccel));

		retv->widget = NULL;
		retv->name = new_string(p1);
		retv->sigid = new_string(p2);
		retv->modifier_mask = modifier_mask;
		retv->accelerator_key = accelerator_key;
		retv->accel_group = NULL;
	}

	_free(p);
	return retv;
}

guchar *gaccel_to_str(gaccelp)
gaccel *gaccelp;
{
	static guchar pom[256];
	guchar *p;

	if (gaccelp->widget)
	{
		GSList *accel_list;

		accel_list = gtk_accel_group_entries_from_object(GTK_OBJECT(gaccelp->widget));

		gaccelp->accelerator_key = 0;
		gaccelp->modifier_mask = 0;

		while(accel_list)
		{
			GtkAccelEntry *ae = accel_list->data;
			if (ae->accel_flags & GTK_ACCEL_VISIBLE)
			{
				gaccelp->accelerator_key = ae->accelerator_key;
				gaccelp->modifier_mask = ae->accelerator_mods;
			}
			accel_list = accel_list->next;
		}
	}

	if (!gaccelp->accelerator_key) return NULL;

	p = gtk_accelerator_name(gaccelp->accelerator_key , gaccelp->modifier_mask);
	sprintf(pom , "\"%s\" \"%s\" \"%s\"" , gaccelp->name , gaccelp->sigid , p);

	p = pom;
	return p;
}

void gaccel_bind_widget(name, sigid , widget, accel_group)
gchar *name;
gchar *sigid;
GtkWidget *widget;
GtkAccelGroup *accel_group;
{
	static GtkAccelGroup *daccel_group = NULL;
	gaccel *gaccelp;

	if (!daccel_group) daccel_group = gtk_accel_group_get_default();

	if (!accel_group) accel_group = daccel_group;


	if (!widget) return;

	gaccelp = gaccel_find_by_name(name);

	if (!gaccelp)
	{
		gaccelp = gaccel_new(name , sigid);
	}

	gaccelp->widget = widget;
	gaccelp->accel_group = accel_group;

	if (gaccelp->accelerator_key)
		gtk_widget_add_accelerator(widget , gaccelp->sigid , accel_group ,
			gaccelp->accelerator_key , gaccelp->modifier_mask , 
			GTK_ACCEL_VISIBLE);
}

gaccel *gaccel_find_by_name(name)
gchar *name;
{
	GSList *lst = gaccel_list;

	while(lst)
	{
		if (!strcmp(((gaccel *)lst->data)->name , name))
			return (gaccel *)lst->data;
		lst = lst->next;	
	}

	return NULL;
}

void gaccel_add(gaccelp)
gaccel *gaccelp;
{
	gaccel_list = g_slist_append(gaccel_list , gaccelp);
}

void gaccel_window_activate(accelp , widget)
GtkAccelGroup *accelp;
GtkWidget* widget;
{
	gtk_window_add_accel_group(GTK_WINDOW(widget) , accelp);
}

void gaccel_load_keys()
{
	int sz;
	char lnbuf[PATH_MAX];
	char *lns;
	gaccel *ga;
	bufio *fd;
	char filename[PATH_MAX];

	sprintf(filename , "%s/.pavuk_keys" , cfg.path_to_home);

	if (!(fd = bufio_open(filename , O_BINARY | O_RDONLY)))
	{
		return;
	}	

	while((sz = bufio_readln(fd , lnbuf , sizeof(lnbuf)) > 0))
	{
		strip_nl(lnbuf);
		for(lns = lnbuf ; *lns && isspace(*lns) ; lns++);
		if (*lns == '#' || !*lns) continue;

		if (!strncasecmp(lnbuf , "MenuAccel:" , 10))
		{
			lns += 10;
			if ((ga = gaccel_parse_str(lns)))
			{
				gaccel_add(ga);
			}
			else
				xprintf(1 , gettext("Unable to parse \"%s\"\n") , lns);
		}
		else
			break;
	}
	bufio_close(fd);
}

void gaccel_save_keys()
{
	GSList *lst = gaccel_list;
	char *p;
	FILE *f;
	char filename[PATH_MAX];

	sprintf(filename , "%s/.pavuk_keys" , cfg.path_to_home);

	if (!(f = fopen(filename , "w")))
	{
		xperror(filename);
		return;
	}	

	fputs("#this file conatains user defined menu accelerators for pavuk web grabber\n\n" , f);
	
	while(lst)
	{
		p = gaccel_to_str(lst->data);
		if (p)
		{
			fprintf(f , "MenuAccel: %s\n" , p);
		}
		lst= lst->next;
	}
	fclose(f);
}

#endif
