/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <netdb.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <time.h>

#include "config.h"
#include "url.h"
#include "tools.h"
#include "ftp.h"
#include "net.h"
#include "doc.h"
#include "mode.h"
#include "http.h"
#include "dns.h"
#include "uexit.h"
#include "times.h"
#include "errcode.h"
#include "abstract.h"
#include "myssl.h"

static int ftp_control_write(docp, buf , bufsize)
doc *docp;
char *buf;
int bufsize;
{
	if (docp->doc_url->type == URLT_FTP)
	{
		return bufio_write(docp->ftp_control, buf, bufsize);
	}
#ifdef USE_SSL
	else if (docp->doc_url->type == URLT_FTPS)
	{
		return bufio_sslwrite(docp->ftp_control, buf, bufsize, docp->ftp_control_ssl_con);
	}
#endif
	return -1;
}

static int ftp_control_readln(docp, buf , bufsize)
doc *docp;
char *buf;
int bufsize;
{
	if (docp->doc_url->type == URLT_FTP)
	{
		return bufio_readln(docp->ftp_control, buf, bufsize);
	}
#ifdef USE_SSL
	else if (docp->doc_url->type == URLT_FTPS)
	{
		return bufio_sslreadln(docp->ftp_control, buf, bufsize, docp->ftp_control_ssl_con);
	}
#endif
	return -1;
}

/********************************************************/
/* zistenie navratoveho kodu z FTP servera 		*/
/********************************************************/
int ftp_get_response(docp, mbuf , setrc)
doc *docp;
char **mbuf;
int setrc;
{
	char buf[2048];
	bool end = FALSE;
	int alen,tlen=0;
	char *sresp = NULL;

	while (!end)
	{
		if ((alen = ftp_control_readln(docp, buf, sizeof(buf))) > 0)
		{
			DEBUG_PROTOS("%s" , buf);
			if (mbuf)
			{
				tlen +=alen;
				sresp = _realloc(sresp , tlen + 1);
				memcpy(sresp + tlen - alen , buf , alen + 1);
			}

			if(strlen(buf) > 3)
			{
				if (isdigit(*(buf)) && isdigit(*(buf + 1)) && 
				    isdigit(*(buf + 2)) && isspace(*(buf+3))) end = TRUE;
			}
		}
		else
		{
			if (alen)
				xperror("ftp_get_response");
			else
				xprintf(1 , gettext("ftp_get_response: ftp control connection closed before any response\n"));
			if (setrc) docp->ftp_respc = 600;
			return 600;
		}
	}

	if (mbuf) *mbuf = sresp;

	if (setrc) docp->ftp_respc = _atoi(buf);

	return _atoi(buf);
}

bufio *ftp_open_data(docp)
doc *docp;
{
	int port_no;
	char buf[256];
	char *mbuf;
	int reply,h0,h1,h2,h3,p0,p1,n;

	if (!cfg.ftp_activec || (cfg.ftp_proxy && cfg.ftp_dirtyp))
	{
		sprintf(buf , "PASV\r\n");
		DEBUG_PROTOC(buf);

		ftp_control_write(docp, buf, strlen(buf));

		mbuf = NULL;

		if ((reply = ftp_get_response(docp, &mbuf , TRUE)) >= 400)
		{
			shutdown(bufio_getfd(docp->ftp_control),2);
			bufio_close(docp->ftp_control);
			docp->ftp_control = NULL;
			docp->ftp_fatal_err = (reply == 600);
			docp->errcode = ERR_FTP_DATACON;
			_free(mbuf);
			return NULL;
		}

		if (!mbuf)
		{
			shutdown(bufio_getfd(docp->ftp_control),2);
			bufio_close(docp->ftp_control);
			docp->ftp_control = NULL;
			docp->errcode = ERR_FTP_DATACON;
			return NULL;
		}

		n = sscanf(mbuf, "%d %*[^(] (%d,%d,%d,%d,%d,%d)", &reply, &h0, &h1, &h2, &
			h3, &p0, &p1);

		_free(mbuf);

		if (n != 7 || reply != 227)
 		{
			docp->errcode = ERR_FTP_DATACON;
			return NULL;
 		}

		port_no = (p0 << 8) + p1;

		sprintf(buf , "%d.%d.%d.%d" , h0 , h1 , h2 , h3);

		if (cfg.ftp_proxy && cfg.ftp_dirtyp)
		{
			if (!(docp->datasock = bufio_fdopen(net_connect(cfg.ftp_proxy , cfg.ftp_proxy_port))))
			{
				docp->errcode = ERR_PROXY_CONNECT;
				return NULL;
 			}
			if (http_dumy_proxy_connect(docp, buf, port_no))
			{
				docp->errcode = ERR_PROXY_CONNECT;	
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
				return NULL;
			}
		}
		else
		{
			if (!(docp->datasock = bufio_fdopen(net_connect(buf , port_no))))
			{
				docp->errcode = ERR_FTP_DATACON;
				return NULL;		
	 		}
		}
	}
	else
	{
		struct sockaddr_in addr;
		char *p;
		struct in_addr pom;

		if (!docp->datasock)
		{
			if (!(docp->datasock = bufio_fdopen(net_bindport(0))))
				return NULL;
		}

		if (!cfg.local_host)
		{
			if (gethostname(buf , sizeof(buf))) return NULL;
			cfg.local_host = new_string(buf);
		}

		if (dns_gethostbyname(cfg.local_host , &n , (char *)&pom)) return NULL;

		n = sizeof(addr);
		if (getsockname(bufio_getfd(docp->datasock) , (struct sockaddr*) &addr, &n))
		{
			xperror("getsockname");
			shutdown(bufio_getfd(docp->datasock), 2);
			bufio_close(docp->datasock);
			docp->datasock = NULL;
			return NULL;
		}

		mbuf = inet_ntoa(pom);

		for(p = mbuf ; (p = strchr(p , '.')) ; *p = ',');
		
		sprintf(buf , "PORT %s,%d,%d\r\n" , mbuf ,
			ntohs(addr.sin_port) / 256 , ntohs(addr.sin_port) % 256);

		ftp_control_write(docp, buf, strlen(buf));
		DEBUG_PROTOC(buf);

		if ((reply = ftp_get_response(docp, NULL , TRUE)) >= 400)
		{
			docp->datasock = NULL;
			shutdown(bufio_getfd(docp->datasock),2);
			bufio_close(docp->datasock);
			docp->ftp_fatal_err = (reply == 600);
			docp->errcode = ERR_FTP_DATACON;
			return NULL;
		}
	}

#ifdef IP_TOS
#ifdef IPTOS_THROUGHPUT
	if (docp->datasock)
	{
		int v = IPTOS_THROUGHPUT;

		if (setsockopt(bufio_getfd(docp->datasock) , 
			IPPROTO_IP, IP_TOS, (char *)&v, sizeof(v)))
		{
			xperror(gettext("ftp: setsockopt TOS - THROUGHPUT failed"));
		}
	}
#endif
#endif

	return docp->datasock;
}

#define CLOSE_CONTROL \
	shutdown(bufio_getfd(docp->ftp_control),2);\
	bufio_close(docp->ftp_control);\
	docp->ftp_control = NULL;

bufio *ftp_open_control_connection(docp, host, port, user, password)
doc *docp;
char *host;
int port;
char *user;
char *password;
{
	char buf[2048];
	int reply;

	docp->errcode = ERR_NOERROR;
	docp->ftp_fatal_err = FALSE;
	docp->ftp_respc = 0;

	if (!docp->ftp_control)
	{
		if (cfg.ftp_proxy && cfg.ftp_dirtyp)
		{
			if (!(docp->datasock = bufio_fdopen(net_connect(cfg.ftp_proxy , cfg.ftp_proxy_port))))
			{
				docp->errcode = ERR_PROXY_CONNECT;
				return NULL;		
 			}

			if (http_dumy_proxy_connect(docp, host , port))
			{
				docp->errcode = ERR_PROXY_CONNECT;	
				return NULL;
			}
			docp->ftp_control = docp->datasock;
			docp->datasock = NULL;
		}
		else
		{
			if (!(docp->ftp_control = bufio_fdopen(net_connect(host,port))))
			{
				if (h_errno != 0)
					xherror(host);
				else
					xperror("net_connect");
				docp->errcode = ERR_FTP_CONNECT;
				docp->ftp_fatal_err = TRUE;
				return NULL;
			}
		}
		if (ftp_get_response(docp, NULL , TRUE) >= 400)
		{
			CLOSE_CONTROL;
			docp->ftp_fatal_err = TRUE;
			docp->errcode = ERR_FTP_CONNECT;
			return NULL;
		}
#ifdef USE_SSL
		if (docp->doc_url->type == URLT_FTPS)
		{
			sprintf(buf , "AUTH SSL\r\n");
			ftp_control_write(docp, buf, strlen(buf));
			DEBUG_PROTOC(buf);

			if ((reply = ftp_get_response(docp, NULL , TRUE)) != 334)
			{
				CLOSE_CONTROL;
				docp->ftp_fatal_err = (reply == 600);
				docp->errcode = ERR_FTPS_UNSUPORTED;
				return NULL;
			}

			if (!ssl_do_connect(docp, docp->ftp_control,
				&docp->ftp_control_ssl_con,
				&docp->ftp_control_ssl_ctx,
				&docp->ssl_method ,
				&docp->ftp_control_ssl_bio, NULL))

			{
				if (!docp->errcode) docp->errcode = ERR_FTPS_CONNECT;
				shutdown(bufio_getfd(docp->ftp_control) , 2);
				bufio_close(docp->ftp_control);
				docp->ftp_control = NULL;
				return NULL;
			}
		}
#endif
	
		sprintf(buf , "USER %s\r\n" , user);
		ftp_control_write(docp, buf, strlen(buf));
		DEBUG_PROTOC(buf);

		if ((reply = ftp_get_response(docp, NULL , TRUE)) >= 400)
		{
			CLOSE_CONTROL;
			docp->ftp_fatal_err = TRUE;
			docp->errcode = ERR_FTP_BUSER;
			return NULL;
		}

		if (reply == 331) /*** wee need password ***/
		{
			sprintf(buf , "PASS %s\r\n" , password);
			ftp_control_write(docp, buf, strlen(buf));
			DEBUG_PROTOC(buf);

			if (ftp_get_response(docp, NULL , TRUE) >= 400)
			{
				CLOSE_CONTROL;
				docp->ftp_fatal_err = TRUE;
				docp->errcode = ERR_FTP_BPASS;
				return NULL;
			}
		}

		sprintf(buf , "TYPE I\r\n");
		ftp_control_write(docp, buf, strlen(buf));
		DEBUG_PROTOC(buf);

		if ((reply = ftp_get_response(docp, NULL , TRUE)) >= 400)
		{
			CLOSE_CONTROL;
			docp->ftp_fatal_err = (reply == 600);
			docp->errcode = ERR_FTP_UNKNOWN;
			return NULL;
		}
#ifdef IP_TOS
#ifdef IPTOS_LOWDELAY
		if (docp->ftp_control)
		{
			int v = IPTOS_LOWDELAY;
			if (setsockopt(bufio_getfd(docp->ftp_control),
				IPPROTO_IP, IP_TOS, (char *)&v, sizeof(v)))
			{
				perror("ftp: setsockopt TOS - LOWDELAY failed");
			}
		}
#endif
#endif

	}
#ifdef DEBUG
	else
	{
		if (cfg.debug)
			xprintf(1 , gettext("Re-using established FTP control connection\n"));
	}
#endif

	return docp->ftp_control;
}

/****************************************************************/
/* otvorenie spojenia na FTP server, prihlasenie + zahajenie	*/
/* prenosu suboru / adresara					*/
/****************************************************************/
bufio *ftp_connect(docp, host, port , user , password , filename , is_dir , pos , modtime)
doc *docp;
char *host;
int port;
char *user;
char *password;
char *filename;
bool *is_dir;
int pos;
time_t modtime;
{
	char buf[2048];
	int reply;
	char *mbuf;

	docp->errcode = ERR_NOERROR;
	docp->ftp_fatal_err = FALSE;
	docp->ftp_respc = 0;
	*is_dir = FALSE;

	if (!(docp->ftp_control = ftp_open_control_connection(docp, host, port , user , password)))
		return NULL;

	if (!tl_is_dirname(filename) && 
		cfg.mode != MODE_FTPDIR)
	{ 
		sprintf(buf , "SIZE %s\r\n",filename);
		ftp_control_write(docp, buf, strlen(buf));
		DEBUG_PROTOC(buf);

		mbuf = NULL;
		if ((reply = ftp_get_response(docp, &mbuf , TRUE)) == 213)
		{
			sscanf(mbuf , "%d %d" , &reply , &docp->totsz);
		}
		else
		{
			if (reply == 600)
			{
				docp->errcode = ERR_READ;
				docp->ftp_fatal_err = TRUE;
				_free(mbuf);
				return NULL;
			}
		}

		_free(mbuf);

		if (reply != 550) /*** file doesn't exists or not plain file  == 550 ***/
		{
		    if (docp->check_limits && docp->totsz && cfg.condition.max_size && 
			docp->totsz > cfg.condition.max_size)
		    {
			docp->errcode = ERR_BIGGER;
			return NULL;
		    }
		    if (docp->check_limits && docp->totsz && cfg.condition.min_size && 
			docp->totsz > cfg.condition.min_size)
		    {
			docp->errcode = ERR_BIGGER;
			return NULL;
		    }


		    sprintf(buf , "MDTM %s\r\n" , filename);
		    ftp_control_write(docp, buf , strlen(buf));
		    DEBUG_PROTOC(buf);

		    mbuf = NULL;
		    if ((reply = ftp_get_response(docp, &mbuf, TRUE)) == 213)
		    {
			sscanf(mbuf , "%d %s" , &reply , buf);
			if (strlen(buf) == 14)
			{
				docp->dtime = time_ftp_scn(buf);
			}
		    }
		    else if (reply == 500 || reply == 502)
		    {
			docp->errcode = ERR_FTP_NOMDTM;
		    }
		    else
		    {
			if (reply == 600)
			{
				docp->ftp_fatal_err = TRUE;
				docp->errcode = ERR_READ;
				_free(mbuf);
				return NULL;
			}
		    }
		    _free(mbuf);


                    if (docp->origsize && docp->totsz && (docp->origsize != docp->totsz))
                    {
                    	xprintf(1 , gettext("Size differs, regeting whole\n"));
                    	pos = docp->rest_pos = 0;
                    }
		    else if (modtime && docp->dtime)
		    {
			if ((difftime(docp->dtime , modtime) > 0))
			{
				if (pos)
				{
					pos = 0;
					docp->rest_pos = 0;
					xprintf(1 , gettext("Modified from last download - regeting whole\n"));
				}
			}
			else if (cfg.mode == MODE_SYNC && !pos)
			{
				docp->errcode = ERR_FTP_ACTUAL;
				return NULL;
			}
			else
			{
				if (docp->check_limits && cfg.condition.btime &&
				    (difftime(docp->dtime , 
				   	     cfg.condition.btime) < 0))
				{
					docp->errcode = ERR_OUTTIME;
					return NULL;
				}
				if (docp->check_limits && cfg.condition.etime &&
				    (difftime(docp->dtime , 
				   	     cfg.condition.etime) > 0))
				{
					docp->errcode = ERR_OUTTIME;
					return NULL;
				}
			}
		    }

		    if (docp->check_limits && cfg.condition.uexit)
		    {
			if (!uexit_condition(docp->doc_url , 
				&docp->totsz ,
				docp->dtime))
			{
				docp->errcode = ERR_SCRIPT_DISABLED;
				return NULL;
			}
		    }

		    if (!(docp->datasock = ftp_open_data(docp)))
		    {
			docp->errcode = ERR_FTP_DATACON;
			return NULL;
		    }

		    if (pos)
		    {
			sprintf(buf , "REST %d\r\n" , pos);
			ftp_control_write(docp, buf , strlen(buf));
		        DEBUG_PROTOC(buf);
			if ((reply = ftp_get_response(docp, NULL , TRUE)) >= 400)
			{
				if (reply == 600)
				{
					docp->ftp_fatal_err = TRUE;
					shutdown(bufio_getfd(docp->datasock) , 2);
					bufio_close(docp->datasock);
					docp->datasock = NULL;
					docp->errcode = ERR_READ;
					return NULL;
				}
				docp->errcode = ERR_FTP_NOREGET;
			}
		    }

		    sprintf(buf , "RETR %s\r\n",filename);
		    ftp_control_write(docp, buf, strlen(buf));
		    DEBUG_PROTOC(buf);
		    if (!((reply = ftp_get_response(docp, NULL , TRUE)) >= 400))
		    {			
			if (cfg.ftp_activec && !(cfg.ftp_proxy && cfg.ftp_dirtyp))
			{
				bufio *dsock = bufio_fdopen(net_accept(bufio_getfd(docp->datasock)));
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = dsock;
			}
			docp->errcode = ERR_NOERROR;
#ifdef USE_SSL
			if (docp->datasock && docp->doc_url->type == URLT_FTPS)
			{
				if (!ssl_do_connect(docp, docp->datasock, 
					&docp->ssl_con, &docp->ssl_ctx,
					&docp->ssl_method, &docp->ssl_bio,
					docp->ftp_control_ssl_con))
				{
					if (!docp->errcode) docp->errcode = ERR_FTPS_DATASSLCONNECT;
					shutdown(bufio_getfd(docp->datasock), 2);
					bufio_close(docp->datasock);
					docp->datasock = NULL;
				}
			}
#endif
			return docp->datasock;
		    }

		    if (reply == 600)
		    {
		    	docp->ftp_fatal_err = TRUE;
			shutdown(bufio_getfd(docp->datasock) , 2);
			bufio_close(docp->datasock);
			docp->datasock = NULL;
			docp->errcode = ERR_READ;
			return NULL;
		    }
		    docp->errcode = ERR_FTP_GET;
		}
		else
		{
			docp->errcode = ERR_FTP_GET;
		}
	}
	else *is_dir = TRUE;

	if ((docp->check_limits && cfg.condition.ftpdir) || !docp->check_limits)
	{
		sprintf(buf , "CWD %s\r\n" , filename);
		ftp_control_write(docp, buf , strlen(buf));
		DEBUG_PROTOC(buf);

		if ((reply = ftp_get_response(docp, NULL , TRUE)) >= 400)
		{
			if (docp->datasock)
			{
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
			}
			docp->ftp_fatal_err = (reply == 600);
			docp->errcode = *is_dir ?
				ERR_FTP_NODIR : ERR_FTP_GET;
			return NULL;
		}
		

		if (!docp->datasock)
		{
			if (!(docp->datasock = ftp_open_data(docp)))
			{
				return NULL;
			}
		}

		if (cfg.ftp_list)
			sprintf(buf , "LIST\r\n");
		else
			sprintf(buf , "NLST\r\n");
		ftp_control_write(docp, buf, strlen(buf));
		DEBUG_PROTOC(buf);
		if (!((reply = ftp_get_response(docp, NULL , TRUE)) >= 400))
		{
			docp->errcode = ERR_NOERROR;
			*is_dir = TRUE;
			if (cfg.ftp_activec && !(cfg.ftp_proxy && cfg.ftp_dirtyp))
			{
				bufio *dsock = bufio_fdopen(net_accept(bufio_getfd(docp->datasock)));
				shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = dsock;
			}
#ifdef USE_SSL
			if (docp->datasock && docp->doc_url->type == URLT_FTPS)
			{
				if (!ssl_do_connect(docp, docp->datasock, 
					&docp->ssl_con, &docp->ssl_ctx,
					&docp->ssl_method, &docp->ssl_bio,
					docp->ftp_control_ssl_con))
				{
					if (!docp->errcode) docp->errcode = ERR_FTPS_DATASSLCONNECT;
					shutdown(bufio_getfd(docp->datasock), 2);
					bufio_close(docp->datasock);
					docp->datasock = NULL;
				}
			}
#endif
			return docp->datasock;
		}
		docp->ftp_fatal_err = (reply == 600);
		docp->errcode = ERR_FTP_BDIR;

	} else if (!cfg.condition.ftpdir && reply == 550 && *is_dir)
	{
		docp->errcode = ERR_FTP_DIRNO;
	}

	if (docp->datasock)
	{
		shutdown(bufio_getfd(docp->datasock) , 2);
		bufio_close(docp->datasock);
		docp->datasock = NULL;
	}

	return NULL;
}

/********************************************************/
/* pre dane  FTP URL vracia deskriptor datoveho spojenia*/
/********************************************************/
bufio *ftp_get_data_socket(docp , pos , modtime)
doc *docp;
int pos;
time_t modtime;
{
	char *user;
	char *password;
	char pom[100];
	bufio *s;
	bool sdir; 

	user = url_get_user(docp->doc_url, NULL);
	password = url_get_pass(docp->doc_url, NULL);

	if (!user)
		user = "anonymous";

	if (!password)
		password = cfg.send_from ? cfg.from : "pavuk@domain.xx"; 

	if (cfg.ftp_proxy && !cfg.ftp_dirtyp)
	{
		sprintf(pom , "%s@%s %d" , user , docp->doc_url->p.ftp.host ,
			 docp->doc_url->p.ftp.port);
		user = pom;
	}

	sdir = docp->doc_url->p.ftp.dir;

	s = ftp_connect(docp, cfg.ftp_proxy && !cfg.ftp_dirtyp ? 
			cfg.ftp_proxy : docp->doc_url->p.ftp.host , 
		cfg.ftp_proxy && !cfg.ftp_dirtyp ? 
			cfg.ftp_proxy_port : docp->doc_url->p.ftp.port , 
		user , password , docp->doc_url->p.ftp.path , &sdir ,
		pos , modtime);

	if (sdir != docp->doc_url->p.ftp.dir)
	{
		url_remove_from_hash_tab(docp->doc_url);
		docp->doc_url->p.ftp.dir = sdir;
		url_changed_filename(docp->doc_url);	
		url_add_to_hash_tab(docp->doc_url);
	}

	return s;
}

/********************************************************/
/* z FTP adresara urobi HTML dokument			*/
/********************************************************/
void ftp_nlst_dir_to_html(docp)
doc *docp;
{
	char *p,*res = NULL;
	char pom[8192];
	int tsize;
	bool last = 1;
	int ilen;

	sprintf(pom , gettext("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n\
<HTML>\n<TITLE>\nDirectory of %s://%s:%d%s\n</TITLE>\n<BODY>\n<H1 ALIGN=CENTER><B>\
List of FTP directory %s://%s:%d/%s </H1><BR><UL>") ,
prottable[docp->doc_url->type].urlid,
docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port , docp->doc_url->p.ftp.path ,
prottable[docp->doc_url->type].urlid ,
docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port , docp->doc_url->p.ftp.path);

	res = new_string(pom);
	tsize = strlen(pom);

	p = docp->contents;

	while (*p)
	{
		ilen = strcspn(p , "\r\n");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;
		
		if (docp->doc_url->p.ftp.user && docp->doc_url->p.ftp.password)
		{
			sprintf(pom , 
			"<LI><A HREF=\"%s://%s:%s@%s:%d%s/%s\">&quot;%s&quot;</A>\n" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.user , docp->doc_url->p.ftp.password ,
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , p , p);
		}
		else if (docp->doc_url->p.ftp.user)
		{
			sprintf(pom , 
			"<LI><A HREF=\"%s://%s@%s:%d%s/%s\">&quot;%s&quot;</A>\n" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.user , 
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , p , p);
		}
		else
			sprintf(pom , 
			"<LI><A HREF=\"%s://%s:%d%s/%s\">&quot;%s&quot;</A>\n" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , p , p);

		tsize += strlen(pom);
		res = _realloc(res , tsize + 1);

		strcat(res , pom);
		p += ilen + last;
		p += strspn(p , "\r\n");
	}
	
	tsize += 22;
	res = _realloc(res , tsize + 1);

	strcat(res , "</UL>\n</BODY>\n</HTML>\n");

	free(docp->contents);

	docp->contents = res;
	docp->size = tsize;
}

static int ftp_list_unix_perm_parse(str)
char *str;
{
	int perm = 0;
	int i;
	char *s;

	if (strlen(str) != 10)
		return -1;

	for (s = str+1 , i = 0; i < 3; i++ , s += 3)
	{
		perm <<= 3;
		if (s[0] == 'r') perm += 4;
		if (s[1] == 'w') perm += 2;
		if (s[2] == 'x') perm += 1;
	}
	return perm;
}

static int ftp_list_unix_perm_type(str)
char *str;
{
	switch (str[0])
	{
		case 'd': return FTP_TYPE_D;
		case 'l': return FTP_TYPE_L;
		default: return FTP_TYPE_F;
	}
}

static void ftp_list_unix_get_slink(str , nm ,ln)
char *str;
char **nm;
char **ln;
{
	char *p;

	*ln = NULL;
	*nm = str;

	if ((p = strstr(str , " -> ")))
	{
		*p = '\0';
		*ln = p + 4;
	}
}

static ftp_url_extension  *ftp_list_unix_parse_line(str, fname, ret)
char *str;
char **fname;
ftp_url_extension *ret;
{
	char pom[PATH_MAX];
	char name[PATH_MAX];
	char attrib[PATH_MAX];
	unsigned int pi;
	char *nm,*sln;

	*fname = NULL;

	if (sscanf(str , "%s %u %s %s %u %s %u %s %[^\n\r]" , attrib , &pi ,
		pom , pom , &(ret->size) , pom , &pi , pom , name)
		!= 9)
	{
		return NULL;
	}

	ret->type = ftp_list_unix_perm_type(attrib);
	ret->perm = ftp_list_unix_perm_parse(attrib);
	if (ret->perm == -1)
		return NULL;
	ftp_list_unix_get_slink(name , &nm , &sln);

	ret->slink = new_string(sln);
	*fname = new_string(nm);
	
	return ret;
}

static ftp_url_extension  *ftp_list_epfl_parse_line(str, fname, ret)
char *str;
char **fname;
ftp_url_extension *ret;
{
	char *p;

	*fname = NULL;

	if (*str != '+')
	{
		return NULL;
	}

	p = strchr(str , '\x09');
	if (!p)
	{
		return NULL;
	}
	*fname = new_string(p+1);
	*p = '\0';

	ret->type = FTP_TYPE_F;
	ret->size = 0;

	p = strtokc(str + 1 , ',');

	while(p)
	{
		switch (*p)
		{
			case 'r':
				ret->type = FTP_TYPE_F;	
			break;
			case '/':
				ret->type = FTP_TYPE_D;
			break;
			case 's':
				ret->size = _atoi(p+1);
			break;
		}
		p = strtokc(NULL, ',');
	}
	ret->slink = NULL;
	ret->perm = (4 << 6) + (2 << 6) + (2 << 3) + 2;

	
	return ret;
}

static ftp_url_extension  *ftp_list_novel_parse_line(str, fname, ret)
char *str;
char **fname;
ftp_url_extension *ret;
{
	char pom[PATH_MAX];
	char name[PATH_MAX];
	char attrib[PATH_MAX];
	unsigned int pi;

	*fname = NULL;

	if (sscanf(str , "%s %u %s %u %s %u %s %[^\n\r]" , attrib , &pi ,
		pom , &(ret->size) , pom , &pi , pom , name)
		!= 8)
	{
		return NULL;
	}

	ret->type = *attrib == 'd' ? FTP_TYPE_D : FTP_TYPE_F;
	ret->slink = NULL;
	ret->perm = (4 << 6) + (2 << 6) + (2 << 3) + 2;

	*fname = new_string(name);
	
	return ret;
}

/********************************************************/
/* z vypisu FTP adresara urobi HTML dokument		*/
/********************************************************/
void ftp_list_unix_dir_to_html(docp)
doc *docp;
{
	char *p,*res = NULL;
	char pom[8192];
	char urlstr[4096];
	int tsize;
	ftp_url_extension *ext;
	ftp_url_extension exta;
	char *name;
	int ilen;
	bool last = 1;

	sprintf(pom , gettext("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n\
<HTML>\n<TITLE>\nDirectory of %s://%s:%d%s\n</TITLE>\n<BODY>\n<H1 ALIGN=CENTER><B>\
List of FTP directory %s://%s:%d/%s </H1><BR><UL>") ,
prottable[docp->doc_url->type].urlid ,
docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port , docp->doc_url->p.ftp.path ,
prottable[docp->doc_url->type].urlid ,
docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port , docp->doc_url->p.ftp.path);

	res = new_string(pom);
	tsize = strlen(pom);

	/*** skip first total line ***/
	p = docp->contents + strcspn(docp->contents , "\r\n");
	p += strspn(p , "\r\n");

	while(*p)
	{
		ilen = strcspn(p , "\r\n");
		if (*(p+ilen)) *(p+ilen) = '\0';
		else last = 0;

		if (*p == '+')
			ext = ftp_list_epfl_parse_line(p , &name, &exta);
		else if (*(p + 1) == '[')
			ext = ftp_list_novel_parse_line(p , &name, &exta);
		else
			ext = ftp_list_unix_parse_line(p , &name, &exta);

		if (!ext)
		{
			xprintf(1 , gettext("ERROR: unable to parse FTP list line :\n\t%s\n") , p);
			p += ilen + last;
			p += strspn(p , "\r\n");
			continue;
		}

		if (!strcmp(name , ".") || !strcmp(name , ".."))
		{
			p += ilen + last;
			p += strspn(p , "\r\n");
			continue;
		} 

		if (docp->doc_url->p.ftp.user && docp->doc_url->p.ftp.password)
		{
			sprintf(urlstr , "%s://%s:%s@%s:%d%s/%s" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.user , docp->doc_url->p.ftp.password ,
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , name);
		}
		else if (docp->doc_url->p.ftp.user)
		{
			sprintf(urlstr , "%s://%s@%s:%d%s/%s" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.user , 
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , name);
		}
		else
			sprintf(urlstr , "%s://%s:%d%s/%s" ,
			prottable[docp->doc_url->type].urlid ,
			docp->doc_url->p.ftp.host , docp->doc_url->p.ftp.port ,
			docp->doc_url->p.ftp.path , name);

		sprintf(pom , "<LI><A PAVUKEXT=\"FTPINF %u %u %u %s\" HREF=\"%s\">&quot;%s&quot;</A> (%ub)\n" ,
			ext->type , ext->perm , ext->size , 
			(ext->slink ? ext->slink : "") ,
			urlstr , name , ext->size);

		_free(name);
		_free(ext->slink);

		tsize += strlen(pom);
		res = _realloc(res , tsize + 1);
		strcat(res , pom);

		p += ilen + last;
		p += strspn(p , "\r\n");
	}

	tsize += 22;
	res = _realloc(res , tsize + 1);

	strcat(res , "</UL>\n</BODY>\n</HTML>\n");

	free(docp->contents);

	docp->contents = res;
	docp->size = tsize;
}

void ftp_dir_to_html(docp)
doc *docp;
{
	if (!cfg.ftp_list)
		ftp_nlst_dir_to_html(docp);
	else
	{
		ftp_list_unix_dir_to_html(docp);
	}
}

ftp_url_extension *ftp_parse_ftpinf_ext(str)
char *str;
{
	ftp_url_extension *rv;
	char pom[8192];
	unsigned int t,p,s;
	int num;

	if (strncmp(str , "FTPINF" , 6))
		return NULL;

	num = sscanf(str , "FTPINF %u %u %u %[^\n\r]" , &t , &p , &s , pom);
		
	if (num < 3) return NULL;

	rv = _malloc(sizeof(ftp_url_extension));

	rv->perm = p;
	rv->size = s;
	rv->type = t;
	rv->slink = (num == 4) ? new_string(pom) : NULL;

	return rv;
}

int ftp_make_symlink(urlp)
url *urlp;
{
	char pom[PATH_MAX];
	char *frompath,*topath;
	char *p;
	ftp_url_extension *ext = (ftp_url_extension *)urlp->extension; 
	int rv;

	frompath = new_string(url_to_filename(urlp , TRUE));

	if (!cfg.preserve_links)
	{
		if (ext->slink[0] == '/')
		{
			url_remove_from_hash_tab(urlp);
			p = urlp->p.ftp.path;
			urlp->p.ftp.path = ext->slink;
			url_changed_filename(urlp);
			topath  = new_string(url_to_filename(urlp , TRUE));
			urlp->p.ftp.path = p;
			url_changed_filename(urlp);
			url_add_to_hash_tab(urlp);
		}
		else
		{
			strcpy(pom , urlp->p.ftp.path);
			p = strrchr(pom , '/');
			if (p) *(p+1) = '\0';
			strcat(pom , ext->slink);

			url_remove_from_hash_tab(urlp);
			p = urlp->p.ftp.path;
			urlp->p.ftp.path = pom;
			url_changed_filename(urlp);
			topath  = new_string(url_to_filename(urlp , TRUE));
			urlp->p.ftp.path = p;
			url_changed_filename(urlp);
			url_add_to_hash_tab(urlp);
		}
		p = topath;
		topath = get_relative_path(frompath , p);
		_free(p);
	}
	else topath = NULL;

	xprintf(1 , gettext("Making symlink \"%s\" to \"%s\"\n"),
		frompath , topath ? topath : ext->slink);
	
	if (makealldirs(frompath))
		xperror(frompath);

	if (!access(frompath , F_OK))
	{
		if(unlink(frompath))
			xperror(frompath);
	}

	rv = symlink(topath ? topath : ext->slink , frompath);

	if (rv == -1)
		xperror("topath");

	_free(topath);
	_free(frompath);

	return rv;
}

