/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _doc_h_
#define _doc_h_
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>

#ifdef USE_SSL
#include <stdio.h>
#ifdef OPENSSL
#include <openssl/ssl.h>
#else
#include <ssl.h>
#endif
#endif

#include "url.h"
#include "tools.h"
#include "bufio.h"

#define _RELOAD 1

typedef struct {
	int		doc_nr;		/*** number of document in queue ***/
        url     	*doc_url;	/*** URL of document ***/
        char		*mime;		/*** MIME header of document ***/
        char		*type_str;	/*** MIME type of document ***/
        bool		is_html;	/*** is this HTML documemt ***/
        ssize_t     	size;		/*** document size readed ***/
        char    	*contents;	/*** document content ***/
        bool		save_online;	/*** document should be saved online ***/
        time_t		dtime;		/*** creation time of document ***/
        time_t		stime;		/*** time of document request ***/
        ssize_t		rest_pos;	/*** restart position ***/
	char 		*etag;		/*** ETag or Last-Modified for conditional partial HTTP GET method ***/
	int		errcode;	/*** error code */
	ssize_t		totsz;		/*** total size of document if known ***/
	ssize_t		origsize;	/*** original size of document ***/
	bufio		*datasock;	/*** socket for data connection ***/
	bool		ftp_fatal_err;	/*** was FTP error fatal ? ***/
	short		ftp_respc;	/*** last FTP response code ***/
	bufio		*ftp_control;	/*** socket for FTP control connection ***/
	bufio		*s_sock;	/*** file where is going online saved data ***/
	char		*lock_fn;	/*** lock file name for document ***/
	bool		remove_lock;	/*** remove lock file ***/
	bool		check_limits;
	bool		report_size;
#ifdef USE_SSL
	SSL		*ssl_con;
	BIO		*ssl_bio;
	SSL_CTX		*ssl_ctx;
	SSL_METHOD	*ssl_method;
	/*** for FTP control connection over   ***/
	/*** SSL as implemented in wu-ftpd+SSL ***/
	SSL		*ftp_control_ssl_con;
	BIO		*ftp_control_ssl_bio;
	SSL_CTX		*ftp_control_ssl_ctx;
#endif
	void		*auth_digest;  /*** HTTP digest access authentification info ***/
	void		*auth_proxy_digest;    /*** HTTP digest access proxy authentification info ***/
#ifdef HAVE_GETTIMEOFDAY
	struct timeval	start_time;	/*** for progress metter ***/
#else
	time_t		start_time;	/*** for progress metter ***/
#endif
	ssize_t		current_size;	/*** size for current speed ***/

	bool		is_http11;
	ssize_t		chunk_size;	/*** for HTTP/1.1 chunked transfer encoding ***/
	bool		is_chunked;
	bool		read_chunksize;
	bool		read_trailer;
	bool		is_persistent;
} doc;

extern int doc_download(doc * , int , int);
extern int doc_store(doc * , int);
extern int doc_remove(url *);
extern void doc_init(doc *, url *);
extern void doc_remove_lock(doc *);
extern time_t doc_etime(doc *,int);

#endif
