/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif
#ifdef HAVE_FSTATVFS
#ifdef HAVE_SYS_STATVFS_H
#include  <sys/statvfs.h>
#endif
#else
#ifdef HAVE_FSTATFS
#ifdef HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif
#endif
#endif
#include <sys/time.h>
#include <time.h>
#include <utime.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif

#include "config.h"
#include "url.h"
#include "doc.h"
#include "tools.h"
#include "mime.h"
#include "http.h"
#include "ftp.h"
#include "gopher.h"
#include "html.h"
#include "decode.h"
#include "abstract.h"
#include "mode.h"
#include "times.h"
#include "uexit.h"
#include "dinfo.h"
#include "errcode.h"

#ifdef I_FACE
static void doc_set_info();
#endif

static void show_progress(doc *, ssize_t, int);
static double compute_speed_rate(time_t, ssize_t);

/********************************************************/
/* nacitanie dokumentu + specificke upravy		*/
/********************************************************/
int doc_download(docu , load , b_lock)
doc * docu;
int load;
int b_lock;
{
	char *buf;
	int bufsize;
	char *p=NULL,*p1,*p3;
	ssize_t totallen = 0,len;
	ssize_t sz;
	ssize_t adj_sz = 0;
	http_response *resp;
	int retcode = 0;
	int mres;
	bool fnd;
	char *fn,*inname;
	struct stat estat;
	bool havelock = FALSE;
	time_t modtime = docu->dtime;
	int t_error = 0;

	docu->remove_lock = TRUE;
	docu->lock_fn = NULL;
	docu->is_html = FALSE;
	docu->contents = NULL;
	docu->mime = NULL;
	docu->type_str = NULL;
	docu->save_online = FALSE;
	docu->size = 0;
	docu->current_size = 0;
	docu->totsz = 0;
	docu->origsize = 0;
	docu->rest_pos = 0;
	docu->stime = time(NULL);
	docu->s_sock = NULL;

	fn = url_to_filename(docu->doc_url , TRUE);

	if (cfg.mode != MODE_SYNC)
	{
		if (docu->doc_url->type != URLT_FILE && !access(fn , R_OK))
		{
			if (!stat(fn , &estat))
			{
				if (!S_ISDIR(estat.st_mode))
				{
					docu->doc_url->status |= URL_REDIRECT;
				}
				else
				{
					char pom[4096];
					char *savepath = url_get_path(docu->doc_url);

					sprintf(pom , "%s/%s" , fn , cfg.index_name);
					if (!stat(pom , &estat))
					{
						if (!S_ISDIR(estat.st_mode))
		                                {
							url_remove_from_hash_tab(docu->doc_url);

							if (docu->doc_url->type != URLT_FILE)
								sprintf(pom , "%s/" , savepath);
							if (docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS)
								docu->doc_url->p.ftp.dir = TRUE;

							url_set_path(docu->doc_url , pom);
							fn = pom;
                		                        docu->doc_url->status |= URL_REDIRECT;
							url_changed_filename(docu->doc_url);

							url_add_to_hash_tab(docu->doc_url);
                                		}
					}
				}
			}
		}

		if ((docu->doc_url->type == URLT_FILE || (docu->doc_url->status & URL_REDIRECT)) && !load)
		{
			if (!stat(fn , &estat))
			{
				if (S_ISDIR(estat.st_mode))
				{
					docu->errcode= ERR_DIR_URL;
					return -1;
				}
			}
			else
			{
				docu->errcode= ERR_FILE_OPEN;
				return -1;
			}

			if ((!cfg.ftp_html && 
				(docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) &&
				!docu->doc_url->p.ftp.dir) || !file_is_html(fn))
			{
				docu->is_html = FALSE;
				docu->save_online = TRUE;
				docu->size = estat.st_size;
#ifdef I_FACE
				if (cfg.xi_face)
					doc_set_info(docu);
#endif
				xprintf(1 , gettext("File redirect\n"));
				return 0;
			}
			else
			{
				if (!strcasecmp("css" , get_extension(fn)))
					docu->doc_url->status |= URL_STYLE;
				docu->is_html = TRUE;
			}
		}
	}
	else
	{
		if (!stat(fn , &estat))
		{
			docu->origsize = estat.st_size;
		}
	}

	if ((inname = url_to_in_filename(docu->doc_url)))
	{
		if (!stat(inname , &estat) && !S_ISDIR(estat.st_mode))
		{
			if (!(docu->s_sock = 
				bufio_copen(inname , O_BINARY | O_RDWR , S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)))
			{
				xperror(inname);
				_free(inname);
				docu->errcode = ERR_STORE_DOC;
				return -1;
			}
			else
			{
				if (_flock(bufio_getfd(docu->s_sock) , inname , O_BINARY | O_RDWR  , b_lock))
				{
					docu->errcode = ERR_LOCKED;
					_free(inname);
					return -1;
				}
				havelock = TRUE;
				docu->lock_fn = new_string(inname);
			}
			docu->rest_pos = estat.st_size - cfg.rollback;
			if (docu->rest_pos)
			{
				xprintf(1 , gettext("Trying to resume from position %d \n") ,
					docu->rest_pos);

				modtime = estat.st_mtime;
				docu->stime = estat.st_mtime;
			}
		}
	}

	_free(inname);

	if (docu->report_size)
		iface_set_what(gettext("Opening connection"));

	if (!(docu->datasock = abs_get_data_socket(docu , docu->rest_pos , modtime)))
	{
		docu->remove_lock = FALSE;
		abs_close_socket(docu, FALSE);
		return -1;
	}

	doc_etime(docu, TRUE);

	if ((((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) && !docu->doc_url->p.ftp.dir)
	   || (docu->doc_url->type == URLT_GOPHER && docu->doc_url->p.gopher.type != '1') || 
	   	(docu->doc_url->type == URLT_HTTP || docu->doc_url->type == URLT_HTTPS)) &&
	   	!(docu->doc_url->status & URL_REDIRECT))
	{
		docu->save_online = TRUE;
	}

	if ((inname = url_to_in_filename(docu->doc_url)))
	{
		if (cfg.mode != MODE_NOSTORE && cfg.mode != MODE_FTPDIR)
			if (makealldirs(inname))
				xperror(inname);
	}
	else
	{
		abs_close_socket(docu, FALSE);
		docu->errcode = ERR_UNKNOWN;
		return -1;		
	}

	if (cfg.ftp_html && 
		(docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) && 
		ext_is_html(docu->doc_url->p.ftp.path))
	{
		docu->is_html = TRUE;
	}

	if (access(inname , R_OK))
	{
	    if (!havelock)
	    {
		if (!(docu->s_sock = 
			bufio_copen(inname , O_BINARY | O_CREAT | O_TRUNC | O_RDWR , S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)))
		{
			xperror(inname);
			_free(inname);
			docu->errcode = ERR_STORE_DOC;
			abs_close_socket(docu, FALSE);
			return -1;
		}
		else
		{
			if (_flock(bufio_getfd(docu->s_sock) , inname , O_BINARY | O_CREAT | O_TRUNC | O_RDWR , b_lock))
			{
				docu->errcode = ERR_LOCKED;
				_free(inname);
				abs_close_socket(docu, FALSE);
				return -1;
			}
			havelock = TRUE;
			docu->lock_fn = new_string(inname);
		}
	    }
	}
	else
	{
	    if (!havelock)
	    {
		if (!(docu->s_sock = 
			bufio_copen(inname , O_BINARY | O_RDWR , S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)))
		{
			xperror(inname);
			_free(inname);
			docu->errcode = ERR_STORE_DOC;
			abs_close_socket(docu, FALSE);
			return -1;
		}
		else
		{
			DEBUG_LOCKS("Locking %s\n" ,inname);
			if (_flock(bufio_getfd(docu->s_sock) , inname , O_BINARY | O_RDWR , b_lock))
			{
				docu->errcode = ERR_LOCKED;
				_free(inname);
				abs_close_socket(docu, FALSE);
				return -1;
			}
			havelock = TRUE;
			docu->lock_fn = new_string(inname);
		}
	    }
	}
	_free(inname);

	if ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTP) && 
	   !(docu->doc_url->status & URL_REDIRECT) &&
	    docu->errcode == ERR_FTP_NOREGET && !cfg.freget &&
	    (!cfg.ftp_proxy || (cfg.ftp_proxy && !cfg.ftp_via_http)))
	{
		abs_close_socket(docu, FALSE);
		docu->remove_lock = FALSE;
		return -1;
	}
	else if ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) && 
		!(docu->doc_url->status & URL_REDIRECT) &&
		 docu->errcode == ERR_FTP_NOREGET && cfg.freget &&
            (!cfg.ftp_proxy || (cfg.ftp_proxy && !cfg.ftp_via_http)))
	{
		docu->rest_pos = 0;
	}

	if (docu->doc_url->status & URL_INNSCACHE)
	{
		struct stat estat;

		fstat(bufio_getfd(docu->datasock) , &estat);
		docu->totsz = estat.st_size;
		docu->is_html = (docu->doc_url->status & URL_ISHTML) != 0;
	}
	else if ((docu->doc_url->type == URLT_HTTP || docu->doc_url->type == URLT_HTTPS ||
	    (docu->doc_url->type == URLT_FTP && cfg.ftp_proxy && cfg.ftp_via_http && !cfg.ftp_dirtyp) ||
	    (docu->doc_url->type == URLT_GOPHER && cfg.gopher_proxy && cfg.gopher_via_http)) 
		&& !(docu->doc_url->status & URL_REDIRECT))
	{
		if ((mres = http_read_mime_header(docu, &p , &totallen)) > 0)
		{
			docu->mime = p;

			adj_sz = totallen;

			if (cfg.htdig)
				printf("%s" , docu->mime);

			DEBUG_PROTOS(gettext("*********** HTTP Server response MIME header **********\n"));
			DEBUG_PROTOS("%s" , docu->mime);
			DEBUG_PROTOS("*******************************************************\n");

			resp = http_get_response_info(docu->mime);
			_free(resp->text);

			if (resp->ver_maj == 1 && resp->ver_min == 1)
			{
				docu->is_http11 = TRUE;
				docu->is_persistent = TRUE;
			}

			docu->type_str = 
				get_mime_param_val_str("Content-type:" , docu->mime);

			if (docu->type_str && (!strncasecmp("text/html" , docu->type_str,9) ||
				!strncasecmp("text/css" , docu->type_str , 8)))
			{
				if (!strncasecmp("text/css" , docu->type_str , 8))
					docu->doc_url->status |= URL_STYLE;
				docu->is_html = TRUE;

				/* dirty hack to detect that FTP document downloaded */
				/* trought HTTP gateway is directory content */ 
				if (docu->doc_url->type == URLT_FTP && !docu->doc_url->p.ftp.dir)
				{
					if (resp->ret_code == 200)
					{
						url_remove_from_hash_tab(docu->doc_url);
						docu->doc_url->p.ftp.dir = TRUE; 
						url_changed_filename(docu->doc_url);
						url_add_to_hash_tab(docu->doc_url);
					}
				}
			}
			else
			{
				docu->is_html = FALSE;
			}

			p3 = get_mime_param_val_str("Content-Length:" , docu->mime);
			if (p3)
			{
				docu->totsz = _atoi(p3);
				if (errno == ERANGE) docu->totsz = 0;
				_free(p3);
			}

			p3 = get_mime_param_val_str("Transfer-Encoding:" , docu->mime);
			if (p3)
			{
				if (!strcasecmp(p3, "chunked") || !strncasecmp(p3, "chunked;" , 8))
				{
					docu->is_chunked = TRUE;
					docu->read_chunksize = TRUE;
				}
				_free(p3);
			}

			p3 = get_mime_param_val_str("Connection:" , docu->mime);
			if (p3)
			{
				if (!strcasecmp(p3, "close"))
					docu->is_persistent = FALSE;
			}

			if (docu->rest_pos)
			{
				p3 = get_mime_param_val_str("Content-Range:" , docu->mime);
				if (!p3)
				{
					if (cfg.freget)
					{
						xprintf(1 , gettext("Regeting whole file\n"));
						docu->rest_pos = 0;
					}
					else
					{
						docu->errcode = ERR_HTTP_NOREGET;
						abs_close_socket(docu, FALSE);
						docu->remove_lock = FALSE;
						_free(resp);
						return -1;
					}	
				}
				else
				{
					if (resp->ret_code != 206)
					{
						docu->rest_pos = 0;
						xprintf(1 , gettext("Modified from last download - regeting whole\n"));
					}
					else
						docu->totsz += docu->rest_pos;
					
					_free(p3);
				}
			}

			/**** get document creation time ****/
			p = get_mime_param_val_str("Last-Modified:" , docu->mime);
			if (p)
			{
				docu->dtime = scntime(p);
				_free(p);
			}
			else if (cfg.mode == MODE_SYNC)
				docu->dtime = 0;

			/**************/
			if (cfg.mode == MODE_SYNC)
			{
				if (resp->ret_code == 304)
				{
					docu->errcode = ERR_HTTP_ACTUAL;
					docu->remove_lock = TRUE;
					docu->is_persistent = FALSE;
					abs_close_socket(docu, FALSE);
					if (load || docu->is_html || 
					   (!docu->type_str && file_is_html(url_to_filename(docu->doc_url, TRUE))))
					{
						xprintf(1 , gettext("Loading local copy\n"));
						p = url_to_filename(docu->doc_url , TRUE);
						if (!(docu->datasock = bufio_open(p,O_BINARY | O_RDONLY)))
						{
							_free(resp);
							docu->errcode = ERR_FILE_OPEN;
							return -1;
						}
						docu->doc_url->status |= URL_REDIRECT;
					}
					else
					{ 
						docu->doc_url->status |= URL_REDIRECT;
						_free(resp);
						return 0;
					}
				}
				else if (modtime)
				{
					if (!docu->dtime || difftime(docu->dtime , modtime) > 0)
					{
						if (docu->rest_pos)
						{
							docu->rest_pos = 0;
							xprintf(1 , gettext("Modified from last download - regeting whole\n"));							}
						}
					else
					{
						docu->errcode = ERR_HTTP_ACTUAL;
						docu->remove_lock = TRUE;
						docu->is_persistent = FALSE;
						abs_close_socket(docu, FALSE);
						if (load || docu->is_html)
						{
							xprintf(1 , gettext("Loading local copy\n"));
							p = url_to_filename(docu->doc_url , TRUE);
							if (!(docu->datasock = bufio_open(p,O_BINARY | O_RDONLY)))
							{
								_free(resp);
								docu->errcode = ERR_FILE_OPEN;	
								return -1;
							}
							docu->doc_url->status |= URL_REDIRECT;
						}
						else
						{
							docu->doc_url->status |= URL_REDIRECT;
							_free(resp);
							return 0;
						}
					}
				}
			}
			else if (docu->dtime)
			{
				if (docu->check_limits && cfg.condition.btime &&
				    (difftime(docu->dtime , 
				   	     cfg.condition.btime) < 0))
				{
					docu->errcode = ERR_OUTTIME;
					_free(resp);
					return -1;
				}
				if (docu->check_limits && cfg.condition.etime &&
				    (difftime(docu->dtime , 
				   	     cfg.condition.etime) > 0))
				{
					docu->errcode = ERR_OUTTIME;
					_free(resp);
					return -1;
				}
			}

			p = NULL;
			totallen = 0;
			_free(resp);
		}
		else if (!mres)
		{
			if (p)
			{
				if (docu->save_online)
				{
					bufio_write(docu->s_sock , p , totallen);
				}
				docu->is_html = TRUE;
			}
		} else
		{
			abs_close_socket(docu, FALSE);
			docu->remove_lock = FALSE;
			return -1;
		}
	}

	if (docu->check_limits && cfg.condition.max_size && docu->totsz && 
		cfg.condition.max_size < docu->totsz &&
		docu->doc_url->type != URLT_FILE && !(docu->doc_url->status & URL_REDIRECT))
	{
		docu->errcode = ERR_BIGGER;
		abs_close_socket(docu, FALSE);
		return -1;
	}

	if (docu->check_limits && cfg.condition.min_size && docu->totsz && 
		cfg.condition.min_size > docu->totsz &&
		docu->doc_url->type != URLT_FILE && !(docu->doc_url->status & URL_REDIRECT))
	{
		docu->errcode = ERR_SMALLER;
		abs_close_socket(docu, FALSE);
		return -1;
	}

        if (docu->check_limits && docu->type_str && cfg.condition.mime && *cfg.condition.mime)
        {
		fnd = is_in_list(docu->type_str , cfg.condition.mime);

		if ((cfg.condition.allow_mime && !fnd) || 
		    (!cfg.condition.allow_mime && fnd))
		{
			docu->errcode = ERR_NOMIMET;
			abs_close_socket(docu, FALSE);
			return -1;
		}
        }

	if (docu->check_limits && cfg.condition.uexit)
	{
		if (!uexit_condition(docu->doc_url ,
			&docu->totsz ,
			docu->dtime))
		{
			docu->errcode = ERR_SCRIPT_DISABLED;
			abs_close_socket(docu, FALSE);
			return -1;
		}
	}

	if (docu->save_online)
	{
		ftruncate(bufio_getfd(docu->s_sock) , docu->rest_pos);
	 	lseek(bufio_getfd(docu->s_sock) , docu->rest_pos , SEEK_SET);
		bufio_reset(docu->s_sock);
	}

	if (docu->doc_url->type != URLT_FILE && 
		!(docu->doc_url->status & URL_REDIRECT))
		dinfo_save(docu);

	if (docu->report_size)
		iface_set_what(gettext("Transfering data"));

	show_progress(docu, adj_sz, FALSE);

	bufsize = (cfg.bufsize > 0 ? cfg.bufsize : 1) * 1024;
	buf = _malloc(bufsize);

#ifdef SO_RCVBUF
	if (docu->doc_url->type != URLT_FILE && 
		!(docu->doc_url->status & URL_REDIRECT))
	{
		if (setsockopt(bufio_getfd(docu->datasock),
			SOL_SOCKET, SO_RCVBUF,
			(char *)&bufsize, sizeof(bufsize)))
		{
			xperror(gettext("setsockopt: SO_RCVBUF failed"));
		}
	}
#endif

	while ((len = abs_read_data(docu, docu->datasock, buf, bufsize)) > 0 ||
		(len == -1 && errno == EWOULDBLOCK))
	{
		if (docu->save_online)
		{
			if (write(bufio_getfd(docu->s_sock) , buf ,len) != len)
			{
				docu->errcode = ERR_STORE_DOC;
				xperror(gettext("storing document"));
				retcode = -1;
				break;
			}
		}

		totallen += len;
		docu->current_size += len;

		if (cfg.maxrate > 0.0 &&
			(docu->doc_url->type != URLT_FILE && 
			 !(docu->doc_url->status & URL_REDIRECT)))
		{
			time_t _tm = doc_etime(docu, FALSE);
			double _rt = compute_speed_rate(_tm , totallen);
			if (_rt > (cfg.maxrate * 1024.0))
			{
				my_msleep((time_t) (1000.0 * ((double)totallen) / (cfg.maxrate * 1024.0)) - _tm);
			}
		}

		docu->size = totallen;
		show_progress(docu, adj_sz, FALSE);

		if (load || docu->is_html ||
		    ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) && 
			docu->doc_url->p.ftp.dir) ||
		    (docu->doc_url->type == URLT_GOPHER && 
		     docu->doc_url->p.gopher.type == '1'))
		{
			p = _realloc(p , totallen + 1);
			memmove(p + totallen - len , buf , len);
		}
		if (cfg.minrate > 0.0 &&
			(docu->doc_url->type != URLT_FILE && 
			 !(docu->doc_url->status & URL_REDIRECT)))
		{
			time_t _tm = doc_etime(docu, FALSE);
			double _rt = compute_speed_rate(_tm , totallen);
			if (_rt < (cfg.minrate * 1024.0))
			{
				docu->errcode = ERR_LOW_TRANSFER_RATE;
				retcode = -1;
				break;
			}	
		}

		if (cfg.max_time)
		{
			if ((cfg.start_time + 60 * cfg.max_time) < time(NULL))
			{
				docu->errcode = ERR_QUOTA_TRANS;
				retcode = -1;
				break;
			}
		}
		/*** quota code ***/
		if (docu->doc_url->type != URLT_FILE &&
                         !(docu->doc_url->status & URL_REDIRECT))
			cfg.trans_size += len;

		if (cfg.file_quota && ((cfg.file_quota * 1024) <= totallen) &&
			(docu->doc_url->type != URLT_FILE) &&
                         !(docu->doc_url->status & URL_REDIRECT))

		{
			docu->errcode = ERR_QUOTA_FILE;
			retcode = 0;
			break;
		}
		if (cfg.trans_quota && ((cfg.trans_quota * 1024) <= cfg.trans_size))
		{
			docu->errcode = ERR_QUOTA_TRANS;
			retcode = -1;
			break;
		}
#if defined HAVE_FSTATFS || defined HAVE_FSTATVFS
		if (cfg.fs_quota && (docu->doc_url->type != URLT_FILE) &&
                         !(docu->doc_url->status & URL_REDIRECT) && docu->s_sock)
		{
#ifdef HAVE_FSTATVFS
			struct statvfs fss;
			if (fstatvfs(bufio_getfd(docu->s_sock) , &fss))
				xperror("fstatvfs");
#else
			struct statfs fss;
			if (fstatfs(bufio_getfd(docu->s_sock) , &fss))
				xperror("fstatfs");
#endif

			else
			{
				long freespace = (fss.f_bsize * fss.f_bavail) / 1024;

				if (freespace < cfg.fs_quota)
				{
					docu->errcode = ERR_QUOTA_FS;
					retcode = -1;
					break;
				}
			}
		}
#endif
	}
	show_progress(docu, adj_sz, TRUE);

	if (cfg.progres && docu->report_size
#ifdef I_FACE
		&& !cfg.xi_face
#endif
	) xprintf(0, "\n");

	if (len < 0) 
	{
		t_error = errno;
		xperror("read");
		retcode = -1;
	}

	if (docu->report_size)
		iface_set_what(gettext("Data transfer done"));

	abs_close_socket(docu, TRUE);

	if ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) &&
		docu->errcode == ERR_FTP_TRUNC)
	{
		docu->remove_lock = FALSE;
		retcode = -1;
	}

	/*** ak nezaciname od zaciatku tak precitaj znovu zo suboru ***/
	if (!retcode && p) 
	{
		if (docu->rest_pos)
		{
			_free(p);
			totallen = 0;
			lseek(bufio_getfd(docu->s_sock) , 0 , SEEK_SET);
			bufio_reset(docu->s_sock);

			while ((len = bufio_read(docu->s_sock, buf, bufsize)) > 0 || errno == EWOULDBLOCK)
			{
				totallen += len;
				p = _realloc(p , totallen + 1);
				memmove(p + totallen - len , buf , len);
			}	
		}
		if (p) *(p + totallen) = '\0';
	}

	_free(buf);

	docu->size = totallen;
	docu->contents = p;

	if (!retcode && docu->doc_url->status & URL_INNSCACHE)
	{
		docu->is_html = (docu->doc_url->status & URL_ISHTML) != 0;
	}
	else if (!retcode && docu->doc_url->type == URLT_GOPHER && !(docu->doc_url->status & URL_REDIRECT) &&
	    !(cfg.gopher_proxy && cfg.gopher_via_http))
	{
		docu->is_html = FALSE;
		/**** gopher adresar prerobime na HTML dokument ****/
		if (docu->doc_url->p.gopher.type == '1')
		{
			if (!(docu->doc_url->status & URL_REDIRECT))
				gopher_dir_to_html(docu);
			docu->is_html = TRUE;
		}
	}
	else if (!retcode && (docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) &&
		!(docu->doc_url->status & URL_REDIRECT) &&
		!(cfg.ftp_proxy && cfg.ftp_via_http && !cfg.ftp_dirtyp))
	{
		docu->is_html = ext_is_html(docu->doc_url->p.ftp.path) != 0;

		/**** ftp adresar prerobime na HTML dokument ****/
		if (docu->doc_url->p.ftp.dir)
		{
			if (!(docu->doc_url->status & URL_REDIRECT))
			{
				ftp_dir_to_html(docu);
			}
			docu->is_html = TRUE;
		}
	}
	else if (!retcode && (docu->doc_url->type == URLT_HTTP || docu->doc_url->type == URLT_HTTPS ||
		 (docu->doc_url->type == URLT_FTP && cfg.ftp_proxy && cfg.ftp_via_http && !cfg.ftp_dirtyp) ||
		 (docu->doc_url->type ==URLT_GOPHER && cfg.gopher_proxy && cfg.gopher_via_http)) && 
		!(docu->doc_url->status & URL_REDIRECT))
	{
		/**** zistime navratovy kod a ci sa jedna o HTTP/1.0 ****/
		resp = http_get_response_info(docu->mime);
		if (resp)
		{
			_free(resp->text);

			/**** chybny dokument ****/
			if (resp->ret_code == 404)
			{
				docu->doc_url->status |= URL_NOT_FOUND;
			}

			if (resp->ret_code >= 400)
			{
				docu->errcode = 2000 + resp->ret_code;
				_free(resp);
				return -1;
			}
	
			/**** presmerovanie dokumentu na ine URL ****/
			if (resp->ret_code == 303 ||
			    resp->ret_code == 302 ||
			    resp->ret_code == 301)
			{
				url *pomurl;
				char *pomcr = NULL;

				free(resp);
				pomcr = get_mime_param_val_str("Location:" , docu->mime);

				if (!pomcr)
				{
					pomcr = get_mime_param_val_str("URI:" , 
						docu->mime);

					if (pomcr)
					{
						char *_pp;

						_pp = strchr(pomcr , ';');
						if (_pp) *_pp = '\0';
						_pp = strchr(pomcr , '>');
						if (_pp) *_pp = '\0';
						if (pomcr[0] == '<')
						{
							_pp = pomcr;
							pomcr = new_string(pomcr+1);
							_free(_pp); 
						}
					}
					else
					{
						dllist *stc;
#ifdef I_FACE					
						bool sxi = cfg.xi_face;
						cfg.xi_face = FALSE;
#endif
			
						stc = html_get_all_links(docu , FALSE , TRUE);
						if (stc)
						{
							pomcr = url_to_urlstr((url *)stc->data , FALSE);
							while(stc)
							{
								free_deep_url((url *)stc->data);
								stc = dllist_remove_entry(stc , stc);
							}
						}	
#ifdef I_FACE
						cfg.xi_face = sxi;	
#endif
					}
				}
			
				if (pomcr)
				{
					pomurl = parse_url(pomcr);
					if (pomurl->type == URLT_FILE)
					{
						char *base;
						char *baset;
						char *xp;

						baset = url_to_urlstr(docu->doc_url , FALSE);
						if ((xp = strrchr(baset, '#')))
							*xp = '\0';
						if ((xp = strrchr(baset, '?')))
							*xp = '\0';

						base = url_to_urlstr(docu->doc_url , FALSE);

						if (!tl_is_dirname(base))
						{
							xp = strrchr(base , '/');
							if (xp) *(xp + 1) = '\0';
						}
						xp = url_to_absolute_url(base, baset , docu->doc_url , pomcr);
						free_deep_url(pomurl);
						pomurl = parse_url(xp);
						_free(xp);
					}

					free(pomcr);

					if (pomurl && prottable[pomurl->type].supported)
					{
						if (url_redirect_to(docu->doc_url , pomurl))
							docu->errcode = ERR_HTTP_CYCLIC;
						else
							docu->errcode = ERR_HTTP_REDIR;
					}
					else 
					{
						if (pomurl)
						{
							free_deep_url(pomurl);
							docu->errcode = ERR_HTTP_UNSUPREDIR;
						}
						else
							docu->errcode = ERR_HTTP_UNKNOWN;
					}
				}
				else 
					docu->errcode = ERR_HTTP_UNKNOWN;
				return -1;
			}

			/*** not modified ***/
			else if (resp->ret_code == 304 && cfg.mode == MODE_SYNC)
			{
				free(resp);
				docu->errcode = ERR_HTTP_ACTUAL;
				return -1;
			}
			free(resp);
		}

		
		/**** kontrola ci bol dokument preneseny cely ****/
		if (cfg.check_size && docu->errcode == ERR_NOERROR)
		{
			p = get_mime_param_val_str("Content-Length:" , docu->mime);
			if (p)
			{
				sz = _atoi(p);	
				if (errno != ERANGE && sz != docu->size - (docu->contents ? docu->rest_pos : 0))
				{
					docu->errcode = ERR_HTTP_TRUNC;

					docu->remove_lock = FALSE;
					retcode = -1;
					xprintf(1 , gettext("File may be truncated\n"));
				}
				_free(p);
			}
		}

		
		/**** zistenie ci bol dokument komprimovany a dekomprimacia ****/
		p = get_mime_param_val_str("Content-Encoding:" , docu->mime);
		if (!retcode && p && cfg.use_enc && 
			(!strcmp(docu->type_str , "text/plain") ||
			 !strcmp(docu->type_str , "text/html")))
		{
			if ((!strcasecmp(p,"x-gzip")) ||
			    (!strcasecmp(p,"gzip")) ||
			    (!strcasecmp(p,"deflate")) ||
			    (!strcasecmp(p,"x-compress")) ||
			    (!strcasecmp(p,"compress")))
			{
				if (!gzip_decode(docu->contents , docu->size , 
					&p1 , &len , 
					(docu->contents ? NULL : docu->lock_fn)))
				{
					docu->size = len;
					free(docu->contents);
					docu->contents = p1;
					xprintf(1 , gettext("Decoding document - OK\n"));
				}
				else
				{
					xperror(gettext("Decoding document - failed\n"));
				}
			}
			else
			{
				xprintf(1 , gettext("Unsupported document encoding\n"));
			}
		}
		else if (p && !retcode)
		{
			xprintf(1 , gettext("Received Encoded file but decoding not allowed (untouched)\n"));	
		}
		_free(p);
	}
	else
	{
		if (docu->doc_url->type == URLT_FILE || (docu->doc_url->status & URL_REDIRECT))
		{
			p1 = url_to_filename(docu->doc_url , TRUE);

			if (file_is_html(p1))
			{
				docu->is_html = TRUE;
			}
		}
		else
		{
			docu->is_html = FALSE;
		}
	}

	if (t_error)
	{
		if (!docu->errcode) docu->errcode = ERR_READ;
		docu->remove_lock = FALSE;
		retcode = -1;
	}

	if (docu->size == 0 && (docu->doc_url->type == URLT_HTTP || 
		docu->doc_url->type == URLT_HTTPS))
	{
		if (!docu->errcode) docu->errcode = ERR_ZERO_SIZE;
		docu->remove_lock = FALSE;
		retcode = -1;
	}
#ifdef I_FACE
	if (cfg.xi_face)
		doc_set_info(docu);
#endif
	if (!retcode && docu->lock_fn && docu->save_online && 
		!docu->contents && (cfg.mode != MODE_NOSTORE) && (cfg.mode != MODE_FTPDIR) &&
		!(docu->doc_url->status & URL_REDIRECT) && (docu->doc_url->type != URLT_FILE))
	{
		p1 = url_to_filename(docu->doc_url , TRUE);
		if (!access(p1 , F_OK))
		{
			if (unlink(p1)) xperror(p1);
		}
		if (link(docu->lock_fn , p1))
		{
#ifdef _WIN32
			if (errno != EPERM && errno != EACCES)
#else
			if (errno != EPERM)
#endif
				xperror(p1);
			else
			{
				if (copy_fd_to_file(bufio_getfd(docu->s_sock) , p1))
					xperror(p1);
			}
		}

		if (docu->dtime && cfg.preserve_time)
		{
			struct utimbuf utmbf;

			stat(p1 , &estat);
			utmbf.actime = estat.st_atime;
			utmbf.modtime = docu->dtime;
			utime(p1 , &utmbf);
		}

		if ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) &&
		    docu->doc_url->extension &&
		    cfg.preserve_perm)
		{
			chmod(p1 , ((ftp_url_extension *)docu->doc_url->extension)->perm);
		}
	}

	return retcode;
}

/********************************************************/
/* ulozi dokument ak je to potrebne vytvori adresare	*/
/********************************************************/
int doc_store(docu , overwrite)
doc *docu;
int overwrite;
{
	char *pom;
	int f;
	struct utimbuf utmbf;
	struct stat estat;

	if (cfg.mode == MODE_NOSTORE || cfg.mode == MODE_FTPDIR) return 0;

	/*** don't store directory indexes ***/
	if (!cfg.store_index && url_is_dir_index(docu->doc_url))
			return 0;

	pom = url_to_filename(docu->doc_url , TRUE);
	if (makealldirs(pom))
		xperror(pom);

	if (!access(pom , R_OK) && !overwrite)
	{
		return 0;
	}
	
	if ((f = open(pom , O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)) == -1)
	{
		if (!access(pom , R_OK)) unlink(pom);
		xperror(pom);
		return -1;
	}

	if (write(f , docu->contents , docu->size) != docu->size)
	{
		if (!access(pom , R_OK)) unlink(pom);
		xperror(pom);
		close(f);
		return -1;
	}

	close(f);

	if (docu->dtime && cfg.preserve_time)
	{
		utmbf.modtime = docu->dtime;
	}
	else
	{
		utmbf.modtime = docu->stime;
	}

	stat(pom , &estat);
	utmbf.actime = estat.st_atime;
	utime(pom , &utmbf);

	if ((docu->doc_url->type == URLT_FTP || docu->doc_url->type == URLT_FTPS) &&
	    docu->doc_url->extension &&
	    cfg.preserve_perm)
	{
		chmod(pom , ((ftp_url_extension *)docu->doc_url->extension)->perm);
	}

	return 0;
}

/*** remove improper documents if required ***/
int doc_remove(urlr)
url *urlr;
{
	char *fn;
	int len;

#ifdef DEBUG
	if (cfg.debug)
	{
		fn = url_to_urlstr(urlr, FALSE);
		xprintf(1 , gettext("Removing improper document : %s\n") , fn); 
		_free(fn);
	}
#endif
	
	fn = url_to_filename(urlr , TRUE);

	if (urlr->type == URLT_FTP || urlr->type == URLT_FTPS)
	{
		len = strlen(fn);

		/*** if URL FTPdir index ***/
		if (!strcmp(fn + len - (( len >= strlen(cfg.index_name)) ? strlen(cfg.index_name) : 0) , cfg.index_name))
			 *(fn + len - strlen(cfg.index_name)) = '\0';

		if (cfg.enable_info)
			dinfo_remove(fn);
		return unlink_recursive(fn);	
	}
	else
	{
		if (cfg.enable_info)
			dinfo_remove(fn);
		if (unlink(fn))
		{
			xperror(fn);
			return -1;
		}
		
	}

	return 0;
}

#ifdef I_FACE
/********************************************************/
/* nastavenie info dokumentu pre informaciu pouzivatela	*/
/********************************************************/

static void doc_set_info(docp)
doc *docp;
{
#ifdef WITH_TREE
	url_prop *prp = _malloc(sizeof(url_prop));

	prp->size = docp->size;
	prp->mdtm = docp->dtime;
	prp->type = NULL;
	switch (docp->doc_url->type)
	{
		case URLT_HTTP:
#ifdef USE_SSL
		case URLT_HTTPS:
#endif
			if (docp->type_str)
				prp->type = new_string(docp->type_str);
			break;
		case URLT_FILE:
			prp->type = new_string(gettext_nop("Local file"));
			break;
		case URLT_GOPHER:
			switch (docp->doc_url->p.gopher.type)
			{
				case '0':
					prp->type = new_string(gettext_nop("Gopher/Text File"));
					break;
				case '1':
					prp->type = new_string(gettext_nop("Gopher/Directory"));
					break;
				case '2':
					prp->type = new_string(gettext_nop("Gopher/CSO phone book"));
					break;
				case '3':
					prp->type = new_string(gettext_nop("Gopher/Error"));
					break;
				case '4':
					prp->type = new_string(gettext_nop("Gopher/BINHEX"));
					break;
				case '5':
					prp->type = new_string(gettext_nop("Gopher/DOS bin"));
					break;
				case '6':
					prp->type = new_string(gettext_nop("Gopher/UUencoded"));
					break;
				case '7':
					prp->type = new_string(gettext_nop("Gopher/Search index"));
					break;
				case '8':
					prp->type = new_string(gettext_nop("Gopher/Telnet session"));
					break;
				case '9':
					prp->type = new_string(gettext_nop("Gopher/bin"));
					break;
				case '+':
					prp->type = new_string(gettext_nop("Gopher/Duplicated server"));
					break;
				case 'T':
					prp->type = new_string(gettext_nop("Gopher/TN3270"));
					break;
				case 'g':
					prp->type = new_string(gettext_nop("Gopher/GIF"));
					break;
				case 'I':
					prp->type = new_string(gettext_nop("Gopher/Image"));
					break;
			}
			break;
		case URLT_FTP:
			if (docp->doc_url->p.ftp.dir)
				prp->type = new_string(gettext_nop("FTP/Directory"));
			else
				prp->type = new_string(gettext_nop("FTP/File"));
			break;
		case URLT_FTPS:
			if (docp->doc_url->p.ftp.dir)
				prp->type = new_string(gettext_nop("FTPS/Directory"));
			else
				prp->type = new_string(gettext_nop("FTPS/File"));
			break;
		default:
			prp->type = new_string(gettext_nop("Unsupported type"));
			break;
	}

	if (!prp->type) prp->type = new_string(gettext_nop("Local file"));

	docp->doc_url->prop = prp;
#endif
}
#endif

void doc_init(docp , urlp)
doc *docp;
url *urlp;
{
	docp->doc_nr = 0;
	docp->doc_url = urlp;
	docp->mime = NULL;
	docp->type_str = NULL;
	docp->is_html = FALSE;
	docp->size = 0;
	docp->totsz = 0;
	docp->contents = NULL;
	docp->save_online = FALSE;
	docp->dtime = 0L;
	docp->stime = 0L;
	docp->rest_pos = 0;
	docp->etag = NULL;
	docp->errcode = ERR_NOERROR;
	docp->origsize = 0;
	docp->ftp_fatal_err = FALSE;
	docp->ftp_respc = 0;
	docp->datasock = NULL;
	docp->ftp_control = NULL;
	docp->s_sock = NULL;
#ifdef USE_SSL
	docp->ssl_con = NULL;
	docp->ssl_bio = NULL;
	docp->ssl_ctx = NULL;
	docp->ssl_method = NULL;
	docp->ftp_control_ssl_con = NULL;
	docp->ftp_control_ssl_bio = NULL;
	docp->ftp_control_ssl_ctx = NULL;
#endif
	docp->auth_digest = NULL;
	docp->auth_proxy_digest = NULL;
	docp->lock_fn = NULL;
	docp->report_size = TRUE;
	docp->check_limits = TRUE;
	docp->remove_lock = FALSE;
	docp->is_http11 = FALSE;
	docp->chunk_size = 0;
	docp->is_chunked = FALSE;
	docp->read_chunksize = FALSE;
	docp->read_trailer = FALSE;
	docp->is_persistent = FALSE;
}

static char *get_rate_str(str , rate)
char *str;
double rate;
{
	if (rate <= 1024.0)
		sprintf(str , "%4.0f B/s" , rate);
	else if (rate <= 1048576.0)
		sprintf(str , "%5.1f kB/s" , rate/1024.0);
	else if (rate <= 1073741824.0)
		sprintf(str , "%5.1f MB/s" , rate/1048576.0);
	else sprintf(str , "%5.1f GB/s" , rate/1073741824.0);

	return str;
}

static char *get_time_str(str , tm)
char *str;
time_t tm;
{
	sprintf(str , "%ld:%02ld:%02ld" ,
		tm/3600000 , (tm%3600000)/60000 , (tm%60000)/1000);

	return str;
}

static char *get_size_str(str , total , actual)
char *str;
int total;
int actual;
{
	if (total)
	{
		if (total < 1000000)
			sprintf(str , "%6d / %d B [%5.1f%%]" , actual , total, 
				(100.0 * (double)actual / (double)total));
		else
			sprintf(str , "%7d / %d kB [%5.1f%%]" , actual/1024 , total/1024, 
				(100.0 * (double)actual / (double)total));
	}
	else
	{
		if (actual < 1000000)
			sprintf(str , "%6d B" , actual);
		else
			sprintf(str , "%6d kB" , actual);
	}
	return str;
}


time_t doc_etime(docp, init)
doc *docp;
int init;
{
#ifdef HAVE_GETTIMEOFDAY
	if (init)
	{
		gettimeofday(&docp->start_time , NULL);
		return 0;
	}
	else
	{
		struct timeval t;
		gettimeofday(&t , NULL);

		return (1000 * (t.tv_sec - docp->start_time.tv_sec) +
			(t.tv_usec - docp->start_time.tv_usec)/1000);
	}
#else
	if (init)
	{
		docp->start_time = time(NULL);
		return 0;
	}
	else
	{
		return 1000 * (time(NULL) - docp->start_time);
	}
#endif
}

static double compute_speed_rate(etime , size)
time_t etime;
ssize_t size;
{
	return (double)size * 1000.0/(etime == 0.0 ? 1.0 : etime);
}

static void show_progress(docp, adjsz, dolog)
doc *docp;
ssize_t adjsz;
int dolog;
{
	time_t etime = doc_etime(docp, FALSE);
	double rate = compute_speed_rate(etime , docp->size+adjsz);
	char s_rate[30]="",s_etime[30]="",s_rtime[30]="",s_size[30]="";

	if (docp->totsz || 
	    ((docp->doc_url->type == URLT_FTP || docp->doc_url->type == URLT_FTPS) &&
		 docp->doc_url->extension)) 
	{
		int size = docp->totsz ? docp->totsz:
			((ftp_url_extension *)docp->doc_url->extension)->size;
		time_t rtime = (time_t)((double)(size - docp->rest_pos)/(double)(docp->size ? docp->size : 10) * (double)((etime != 0.0) ? etime : 1.0)) - etime;

		get_time_str(s_rtime , rtime);
		get_size_str(s_size , size , docp->size + docp->rest_pos);
	}
	else
		get_size_str(s_size , 0 , docp->size + docp->rest_pos);

	get_rate_str(s_rate , rate);
	get_time_str(s_etime , etime);

	if (cfg.progres && docp->report_size && !cfg.quiet && !cfg.bgmode
#ifdef I_FACE
	    && !cfg.xi_face
#endif
           )
	{
		if (*s_rtime)
			xprintf(0, gettext("S: %s [R: %s] [ET: %s] [RT: %s] \r") ,
				s_size , s_rate , s_etime , s_rtime);
		else 
			xprintf(0, gettext("S: %s [R: %s] [ET: %s] \r") , 
				s_size, s_rate , s_etime);
	}

#ifdef I_FACE
	if (docp->report_size && cfg.xi_face)
	{
		iface_set_size(s_size , s_rate , s_etime , s_rtime);
	}
#endif
}

/****************************************************/
/* Unlock document and remove lock file if required */
/****************************************************/
void doc_remove_lock(docp)
doc *docp;
{
	struct utimbuf utmbf;

	if (docp->s_sock)
	{
		DEBUG_LOCKS("Unlocking document %s\n", docp->lock_fn);
		_funlock(bufio_getfd(docp->s_sock));
		bufio_close(docp->s_sock);

		utmbf.actime = time(NULL);

		if (docp->dtime && cfg.preserve_time)
			utmbf.modtime = docp->dtime;
		else
			utmbf.modtime = docp->stime;

		utime(docp->lock_fn , &utmbf);

		if (docp->remove_lock)
		{
			unlink(docp->lock_fn);
		}
		_free(docp->lock_fn);
	}
}
