/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>

#include "dllist.h"

dllist *dllist_new_entry(data)
void *data;
{
	dllist *retv = NULL;

	retv = (dllist *) malloc(sizeof(dllist));

	retv->data = data;
	retv->next = NULL;
	retv->prev = NULL;

	return retv;
}

dllist *dllist_append(list , data)
dllist *list;
void *data;
{
	dllist *nentry = dllist_new_entry(data);

	if (list)
	{
		dllist *last = dllist_last(list);

		last->next = nentry;
		nentry->prev = last;

		return list;
	}
	else
		return nentry;
	
}

dllist *dllist_prepend(list , data)
dllist *list;
void *data;
{
	dllist *nentry = dllist_new_entry(data);

	if (list)
	{
		dllist *first = dllist_first(list);

		first->prev = nentry;
		nentry->next = first;

		return nentry;
	}
	else
		return nentry;
}

dllist *dllist_insert(list , position , data)
dllist *list;
int position;
void *data;
{
	if (!list)
 		return dllist_new_entry(data);

	if (position <= 0)
		return dllist_prepend(list , data);
	else
	{
		dllist *nth = dllist_nth(list , position);

		if (!nth)
			return dllist_append(list , data); 
		else
		{
			dllist *nentry = dllist_new_entry(data);

			nentry->next = nth;
			nth->prev = nentry;

			if (nth->prev)
			{
				nth->prev->next = nentry;
				nentry->prev = nth->prev;

				return list;
			}
			else
				return nentry;
		}
	}
}

dllist *dllist_insert_after(list , node , data)
dllist *list;
dllist *node;
void *data;
{
	if (!list)
 		return dllist_new_entry(data);

	if (!node)
		return dllist_append(list , data);
	else
	{
		dllist *nentry = dllist_new_entry(data);

		nentry->prev = node;
		nentry->next = node->next;
		node->next = nentry;

		return list;
	}
}

dllist *dllist_insert_list_after(list1 , node , list2)
dllist *list1;
dllist *node;
dllist *list2;
{
	if (!list1)
		return list2;

	if (!node)
	{
		dllist *last = dllist_last(list2);
		if (last)
		{
			last->next = list1;
			list1->prev = last;
			return list2;
		}
		else
			return list1;
	}
	else
	{
		dllist *last = dllist_last(list2);
		if (last)
		{
			last->next = node->next;
			node->next = list2;
			list2->prev = node;
		}
		return list1;
	}
}

dllist *dllist_first(list)
dllist *list;
{
	if (list)
		while (list->prev) list = list->prev;

	return list;
}

dllist *dllist_last(list)
dllist *list;
{
	if (list)
		while (list->next) list = list->next;

	return list;
}


dllist *dllist_nth(list , n)
dllist *list;
int n;
{
	while (n && list) 
	{
		n--;
		list = list->next;
	}

	return list;
}

dllist *dllist_find(list , data)
dllist *list;
void *data;
{
	while (list)
	{
		if (list->data == data)
		{
			break;
		}
		list = list->next;
	}

	return list;
}

unsigned int dllist_count(list)
dllist *list;
{
	unsigned int retv = 0;

	while (list)
	{
		retv ++;
		list = list->next;
	}

	return retv;
}

dllist *dllist_remove_entry(list , entry)
dllist *list;
dllist *entry;
{

	if (entry)
	{
		if (entry->prev)
			entry->prev->next = entry->next;
		if (entry->next)
			entry->next->prev = entry->prev;

		if (entry == list)
			list = entry->next;

		free(entry);
	}

	return list;
}

dllist *dllist_remove_data(list , data)
dllist *list;
void *data;
{
	dllist *pom;

	while((pom = dllist_find(list , data)))
	{
		list = dllist_remove_entry(list , pom);
	}

	return list;
}

void dllist_free_all(list)
dllist *list;
{
	dllist *pom;

	while (list)
	{
		pom = list;
		list = list->next;

		free(pom);
	}
}

dllist *dllist_concat(list1 , list2)
dllist *list1;
dllist *list2;
{
	dllist *retv = list1;

	if (list2)
	{
		dllist *last = dllist_last(list1);

		if (last) last->next = list2;
		else retv = list2;
		list2->prev = last;
	}

	return retv;
}

