/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include "doc.h"
#include "url.h"
#include "mime.h"
#include "tools.h"
#include "bufio.h"

static char *dinfo_get_filename_by_filename(fname)
char *fname;
{
	char *p;
	char *pom;

	pom = _malloc(strlen(fname) + 13);
	strcpy(pom , fname);

	p = strrchr(pom , '/');
	if (!p) p = pom;
	else p++;
	memmove(p + 12 , p , strlen(p) + 1); 
	strncpy(p , ".pavuk_info/" , 12);

	return pom;
}

static char *dinfo_get_filename_by_url(urlp)
url *urlp;
{
	return dinfo_get_filename_by_filename(url_to_filename(urlp , TRUE));
}

static int dinfo_save_real(fnm , urlp , mime)
char *fnm;
url *urlp;
char *mime;
{
	int fd;
	char *p;

	if (makealldirs(fnm))
		xperror(fnm);

	if ((fd = open(fnm , O_BINARY | O_CREAT | O_TRUNC | O_RDWR , 
			S_IRUSR | S_IRGRP | S_IROTH | S_IWUSR)) < 0)
	{
		xperror(fnm);
		return -1;
	}

	write(fd , "Original_URL: " , 14);
	p = url_to_urlstr(urlp , FALSE);
	write(fd , p , strlen(p));
	_free(p);
	write(fd , "\n" , 1);

	if (mime)
		write(fd , mime , strlen(mime));

	close(fd);

	return 0;
}

int dinfo_save(docp)
doc *docp;
{
	char *p;
	int rv;

	if (!cfg.enable_info) return 0;

	p = dinfo_get_filename_by_url(docp->doc_url);
	rv = dinfo_save_real(p , docp->doc_url , docp->mime);

	_free(p);
	return rv;
}

char *dinfo_load(fname)
char *fname;
{
	char *p = NULL;
	char pom[8192];
	int l,tl = 0;
	bufio *fd;

	if (!(fd = bufio_open(fname , O_BINARY | O_RDONLY)))
	{
		/*xperror(fname);*/
		return NULL;
	}

	while((l = bufio_readln(fd , pom , sizeof(pom))) > 0)
	{
		p = _realloc(p , tl + l + 1);
		memcpy(p + tl , pom , l);
		tl += l;
	}

	if (p) *(p + tl) = '\0';

	bufio_close(fd);

	return p;
}

char *dinfo_get_unique_name(urlp , pname , lockfn)
url *urlp;
char *pname;
int lockfn;
{
	char *dinfos;
	char *p,*us;
	int i;
	char *pom = NULL;
	char *pom2 = NULL;
	char xidx[20];
	char *idir,*ofn;
	int fd = -1;
	bool exist = FALSE;

	pom = _malloc(strlen(pname) + 8);

	p = strrchr(pname , '/');
	if (p)
	{
		ofn = new_string(p + 1);
		idir = new_n_string(pname , p - pname);
	}
	else
	{
		ofn = new_string("");
		idir = new_string(pname);
	}

	/* !!!!! lock !!!!! */
	if (lockfn)
	{
		sprintf(pom , "%s/._lock" , idir);
		if (makealldirs(pom))
			xperror(pom);
		fd = open(pom , O_WRONLY | O_CREAT , 0644);
		if (fd < 0)
		{
			xperror(pom);
			_free(ofn);
			_free(idir);
			_free(pom);
			return NULL;
		}
		if (_flock(fd , pom , O_WRONLY | O_CREAT , TRUE))
		{
			xperror(pom);
			_free(ofn);
			_free(idir);
			close(fd);
			_free(pom);
			return NULL;
		}
		sprintf(pom , "%s/.pavuk_info/" , idir);
		if (makealldirs(pom))
			xperror(pom);
	}

	us = url_to_urlstr(urlp , FALSE);
	pom2 = _malloc(strlen(pname) + 21);

	i = 1;
	xidx[0] = '\0';
	while(i > 0)
	{
		sprintf(pom , "%s/%s%s" , idir , xidx , ofn);
		sprintf(pom2 , "%s/.pavuk_info/%s%s" , idir , xidx , ofn);
		if (access(pom , F_OK) && access(pom2 , F_OK))
			break;
		if ((dinfos = dinfo_load(pom2)))
		{
			p = get_mime_param_val_str("Original_URL:" , dinfos);
			_free(dinfos);
			if (p && !strcmp(p , us))
			{
				_free(p);
				exist = TRUE;
				break;
			}
			_free(p);
		}
		sprintf(xidx , "%03d_" , i);
		i++;
	}

	/* create info file to know, that this filename is reserved */
	if (lockfn)
	{
		if (!exist)
			dinfo_save_real(pom2 , urlp , NULL);

		/* !!!! unlock !!!! */
		_funlock(fd);
		close(fd);
	}

	_free(us);
	_free(idir);
	_free(ofn);
	_free(pom2);
	return pom;
}

url *dinfo_get_url_for_filename(fn)
char *fn;
{
	char *p = dinfo_get_filename_by_filename(fn);
	char *dinfos;
	url *rv = NULL;

	dinfos = dinfo_load(p);
	_free(p);

	if (dinfos)
	{
		p = get_mime_param_val_str("Original_URL:" , dinfos);
		_free(dinfos);
		if (p)
		{
			rv = parse_url(p);
			_free(p);
		}
	}

	return rv;
}

void dinfo_remove(fn)
char *fn;
{
	char *p;
	char *pom;
	int fd;

	p = dinfo_get_filename_by_filename(fn);

	pom = _malloc(strlen(p) + 21);
	if (!unlink(p))
	{
		_free(p);
		strcpy(pom , fn);
		p = strrchr(pom , '/');
		if (p) *(p+1) = '\0';
		strcat(pom , "._lock");
		
		fd = open(pom , O_WRONLY | O_CREAT , 0644);
		if (fd < 0)
		{
			xperror(pom);
			_free(pom);
			return;
		}
		if (_flock(fd , pom , O_WRONLY | O_CREAT , TRUE))
		{
			xperror(pom);
			close(fd);
			_free(pom);
			return;
		}
		
		p = strrchr(pom , '/');
		if (p) *(p+1) = '\0';
		strcat(pom , ".pavuk_info");
		if (rmdir(pom) && errno != ENOTEMPTY) xperror(pom);

		p = strrchr(pom , '/');
		if (p) *(p+1) = '\0';
		strcat(pom , "._lock");
		if (unlink(pom) && errno != ENOENT) xperror(pom);
		_funlock(fd);
		close(fd);
	}
	_free(pom);
}

