/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>

#include "config.h"
#include "url.h"
#include "doc.h"
#include "tools.h"
#include "mode.h"

#define NARAZNIK        2048
#define MEXPAND(sv)     if ((sz - (sv + r + NARAZNIK)) < 0)\
			{\
				result = _realloc(result , sz + sv  + NARAZNIK);\
				sz += NARAZNIK + sv;\
			}

#define SEXPAND(sv)         if ((ssz - (sv + sr + NARAZNIK)) < 0)\
			{\
				stack = _realloc(stack , ssz + sv  + NARAZNIK);\
				ssz += NARAZNIK + sv;\
			}

dllist *css_get_all_links(docp, stylestr , base , baset , no_limits)
doc *docp;
char *stylestr;
char *base;
char *baset;
int no_limits;
{
	bool urlstart = FALSE;
	char *p;
	char *stack;
	char *sp;
	int sr,ssz;
	dllist *retval = NULL;

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	for (p = stylestr; *p ; p++)
	{
		if (urlstart)
		{
			if (*p == ')')
			{
				char *pom;

				stack[sr] = '\0';

				sp = stack + sr - 1;
				while(isspace(*sp) && sp > stack) 
				{
					*sp = '\0';
					sp--;
				}
				if (*sp == '\"' || *sp == '\'') *sp = '\0';
				sp = stack;
				while(isspace(*sp)) sp++;
				if (*sp == '\"' || *sp == '\'') sp++;

				pom = url_to_absolute_url(base , baset , docp->doc_url , sp);

				if (pom)
				{
					url *purl;

					purl = parse_url(pom);
					_free(pom);
					purl->parent_url = (url **)_malloc(2 * sizeof(url *));
					purl->parent_url[0] = docp->doc_url;
					purl->parent_url[1] = NULL;
					purl->level = docp->doc_url->level + 1;
					purl->status |= URL_INLINE_OBJ;
					url_path_abs(purl);

					if ((cfg.mode == MODE_SYNC) && cfg.prepurlstr && (purl->type == URLT_FILE))
					{
						url *pomurl = filename_to_url(purl->p.file.filename);

						if (pomurl)
						{
							free_deep_url(purl);
							_free(purl);
							purl = pomurl;
						}
					}

					if (no_limits || url_append_condition(purl, 0))
					{
						retval = dllist_append(retval , purl);
					}
					else
					{
						free_deep_url(purl);
						_free(purl);
					}
				}
				urlstart = FALSE;
			}
			else
			{
				SEXPAND(1);
				stack[sr] = *p;
				sr++;
			}
			continue;
		}

		if (((p - stylestr) > 3) && !strncasecmp(p - 3 , "url(" , 4))
		{
			urlstart = TRUE;
			sr = 0;
		}
	}

	_free(stack);
	return retval;
}

char *css_to_absolute_links(docp , stylestr , base , baset)
doc *docp;
char *stylestr;
char *base;
char *baset;
{
	bool urlstart = FALSE;
	char *result;
	int sz,r;
	char *p;
	char *sp;
	char *stack;
	int ssz,sr,l;

	sz = strlen(stylestr) + NARAZNIK;
	result = _malloc(sz);
	r = 0;

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	for (p = stylestr ; *p ; p++)
	{
		if (urlstart)
		{
			if (*p == ')')
			{
				char *pom;

				stack[sr] = '\0';

				sp = stack + sr - 1;
				while(isspace(*sp) && sp > stack) 
				{
					*sp = '\0';
					sp--;
				}
				if (*sp == '\"' || *sp == '\'') *sp = '\0';
				sp = stack;
				while(isspace(*sp)) sp++;
				if (*sp == '\"' || *sp == '\'') sp++;

				pom = url_to_absolute_url(base , baset , docp->doc_url , sp);

				if (pom)
				{
					url *purl;

					purl = parse_url(pom);
					_free(pom);
					url_path_abs(purl);
					pom = url_to_urlstr(purl , TRUE);
					free_deep_url(purl);
					_free(purl);
				}
				else
					pom = new_string(sp);

				l = strlen(pom);
				MEXPAND(l);
				result[r] = '\'';
				r++;
				strcpy(result + r , pom);
				r += l;
				result[r] = '\'';
				r++;
				result[r] = ')';
				r++;

				urlstart = FALSE;

				_free(pom);
			}
			else
			{
				SEXPAND(1);
				stack[sr] = *p;
				sr++;
			}
			continue;
		}
		
		if (((p - stylestr) > 3) && !strncasecmp(p - 3 , "url(" , 4))
		{
			urlstart = TRUE;
			sr = 0;
		}
		MEXPAND(1);
		result[r] = *p;
		r++;
	}
	result[r]= '\0';

	_free(stack);

	return result;
}


char *css_remote_to_local_links(docp , stylestr , all , sel , base , baset)
doc *docp;
char *stylestr;
int all;
int sel;
char *base;
char *baset;
{
	bool urlstart = FALSE;
	char *result;
	int sz,r;
	char *p;
	char pom[4096];
	char *act_name = url_to_filename(docp->doc_url , TRUE);
	char *anchor;
	char *sp;
	char *stack;
	int ssz,sr,l;

	sz = strlen(stylestr) + NARAZNIK;
	result = _malloc(sz);
	r = 0;

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	for (p = stylestr ; *p ; p++)
	{
		if (urlstart)
		{
			if (*p == ')')
			{
				char *fn;
				url *urlp;
				url *purl;
				struct stat estat;

				stack[sr] = '\0';

				sp = stack + sr - 1;
				while(isspace(*sp) && sp > stack) 
				{
					*sp = '\0';
					sp--;
				}
				if (*sp == '\"' || *sp == '\'') *sp = '\0';
				sp = stack;
				while(isspace(*sp)) sp++;
				if (*sp == '\"' || *sp == '\'') sp++;

				urlp = parse_url(sp);
				if (all && urlp->type == URLT_FILE)
				{
					fn = url_to_absolute_url(base , baset ,
						docp->doc_url , sp);
					free_deep_url(urlp);
					_free(urlp);
					urlp = parse_url(fn);
				}
				anchor = url_get_anchor_name(urlp);

				/** for better performance with info files **/
				if ((purl = url_was_befor(urlp)))
					fn = url_to_filename(purl , TRUE);
				else
					fn = url_to_filename(urlp , FALSE);

				strcpy(pom , sp);

				if (((all || (sel && purl)) && fn) || (!sel &&
				 	(((urlp->type != URLT_FILE) && fn &&((!access(fn , R_OK) &&
					 !stat(fn , &estat)) || !strcmp(act_name , fn))))))
				{
					if (all || (sel && purl) || (!sel && ((!access(fn , R_OK) && !S_ISDIR(estat.st_mode)) || !strcmp(act_name , fn))))
					{
						char *relfn = get_relative_path(act_name , fn);
						if (anchor)
							sprintf(pom , "%s#%s" , relfn , anchor);
						else strcpy(pom ,relfn);

						_free(relfn);
					}
					else
					{
						sprintf(pom , "%s/%s" , fn , cfg.index_name);

						if (!stat(pom , &estat) && !S_ISDIR(estat.st_mode))
						{
							char *relfn = get_relative_path(act_name , pom);

							if (anchor)
								sprintf(pom , "%s#%s" , relfn , anchor);
							else strcpy(pom ,relfn);

							free(relfn);
						}
					}
				}
				free_deep_url(urlp);
				_free(urlp);

				l = strlen(pom);
				MEXPAND(l);
				result[r] = '\'';
				r++;
				strcpy(result + r , pom);
				r += l;
				result[r] = '\'';
				r++;
				result[r] = ')';
				r++;
			
				urlstart = FALSE;
			}
			else
			{
				SEXPAND(1);
				stack[sr] = *p;
				sr++;
			}
			continue;
		}
		
		if (((p - stylestr) > 3) && !strncasecmp(p - 3 , "url(" , 4))
		{
			urlstart = TRUE;
			sr = 0;
		}
		MEXPAND(1);
		result[r] = *p;
		r++;
	}
	result[r]= '\0';

	_free(stack);

	return result;
}


char *css_change_url(docp , stylestr , url_old , url_new)
doc *docp;
char *stylestr;
url *url_old;
char *url_new;
{
	bool urlstart = FALSE;
	char *result;
	int sz,r;
	char *p;
	char pom[4096];
	char *anchor;
	char *oldfn;
	char *sp;
	char *stack;
	int ssz,sr,l;

	sz = strlen(stylestr) + NARAZNIK;
	result = _malloc(sz);
	r = 0;

	ssz = 2 * NARAZNIK;
	stack = _malloc(ssz);
	sr = 0;

	oldfn = url_to_urlstr(url_old , FALSE);

	for (p = stylestr ; *p ; p++)
	{
		if (urlstart)
		{
			if (*p == ')')
			{
				char *pfn;
				url *urlp;

				stack[sr] = '\0';

				sp = stack + sr - 1;
				while(isspace(*sp) && sp > stack) 
				{
					*sp = '\0';
					sp--;
				}
				if (*sp == '\"' || *sp == '\'') *sp = '\0';
				sp = stack;
				while(isspace(*sp)) sp++;
				if (*sp == '\"' || *sp == '\'') sp++;

				pfn = NULL;
				urlp = parse_url(sp);
				anchor = url_get_anchor_name(urlp);

				strcpy(pom , sp);

				if (urlp && (urlp->type != URLT_FILE) && 
				    (pfn = url_to_urlstr(urlp , FALSE)))
				{
					if (!strcmp(pfn , oldfn))
					{
						if (anchor)
							sprintf(pom , "%s#%s" , url_new , anchor);
						else
							strcpy(pom , url_new);
					}
				}

				free_deep_url(urlp);
				free(urlp);
				_free(pfn);

				l = strlen(pom);
				MEXPAND(l);
				result[r] = '\'';
				r++;
				strcpy(result + r , pom);
				r += l;
				result[r] = '\'';
				r++;
				result[r] = ')';
				r++;

				urlstart = FALSE;
			}
			else
			{
				SEXPAND(1);
				stack[sr] = *p;
				sr++;
			}
			continue;
		}
		
		if (((p - stylestr) > 3) && !strncasecmp(p - 3 , "url(" , 4))
		{
			urlstart = TRUE;
			sr = 0;
		}
		MEXPAND(1);
		result[r] = *p;
		r++;
	}
	result[r]= '\0';

	_free(stack);

	return result;
}

