/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _config_h_
#define _config_h_

#define NeedFunctionPrototypes 1

#ifdef NEED_DECLARE_H_ERRNO
extern int h_errno;
#endif

#ifndef HAVE_LONG_FILE_NAMES
#warning "This program can't run successfuly on machine without long filenames support"
#endif

#include <time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <netinet/in.h>

#include "mode.h"

#ifdef X_FACE
#include "xinterface.h"
#include "icons.h"
#else
#ifdef GTK_FACE
#include "ginterface.h"
#include "icons.h"

#else
#define _Xt_Serve
#define _X_EscapeLoop
#define _Xt_ServeLoop
#define iface_set_what(w) DEBUG_USER(" - %s\n", w);
#endif
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif

#ifdef NO_SETENV
#define setenv my_setenv
#define unsetenv(var) my_setenv(var , "" , 1)
#endif

#ifdef HAVE_FLOCK
#include <sys/file.h>
#define _flock(fd , fname , opt , blk) my_flock(&fd , fname , opt , blk)
#define _funlock(fd) flock(fd , LOCK_UN)
#else
#ifdef HAVE_FCNTL_LOCK
#define _flock(fd , fname , opt , blk) my_flock(&fd , fname , opt , blk)
#define _funlock(fd) my_funlock(fd)
#else
#define _flock(fd , fname , opt , blk) 0
#define _funlock(fd) 0
#endif
#endif

#include <limits.h>
#ifndef PATH_MAX
#ifdef FILENAME_MAX
#define PATH_MAX FILENAME_MAX
#else
#define PATH_MAX	2048
#endif
#endif

#ifndef NAME_MAX
#ifdef MAXNAMLEN
#define NAME_MAX MAXNAMLEN
#else
#define NAME_MAX 256
#endif
#endif

#ifndef INT_MAX
#define INT_MAX		2147483647
#endif
#ifndef USHRT_MAX
#define	USHRT_MAX	65535
#endif

#ifdef SOCKS

#ifdef HAVE_SOCKS_H
#include <socks.h>
#endif

#ifndef SOCKS5
#define connect 	Rconnect
#define bind		Rbind
#define accept		Raccept
#define listen		Rlisten
#define select		Rselect
#define gethostbyname	Rgethostbyname
#define getsockname	Rgetsockname
#endif

#endif

#include "mt.h"
#include "debugl.h"
#include "condition.h"
#include "mode.h"
#include "nls.h"
#include "http.h"
#include "dllist.h"
#include "dlhash.h"

#define HASH_TBL_SIZE	233

typedef enum {
	SSTRAT_DO_SIRKY ,
	SSTRAT_DO_SIRKY_I ,
	SSTRAT_DO_HLBKY ,
	SSTRAT_DO_HLBKY_I ,
	SSTRAT_LAST ,
} strategie;

typedef struct {
/*** CMDline parameters ***/
	char 	*urls_file;	/*** urls will be rad from file ***/
	char	*cookie_file;	/*** cookie file in NS format ***/
	char	*auth_file;	/*** file for authentification informations ***/
	char	*save_scn;	/*** name for scenario saving ***/
	char    *scndir;	/*** directory where scenarios are stored ***/
	char	*scenario;	/*** scenario file to load ***/
	char	*subdir;	/*** subdirectory of cache_dir to focus  ***/
	char	*cache_dir;	/*** dir where your local tree is located ***/
	char 	*logfile;	/*** logging file ***/
	char	*short_logfile;	/*** newstyle log file name ***/
	char	*remind_cmd;	/*** command for reminding changed URLS ***/
	char	*ns_cache_dir;	/*** directory for Netscape cache ***/
	char	*sched_cmd;	/*** scheduling command ***/
	char	*post_cmd;	/*** command for post downloading processing of files ***/
	char	*stats_file;	/*** status file ***/

	int	ssl_version;	/*** 2/3/23 version of ssl_client_method() ***/
	int	hash_size;	/*** hash tables size ***/
	int	trans_quota;	/*** transfer quota ***/
	int	file_quota;	/*** file size quota ***/
	int	fs_quota;	/*** filesystem quota ***/
	int	bufsize;	/*** size of read buffer ***/
	int	base_level;	/*** base tree level from which is built local file tree ***/
	int	nretry;		/*** number of retries on error ***/
	int	nreget;		/*** number of regets ***/
	int	nredir;		/*** max number of redirections ***/
	int	ddays;		/*** delay in days for document reload ***/
	int	rollback;	/*** size to go back when reget-ing ***/
	int	sleep;		/*** sleeptime between transfers ***/
	int	cookies_max;	/*** maximal number of cookies ***/
	int	ctimeout;	/*** timeout for network communication ***/
	int	reschedh;	/*** number of hours for rescheduling ***/
	int	max_time;	/*** maximal time for run ***/
	pavuk_mode	mode;	/*** working mode ***/
	struct tm *time;	/*** when to schedule execution time ***/
	time_t	schtime;	/*** cmdln param for scheduling time ***/
	strategie scheduling_strategie;	/*** url downloading scheduling strategie ***/

	char	*http_proxy;	/*** HTTP proxy server ***/
	int	http_proxy_port;
	char	*http_proxy_pass; /*** password for access to HTTP proxy server ***/
	char	*http_proxy_user; /*** username for access to HTTP proxy server ***/
	int	proxy_auth_scheme; /*** authorization scheme for proxy server ***/
	char	*ftp_proxy;	/*** FTP proxy server ***/
	int	ftp_proxy_port;
	bool	ftp_via_http;	/*** gatewaying FTP through HTTP proxy ***/
	bool	ftp_dirtyp;	/*** dirty FTP proxying via CONNECT request to HTTP proxy ***/
	char	*ssl_proxy;	/*** SSL tuneling proxy ***/
	int	ssl_proxy_port;
	char	*gopher_proxy;	/*** Gopher proxy ***/
	int	gopher_proxy_port;
	bool	gopher_via_http; /*** gatewaying Gopher trough HTTP proxy ***/
	char	*name_auth;	/*** meno pouzivatela pri HTTP autentifikacii ***/
	char	*passwd_auth;	/*** password for HTTP authorization ***/
	int	auth_scheme;	/*** authorization scheme 1- user, 2- Basic, 3- Digest ***/

#ifdef _WIN32
	bool	wait_on_exit;	/*** this option is for WIN32 CLI version ***/
#endif
	bool	use_http11;	/*** enable using of HTTP/1.1 protocol version ***/
	bool	unique_sslid;	/*** use unique SSL IDs with each SSL connection ***/
	bool	gen_logname;	/*** generate nummbered log names when original locked ***/
	bool	send_if_range;	/*** send If-Range: header in HTTP request ***/
	bool	tccheck;	/*** checking of we are at foreground ***/
	bool	remove_adv;	/*** enable / disable advertisement banners ***/
	bool	auto_referer;	/*** send own URL as referer with starting URLs ***/
	bool	all_to_remote;	/*** change all links to remote and don't do any further changes to it ***/
	bool	sel_to_local;	/*** change links, which acomplish limits, to local immediately ***/
	bool	all_to_local;	/*** change all links to local immediately ***/
	bool	enable_info;	/*** enable using and creating info files ***/
	bool	enable_js;	/*** enable javascript ***/
	bool	bgmode;		/*** run at background ***/
	bool	store_index;	/*** store directory URLS as index files ***/
	bool	send_from;	/*** send From: header in request ***/
	bool	check_size;	/*** some broken HTTP servers send wrong Content-Length: header ***/
	bool	htdig;		/*** to dump HTTP response - used by htDig ***/
	bool	send_cookies;	/*** send available cookies in HTTP request ***/
	bool	recv_cookies;	/*** receive cookie infos ***/
	bool	update_cookies; /*** update cookie file ***/
	bool	cookie_check_domain; /*** check if server sets cookie for own domain ***/
	bool	preserve_time;	/*** preserve time of remote document ***/
	bool	preserve_perm;	/*** preserve permisions of remote document ***/
	bool	preserve_links;	/*** preserve absolute symlinks ***/
	bool	quiet;		/*** ? output messages ***/
	bool	auth_reuse_nonce;
	bool	auth_reuse_proxy_nonce;
	bool	show_time;	/*** show start and end time of download ? */
	bool	remove_old;	/*** remove old documents (when not occurrs on remote site) ***/
	bool	progres;	/*** show retrieving progres , when on console ***/
	bool	ftp_activec;	/*** use active FTP data connection instead of passive ***/
	bool	ftp_list;	/*** retrieve FTP directory with LIST cmd insted of NLST ***/
	bool	ftp_html;	/*** process HTML files downloaded over FTP protocol ***/
	bool	cache;		/*** disallow caching of HTTP documents (on proxy cache) ***/
	bool	rewrite_links;	/*** indikacia ci ma maju byt odkazy v HTML dokumentoch prepisovane ***/
	bool	freget;		/*** force reget whole file when server doesn't support reget ***/
	bool	use_enc;	/*** indikacia ci sa ma pouzivat gzip/compress kodovanie pri prenose ***/

	char	*local_ip;	/*** address for local network interface ***/
	char	*index_name;	/*** name of directory index file instead of _._.html ***/
	char	*store_name;    /*** filename of document transfered with -mode singlepage ***/
	char	*from;		/*** HTTP request field From: or anonymous FTP password ***/
	char	*identity;	/*** User-agent: field contents ***/
	char	**accept_lang;	/*** list of preffered languages ***/
	char	**accept_chars;	/*** list of preffered character sets ***/
	char	**cookies_disabled_domains; /*** domains from which cookies are not acceptable ***/

	cond	condition;	/*** structure which contains all limiting conditions ***/
	dllist	*prepurlstr;	/*** list of urls entered by user ***/
	dllist	*lfnames;	/*** list of filename conversion rules ***/
	dllist	*advert_res;	/*** list of RE-s for advertisement banners ***/
	dllist	*http_headers;	/*** list of additional HTTP headers ***/

	char	*tr_del_chr;	/*** set of characters to delete while doing name transformation ***/
	char	*tr_str_s1;	/*** strfrom in transformation ***/ 
	char	*tr_str_s2;	/*** strto in transformation ***/
	char	*tr_chr_s1;	/*** setfrom in transformation ***/
	char	*tr_chr_s2;	/*** setto in transformation ***/

	double	maxrate;	/*** maximal transfer rate ***/
	double	minrate;	/*** minimal transfer rate ***/
#ifdef DEBUG
	bool	debug;		/*** debug mode on/off ***/
	int	debug_level;	/*** debug level ***/
#endif
#ifdef USE_SSL
	char	*ssl_cipher_list;
	char	*ssl_cert_file;
	char	*ssl_key_file;
	char	*ssl_cert_passwd;
#endif
#ifdef GETTEXT_NLS
	char	*msgcatd;	/*** explicit message catalog directory ***/
	char	*language;	/*** language for LC_MESSAGES ***/
#endif
#ifdef I_FACE
	char	*fontname;	/*** default font used in interface ***/
	int	xlogsize;	/*** max number of lines in LOG widget ***/
	bool	log_autoscroll;	/*** autoscroll of log window ***/
	bool	xi_face;	/*** requested GUI interface ***/
	bool	run_iface;	/*** if immediately run download after start of pavuk in GUI interface ***/
	bool	use_prefs;	/*** store & load prefernces from ~/.pavuk_prefs file ***/
#ifdef WITH_TREE
	char	*browser;	/*** command to execute your preffered browser ***/
#endif
#endif

/*** GLOBALdata ***/
	struct in_addr local_ip_addr;	/*** numeric address for local network interface ***/
	time_t	start_time;	/*** start time of downloading ***/
	long	trans_size;	/*** transfered size in session ***/
	char	*path_to_home;
	char	*local_host;	/*** hostname of local machine ***/
	int	fail_cnt;	/*** counter for failed transfers ---> return code of pavuk ***/
	char	*prg_path;	/*** nazov programu pod akym bol spusteny ***/
	int	total_cnt;	/*** celkovy pocet URL v zozname ***/
	pavuk_mode prev_mode;	/*** previous active mode ***/
	bool	mode_started;	/*** mode startup finisched ***/
	bool	rbreak;		/*** immediately stop transfer ***/
	bool	stop;		/*** stop after this document will be processed ***/
	dllist	*urlstack;	/*** list of URLs in processing queue ***/
	dllist	*urls_in_dir;	/*** list of URLs extracted from mirroring directory, for checking for nonexisten document removal ***/
	dlhash	*url_hash_tbl;	/*** hash table for better performance URL lookup ***/
	dlhash	*fn_hash_tbl;	/*** hash table for better performance filename lookup ***/

#ifdef X_FACE
	Xnfo	X;
#endif
#ifdef GTK_FACE
	Gtk_nfo	gtk;
#endif
#ifdef I_FACE
#ifdef WITH_TREE
	urltype_icon icon;	/*** icons in URL tree preview ***/
#endif
	bool	done;		/*** was done startup ? ***/
	bool	processing;	/*** some URL is actualy in processing ***/
#endif
} _config_struct;

extern _config_struct cfg;

typedef enum {
	PARAM_NUM ,
	PARAM_PBOOL ,
	PARAM_NBOOL ,
	PARAM_STR ,
	PARAM_STRLIST ,
	PARAM_CONN ,
	PARAM_AUTHSCH ,
	PARAM_MODE ,
	PARAM_PATH ,
	PARAM_TIME ,
	PARAM_HTMLTAG ,
	PARAM_TWO_QSTR ,
	PARAM_DOUBLE ,
	PARAM_LFNAME ,
	PARAM_RE ,
	PARAM_USTRAT,
	PARAM_SSLVER,
	PARAM_HTTPHDR,
	PARAM_DEBUGL
} par_type;

typedef struct _cfg_param {
	char		*par_cmd;
	char		*par_entry;
	par_type	type;
	void		*default_val;
	void		*val_adr;
	void		*mdefault_val;
	void		*mval_adr;
	char		*help;
} cfg_param;

extern void usage(char *);
extern void usage_short(char *);
extern void cfg_setup_default();
extern void cfg_setup_cmdln(int , char **);
extern int cfg_load(char *);
extern void cfg_load_setup();
extern int cfg_dump(char *);
extern int cfg_dump_cmd(char *);
extern void cfg_free_params();
extern int cfg_dump_pref();
extern int cfg_load_pref();

#endif
