/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>


#include "config.h"
#include "recurse.h"
#include "update_links.h"
#include "tools.h"
#include "remind.h"

void free_all()
{
#ifdef WITH_TREE
#ifdef X_FACE
	if (cfg.xi_face && cfg.X.root)
	{
		TreeListDeleteItem(cfg.X.tree_widget , cfg.X.root);
		cfg.X.root = NULL;
	}
#endif
#ifdef GTK_FACE
	if (cfg.xi_face && cfg.gtk.root)
	{
#ifdef _GTK_FEATURES_1_2
		gtk_clist_freeze(GTK_CLIST(cfg.gtk.tree_widget));
		gtk_clist_clear(GTK_CLIST(cfg.gtk.tree_widget));
		gtk_clist_thaw(GTK_CLIST(cfg.gtk.tree_widget));
#else
		GList rw;

		rw.prev = NULL;
		rw.next = NULL;
		rw.data = cfg.gtk.root;

		gtk_tree_remove_items(GTK_TREE(cfg.gtk.tree_widget) , &rw);

#endif
		cfg.gtk.root = NULL;
	}
#endif
#endif /* WITH_TREE */

	while(cfg.urlstack) cfg.urlstack = dllist_remove_entry(cfg.urlstack, cfg.urlstack);
	while(cfg.urls_in_dir) cfg.urls_in_dir = dllist_remove_entry(cfg.urls_in_dir, cfg.urls_in_dir);

	dlhash_empty(cfg.url_hash_tbl);
	dlhash_empty(cfg.fn_hash_tbl);

	cfg.urlstack = NULL;
}

int append_starting_url(urlstr)
char *urlstr;
{
	int rv = 1;
	url *urlp = parse_url(urlstr);

	if ((urlp->type == URLT_FILE) &&
	    (*urlstr != '/') && prottable[urlp->type].supported)
	{
		char *p = NULL;

		free_deep_url(urlp);
		if (!strncasecmp(urlstr , "gopher." , 7))
			p = tl_str_concat(p , "gopher://" , urlstr, NULL);
		else if (!strncasecmp(urlstr , "ftp." , 4))
			p = tl_str_concat(p , "ftp://" , urlstr, NULL);
		else if (!strncasecmp(urlstr , "ssl." , 4))
			p = tl_str_concat(p , "https://" , urlstr, NULL);
		else
			p = tl_str_concat(p , "http://" , urlstr, NULL);
		urlp = parse_url(p);
		_free(p);
	}

	if (!prottable[urlp->type].supported || url_was_befor(urlp))
	{
		if (!prottable[urlp->type].supported)
		{
			xprintf(1, gettext("Removing unsupported URL: %s\n") , urlstr);
		}
		free_deep_url(urlp);
		_free(urlp)
		rv = 0;
	}
	else
		append_url_to_list(urlp);

	return rv;
}

static void _append_starting_urls()
{
	dllist *dptr;

	for(dptr = cfg.prepurlstr ; dptr ; dptr = dptr->next)
	{
		char *p = (char *)dptr->data;
		append_starting_url(p);
	}
}

void absi_restart()
{
	int i;

#ifdef I_FACE

	cfg.rbreak = FALSE;
	cfg.stop = FALSE;
#endif
	cfg.start_time = time(NULL);
	cfg.fail_cnt = 0;
	cfg.mode_started = FALSE;
	cfg.prev_mode = cfg.mode;

	cfg.trans_size = 0;

	/*** cleanup ***/
	free_all();

#ifdef WITH_TREE
#ifdef X_FACE
	if (cfg.xi_face) 
	{
		TreeListItem i_nfo;

		/*** startup ***/
		i_nfo.label = gettext("Start");
		i_nfo.icon = cfg.icon.notprocessed;
		i_nfo.id = 0;
		i_nfo.related_info = NULL;
		cfg.X.root = TreeListSetNewRoot(cfg.X.tree_widget , &i_nfo);
	}
#endif
#ifdef GTK_FACE
	if (cfg.xi_face && !cfg.gtk.root) 
	{
#ifdef _GTK_FEATURES_1_2
		gchar *text[1];

		text[0] = gettext("Start");

		cfg.gtk.root = (GtkCTreeNode *)gtk_ctree_insert_node(GTK_CTREE(cfg.gtk.tree_widget) ,
				NULL , NULL , text , 8 ,
				cfg.icon.notprocessed->pixmap ,
				cfg.icon.notprocessed->shape ,
				cfg.icon.notprocessed->pixmap ,
				cfg.icon.notprocessed->shape ,
				FALSE , TRUE);
#else
		cfg.gtk.root = gtk_tree_item_new_with_label(gettext("Start"));
		gtk_tree_append(GTK_TREE(cfg.gtk.tree_widget), cfg.gtk.root);
		gtk_widget_show(cfg.gtk.root);
		gtk_object_set_user_data(GTK_OBJECT(cfg.gtk.root) , NULL);
#endif
	}
#endif
#endif /* WITH_TREE */

	cfg.total_cnt = 0;
	cfg.urlstack = NULL;

	switch(cfg.mode)
	{
	    case MODE_SINGLE:
	    case MODE_SREGET:
	    case MODE_NORMAL:
	    case MODE_NOSTORE:
	    case MODE_FTPDIR:
#ifdef I_FACE
		if (!cfg.xi_face) 
#endif
			if (!cfg.prepurlstr) usage_short(cfg.prg_path);
			
	    	if (cfg.prepurlstr)
	    	{
			_append_starting_urls();
			cfg.mode_started = TRUE;
			recurse(TRUE);
		}
#ifdef I_FACE
		else if (cfg.xi_face)
			iface_set_what(gettext("Specify at least one starting URL !!!"));
#endif
		else
			xprintf(1 , gettext("Specify at least one starting URL !!!\n"));
		break;
	    case MODE_LNUPD:
		if (!cfg.subdir)
		{
			char pom[PATH_MAX];

			for(i = 0 ; i < NUM_ELEM(prottable) ; i++)
			{
			    	if (prottable[i].supported && prottable[i].dirname)
			    	{
					sprintf(pom , "%s/%s" , cfg.cache_dir ,
		    				prottable[i].dirname);
		    			if (!access(pom , F_OK))
						update_links(pom);
				}
			}
		}
		else
		{
			update_links(cfg.subdir);
		}
		break;
	    case MODE_SYNC:
		cfg.total_cnt = 0;
	    	cfg.urlstack = NULL;
		if (cfg.prepurlstr)
		{
			_append_starting_urls();
		}
		if ((cfg.remove_old && cfg.subdir) || !cfg.prepurlstr)
		{
		    	if (!cfg.subdir)
		    	{
	    			char pom[PATH_MAX];

			    	for(i = 0 ; i < NUM_ELEM(prottable) ; i++)
			    	{
			    		if (prottable[i].supported && prottable[i].dirname)
			    		{
				    		sprintf(pom , "%s/%s" , cfg.cache_dir ,
			    				prottable[i].dirname);
		    				if (!access(pom , F_OK))
							get_urls_to_synchronize(pom, &cfg.urls_in_dir);
					}
				}
			}
			else
			{
				get_urls_to_synchronize(cfg.subdir, &cfg.urls_in_dir);
			}
			if (!cfg.prepurlstr)
			{
				while(cfg.urls_in_dir)
				{
					url *purl = (url *)cfg.urls_in_dir->data;

					append_url_to_list(purl);
					cfg.urls_in_dir = dllist_remove_entry(cfg.urls_in_dir , cfg.urls_in_dir);
				}
			}
		}
		cfg.mode_started = TRUE;
		recurse(TRUE);
		if (!cfg.urlstack)
		{
			while(cfg.urls_in_dir)
			{
				url *purl = (url *)cfg.urls_in_dir->data;

				purl->status |= URL_NORECURSE;
				if (url_was_befor(purl))
				{
					free_deep_url(purl);
					_free(purl);
				}
				else
					append_url_to_list(purl);
				cfg.urls_in_dir = dllist_remove_entry(cfg.urls_in_dir , cfg.urls_in_dir);
			}
			if (cfg.urlstack)
				recurse(FALSE);
		}
		break;
	    case MODE_RESUME:
		cfg.total_cnt = 0;
	    	cfg.urlstack = NULL;
	    	if (!cfg.subdir)
	    	{
	    		char pom[PATH_MAX];

		    	for(i = 0 ; i < NUM_ELEM(prottable) ; i++)
		    	{
		    		if (prottable[i].supported && prottable[i].dirname)
		    		{
		    			sprintf(pom , "%s/%s" , cfg.cache_dir ,
		    				prottable[i].dirname);
		    			if (!access(pom , F_OK))
						get_urls_to_resume(pom);
				}
			}
		}
		else
		{
			get_urls_to_resume(cfg.subdir);
		}
		cfg.mode_started = TRUE;
		recurse(TRUE);
		break;
	    case MODE_REMIND:
		remind_load_db();
		remind_start_add();
		remind_do();
		remind_save_db();
		if (!cfg.stop && !cfg.rbreak)
			remind_send_result();
		break;
	    default:
		break;
	}
}

void absi_cont()
{
	int i;
	
#ifdef I_FACE
	cfg.rbreak = FALSE;
	cfg.stop = FALSE;
#endif

	switch(cfg.mode)
	{
	    case MODE_SINGLE:
	    case MODE_SREGET:
	    case MODE_RESUME:
	    case MODE_NORMAL:
	    case MODE_NOSTORE:
	    case MODE_FTPDIR:
		recurse(FALSE);
		break;
	    case MODE_SYNC:
		recurse(FALSE);
		if (!cfg.urlstack)
		{
			while(cfg.urls_in_dir)
			{
				url *purl = (url *)cfg.urls_in_dir->data;

				purl->status |= URL_NORECURSE;
				if (url_was_befor(purl))
				{
					free_deep_url(purl);
					_free(purl);
				}
				else
					append_url_to_list(purl);
				cfg.urls_in_dir = dllist_remove_entry(cfg.urls_in_dir , cfg.urls_in_dir);
			}
			if (cfg.urlstack)
				recurse(FALSE);
		}
		break;
	    case MODE_LNUPD:
		if (!cfg.subdir)
		{
			char pom[PATH_MAX];

			for(i = 0 ; i < NUM_ELEM(prottable) ; i++)
			{
			    	if (prottable[i].supported && prottable[i].dirname)
			    	{
					sprintf(pom , "%s/%s" , cfg.cache_dir ,
		    				prottable[i].dirname);
					update_links(pom);
				}
			}
		}
		else
		{
			update_links(cfg.subdir);
		}
	    	break;	    	
	    case MODE_REMIND:
		remind_do();
		remind_start_add();
		remind_save_db();
		if (!cfg.stop && !cfg.rbreak)
			remind_send_result();
	    default:
		break;
	}
}

#ifdef GETTEXT_NLS

static int sort_strcmp(s1 , s2)
char **s1;
char **s2;
{
	return strcmp(*s1 , *s2);
}

char **get_available_languages()
{
	DIR *dir;
	struct dirent *dent;
	char msgfile[PATH_MAX];
	char **retv = NULL;
	int nr = 0;

	if (!cfg.msgcatd || !(dir = opendir(cfg.msgcatd)))
	{
		xprintf(0 , gettext("Can't list available message catalogs\n"));
		return NULL;
	}

	while((dent = readdir(dir)))
	{
		if (!strcmp(dent->d_name , ".")) continue;
		if (!strcmp(dent->d_name , "..")) continue;
		sprintf(msgfile , "%s/%s/LC_MESSAGES/%s.mo" , cfg.msgcatd ,
			dent->d_name ,  CATALOG_NAME);

		if (!access(msgfile , R_OK))
		{
			nr++;
			retv = _realloc(retv , (nr + 1) * sizeof(char *));
			retv[nr - 1] = new_string(dent->d_name);
			retv[nr] = NULL;
		}
	}

	closedir(dir);

	if (retv) qsort((void *)retv , nr , sizeof(char *) , sort_strcmp);

	return retv;
}
#endif
