/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <errno.h>


#include	"FloatEntryP.h"
#include	"Init.h"
#include	"misc.h"
#include	"utils.h"
#include	"cvt.h"

#define offset(field) XtOffsetOf(FloatEntryRec,floatEntry.field)

static XtResource resources [] = {
        {
	 XtNvalue ,
         XtCValue ,
         XtRFloat ,
         sizeof(float) ,
         offset(value) ,
         XtRString ,
         (XtPointer) "0.0"
        },
	{
	 XtNminval ,
         XtCMinval ,
         XtRFloat ,
         sizeof(float) ,
         offset(minval) ,
         XtRString ,
         (XtPointer) "0.0"
        },
	{
	 XtNmaxval ,
         XtCMaxval ,
         XtRFloat ,
         sizeof(float) ,
         offset(maxval) ,
         XtRString ,
         (XtPointer) "1000000.0"
        },
        {
         XtNarrow_width ,
         XtCArrow_width ,
         XtRInt ,
         sizeof(int) ,
         offset(arrow_width) ,
         XtRImmediate ,
         (XtPointer) 16
        },
        {
         XtNvalid ,
         XtCValid ,
	 XtRString ,
	 sizeof(char *) ,
	 XtOffsetOf(FloatEntryRec , entryLine.valid) ,
	 XtRImmediate ,
	 (XtPointer) "-0123456789.,"
        },
        {
	 XtNincrement ,
	 XtCIncrement ,
	 XtRFloat ,
	 sizeof(float) ,
	 offset(increment) ,
	 XtRString ,
	 (XtPointer) "1.0"
        },
        {
	 XtNdecimals ,
	 XtCDecimals ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(decimals) ,
	 XtRImmediate ,
	 (XtPointer) 2
        },
};

static void ClassInitialize();
static void Initialize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();
static void GetTextDimension ();

static void Increment ();
static void Decrement ();
static void GetValue ();
static void StartArrow ();
static void timerCB ();
static void StopArrow ();
static void ChValid ();


static XtActionsRec action [] = {
        {"get_value",GetValue},
        {"increment",Increment},
        {"decrement",Decrement},
	{"start_arrow",StartArrow},
	{"stop_arrow",StopArrow},
        };

static char trans_tab [] = "\
	<FocusIn>: focusIn() draw_cursor()\n\
	<FocusOut>: focusOut() clear_cursor()\n\
	~Shift<Key>Tab: traverseForward()\n\
	Shift<Key>Tab: traverseBackward()\n\
        <Key>Up: increment(1.0) \n\
        <Key>Down: decrement(1.0) \n\
        <Key>Return: get_value() \n\
       	<Key>Home: bol() \n\
	Ctrl<Key>E: eol() \n\
	<Key>End: eol() \n\
	Ctrl<Key>A: bol() \n\
	Ctrl<Key>Y: kill_line() \n\
	Ctrl<Key>K: kill_end() \n\
	<Key>Right: move_right() \n\
	<Key>Left: move_left() \n\
	<Key>BackSpace: delete_previous() \n\
	<Key>Delete: delete_next() \n\
	<Key>: insert_char() \n\
	<Btn1Down>: focusCurrent() selection_start() start_arrow() \n\
	<Btn1Motion>: do_selection() \n\
	<Btn1Up>: selection_end() stop_arrow() \n\
	<Btn2Down>: focusCurrent() insert_selection(CUT_BUFFER0) \n\
	<Btn3Down>: focusCurrent() \n\
	<Enter>: highlight() show_help() \n\
        <Leave>: unhighlight() hide_help() \n\
         ~Shift<Key>Tab: traverseForward()\n\
         Shift<Key>Tab: traverseBackward()\n\
         <FocusIn>: focusIn()\n\
         <FocusOut>: focusOut()\n\
        <BtnDown>: hide_help() \n\
        <KeyDown>: hide_help() \n\
        ";


FloatEntryClassRec floatEntryClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &entryLineClassRec,
    /* class_name            */ "FloatEntry",
    /* widget_size           */ sizeof(FloatEntryRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* entryLine */
   {
    /* get_text_dimension      */ GetTextDimension,
   },
/* floatEntry */
   {
    /* empty		       */ 0
   }
};

WidgetClass floatEntryWidgetClass = (WidgetClass) &floatEntryClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	FloatEntryWidget nw = (FloatEntryWidget) new_widget;
	char _pom[10];
	char _pom2[10];

	sprintf(_pom2 , "%%.%df" , nw->floatEntry.decimals);
	sprintf(_pom , _pom2 , nw->floatEntry.value);
	XtVaSetValues(new_widget , XtNtext , _pom , NULL);

	nw->floatEntry.active_arrows = False;

	nw->floatEntry.oldtext = XtNewString(nw->entryLine.text);

	XtAddCallback(new_widget , XtNchange , ChValid , NULL);
}

static void Destroy(w)
Widget w;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;

	if (cw->floatEntry.oldtext)
		XtFree(cw->floatEntry.oldtext);
}


static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Dimension width,height;
	Position x,y;

	((FloatEntryWidgetClass)XtClass(w))->base_class.get_internal_dimension(w ,
		&x , &y , &width , &height);

	entryLineClassRec.core_class.expose(w,event,region);

	if (cw->floatEntry.active_arrows &&  cw->floatEntry.arrow == XtCtop_arrow)
		X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width , y ,
			cw->floatEntry.arrow_width , height / 2 , 1 , 
			cw->base.dark , cw->base.light);
	else
		X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width , y ,
			cw->floatEntry.arrow_width , height / 2 , 1 , 
			cw->base.light , cw->base.dark);
	if (cw->floatEntry.active_arrows &&  cw->floatEntry.arrow == XtCbottom_arrow)
		X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width , 
			y + height / 2 , cw->floatEntry.arrow_width ,
			height - height / 2 , 1 , cw->base.dark , cw->base.light);
	else	
		X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width , 
			y + height / 2 , cw->floatEntry.arrow_width ,
			height - height / 2 , 1 , cw->base.light , cw->base.dark);

	{
		XPoint triangel[3];
		
		triangel[0].x = x + width - cw->floatEntry.arrow_width + 2;
		triangel[0].y = y + height/2 - 2;
		triangel[1].x = x + width - 2;
		triangel[1].y = y + height / 2 - 2;
		triangel[2].x = x + width - cw->floatEntry.arrow_width / 2;
		triangel[2].y = y + 2;

		XFillPolygon(dpy , win , cw->entryLine.normalGC , triangel ,
                        XtNumber(triangel),Convex,CoordModeOrigin);

		triangel[0].x = x + width - cw->floatEntry.arrow_width  + 2;
		triangel[0].y = y + (height - height / 2) + 2;
		triangel[1].x = x + width - 2;
		triangel[1].y = y + (height - height / 2) + 2;
		triangel[2].x = x + width - cw->floatEntry.arrow_width / 2;
		triangel[2].y = y + height - 2;

		XFillPolygon(dpy , win , cw->entryLine.normalGC , triangel ,
                        XtNumber(triangel),Convex,CoordModeOrigin);



	}
	if (!XtIsSensitive(w)) Xt_SetInsensitive(w);
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> floatEntry.component != \
						w2 -> floatEntry.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args; 
{
	FloatEntryWidget cw = (FloatEntryWidget) current;
	FloatEntryWidget nw = (FloatEntryWidget) new_widget;
	char _pom[10];
	char _pom2[10];
	Boolean redraw = False;
	
	if (WidgetValuesDiffer(cw , nw , value) || WidgetValuesDiffer(cw , nw , decimals))
	{
		sprintf(_pom2 , "%%.%df" , nw->floatEntry.decimals);
		sprintf(_pom , _pom2 , nw->floatEntry.value);
		EntryLineSetText(new_widget , _pom);

		redraw = True;
	}

	return redraw;
}

static void ChValid(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	float c;
		
	c = x_atof(cw->entryLine.text);

	if (!BETWEEN(c , cw->floatEntry.minval , cw->floatEntry.maxval) || 
		errno == ERANGE)
	{
		XBell(XtDisplay(w) , 50);
		EntryLineSetText(w , cw->floatEntry.oldtext);
	}
	else
	{
		cw->floatEntry.value = c;
		if (cw->floatEntry.oldtext)
			XtFree(cw->floatEntry.oldtext);
		cw->floatEntry.oldtext = XtNewString(cw->entryLine.text);
	}
}

static void GetTextDimension(w , x , y , width , height)
Widget w;
Position *x;
Position *y;
Dimension *width;
Dimension *height;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;

	entryLineClassRec.entryLine_class.get_text_dimension(w , x , y , width , height);

	*width -= cw->floatEntry.arrow_width + 1;
}

static void GetValue(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;

	cw->floatEntry.value =  x_atof(cw->entryLine.text);

        XtCallCallbackList(w , cw->entryLine.activate , (XtPointer) &cw->floatEntry.value);
}

static void Decrement(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	char _pom[10];
	char _pom2[10];
	float c;

	c = x_atof(cw->entryLine.text);
	c -= x_atof(params[0]);

	sprintf(_pom2 , "%%.%df" , cw->floatEntry.decimals);
	sprintf(_pom , _pom2 , c);

	EntryLineSetText(w , _pom);
}

static void Increment(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	char _pom[10];
	char _pom2[10];
	float c;

	c = x_atof(cw->entryLine.text);
	c += x_atof(params[0]);

	sprintf(_pom2 , "%%.%df" , cw->floatEntry.decimals);
	sprintf(_pom , _pom2 , c);

	EntryLineSetText(w , _pom);
}

static void StartArrow(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Dimension width,height;
	Position x,y;
	char _pom[10];
	char _pom2[10];
	float c;

	((FloatEntryWidgetClass)XtClass(w))->base_class.get_internal_dimension(w ,
		&x , &y , &width , &height);

	if (BETWEEN(event->xbutton.x , x + width - cw->floatEntry.arrow_width , x + width))
	{
		if (BETWEEN(event->xbutton.y , y , y + height / 2))
		{
			cw->floatEntry.arrow = XtCtop_arrow;

			X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width ,
				y , cw->floatEntry.arrow_width , height / 2 , 1 , 
				cw->base.dark , cw->base.light);

		}
		else if (BETWEEN(event->xbutton.y , y + (height -  height / 2), y + height))
		{
			cw->floatEntry.arrow = XtCbottom_arrow;

			X_DrawSimple3DFrame(dpy , win , x + width - cw->floatEntry.arrow_width , 
				y + height / 2 , cw->floatEntry.arrow_width ,
				height - height / 2 , 1 , cw->base.dark , cw->base.light);

		}
		else return;
	} else return;

	c = x_atof(cw->entryLine.text);

	switch(cw->floatEntry.arrow)
	{
		case XtCtop_arrow:
				c += cw->floatEntry.increment;
				break;
		case XtCbottom_arrow: 
		default:
			c -= cw->floatEntry.increment;
	}

	sprintf(_pom2 , "%%.%df" , cw->floatEntry.decimals);
	sprintf(_pom , _pom2 , c);

	EntryLineSetText(w , _pom);

	cw->floatEntry.active_arrows = True;

        cw->floatEntry.timer = XtAppAddTimeOut(XtWidgetToApplicationContext(w),
                                500 , timerCB, w);
}

static void StopArrow(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;

	if  (!cw->floatEntry.active_arrows) return;

	cw->floatEntry.active_arrows = False;
	XtRemoveTimeOut(((FloatEntryWidget)w)->floatEntry.timer);
	Redisplay(w , NULL , NULL);
}

static void timerCB(client_data,timer)
XtPointer  client_data;
XtIntervalId * timer;
{
	FloatEntryWidget w = (FloatEntryWidget) client_data;
	char _pom[10];
	char _pom2[10];
	float c;

	c = x_atof(w->entryLine.text);

	switch(w->floatEntry.arrow)
	{
		case XtCtop_arrow:
				c += w->floatEntry.increment;
				break;
		case XtCbottom_arrow: 
		default:
			c -= w->floatEntry.increment;
	}

	sprintf(_pom2 , "%%.%df" , w->floatEntry.decimals);
	sprintf(_pom , _pom2 , c);

	EntryLineSetText((Widget)w , _pom);

	w->floatEntry.timer = XtAppAddTimeOut(XtWidgetToApplicationContext((Widget) w),
                                100 , timerCB, w);
}

float FloatEntryGetValue(w)
Widget w;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;

	return x_atof(cw->entryLine.text);
}

void FloatEntrySetValue(w , v)
Widget w;
float v;
{
	FloatEntryWidget cw = (FloatEntryWidget) w;
	char _pom[20];
	char _pom2[20];

	cw->floatEntry.value = v;

	sprintf(_pom2 , "%%.%df" , cw->floatEntry.decimals);
	sprintf(_pom , _pom2 , v);

	EntryLineSetText((Widget)w , _pom);
}

