/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "CheckMEP.h"
#include "Init.h"
#include "utils.h"

/* pixmapy */
#include        "mdoff.xpm"
#include        "mdon.xpm"
#include        "mroff.xpm"
#include        "mron.xpm"
#include        "mcoff.xpm"
#include        "mcon.xpm"
#include        "mchoff.xpm"
#include        "mchon.xpm"
#include        "mc2on.xpm"
#include        "mc2off.xpm"
#include        "mcron.xpm"
#include        "mcroff.xpm"


#define offset(field) XtOffsetOf(CheckMERec,checkME.field)

static XtResource resources [] = {
	{
	 XtNset ,
	 XtCSet ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(set) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNswitch ,
	 XtCSwitch ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(switchcb) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNreset ,
	 XtCReset ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(reset) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNon , 
	 XtCOn ,
	 XtRBool ,
	 sizeof(Boolean) ,
	 offset(on) ,
	 XtRString ,
	 (XtPointer) False
	},
	{
	 XtNtype ,
	 XtCType ,
	 XtRCheck_type ,
	 sizeof(int) ,
	 offset(type) ,
	 XtRImmediate ,
	 (XtPointer) XtCdiamond
	},
};

static void Destroy();
static void ClassInitialize ();
static void Initialize();
static Boolean SetValues();

static void Activate();

CheckMEClassRec checkMEClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &labelMEClassRec,
    /* class_name            */ "CheckME",
    /* widget_size           */ sizeof(CheckMERec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* rect1                 */ NULL,
    /* rect2                 */ NULL,
    /* rect3                 */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* rect4                 */ False,
    /* rect5                 */ False,
    /* rect6                 */ False,
    /* rect7                 */ False,
    /* destroy               */ Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ XtInheritExpose,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* rect9                 */ NULL,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* rect10                */ NULL,
    /* query_geometry        */ XtInheritQueryGeometry,
    /* rect11                */ NULL,
    /* extension             */ NULL
   },
/* baseME */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* enternotify	       */ XtInheritEnternotify,
    /* leavenotify	       */ XtInheritLeavenotify,
    /* activate		       */ Activate,
   },
/* labelME */
   {
   /* empty		       */ 0,
   },
/* checkME */
   {
   /* empty		       */ 0,
   }
};

WidgetClass checkMEObjectClass = (WidgetClass) &checkMEClassRec;

static void ClassInitialize()
{
    _InitializeWidgetSet();

    XtSetTypeConverter(XtRString, XtRCheck_type, cvtStringToCheckType,
                       NULL, 0, XtCacheNone, NULL);
}

static Icon * get_icon(w,icon_data)
CheckMEObject w;
char **icon_data;
{
	XColor top , bottom , bc;
	Icon *iconfin = (Icon *) XtMalloc(sizeof(Icon));
	Display *dpy = XtDisplayOfObject((Widget) w);
	static XpmColorSymbol	tbl[4];
	XpmAttributes		attributes;

	bc.pixel=w->baseME.background;

	XQueryColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&bc);

	LightColor(w->baseME.box_intensity,bc,top);

	DarkColor(w->baseME.box_intensity,bc,bottom);

	tbl[0].name="topShadowColor";
	tbl[0].value=NULL;
	tbl[0].pixel=top.pixel;
	tbl[1].name="bottomShadowColor";
	tbl[1].value=NULL;
	tbl[1].pixel=bottom.pixel;
	tbl[2].name="foreground";
	tbl[2].value=NULL;
	tbl[2].pixel=w->baseME.foreground;
	tbl[3].name="background";
	tbl[3].value=NULL;
	tbl[3].pixel=w->baseME.background;
	

	iconfin->shape=None;
	attributes.valuemask = XpmReturnInfos | XpmColorSymbols;
	attributes.colorsymbols = tbl;
	attributes.numsymbols = 4;


	XpmCreatePixmapFromData (dpy , DefaultRootWindow(dpy) , icon_data , 
				&iconfin->pixmap , &iconfin->shape , &attributes);

	iconfin->width = attributes.width;
	iconfin->height = attributes.height;

	return iconfin;
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CheckMEObject nw = (CheckMEObject) new_widget;
	char ** id_on , ** id_off;
	
	switch (nw->checkME.type)
	{
		case XtCrectangle:
			id_on = mron;
			id_off = mroff;
			break;
		case XtCcircle:
			id_on = mcon;
			id_off = mcoff;
			break;
		case XtCcheck:
			id_on = mchon;
			id_off = mchoff;
			break;
		case XtCcircle2:
			id_on = mc2on;
			id_off = mc2off;
			break;
		case XtCcross:
			id_on = mcron;
			id_off = mcroff;
			break;
		case XtCdiamond:
		default :
			id_on = mdon;
			id_off = mdoff;
	}	

	nw->checkME.i_on=get_icon(nw,id_on);
	nw->checkME.i_off=get_icon(nw,id_off);

	if (nw->checkME.on)
	{
		nw->labelME.left_icon = nw->checkME.i_on;
	}
	else 
	{
		nw->labelME.left_icon =  nw->checkME.i_off;
	}

	labelMEClassRec.rect_class.initialize(req_widget,new_widget,args,num_args);
}

static void Destroy (w)
Widget w;
{
	CheckMEObject cw = (CheckMEObject) w;
	Display *dpy = XtDisplayOfObject(w);

	XFreePixmap(dpy , cw->checkME.i_on->pixmap);
	XFreePixmap(dpy , cw->checkME.i_on->shape);
	XFreePixmap(dpy , cw->checkME.i_off->pixmap);
	XFreePixmap(dpy , cw->checkME.i_off->shape);

}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> checkME.component != \
                                             w2 -> checkME.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CheckMEObject cw = (CheckMEObject) current;
	CheckMEObject nw = (CheckMEObject) new_widget;
	Display *dpy = XtDisplayOfObject((Widget)nw);
	Boolean redraw = False;
	char ** id_on , ** id_off;

	if WidgetValuesDiffer( nw , cw , type)
	{
		switch (nw->checkME.type)
		{
			case XtCrectangle:
				id_on = mron;
				id_off = mroff;
				break;
			case XtCcircle:
				id_on = mcon;
				id_off = mcoff;
				break;
			case XtCcheck:
				id_on = mchon;
				id_off = mchoff;
				break;
			case XtCcircle2:
				id_on = mc2on;
				id_off = mc2off;
				break;
			case XtCcross:
				id_on = mcron;
				id_off = mcroff;
				break;
			case XtCdiamond:
			default :
				id_on = mdoff;
				id_off = mdon;
		}	
		nw->checkME.i_on=get_icon(nw,id_on);
		nw->checkME.i_off=get_icon(nw,id_off);
		XFreePixmap(dpy , cw->checkME.i_on->pixmap);
		XFreePixmap(dpy , cw->checkME.i_on->shape);
		XFreePixmap(dpy , cw->checkME.i_off->pixmap);
		XFreePixmap(dpy , cw->checkME.i_off->shape);
		XtFree((void*)cw->checkME.i_on);
		XtFree((void*)cw->checkME.i_off);

		if (nw->checkME.on)
		{
			nw->labelME.left_icon = nw->checkME.i_on;
		}
		else 
		{
			nw->labelME.left_icon =  nw->checkME.i_off;
		}

		redraw = True;
	}

	if WidgetValuesDiffer( nw , cw , on)
	{
		if (nw->checkME.on)
		{
			nw->labelME.left_icon = nw->checkME.i_on;
		}
		else 
		{
			nw->labelME.left_icon =  nw->checkME.i_off;
		}
	}

	return redraw;
}

static void Activate (w)
Widget w;
{
	CheckMEObject cw = (CheckMEObject) w;

	labelMEClassRec.baseME_class.activate(w);

	cw->checkME.on = !cw->checkME.on;
	if (cw->checkME.on)
	{
		XtVaSetValues(w , XtNleft_icon , cw->checkME.i_on , NULL);
		XtCallCallbackList(w,cw->checkME.set, NULL);
	}
	else 
	{
		XtVaSetValues(w , XtNleft_icon , cw->checkME.i_off , NULL);
		XtCallCallbackList(w,cw->checkME.reset, NULL);
	}

	XtCallCallbackList(w,cw->checkME.switchcb, NULL);	
}
