/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _BaseMEP_H_
#define _BaseMEP_H_

#include <X11/RectObjP.h>

#include <Nws/BaseME.h>
#include <Nws/dimdefP.h>

#if NeedFunctionPrototypes
typedef void (*enternotify_Proc) (Widget);
typedef void (*leavenotify_Proc) (Widget);
typedef void (*activate_Proc) (Widget);
#else
typedef void (*enternotify_Proc) ();
typedef void (*leavenotify_Proc) ();
typedef void (*activate_Proc) ();
#endif


#define  XtInheritEnternotify ((enternotify_Proc) _XtInherit)
#define  XtInheritLeavenotify ((leavenotify_Proc) _XtInherit)
#define  XtInheritActivate ((activate_Proc) _XtInherit)


typedef struct _BaseMEClassPart {
        get_internal_dimension_Proc     get_internal_dimension;
        set_internal_dimension_Proc     set_internal_dimension;
	enternotify_Proc		enternotify;
	leavenotify_Proc		leavenotify;
	activate_Proc			activate;
} BaseMEClassPart;

typedef struct _BaseMEClassRec {
	RectObjClassPart	rect_class;
	BaseMEClassPart		baseME_class;
} BaseMEClassRec;

extern BaseMEClassRec baseMEClassRec;

typedef struct {
	/* resources */
	int	wid;
	XtCallbackList  activate;
	Pixel	foreground;
	Pixel	background;
	Pixel	activ_bg;
	Pixel	activ_fg;
	Pixel	box_color;
	int	box_width;
	int	box_intensity;
	int	box_type;
	/* private */
	Pixel	light,dark;
	GC	gc;
	Boolean	entered;
	void	*related_data;
} BaseMEPart;

typedef struct _BaseMERec {
	ObjectPart		object;
	RectObjPart		rectangle;
	BaseMEPart		baseME;
} BaseMERec;

#endif
