/* arc.h - a 12 bit version 
   This has nothing to do with cryptography.
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#ifndef _ARC_ENCRYPTION_H
#define _ARC_ENCRYPTION_H

typedef struct {
#ifdef HAVE_BUILTIN_ARC
    int i;
    int j;
    int offset;
    unsigned long left_over;
    unsigned short s[0x1000];
#else
    Value heap[16];
    long s[0x1000];
    void *c;
    char *key;
    int key_size;
    char *data;
    int len;
#endif
    int initialised;
} Arc;

#ifndef HAVE_BUILTIN_ARC
#define ARC_INIT_SCRIPT		"/etc/ssocket/arcinit.cs"
#define ARC_ENCRYPT_SCRIPT	"/etc/ssocket/arcencrypt.cs"
#endif

void arc_init (Arc * arc, unsigned char *key, int key_size);
void arc_shut (Arc * arc);
void arc_encrypt (Arc * arc, unsigned char *data, int len);
void arc_decrypt (Arc * arc, unsigned char *data, int len);

#endif				/* ! _ARC_ENCRYPTION_H */


