/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.pep.client.config;

import eu.emi.security.authn.x509.CommonX509TrustManager;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.InMemoryKeystoreCertChainValidator;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.authz.pep.client.config.PEPClientConfigurationException;
import org.glite.authz.pep.obligation.ObligationHandler;
import org.glite.authz.pep.pip.PolicyInformationPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEPClientConfiguration {
    private Log log_ = LogFactory.getLog(PEPClientConfiguration.class);
    private List<String> pepdEndpoints_ = new ArrayList<String>();
    private List<PolicyInformationPoint> pips_ = new ArrayList<PolicyInformationPoint>();
    private List<ObligationHandler> obligationHandlers_ = new ArrayList<ObligationHandler>();
    private X509TrustManager trustManager_ = null;
    private X509KeyManager keyManager_ = null;
    private int connectionTimeout_ = 5000;
    private int maxConnectionsPerHost_ = 5;
    private int maxTotalConnections_ = 20;

    public List<String> getPEPDaemonEndpoints() {
        return Collections.unmodifiableList(this.pepdEndpoints_);
    }

    public void addPEPDaemonEndpoint(String endpoint) {
        this.pepdEndpoints_.add(endpoint);
    }

    public List<PolicyInformationPoint> getPolicyInformationPoints() {
        return Collections.unmodifiableList(this.pips_);
    }

    public void addPolicyInformationPoint(PolicyInformationPoint pip) {
        this.pips_.add(pip);
    }

    public List<ObligationHandler> getObligationHandlers() {
        return Collections.unmodifiableList(this.obligationHandlers_);
    }

    public void addObligationHandler(ObligationHandler oh) {
        this.obligationHandlers_.add(oh);
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout_;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout_ = timeout;
    }

    public void setTrustMaterial(String cadirname) throws PEPClientConfigurationException {
        File caDirectory;
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("cadirname: " + cadirname));
        }
        if (!(caDirectory = new File(cadirname)).isDirectory()) {
            throw new PEPClientConfigurationException(cadirname + " is not a valid directory");
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(cadirname);
        this.trustManager_ = new CommonX509TrustManager((X509CertChainValidator)validator);
    }

    public void setTrustMaterial(KeyStore truststore) throws PEPClientConfigurationException {
        try {
            InMemoryKeystoreCertChainValidator validator = new InMemoryKeystoreCertChainValidator(truststore);
            this.trustManager_ = new CommonX509TrustManager((X509CertChainValidator)validator);
        }
        catch (IOException e) {
            throw new PEPClientConfigurationException(e);
        }
        catch (KeyStoreException e) {
            throw new PEPClientConfigurationException(e);
        }
    }

    public void setKeyMaterial(String usercert, String userkey, String password) throws PEPClientConfigurationException {
        if (password == null) {
            throw new IllegalArgumentException("password can not be null");
        }
        if (this.log_.isDebugEnabled()) {
            this.log_.debug((Object)("usercert: " + usercert));
            this.log_.debug((Object)("userkey: " + userkey + " password: " + password));
        }
        try {
            PEMCredential credential = new PEMCredential(userkey, usercert, password.toCharArray());
            this.keyManager_ = credential.getKeyManager();
        }
        catch (GeneralSecurityException e) {
            throw new PEPClientConfigurationException(e);
        }
        catch (IOException e) {
            throw new PEPClientConfigurationException(e);
        }
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager_;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager_;
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost_;
    }

    public void setMaxConnectionsPerHost(int connectionsPerHost) {
        this.maxConnectionsPerHost_ = connectionsPerHost;
    }

    public void setMaxTotalConnections(int maxConnections) {
        this.maxTotalConnections_ = maxConnections;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections_;
    }
}

