/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.canl.tomcat;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class CANLSSLServerSocketFactory
extends ServerSocketFactory {
    private static final Log LOGGER = LogFactory.getLog(CANLSSLServerSocketFactory.class);
    protected SSLServerSocketFactory _serverSocketFactory = null;
    private boolean m_allowUnsafeLegacyRenegotiation = false;

    public Socket acceptSocket(ServerSocket sSocket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)sSocket.accept();
            this.configureClientAuth(asock);
            String ip = asock.getInetAddress().toString();
            X509Certificate[] certs = asock.getSession().getPeerCertificateChain();
            String dn = null;
            if (certs != null) {
                dn = X500NameUtils.getReadableForm((String)((Object)certs[0].getSubjectDN()).toString());
            }
            Date now = new Date();
            System.out.println(now.toString() + " : connection from " + ip + (dn == null ? " no certificate." : " dn: " + dn + "."));
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException, InstantiationException {
        if (this._serverSocketFactory == null) {
            this.initServerSocketFactory();
        }
        ServerSocket socket = this._serverSocketFactory.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException, InstantiationException {
        if (this._serverSocketFactory == null) {
            this.initServerSocketFactory();
        }
        ServerSocket socket = this._serverSocketFactory.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port) throws IOException, InstantiationException {
        if (this._serverSocketFactory == null) {
            this.initServerSocketFactory();
        }
        ServerSocket socket = this._serverSocketFactory.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public void handshake(Socket socket) throws IOException {
        SSLSession session = ((SSLSocket)socket).getSession();
        if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
            throw new IOException("SSL handshake failed. Ciper suite in SSL Session is SSL_NULL_WITH_NULL_NULL");
        }
        if (!this.m_allowUnsafeLegacyRenegotiation) {
            ((SSLSocket)socket).setEnabledCipherSuites(new String[0]);
        }
    }

    private void initServerSocketFactory() throws IOException {
        KeyAndCertCredential credentials;
        StoreUpdateListener listener = new StoreUpdateListener(){

            public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
                if (level != StoreUpdateListener.Severity.NOTIFICATION) {
                    System.out.println("Error when creating or using SSL socket. Type " + type + " level: " + level + (cause == null ? "" : " cause: " + cause.getClass() + ":" + cause.getMessage()));
                }
            }
        };
        ArrayList<1> listenerList = new ArrayList<1>();
        listenerList.add(listener);
        RevocationParameters revParam = new RevocationParameters(CrlCheckingMode.REQUIRE, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
        String crlCheckingMode = (String)this.attributes.get("crlcheckingmode");
        if (crlCheckingMode != null) {
            if (crlCheckingMode.equalsIgnoreCase("ifvalid")) {
                revParam = new RevocationParameters(CrlCheckingMode.IF_VALID, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
            }
            if (crlCheckingMode.equalsIgnoreCase("ignore")) {
                revParam = new RevocationParameters(CrlCheckingMode.IGNORE, new OCSPParametes(), false, RevocationParameters.RevocationCheckingOrder.CRL_OCSP);
            }
        }
        ProxySupport proxySupport = ProxySupport.ALLOW;
        String proxySupportString = (String)this.attributes.get("proxysupport");
        if (proxySupportString != null && (proxySupportString.equalsIgnoreCase("no") || proxySupportString.equalsIgnoreCase("false"))) {
            proxySupport = ProxySupport.DENY;
        }
        ValidatorParams validatorParams = new ValidatorParams(revParam, proxySupport, listenerList);
        String trustStoreLocation = (String)this.attributes.get("truststore");
        if (trustStoreLocation == null) {
            throw new IOException("No truststore defined, unable to load CA certificates and thus create SSL socket.");
        }
        String namespaceModeString = (String)this.attributes.get("namespace");
        NamespaceCheckingMode namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS;
        if (namespaceModeString != null) {
            if (namespaceModeString.equalsIgnoreCase("no") || namespaceModeString.equalsIgnoreCase("false") || namespaceModeString.equalsIgnoreCase("off")) {
                namespaceMode = NamespaceCheckingMode.IGNORE;
            } else if (namespaceModeString.equalsIgnoreCase("require")) {
                namespaceMode = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS_REQUIRE;
            }
        }
        String intervalString = (String)this.attributes.get("updateinterval");
        long intervalMS = 3600000L;
        if (intervalString != null) {
            intervalMS = Long.parseLong(intervalString);
        }
        OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreLocation, namespaceMode, intervalMS, validatorParams);
        ValidationErrorListener validationListener = new ValidationErrorListener(){

            public boolean onValidationError(ValidationError error) {
                java.security.cert.X509Certificate[] chain;
                System.out.println("Error when validating incoming certificate: " + error.getMessage() + " position: " + error.getPosition() + " " + error.getParameters());
                for (java.security.cert.X509Certificate cert : chain = error.getChain()) {
                    System.out.println(cert.toString());
                }
                return false;
            }
        };
        validator.addValidationListener(validationListener);
        String hostCertLoc = (String)this.attributes.get("hostcert");
        if (hostCertLoc == null) {
            throw new IOException("Variable hostcert undefined, cannot start server with SSL/TLS without host certificate.");
        }
        java.security.cert.X509Certificate[] hostCertChain = CertificateUtils.loadCertificateChain((InputStream)new FileInputStream(hostCertLoc), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        String hostKeyLoc = (String)this.attributes.get("hostkey");
        if (hostKeyLoc == null) {
            throw new IOException("Variable hostkey undefined, cannot start server with SSL/TLS without host private key.");
        }
        PrivateKey hostKey = CertificateUtils.loadPrivateKey((InputStream)new FileInputStream(hostKeyLoc), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, null);
        try {
            credentials = new KeyAndCertCredential(hostKey, hostCertChain);
        }
        catch (KeyStoreException e) {
            throw new IOException("Error while creating keystore: " + e + ": " + e.getMessage(), e);
        }
        this._serverSocketFactory = SocketFactoryCreator.getServerSocketFactory((X509Credential)credentials, (X509CertChainValidator)validator);
    }

    private void initServerSocket(ServerSocket ssocket) {
        LOGGER.debug((Object)"TMSSLServerSocketFactory.initServerSocket:");
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] ciphers = socket.getEnabledCipherSuites();
        ArrayList<String> newCiphers = new ArrayList<String>(ciphers.length);
        for (String cipher : ciphers) {
            if (cipher.indexOf("RC4") == -1 && cipher.indexOf("ECDH") == -1) {
                LOGGER.debug((Object)("Enabling cipher: " + cipher));
                newCiphers.add(cipher);
                continue;
            }
            LOGGER.debug((Object)("Disabling cipher: " + cipher));
        }
        socket.setEnabledCipherSuites(newCiphers.toArray(new String[0]));
        this.configureClientAuth(socket);
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        String clientAuthStr = (String)this.attributes.get("clientauth");
        if (clientAuthStr == null) {
            return;
        }
        if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
            socket.setNeedClientAuth(true);
        }
        if ("want".equalsIgnoreCase(clientAuthStr)) {
            socket.setWantClientAuth(true);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
        String clientAuthStr = (String)this.attributes.get("clientauth");
        if (clientAuthStr == null) {
            return;
        }
        if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
            socket.setNeedClientAuth(true);
        }
        if ("want".equalsIgnoreCase(clientAuthStr)) {
            socket.setWantClientAuth(true);
        }
    }
}

