/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServletContainerInitializerListener
implements ServletContextListener {
    private static final Logger LOG = Log.getLogger(ServletContainerInitializerListener.class);
    protected WebAppContext _context = null;

    public void setWebAppContext(WebAppContext context) {
        this._context = context;
    }

    public void contextInitialized(ServletContextEvent sce) {
        List initializers = (List)this._context.getAttribute("org.eclipse.jetty.containerInitializers");
        MultiMap classMap = (MultiMap)this._context.getAttribute("org.eclipse.jetty.classInheritanceMap");
        if (initializers != null) {
            for (ContainerInitializer i : initializers) {
                if (i.getAnnotatedTypeNames() != null) {
                    HashSet<String> annotatedClassNames = new HashSet<String>(i.getAnnotatedTypeNames());
                    for (String name : annotatedClassNames) {
                        List implementsOrExtends;
                        i.addApplicableTypeName(name);
                        if (classMap == null || (implementsOrExtends = classMap.getValues(name)) == null || implementsOrExtends.isEmpty()) continue;
                        this.addInheritedTypes(classMap, i, implementsOrExtends);
                    }
                }
                if (i.getInterestedTypes() != null) {
                    for (Class c : i.getInterestedTypes()) {
                        List implementsOrExtends;
                        if (c.isAnnotation() || classMap == null || (implementsOrExtends = classMap.getValues(c.getName())) == null || implementsOrExtends.isEmpty()) continue;
                        this.addInheritedTypes(classMap, i, implementsOrExtends);
                    }
                }
                try {
                    i.callStartup(this._context);
                }
                catch (Exception e) {
                    LOG.warn(e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    void addInheritedTypes(MultiMap classMap, ContainerInitializer initializer, List<String> applicableTypes) {
        for (String s : applicableTypes) {
            initializer.addApplicableTypeName(s);
            List implementsOrExtends = classMap.getValues(s);
            if (implementsOrExtends == null || implementsOrExtends.isEmpty()) continue;
            this.addInheritedTypes(classMap, initializer, implementsOrExtends);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

