/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.AbstractDelegatingX509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class DERCredential
extends AbstractDelegatingX509Credential {
    public DERCredential(InputStream privateKeyStream, InputStream certificateStream, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        X509Certificate[] chain = CertificateUtils.loadCertificateChain(certificateStream, CertificateUtils.Encoding.DER);
        PrivateKey pk = CertificateUtils.loadPrivateKey(privateKeyStream, CertificateUtils.Encoding.DER, keyPasswd);
        privateKeyStream.close();
        certificateStream.close();
        this.delegate = new KeyAndCertCredential(pk, chain);
    }

    public DERCredential(String keyPath, String certificatePath, char[] keyPasswd) throws IOException, KeyStoreException, CertificateException {
        this(new BufferedInputStream(new FileInputStream(new File(keyPath))), new BufferedInputStream(new FileInputStream(new File(certificatePath))), keyPasswd);
    }
}

