/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;

public class FixedV3TBSCertificateGenerator {
    DERTaggedObject version = new DERTaggedObject(0, (DEREncodable)new DERInteger(2));
    DERInteger serialNumber;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Time startDate;
    Time endDate;
    X500Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    X509Extensions extensions;
    private boolean altNamePresentAndCritical;
    private DERBitString issuerUniqueID;
    private DERBitString subjectUniqueID;

    public void setSerialNumber(DERInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSignature(AlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
    }

    public void setStartDate(DERUTCTime startDate) {
        this.startDate = new Time((DERObject)startDate);
    }

    public void setStartDate(Time startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(DERUTCTime endDate) {
        this.endDate = new Time((DERObject)endDate);
    }

    public void setEndDate(Time endDate) {
        this.endDate = endDate;
    }

    public void setSubject(X500Name subject) {
        this.subject = subject;
    }

    public void setIssuerUniqueID(DERBitString uniqueID) {
        this.issuerUniqueID = uniqueID;
    }

    public void setSubjectUniqueID(DERBitString uniqueID) {
        this.subjectUniqueID = uniqueID;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo pubKeyInfo) {
        this.subjectPublicKeyInfo = pubKeyInfo;
    }

    public void setExtensions(X509Extensions extensions) {
        X509Extension altName;
        this.extensions = extensions;
        if (extensions != null && (altName = extensions.getExtension(X509Extensions.SubjectAlternativeName)) != null && altName.isCritical()) {
            this.altNamePresentAndCritical = true;
        }
    }

    public DERSequence generateTBSCertificate() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.startDate == null || this.endDate == null || this.subject == null && !this.altNamePresentAndCritical || this.subjectPublicKeyInfo == null) {
            throw new IllegalStateException("not all mandatory fields set in V3 TBScertificate generator");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.version);
        v.add((DEREncodable)this.serialNumber);
        v.add((DEREncodable)this.signature);
        v.add((DEREncodable)this.issuer);
        ASN1EncodableVector validity = new ASN1EncodableVector();
        validity.add((DEREncodable)this.startDate);
        validity.add((DEREncodable)this.endDate);
        v.add((DEREncodable)new DERSequence(validity));
        if (this.subject != null) {
            v.add((DEREncodable)this.subject);
        } else {
            v.add((DEREncodable)new DERSequence());
        }
        v.add((DEREncodable)this.subjectPublicKeyInfo);
        if (this.issuerUniqueID != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.issuerUniqueID));
        }
        if (this.subjectUniqueID != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)this.subjectUniqueID));
        }
        if (this.extensions != null) {
            v.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)this.extensions));
        }
        return new DERSequence(v);
    }
}

