/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.pkipath.BCErrorMapper;
import eu.emi.security.authn.x509.helpers.pkipath.ExtPKIXParameters;
import eu.emi.security.authn.x509.helpers.pkipath.NonValidatingCertPathBuilder;
import eu.emi.security.authn.x509.helpers.pkipath.PKIXProxyCertificateChecker;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.ValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.FixedBCPKIXCertPathReviewer;
import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.ProxyHelper;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.i18n.ErrorBundle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.x509.CertPathReviewerException;
import org.bouncycastle.x509.PKIXCertPathReviewer;
import org.bouncycastle.x509.X509CertStoreSelector;

public class BCCertPathValidator {
    public static final long PROXY_VALIDATION_GRACE_PERIOD = 300000L;

    public ValidationResult validate(X509Certificate[] toCheck, boolean proxySupport, Set<TrustAnchor> trustAnchors, CertStore crlStore, RevocationParameters revocationParams, ObserversHandler observersHandler) throws CertificateException {
        int i;
        if (toCheck == null || toCheck.length == 0) {
            throw new IllegalArgumentException("Chain to be validated must be non-empty");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashSet<String> unresolvedExtensions = new HashSet<String>();
        if (!proxySupport || !ProxyUtils.isProxy(toCheck)) {
            ExtPKIXParameters params = this.createPKIXParameters(toCheck, proxySupport, trustAnchors, crlStore, revocationParams, observersHandler);
            List<X509Certificate> chain = this.checkNonProxyChain(toCheck, params, errors, unresolvedExtensions, 0, toCheck);
            return new ValidationResult(errors.size() == 0, errors, unresolvedExtensions, chain);
        }
        int split = this.getFirstProxy(toCheck);
        if (split == toCheck.length - 1) {
            errors.add(new ValidationError(toCheck, -1, ValidationErrorCode.proxyNoIssuer, new Object[0]));
            return new ValidationResult(false, errors, unresolvedExtensions, null);
        }
        X509Certificate[] baseChain = new X509Certificate[toCheck.length - split - 1];
        X509Certificate[] proxyChain = new X509Certificate[split + 2];
        for (i = split + 1; i < toCheck.length; ++i) {
            baseChain[i - split - 1] = toCheck[i];
        }
        for (i = 0; i < split + 2; ++i) {
            proxyChain[i] = toCheck[i];
        }
        ExtPKIXParameters params = this.createPKIXParameters(baseChain, proxySupport, trustAnchors, crlStore, revocationParams, observersHandler);
        List<X509Certificate> validatedChain = this.checkNonProxyChain(baseChain, params, errors, unresolvedExtensions, split + 1, toCheck);
        Set<TrustAnchor> trustForProxyChain = baseChain.length > 1 ? Collections.singleton(new TrustAnchor(baseChain[1], null)) : trustAnchors;
        this.checkProxyChainWithBC(proxyChain, trustForProxyChain, errors, unresolvedExtensions);
        this.checkProxyChainMain(proxyChain, errors, unresolvedExtensions, params.getDate());
        if (errors.size() == 0 && validatedChain != null) {
            for (int j = proxyChain.length - 2; j >= 0; --j) {
                validatedChain.add(0, proxyChain[j]);
            }
        }
        return new ValidationResult(errors.size() == 0, errors, unresolvedExtensions, validatedChain);
    }

    protected ExtPKIXParameters createPKIXParameters(X509Certificate[] toCheck, boolean proxySupport, Set<TrustAnchor> trustAnchors, CertStore crlStore, RevocationParameters revocationParams, ObserversHandler observersHandler) {
        CertStore certStore;
        ExtPKIXParameters params;
        X509CertStoreSelector endSelector = new X509CertStoreSelector();
        endSelector.setCertificate(toCheck[0]);
        try {
            params = new ExtPKIXParameters(trustAnchors, (Selector)endSelector, observersHandler);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("BUG, never should happen", e);
        }
        params.addCertStore(crlStore);
        try {
            certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(toCheck)), BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception e1) {
            throw new RuntimeException("Can't create an instance of a simple Collection certificate store, using the BC provider, BUG?", e1);
        }
        params.addCertStore(certStore);
        params.setRevocationParams(revocationParams);
        params.setProxySupport(proxySupport);
        params.setDate(new Date());
        return params;
    }

    protected int getFirstProxy(X509Certificate[] toCheck) {
        for (int j = toCheck.length - 1; j >= 0; --j) {
            if (!ProxyUtils.isProxy(toCheck[j])) continue;
            return j;
        }
        throw new RuntimeException("No proxy found, while it should be in chain?? BUG");
    }

    protected List<X509Certificate> checkNonProxyChain(X509Certificate[] baseChain, ExtPKIXParameters params, List<ValidationError> errors, Set<String> unresolvedExtensions, int posDelta, X509Certificate[] cc) throws CertificateException {
        List<CertPath> certPaths;
        NonValidatingCertPathBuilder builder = new NonValidatingCertPathBuilder();
        List<ValidationError> buildPathErrors = null;
        try {
            certPaths = builder.buildPath(params, baseChain[0], cc);
        }
        catch (ValidationErrorException e1) {
            buildPathErrors = e1.getErrors();
            certPaths = Collections.singletonList(CertificateHelpers.toCertPath(baseChain));
        }
        List<ValidationError> validationErrors = null;
        List[] rawErrors = null;
        for (int i = 0; i < certPaths.size(); ++i) {
            FixedBCPKIXCertPathReviewer baseReviewer;
            try {
                baseReviewer = new FixedBCPKIXCertPathReviewer(certPaths.get(i), params);
            }
            catch (CertPathReviewerException e) {
                throw new RuntimeException("Can't init PKIXCertPathReviewer, bug?", e);
            }
            if (buildPathErrors != null && baseReviewer.isValidCertPath()) {
                throw new RuntimeException("PKIXCertPAthReviewer validated while the path was not even build correctly. Build path error: " + buildPathErrors.get(0));
            }
            List<ValidationError> processedErrors = this.convertErrors(baseReviewer.getErrors(), false, posDelta, cc);
            if (processedErrors.size() == 0) {
                X509Certificate ta = baseReviewer.getTrustAnchor().getTrustedCert();
                if (ta == null) {
                    return null;
                }
                List<? extends Certificate> path = certPaths.get(i).getCertificates();
                ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>(path.size() + 1);
                for (int j = 0; j < path.size(); ++j) {
                    ret.add((X509Certificate)path.get(j));
                }
                ret.add(ta);
                return ret;
            }
            if (validationErrors != null && validationErrors.size() <= processedErrors.size()) continue;
            validationErrors = processedErrors;
            rawErrors = baseReviewer.getErrors();
        }
        if (validationErrors != null) {
            errors.addAll(validationErrors);
            if (rawErrors != null) {
                unresolvedExtensions.addAll(this.getUnresolvedExtensionons(rawErrors));
            }
        } else {
            throw new RuntimeException("PKIXCertPAthReviewer BUG: validationErrors is null, tested chain: " + CertificateUtils.format(baseChain, FormatMode.FULL));
        }
        return null;
    }

    protected void checkProxyChainWithBC(X509Certificate[] proxyChain, Set<TrustAnchor> trustAnchor, List<ValidationError> errors, Set<String> unresolvedExtensions) throws CertificateException {
        PKIXCertPathReviewer proxyReviewer;
        CertPath proxyCertPath = CertificateHelpers.toCertPath(proxyChain);
        try {
            PKIXParameters proxyParams = new PKIXParameters(trustAnchor);
            proxyParams.addCertPathChecker(new PKIXProxyCertificateChecker());
            proxyParams.setRevocationEnabled(false);
            proxyReviewer = new PKIXCertPathReviewer(proxyCertPath, proxyParams);
        }
        catch (InvalidAlgorithmParameterException e1) {
            throw new RuntimeException("Can't init PKIXParameters, bug?", e1);
        }
        catch (CertPathReviewerException e) {
            throw new RuntimeException("Can't init PKIXCertPathReviewer, bug?", e);
        }
        errors.addAll(this.convertErrors(proxyReviewer.getErrors(), true, 0, proxyChain));
        unresolvedExtensions.addAll(this.getUnresolvedExtensionons(proxyReviewer.getErrors()));
    }

    protected void checkProxyChainMain(X509Certificate[] proxyChain, List<ValidationError> errors, Set<String> unresolvedExtensions, Date validDate) throws CertificateException {
        int last;
        int remainingLen = Integer.MAX_VALUE;
        for (int i = last = proxyChain.length - 1; i > 0; --i) {
            try {
                this.checkPairWithProxy(proxyChain[i], proxyChain[i - 1], errors, i - 1, proxyChain, validDate);
                if (i == last || remainingLen == Integer.MIN_VALUE) continue;
                int lenRestriction = ProxyHelper.getProxyPathLimit(proxyChain[i]);
                if (lenRestriction < remainingLen) {
                    remainingLen = lenRestriction - 1;
                } else if (remainingLen != Integer.MAX_VALUE) {
                    --remainingLen;
                }
                if (remainingLen >= 0) continue;
                remainingLen = Integer.MIN_VALUE;
                errors.add(new ValidationError(proxyChain, i - 1, ValidationErrorCode.proxyLength, new Object[0]));
                continue;
            }
            catch (CertPathValidatorException e) {
                break;
            }
            catch (IOException e) {
                throw new CertificateException("Can't parse the proxy path limit information", e);
            }
        }
    }

    protected void checkPairWithProxy(X509Certificate issuerCert, X509Certificate proxyCert, List<ValidationError> errors, int position, X509Certificate[] proxyChain, Date validationTime) throws CertPathValidatorException, CertificateParsingException {
        boolean[] keyUsage;
        X500Principal issuerDN;
        if (!ProxyUtils.isProxy(proxyCert)) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxyEECInChain, new Object[0]));
            throw new CertPathValidatorException();
        }
        if (proxyCert.getBasicConstraints() >= 0) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxyCASet, new Object[0]));
        }
        if (proxyCert.getIssuerAlternativeNames() != null) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxyIssuerAltNameSet, new Object[0]));
        }
        if (proxyCert.getSubjectAlternativeNames() != null) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxySubjectAltNameSet, new Object[0]));
        }
        if (issuerCert.getBasicConstraints() >= 0) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxyIssuedByCa, new Object[0]));
        }
        if ("".equals((issuerDN = issuerCert.getSubjectX500Principal()).getName())) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxyNoIssuerSubject, new Object[0]));
            throw new CertPathValidatorException();
        }
        if (!X500NameUtils.rfc3280Equal(issuerDN, proxyCert.getIssuerX500Principal())) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxySubjectInconsistent, new Object[0]));
        }
        if ((keyUsage = issuerCert.getKeyUsage()) != null && !keyUsage[0]) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxyIssuerNoDsig, new Object[0]));
        }
        this.checkLastCNNameRule(proxyCert.getSubjectX500Principal(), issuerDN, errors, position, proxyChain);
        this.checkProxyTime(proxyCert, validationTime, proxyChain, errors, position);
        if (position + 2 != proxyChain.length) {
            ExtendedProxyType proxyType;
            ExtendedProxyType issuerType = ProxyHelper.getProxyType(issuerCert);
            if (issuerType != (proxyType = ProxyHelper.getProxyType(proxyCert))) {
                errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxyTypeInconsistent, new Object[0]));
            }
            try {
                if (ProxyHelper.isLimited(issuerCert) && !ProxyHelper.isLimited(proxyCert)) {
                    errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.proxyInconsistentlyLimited, new Object[0]));
                }
            }
            catch (IOException e) {
                throw new CertificateParsingException("Can't establish whether the proxy is limited", e);
            }
        }
    }

    protected void checkProxyTime(X509Certificate proxyCert, Date validationTime, X509Certificate[] proxyChain, List<ValidationError> errors, int position) {
        if (validationTime.getTime() > proxyCert.getNotAfter().getTime() + 300000L) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.certificateExpired, proxyCert.getNotAfter()));
        }
        if (validationTime.getTime() < proxyCert.getNotBefore().getTime() - 300000L) {
            errors.add(new ValidationError(proxyChain, position, ValidationErrorCode.certificateNotYetValid, proxyCert.getNotBefore()));
        }
    }

    protected void checkLastCNNameRule(X500Principal srcP, X500Principal issuerP, List<ValidationError> errors, int position, X509Certificate[] proxyChain) throws CertPathValidatorException {
        X500Name src = CertificateHelpers.toX500Name(srcP);
        X500Name issuer = CertificateHelpers.toX500Name(issuerP);
        RDN[] srcRDNs = src.getRDNs();
        if (srcRDNs.length < 2) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxySubjectOneRDN, new Object[0]));
            throw new CertPathValidatorException();
        }
        if (srcRDNs[srcRDNs.length - 1].isMultiValued()) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxySubjectMultiLastRDN, new Object[0]));
            throw new CertPathValidatorException();
        }
        AttributeTypeAndValue lastAVA = srcRDNs[srcRDNs.length - 1].getFirst();
        if (!lastAVA.getType().equals((Object)BCStyle.CN)) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxySubjectLastRDNNotCN, new Object[0]));
            throw new CertPathValidatorException();
        }
        JavaAndBCStyle style = new JavaAndBCStyle();
        RDN[] finalRDNs = Arrays.copyOf(srcRDNs, srcRDNs.length - 1);
        X500Name truncatedName = new X500Name((X500NameStyle)style, finalRDNs);
        if (!style.areEqual(issuer, truncatedName)) {
            errors.add(new ValidationError(proxyChain, position + 1, ValidationErrorCode.proxySubjectBaseWrong, new Object[0]));
        }
    }

    protected List<ValidationError> convertErrors(List<?>[] bcErrorsA, boolean ignoreProxyErrors, int positionDelta, X509Certificate[] cc) {
        ArrayList<ValidationError> ret = new ArrayList<ValidationError>();
        for (int i = 0; i < bcErrorsA.length; ++i) {
            List<?> bcErrors = bcErrorsA[i];
            for (Object bcError : bcErrors) {
                Object id;
                Object error;
                if (bcError instanceof ErrorBundle) {
                    error = (ErrorBundle)bcError;
                    if (ignoreProxyErrors && (((String)(id = error.getId())).equals("CertPathReviewer.noBasicConstraints") || ((String)id).equals("CertPathReviewer.noCACert") || ((String)id).equals("CertPathReviewer.noCertSign") || ((String)id).equals("CertPathReviewer.certificateNotYetValid") || ((String)id).equals("CertPathReviewer.certificateExpired"))) continue;
                    ret.add(BCErrorMapper.map((ErrorBundle)error, i - 1 + positionDelta, cc));
                    continue;
                }
                error = (SimpleValidationErrorException)bcError;
                if (ignoreProxyErrors && (((Enum)(id = ((SimpleValidationErrorException)error).getCode())).equals((Object)ValidationErrorCode.noBasicConstraints) || ((Enum)id).equals((Object)ValidationErrorCode.noCACert) || ((Enum)id).equals((Object)ValidationErrorCode.noCertSign) || ((Enum)id).equals((Object)ValidationErrorCode.certificateExpired) || ((Enum)id).equals((Object)ValidationErrorCode.certificateNotYetValid))) continue;
                ret.add(new ValidationError(cc, i - 1 + positionDelta, ((SimpleValidationErrorException)error).getCode(), ((SimpleValidationErrorException)error).getArguments()));
            }
        }
        return ret;
    }

    protected Set<String> getUnresolvedExtensionons(List<?>[] bcErrorsA) {
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < bcErrorsA.length; ++i) {
            List<?> bcErrors = bcErrorsA[i];
            for (Object bcError : bcErrors) {
                DERObjectIdentifier extId;
                Object error;
                if (bcError instanceof ErrorBundle) {
                    error = (ErrorBundle)bcError;
                    if (!error.getId().equals("CertPathReviewer.unknownCriticalExt")) continue;
                    extId = (DERObjectIdentifier)error.getArguments()[0];
                    ret.add(extId.getId());
                    continue;
                }
                error = (SimpleValidationErrorException)bcError;
                if (!((SimpleValidationErrorException)error).getCode().equals((Object)ValidationErrorCode.unknownCriticalExt)) continue;
                extId = (DERObjectIdentifier)((SimpleValidationErrorException)error).getArguments()[0];
                ret.add(extId.getId());
            }
        }
        return ret;
    }
}

