/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.encoding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.encoder.BaseMessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSAML1MessageEncoder
extends BaseMessageEncoder
implements SAMLMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAML1MessageEncoder.class);
    private List<String> allowedURLSchemes;

    public BaseSAML1MessageEncoder() {
        this.setAllowedURLSchemes(new String[]{"http", "https"});
    }

    public List<String> getAllowedURLSchemes() {
        return this.allowedURLSchemes;
    }

    public void setAllowedURLSchemes(String[] schemes) {
        if (schemes == null || schemes.length == 0) {
            this.allowedURLSchemes = Collections.emptyList();
        } else {
            ArrayList<String> temp = new ArrayList<String>();
            for (String scheme : schemes) {
                temp.add(scheme);
            }
            this.allowedURLSchemes = Collections.unmodifiableList(temp);
        }
    }

    protected URLBuilder getEndpointURL(SAMLMessageContext messageContext) throws MessageEncodingException {
        URLBuilder urlBuilder;
        Endpoint endpoint = messageContext.getPeerEntityEndpoint();
        if (endpoint == null) {
            throw new MessageEncodingException("Endpoint for relying party was null.");
        }
        if (messageContext.getOutboundMessage() instanceof Response && !DatatypeHelper.isEmpty((String)endpoint.getResponseLocation())) {
            urlBuilder = new URLBuilder(endpoint.getResponseLocation());
        } else {
            if (DatatypeHelper.isEmpty((String)endpoint.getLocation())) {
                throw new MessageEncodingException("Relying party endpoint location was null or empty.");
            }
            urlBuilder = new URLBuilder(endpoint.getLocation());
        }
        if (!this.getAllowedURLSchemes().contains(urlBuilder.getScheme())) {
            throw new MessageEncodingException("Relying party endpoint used the untrusted URL scheme " + urlBuilder.getScheme());
        }
        return urlBuilder;
    }

    protected void signMessage(SAMLMessageContext messageContext) throws MessageEncodingException {
        Object outboundMessage = messageContext.getOutboundSAMLMessage();
        if (outboundMessage instanceof SignableSAMLObject && messageContext.getOuboundSAMLMessageSigningCredential() != null) {
            this.log.debug("Signing outbound SAML message.");
            SignableSAMLObject signableMessage = (SignableSAMLObject)outboundMessage;
            Credential signingCredential = messageContext.getOuboundSAMLMessageSigningCredential();
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential(signingCredential);
            try {
                SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
            }
            catch (SecurityException e) {
                throw new MessageEncodingException("Error preparing signature for signing", (Exception)((Object)e));
            }
            signableMessage.setSignature(signature);
            try {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                marshaller.marshall((XMLObject)signableMessage);
                Signer.signObject((Signature)signature);
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall protocol message in preparation for signing", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall protocol message in preparation for signing", (Exception)((Object)e));
            }
            catch (SignatureException e) {
                this.log.error("Unable to sign protocol message", (Throwable)e);
                throw new MessageEncodingException("Unable to sign protocol message", (Exception)((Object)e));
            }
        }
    }
}

