/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.preparers.user;

import java.util.Collections;
import java.util.List;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.PreparerException;
import org.apache.tiles.preparer.ViewPreparer;
import org.glite.security.voms.admin.error.VOMSAuthorizationException;
import org.glite.security.voms.admin.operations.groups.ListGroupsOperation;
import org.glite.security.voms.admin.operations.roles.ListRolesOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUsersPreparer
implements ViewPreparer {
    private static Logger log = LoggerFactory.getLogger(ListUsersPreparer.class);

    public void execute(TilesRequestContext context, AttributeContext attributeContext) throws PreparerException {
        List roles;
        List groups;
        try {
            groups = (List)ListGroupsOperation.instance().execute();
            roles = (List)ListRolesOperation.instance().execute();
        }
        catch (VOMSAuthorizationException e) {
            log.warn(e.getMessage());
            if (log.isDebugEnabled()) {
                log.warn(e.getMessage(), (Throwable)e);
            }
            groups = Collections.EMPTY_LIST;
            roles = Collections.EMPTY_LIST;
        }
        context.getRequestScope().put("voGroups", groups);
        context.getRequestScope().put("voRoles", roles);
    }
}

