/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import java.util.List;
import java.util.Map;
import org.apache.struts2.interceptor.SessionAware;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.CertificateRequest;
import org.glite.security.voms.admin.persistence.model.request.GroupMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.MembershipRemovalRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.persistence.model.request.RoleMembershipRequest;
import org.glite.security.voms.admin.view.actions.BaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserActionSupport
extends BaseAction
implements ModelDriven<VOMSUser>,
Preparable,
SessionAware {
    public static final Logger log = LoggerFactory.getLogger(UserActionSupport.class);
    private static final long serialVersionUID = 1L;
    public static String LOAD_THIS_USER_KEY = "loadUserId";
    Long userId = -1L;
    VOMSUser model;
    protected List<Request> requests;
    protected List<GroupMembershipRequest> pendingGroupMembershipRequests;
    protected List<RoleMembershipRequest> pendingRoleMembershipRequests;
    protected List<CertificateRequest> pendingCertificateRequests;
    protected List<MembershipRemovalRequest> pendingMembershipRemovalRequests;
    protected Map<String, Object> theSession;

    public VOMSUser getModel() {
        return this.model;
    }

    public void prepare() throws Exception {
        if (this.getModel() == null) {
            if (this.getUserId() != -1L) {
                this.model = this.userById(this.getUserId());
            } else {
                Long loadThisUserKey = (Long)this.theSession.get(LOAD_THIS_USER_KEY);
                if (loadThisUserKey != null) {
                    this.model = this.userById(loadThisUserKey);
                    this.theSession.remove(LOAD_THIS_USER_KEY);
                }
            }
        }
        if (this.getModel() != null) {
            this.refreshPendingRequests();
        }
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<GroupMembershipRequest> getPendingGroupMembershipRequests() {
        return this.pendingGroupMembershipRequests;
    }

    public List<RoleMembershipRequest> getPendingRoleMembershipRequests() {
        return this.pendingRoleMembershipRequests;
    }

    public List<CertificateRequest> getPendingCertificateRequests() {
        return this.pendingCertificateRequests;
    }

    public List<MembershipRemovalRequest> getPendingMembershipRemovalRequests() {
        return this.pendingMembershipRemovalRequests;
    }

    protected void refreshPendingRequests() {
        RequestDAO rDAO = DAOFactory.instance().getRequestDAO();
        this.requests = rDAO.findRequestsFromUser(this.model);
        this.pendingGroupMembershipRequests = rDAO.findPendingUserGroupMembershipRequests(this.model);
        this.pendingRoleMembershipRequests = rDAO.findPendingUserRoleMembershipRequests(this.model);
        this.pendingCertificateRequests = rDAO.findPendingUserCertificateRequests(this.model);
        this.pendingMembershipRemovalRequests = rDAO.findPendingUserMembershipRemovalRequests(this.model);
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public List<Request> getRequests() {
        return this.requests;
    }

    public void setSession(Map<String, Object> session) {
        log.debug("Setting session: " + session);
        this.theSession = session;
    }

    public boolean hasValidAUPAcceptanceRecord() {
        AUP aup = DAOFactory.instance().getAUPDAO().getVOAUP();
        return this.getModel().getAUPAccceptanceRecord(aup.getActiveVersion()).getValid() == true;
    }
}

