/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.users.SuspendUserCertificateOperation;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.user.CertificateActionSupport;

@Results(value={@Result(name="success", location="certificates.jsp"), @Result(name="input", location="certificates.jsp"), @Result(name="invalid.token", location="certificates.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class SuspendCertificateAction
extends CertificateActionSupport {
    private static final long serialVersionUID = 1L;
    String suspensionReason;

    public String execute() throws Exception {
        VOMSUser.SuspensionReason r = VOMSUser.SuspensionReason.OTHER;
        r.setMessage(this.suspensionReason);
        SuspendUserCertificateOperation.instance(this.getModel(), this.certificate, r).execute();
        return "success";
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters in the suspension reason field!")
    public String getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(String suspensionReason) {
        this.suspensionReason = suspensionReason;
    }

    public void validate() {
        if (!this.getFieldErrors().isEmpty()) {
            this.addActionError("You entered invalid characters in the suspension reason field!");
        }
    }
}

