/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.users.SaveUserPersonalInfoOperation;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="personalInfo.jsp"), @Result(name="input", location="personalInfo.jsp"), @Result(name="invalid.token", location="personalInfo.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class SavePersonalInformationAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    String theName;
    String theSurname;
    String theInstitution;
    String theAddress;
    String thePhoneNumber;
    String theEmailAddress;

    public String execute() throws Exception {
        Boolean roPI = VOMSConfiguration.instance().getBoolean("___voms.read-only-personal-information", Boolean.FALSE);
        if (roPI != null && roPI.booleanValue()) {
            this.addActionError("Personal informations are read only in this VOMS instance!");
            return "input";
        }
        SaveUserPersonalInfoOperation op = new SaveUserPersonalInfoOperation(this.getModel(), this.theName, this.theSurname, this.theInstitution, this.theAddress, this.thePhoneNumber, this.theEmailAddress);
        op.setAuthorizedUser(this.getModel());
        op.execute();
        this.addActionMessage("Personal information updated.");
        return "success";
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The name field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheName() {
        return this.theName;
    }

    public void setTheName(String theName) {
        this.theName = theName;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The surname field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheSurname() {
        return this.theSurname;
    }

    public void setTheSurname(String theSurname) {
        this.theSurname = theSurname;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The institution field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheInstitution() {
        return this.theInstitution;
    }

    public void setTheInstitution(String theInstitution) {
        this.theInstitution = theInstitution;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The address field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheAddress() {
        return this.theAddress;
    }

    public void setTheAddress(String theAddress) {
        this.theAddress = theAddress;
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, message="The phoneNumber field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getThePhoneNumber() {
        return this.thePhoneNumber;
    }

    public void setThePhoneNumber(String thePhoneNumber) {
        this.thePhoneNumber = thePhoneNumber;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter an email address.")
    @EmailValidator(type=ValidatorType.FIELD, message="Please enter a valid email address.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The email field name contains illegal characters!", expression="^[^<>&=;]*$")
    public String getTheEmailAddress() {
        return this.theEmailAddress;
    }

    public void setTheEmailAddress(String theEmailAddress) {
        this.theEmailAddress = theEmailAddress;
    }
}

