/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.MembershipRemovalSubmittedEvent;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.MembershipRemovalRequest;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="userHome"), @Result(name="input", location="requestMembershipRemoval"), @Result(name="registrationDisabled", location="userHome")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class RequestMembershipRemovalAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    String reason;

    public void validate() {
        RequestDAO reqDAO;
        VOMSUser u = CurrentAdmin.instance().getVoUser();
        if (!this.getModel().equals(u)) {
            this.addActionError("You cannot submit a membership removal request for another user!");
        }
        if ((reqDAO = DAOFactory.instance().getRequestDAO()).userHasPendingMembershipRemovalRequest(this.getModel())) {
            this.addActionError("User has pending membership removal requests!");
        }
    }

    public String execute() throws Exception {
        if (!VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true)) {
            return "registrationDisabled";
        }
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        MembershipRemovalRequest req = reqDAO.createMembershipRemovalRequest(this.getModel(), this.reason, this.getDefaultFutureDate());
        EventManager.dispatch(new MembershipRemovalSubmittedEvent(req, this.getHomeURL()));
        this.refreshPendingRequests();
        return "success";
    }

    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters in the reason field!")
    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter a reason.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}

