/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.user;

import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.GroupMembershipSubmittedEvent;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.request.GroupMembershipRequest;
import org.glite.security.voms.admin.view.actions.user.UserActionSupport;

@Results(value={@Result(name="success", location="mappingsRequest.jsp"), @Result(name="error", location="mappingsRequest.jsp"), @Result(name="input", location="mappingsRequest.jsp")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class RequestGroupMembershipAction
extends UserActionSupport {
    private static final long serialVersionUID = 1L;
    Long groupId;

    public void validate() {
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        VOMSGroup g = this.groupById(this.groupId);
        if (g == null) {
            throw new NoSuchGroupException("Group with id '" + this.groupId + "' not found!");
        }
        if (this.model.isMember(g)) {
            this.addActionError(this.getText("group_request.user.already_member", new String[]{this.model.toString(), g.getName()}));
        }
        if (reqDAO.userHasPendingGroupMembershipRequest(this.model, g)) {
            this.addActionError(this.getText("group_request.user.has_pending_request", new String[]{this.model.toString(), g.getName()}));
        }
    }

    public String execute() throws Exception {
        if (!VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true)) {
            return "registrationDisabled";
        }
        if (this.hasActionErrors()) {
            return "error";
        }
        RequestDAO reqDAO = DAOFactory.instance().getRequestDAO();
        VOMSGroup g = this.groupById(this.groupId);
        GroupMembershipRequest req = reqDAO.createGroupMembershipRequest(this.getModel(), g, this.getDefaultFutureDate());
        EventManager.dispatch(new GroupMembershipSubmittedEvent(req, this.getHomeURL()));
        this.refreshPendingRequests();
        return "success";
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }
}

