/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register.orgdb;

import java.util.Map;
import org.apache.struts2.interceptor.SessionAware;
import org.glite.security.voms.admin.error.IllegalStateException;
import org.glite.security.voms.admin.integration.PluginConfigurator;
import org.glite.security.voms.admin.integration.PluginManager;
import org.glite.security.voms.admin.integration.orgdb.OrgDBConfigurator;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBDAOFactory;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.glite.security.voms.admin.view.actions.register.RegisterActionSupport;

public class OrgDbRegisterActionSupport
extends RegisterActionSupport
implements SessionAware {
    private static final long serialVersionUID = 1L;
    public static final String ORGDB_RECORD_SESSION_KEY = "___voms.user-orgdb-record";
    Long vomsPersonId;
    Map<String, Object> session;

    protected void populateRequesterFromOrgdb() {
        if (this.requester == null) {
            this.requester = this.requesterInfoFromCurrentAdmin();
        }
        if (this.session == null) {
            throw new IllegalStateException("Session is null for this user!");
        }
        VOMSOrgDBPerson orgDbPerson = (VOMSOrgDBPerson)this.session.get(ORGDB_RECORD_SESSION_KEY);
        if (orgDbPerson == null) {
            if (this.vomsPersonId == null) {
                throw new IllegalArgumentException("No id provided for the VOMS person orgdb record and no record found in session!");
            }
            orgDbPerson = (VOMSOrgDBPerson)OrgDBDAOFactory.instance().getVOMSPersonDAO().findById(this.vomsPersonId, false);
            if (orgDbPerson == null) {
                throw new IllegalArgumentException("No orgb record found for id '" + this.vomsPersonId + "'.");
            }
            this.session.put(ORGDB_RECORD_SESSION_KEY, orgDbPerson);
        }
        PluginConfigurator configuredPlugin = PluginManager.instance().getConfiguredPlugin(OrgDBConfigurator.class.getName());
        String experimentName = configuredPlugin.getPluginProperty("experimentName");
        this.requester.setName(orgDbPerson.getFirstName());
        this.requester.setSurname(orgDbPerson.getName());
        this.requester.setEmailAddress(orgDbPerson.getPhysicalEmail());
        this.requester.setInstitution(orgDbPerson.getValidParticipationForExperiment(experimentName).getInstitute().getOriginalName());
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.populateRequesterFromOrgdb();
    }

    public Long getVomsPersonId() {
        return this.vomsPersonId;
    }

    public void setVomsPersonId(Long vomsPersonId) {
        this.vomsPersonId = vomsPersonId;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }
}

