/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register;

import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.Date;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.validation.RequestValidationResult;
import org.glite.security.voms.admin.core.validation.ValidationManager;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestSubmittedEvent;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.view.actions.register.RegisterActionSupport;

@Results(value={@Result(name="input", location="register"), @Result(name="success", location="registerConfirmation"), @Result(name="needToConfirm", location="registerConfirmation"), @Result(name="registrationDisabled", location="registrationDisabled"), @Result(name="pluginValidationError", location="pluginValidationError")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class SubmitRequestAction
extends RegisterActionSupport {
    private static final long serialVersionUID = 1L;
    public static final String SIGNED_AUP_VERSION_KEY = "signedAUPVersion";
    String name;
    String surname;
    String institution;
    String address;
    String phoneNumber;
    String emailAddress;
    String aupAccepted;
    RequestValidationResult validationResult;

    protected void populateRequestModel() {
        long requestLifetime = VOMSConfiguration.instance().getLong("voms.request.vo_membership.lifetime", 300L);
        Date expirationDate = this.getFutureDate(new Date(), 13, (int)requestLifetime);
        this.requester.setName(this.name);
        this.requester.setSurname(this.surname);
        this.requester.setInstitution(this.institution);
        this.requester.setAddress(this.address);
        this.requester.setPhoneNumber(this.phoneNumber);
        this.requester.setEmailAddress(this.emailAddress);
        this.requester.addInfo(SIGNED_AUP_VERSION_KEY, this.currentAUPVersion.getVersion());
        this.request = DAOFactory.instance().getRequestDAO().createVOMembershipRequest(this.requester, expirationDate);
    }

    public String execute() throws Exception {
        if (!this.registrationEnabled()) {
            return "registrationDisabled";
        }
        String result = this.checkExistingPendingRequests();
        if (result != null) {
            return result;
        }
        this.populateRequestModel();
        this.validationResult = ValidationManager.instance().validateRequest(this.request);
        if (!this.validationResult.getOutcome().equals((Object)RequestValidationResult.Outcome.SUCCESS)) {
            DAOFactory.instance().getRequestDAO().makeTransient(this.request);
            this.addActionError(this.validationResult.getMessage());
            return "pluginValidationError";
        }
        EventManager.dispatch(new VOMembershipRequestSubmittedEvent(this.request, this.buildConfirmURL(), this.buildCancelURL()));
        return "success";
    }

    private String buildCancelURL() {
        return this.getBaseURL() + "/register/cancel-request.action?requestId=" + this.getModel().getId() + "&confirmationId=" + this.getModel().getConfirmId();
    }

    private String buildConfirmURL() {
        return this.getBaseURL() + "/register/confirm-request.action?requestId=" + this.getModel().getId() + "&confirmationId=" + this.getModel().getConfirmId();
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your name.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your surname.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters.")
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your institution.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters.")
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your address.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your phone number.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^[^<>&=;]*$", message="You entered invalid characters.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="You must sign the AUP.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="^true$", message="You must accept the terms of the AUP to proceed")
    public String getAupAccepted() {
        return this.aupAccepted;
    }

    public void setAupAccepted(String aupAccepted) {
        this.aupAccepted = aupAccepted;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please enter your email address.")
    @EmailValidator(type=ValidatorType.FIELD, message="Please enter a valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public RequestValidationResult getValidationResult() {
        return this.validationResult;
    }
}

