/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.List;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestConfirmedEvent;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.view.actions.register.RegisterActionSupport;

@Results(value={@Result(name="input", location="requestAttributes"), @Result(name="success", location="registrationConfirmed"), @Result(name="error", location="registrationConfirmationError")})
public class RequestAttributesAction
extends RegisterActionSupport {
    private static final long serialVersionUID = 1L;
    String confirmationId;
    List<String> requestedGroups;

    public String execute() throws Exception {
        if (!this.registrationEnabled()) {
            return "registrationDisabled";
        }
        if (!this.getModel().getStatus().equals((Object)Request.STATUS.SUBMITTED)) {
            this.addActionError("Your request has already been confirmed!");
            return "error";
        }
        if (!this.getModel().getConfirmId().equals(this.confirmationId)) {
            this.addActionError("Wrong confirmation id!");
            return "error";
        }
        this.request.setStatus(Request.STATUS.CONFIRMED);
        String manageURL = this.getBaseURL() + "/home/login.action";
        if (this.requestedGroups != null && !this.requestedGroups.isEmpty()) {
            Integer requestedGroupsSize = this.requestedGroups.size();
            this.getModel().getRequesterInfo().addInfo("num_requestedGroup", requestedGroupsSize.toString());
            for (int i = 0; i < requestedGroupsSize; ++i) {
                this.getModel().getRequesterInfo().addInfo("requestedGroup" + i, this.requestedGroups.get(i));
            }
        }
        EventManager.dispatch(new VOMembershipRequestConfirmedEvent(this.request, manageURL));
        return "success";
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="A confirmation id is required!")
    public String getConfirmationId() {
        return this.confirmationId;
    }

    public void setConfirmationId(String confirmationId) {
        this.confirmationId = confirmationId;
    }

    public List<String> getRequestedGroups() {
        return this.requestedGroups;
    }

    public void setRequestedGroups(List<String> requestedGroups) {
        this.requestedGroups = requestedGroups;
    }
}

