/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.register;

import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.view.actions.register.RegisterActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Results(value={@Result(name="success", location="registrationCancelled"), @Result(name="error", location="registrationConfirmationError")})
public class CancelRequestAction
extends RegisterActionSupport {
    private static final long serialVersionUID = 1L;
    public static final Logger log = LoggerFactory.getLogger(CancelRequestAction.class);
    String confirmationId;

    public String execute() throws Exception {
        if (!this.registrationEnabled()) {
            return "registrationDisabled";
        }
        if (!this.request.getStatus().equals((Object)Request.STATUS.SUBMITTED)) {
            this.addActionError("Your request cannot be canceled at this stage!");
            return "error";
        }
        if (this.request.getConfirmId().equals(this.confirmationId)) {
            RequestDAO rDAO = DAOFactory.instance().getRequestDAO();
            log.info("Removing request '" + this.request + "' on user's request.");
            rDAO.makeTransient(this.request);
            return "success";
        }
        this.addActionError("Wrong confirmation id!");
        return "error";
    }

    public String getConfirmationId() {
        return this.confirmationId;
    }

    public void setConfirmationId(String confirmationId) {
        this.confirmationId = confirmationId;
    }
}

