/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.aup;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.aup.SaveVersionOperation;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.util.URLContentFetcher;
import org.glite.security.voms.admin.view.actions.aup.AUPVersionActions;

@Results(value={@Result(name="input", location="editAupVersion"), @Result(name="success", location="/aup/load.action", type="redirect")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class EditVersionAction
extends AUPVersionActions {
    private static final long serialVersionUID = 1L;
    String url;

    @Override
    public void prepare() throws Exception {
        if (this.aup == null) {
            AUPDAO dao = DAOFactory.instance().getAUPDAO();
            this.aup = (AUP)dao.findById(this.aupId, false);
        }
        if (this.version != null) {
            this.url = this.aup.getVersion(this.version).getUrl();
        }
    }

    public void validate() {
        String newAUPcontent = URLContentFetcher.fetchTextFromURL(this.url);
        if (newAUPcontent == null) {
            this.addFieldError("url", "Error fetching the content of the specified URL! Please provide a valid URL pointing to a text file!");
        }
    }

    public String execute() throws Exception {
        AUPVersion aupVersion = this.aup.getVersion(this.version);
        SaveVersionOperation op = new SaveVersionOperation(aupVersion, this.getUrl());
        op.execute();
        return "success";
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="The url field is required!")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The version field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

