/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.aup;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.validator.annotations.IntRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.aup.ChangeReacceptancePeriodOperation;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.view.actions.BaseAction;

@Results(value={@Result(name="input", location="aups"), @Result(name="success", location="/aup/load.action", type="redirect")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class ChangeReacceptancePeriodAction
extends BaseAction
implements Preparable,
ModelDriven<AUP> {
    private static final long serialVersionUID = 1L;
    Long aupId;
    int period;
    AUP aup;

    public String execute() throws Exception {
        ChangeReacceptancePeriodOperation op = new ChangeReacceptancePeriodOperation(this.aup, this.period);
        op.execute();
        return "success";
    }

    public Long getAupId() {
        return this.aupId;
    }

    public void setAupId(Long aupId) {
        this.aupId = aupId;
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="The period (in days) is required.")
    @RegexFieldValidator(type=ValidatorType.FIELD, expression="[0-9]+", message="Please specify a positive integer number.")
    @IntRangeFieldValidator(type=ValidatorType.FIELD, min="1", max="730", message="The input is out of the acceptable range (1 < x < 730)")
    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void prepare() throws Exception {
        if (this.aup == null) {
            AUPDAO dao = DAOFactory.instance().getAUPDAO();
            this.aup = (AUP)dao.findById(this.getAupId(), true);
        }
    }

    public AUP getModel() {
        return this.aup;
    }
}

