/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.aup;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.aup.AddVersionOperation;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.view.actions.aup.AUPVersionActions;

@Results(value={@Result(name="input", location="addAupVersion"), @Result(name="success", location="/aup/load.action", type="redirect")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class AddVersionAction
extends AUPVersionActions {
    private static final long serialVersionUID = 1L;
    String url;

    public void validate() {
        for (AUPVersion existingVersion : this.getModel().getVersions()) {
            if (!existingVersion.getVersion().equals(this.getVersion())) continue;
            this.addFieldError("version", "Version '" + this.getVersion() + "' already exists for this aup!");
        }
        AUPVersion candidateVersion = new AUPVersion();
        candidateVersion.setUrl(this.url);
        if (candidateVersion.getURLContent() == null) {
            this.addFieldError("url", "Error fetching the content of the specified URL! Please provide a valid URL pointing to a text file!");
        }
    }

    public String execute() throws Exception {
        AddVersionOperation op = new AddVersionOperation(this.getModel(), this.getVersion(), this.url);
        op.execute();
        return "success";
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="The url field is required!")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The version field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

