/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.apiv2;

import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.Collection;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.json.annotations.JSON;
import org.glite.security.voms.admin.operations.users.SuspendUserOperation;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.apiv2.RestUserAction;

@ParentPackage(value="json")
@Results(value={@Result(name="success", type="json")})
public class SuspendUserAction
extends RestUserAction {
    private static final long serialVersionUID = 1L;
    String suspensionReason;

    public String execute() throws Exception {
        VOMSUser.SuspensionReason r = VOMSUser.SuspensionReason.OTHER;
        r.setMessage(this.getSuspensionReason());
        SuspendUserOperation.instance(this.getModel(), r).execute();
        this.addActionMessage(String.format("User %s is now suspended", this.getModel().getShortName()));
        return "success";
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a reason for the suspension.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The reason contains illegal characters!", expression="^[^<>&;]*$")
    public String getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(String suspensionReason) {
        this.suspensionReason = suspensionReason;
    }

    @JSON(serialize=true)
    public Collection<String> getActionMessages() {
        return super.getActionMessages();
    }
}

