/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.apiv2;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.json.annotations.JSON;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.BaseAction;

@ParentPackage(value="json")
@Results(value={@Result(name="success", type="json")})
public class RestUserAction
extends BaseAction
implements Preparable,
ModelDriven<VOMSUser> {
    private static final long serialVersionUID = 1L;
    VOMSUser user;
    Long userId;
    String certificateSubject;
    String caSubject;

    public VOMSUser getModel() {
        return this.user;
    }

    public void prepare() throws Exception {
        if (this.getModel() == null) {
            if (this.certificateSubject == null || this.caSubject == null) {
                return;
            }
            this.user = VOMSUserDAO.instance().findByCertificate(this.certificateSubject, this.caSubject);
        }
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a DN for the user.")
    public String getCertificateSubject() {
        return this.certificateSubject;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a CA for the user.")
    public String getCaSubject() {
        return this.caSubject;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setCertificateSubject(String certificateSubject) {
        this.certificateSubject = certificateSubject;
    }

    public void setCaSubject(String caSubject) {
        this.caSubject = caSubject;
    }

    @JSON(serialize=false)
    public Long getUserId() {
        return this.userId;
    }
}

