/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.acl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.acls.SaveACLEntryOperation;
import org.glite.security.voms.admin.view.actions.acl.ACLActionSupport;

@Results(value={@Result(name="success", location="manage", type="chain"), @Result(name="input", location="editACLEntry")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class EditEntryAction
extends ACLActionSupport {
    private static final long serialVersionUID = 1L;
    List<String> selectedPermissions;
    VOMSPermission permission;

    public String execute() throws Exception {
        String permString = this.selectedPermissions == null ? "NONE" : (this.selectedPermissions.contains("ALL") ? "ALL" : StringUtils.join(this.selectedPermissions, (String)"|"));
        VOMSPermission perm = VOMSPermission.fromString(permString);
        this.limitUnauthenticatedClientPermissions(perm);
        SaveACLEntryOperation op = SaveACLEntryOperation.instance(this.getModel(), this.admin, perm, this.propagate);
        op.execute();
        return "success";
    }

    public void prepareInput() throws Exception {
        this.prepare();
        if (this.permission == null) {
            this.permission = this.getModel().getPermissions(this.getAdmin());
        }
    }

    public VOMSPermission getPermission() {
        return this.permission;
    }

    public void setPermission(VOMSPermission permission) {
        this.permission = permission;
    }

    public List<String> getSelectedPermissions() {
        return this.selectedPermissions;
    }

    public void setSelectedPermissions(List<String> selectedPermissions) {
        this.selectedPermissions = selectedPermissions;
    }
}

