/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.view.actions.acl;

import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.acls.SaveACLEntryOperation;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSCADAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.view.actions.acl.ACLActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Results(value={@Result(name="success", location="manage", type="chain"), @Result(name="input", location="addACLEntry")})
@InterceptorRef(value="authenticatedStack", params={"token.includeMethods", "execute"})
public class AddEntryAction
extends ACLActionSupport {
    public static final Logger log = LoggerFactory.getLogger(AddEntryAction.class);
    private static final long serialVersionUID = 1L;
    String entryType;
    List<String> selectedPermissions;
    VOMSPermission permission;
    Long userId;
    String dn;
    Short caId;
    String emailAddress;
    Long roleId;
    Long roleGroupId;
    Long groupId;
    Map<String, String> entryTypeMap;

    public void validate() {
        if (this.selectedPermissions == null) {
            this.addActionError("No permissions selected!");
        } else if (this.selectedPermissions.isEmpty()) {
            this.addActionError("No permissions selected!");
        }
        if (this.entryType.equals("non-vo-user")) {
            VOMSCA adminCA;
            if (this.dn == null || "".equals(this.dn)) {
                this.addFieldError("dn", "Please specify a subject!");
            }
            if (this.emailAddress == null || "".equals(this.emailAddress)) {
                this.addFieldError("emailAddress", "Please specify a valid email address!");
            }
            if ((adminCA = VOMSCADAO.instance().getByID(this.caId)) == null) {
                this.addFieldError("caId", "A CA for the given subject is not registered in the VOMS database!");
            }
            if (VOMSAdminDAO.instance().getByName(this.dn, adminCA.getSubjectString()) != null) {
                this.addFieldError("dn", "An administrator with the given subject already exists. Choose a different subject!");
            }
        }
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            this.buildEntryTypeMap();
        }
    }

    private void loadAdmin() throws Exception {
        if (this.entryType.equals("vo-user")) {
            VOMSUser u = (VOMSUser)FindUserOperation.instance(this.userId).execute();
            if (u == null) {
                throw new NoSuchUserException("User not found for id : " + this.userId);
            }
            this.admin = VOMSAdminDAO.instance().createFromUser(u);
        } else if (this.entryType.equals("non-vo-user")) {
            VOMSCA ca = VOMSCADAO.instance().getByID(this.caId);
            this.admin = VOMSAdminDAO.instance().getByName(this.dn, ca.getSubjectString());
            if (this.admin == null) {
                this.admin = VOMSAdminDAO.instance().create(this.dn, ca.getSubjectString());
                this.admin.setEmailAddress(this.getEmailAddress());
            }
        } else if (this.entryType.equals("role-admin")) {
            VOMSRole r = (VOMSRole)FindRoleOperation.instance(this.roleId).execute();
            VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(this.roleGroupId).execute();
            VOMSContext ctxt = VOMSContext.instance(g, r);
            this.admin = VOMSAdminDAO.instance().getByFQAN(ctxt.toString());
            if (this.admin == null) {
                this.admin = VOMSAdminDAO.instance().create(ctxt.toString());
            }
        } else if (this.entryType.equals("group-admin")) {
            VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(this.groupId).execute();
            VOMSContext ctxt = VOMSContext.instance(g);
            this.admin = VOMSAdminDAO.instance().getByFQAN(ctxt.toString());
            if (this.admin == null) {
                this.admin = VOMSAdminDAO.instance().create(ctxt.toString());
            }
        } else if (this.entryType.equals("anyone")) {
            this.admin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
        } else if (this.entryType.equals("unauthenticated")) {
            this.admin = VOMSAdminDAO.instance().getUnauthenticatedClientAdmin();
            if (this.admin == null) {
                this.admin = VOMSAdminDAO.instance().createUnauthenticateClientAdmin();
            }
        } else {
            throw new IllegalArgumentException("Unsupported entryType value: " + this.entryType);
        }
    }

    public String execute() throws Exception {
        this.loadAdmin();
        VOMSPermission perms = VOMSPermission.fromStringArray(this.selectedPermissions.toArray(new String[this.selectedPermissions.size()]));
        this.limitUnauthenticatedClientPermissions(perms);
        SaveACLEntryOperation op = SaveACLEntryOperation.instance(this.getModel(), this.admin, perms, this.propagate == null ? false : this.propagate);
        op.execute();
        return "success";
    }

    public List<String> getSelectedPermissions() {
        return this.selectedPermissions;
    }

    public void setSelectedPermissions(List<String> selectedPermissions) {
        this.selectedPermissions = selectedPermissions;
    }

    @RequiredFieldValidator(type=ValidatorType.FIELD, message="entryType is required!")
    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String entryType) {
        this.entryType = entryType;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Short getCaId() {
        return this.caId;
    }

    public void setCaId(Short caId) {
        this.caId = caId;
    }

    public Long getRoleGroupId() {
        return this.roleGroupId;
    }

    public void setRoleGroupId(Long roleGroupId) {
        this.roleGroupId = roleGroupId;
    }

    public VOMSPermission getPermission() {
        return this.permission;
    }

    public void setPermission(VOMSPermission permission) {
        this.permission = permission;
    }

    public void prepareInput() throws Exception {
        this.prepare();
        if (this.permission == null) {
            this.permission = VOMSPermission.getEmptyPermissions();
        }
        this.buildEntryTypeMap();
    }

    protected void buildEntryTypeMap() {
        this.entryTypeMap = new LinkedHashMap<String, String>();
        this.entryTypeMap.put("anyone", "any authenticated user");
        this.entryTypeMap.put("unauthenticated", "unauthenticated clients");
        if (!VOMSUserDAO.instance().findAll().isEmpty()) {
            this.entryTypeMap.put("vo-user", "a VO member certificate");
        }
        this.entryTypeMap.put("role-admin", "VO members with a specific role");
        this.entryTypeMap.put("group-admin", "VO members in a specific group");
        this.entryTypeMap.put("non-vo-user", "a non VO member");
    }

    public Map<String, String> getEntryTypeMap() {
        return this.entryTypeMap;
    }
}

