/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.util.version;

import java.util.regex.Pattern;
import org.glite.security.voms.admin.util.version.EndpointVersion;

public class VersionNumber
implements EndpointVersion {
    private static final String versionRegex = "\\d+\\.\\d+\\.\\d+$";
    private static final Pattern versionPattern = Pattern.compile("\\d+\\.\\d+\\.\\d+$");
    private String version;
    private int majorVersionNumber = 0;
    private int minorVersionNumber = 0;
    private int patchVersionNumber = 1;

    private void parseVersion() {
        if (!versionPattern.matcher(this.version).matches()) {
            throw new IllegalArgumentException("voms version number must comply to the following format: MAJOR.MINOR.PATCH.");
        }
        String[] tokens = this.version.split("\\.");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("voms version numbers must comply to the following format: MAJOR.MINOR.PATCH.");
        }
        this.majorVersionNumber = Integer.valueOf(tokens[0]);
        this.minorVersionNumber = Integer.valueOf(tokens[1]);
        this.patchVersionNumber = Integer.valueOf(tokens[2]);
    }

    public VersionNumber(String versionString) {
        assert (versionString != null) : "Cannot create a VersionNumber from a null string!";
        this.version = versionString;
        this.parseVersion();
    }

    @Override
    public int getMajorVersionNumber() {
        return this.majorVersionNumber;
    }

    @Override
    public int getMinorVersionNumber() {
        return this.minorVersionNumber;
    }

    @Override
    public int getPatchVersionNumber() {
        return this.patchVersionNumber;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version;
    }
}

