/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.slf4j.LoggerFactory;

public class ShutdownClient {
    private static final String ARG_VO = "vo";
    private static final String ARG_VO_DESC = "The VO to be shut down.";
    private static final String ARG_PORT = "port";
    private static final String ARG_PORT_DESC = "The port where the shutdown service is listening.";
    private static final String ARG_PASSWORD = "password";
    private static final String ARG_PASSWORD_DESC = "The password used to authenticate at the shutdown service.";
    private int port;
    private String password;
    private static Options cliOptions = new Options();
    private static CommandLineParser parser = new GnuParser();

    private static void initOptions() {
        OptionGroup og = new OptionGroup();
        og.addOption(new Option(ARG_VO, true, ARG_VO_DESC));
        og.addOption(new Option(ARG_PORT, true, ARG_PORT_DESC));
        cliOptions.addOptionGroup(og);
        cliOptions.addOption(new Option(ARG_PASSWORD, true, ARG_PASSWORD_DESC));
    }

    public ShutdownClient(int shutdownPort, String shutdownPassword) {
        this.port = shutdownPort;
        if (shutdownPassword != null) {
            this.password = shutdownPassword.trim();
        }
    }

    private static void disableLogBackLibraryLogging() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.setLevel(Level.OFF);
    }

    public void doShutdown() {
        String shutdownEndpoint = String.format("http://localhost:%d/shutdown", this.port);
        if (this.password != null) {
            shutdownEndpoint = shutdownEndpoint + String.format("?password=%s", this.password);
        }
        HttpClient httpClient = new HttpClient();
        GetMethod shutdown = new GetMethod(shutdownEndpoint);
        try {
            httpClient.executeMethod((HttpMethod)shutdown);
        }
        catch (Exception e) {
            System.err.println("VOMS shutdown error. " + e.getMessage());
            System.exit(1);
        }
    }

    static void usage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp ... org.glite.security.voms.admin.server.ShutdownClient", cliOptions);
    }

    protected static ShutdownClient getShutdownClientForVO(String voName) {
        System.setProperty("voms.vo.name", voName);
        VOMSConfiguration conf = VOMSConfiguration.load(null);
        conf.loadServiceProperties();
        String port = conf.getString("voms.shutdown_port");
        String password = conf.getString("voms.shutdown_password");
        if (port == null) {
            System.err.format("Shutdown port property not found in VO %s configuration!", voName);
            System.exit(1);
        }
        int portNumber = ShutdownClient.checkPortNumber(port);
        return new ShutdownClient(portNumber, password);
    }

    protected static int checkPortNumber(String portNumberString) {
        int thePort = -1;
        try {
            thePort = Integer.parseInt(portNumberString);
            if (thePort > 65536 || thePort < 0) {
                System.err.print("Please provide a valid shutdown port! (0 < port < 65536)");
                System.exit(1);
            }
        }
        catch (NumberFormatException e) {
            System.err.print("Error parsing the shutdown port number (not an integer). " + e.getMessage());
            System.exit(-1);
        }
        return thePort;
    }

    public static void main(String[] args) {
        ShutdownClient.disableLogBackLibraryLogging();
        ShutdownClient.initOptions();
        ShutdownClient sc = null;
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(cliOptions, args);
        }
        catch (ParseException e) {
            System.err.println("Error parsing command line arguments: " + e.getMessage());
            ShutdownClient.usage();
            System.exit(1);
        }
        String vo = cmdLine.getOptionValue(ARG_VO);
        String port = cmdLine.getOptionValue(ARG_PORT);
        String password = cmdLine.getOptionValue(ARG_PASSWORD);
        if (vo != null) {
            sc = ShutdownClient.getShutdownClientForVO(vo);
        }
        if (port != null) {
            int portNumber = ShutdownClient.checkPortNumber(port);
            sc = new ShutdownClient(portNumber, password);
        }
        sc.doShutdown();
    }
}

