/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.glite.security.voms.admin.util.AdminServiceContactInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminServiceContactUtil {
    public static final String SERVICE_CONTACT_FILENAME = "service-endpoint";
    public static final Logger log = LoggerFactory.getLogger(AdminServiceContactUtil.class);

    private AdminServiceContactUtil() {
    }

    private static AdminServiceContactInfo parseContactInfo(String voConfDirPath) throws IOException {
        File contactFile;
        String voName = voConfDirPath.substring(voConfDirPath.lastIndexOf(47) + 1);
        File voDir = new File(voConfDirPath);
        if (voDir.exists() && voDir.isDirectory() && voDir.canRead() && voDir.canExecute() && (contactFile = new File(voDir.getAbsolutePath() + "/" + SERVICE_CONTACT_FILENAME)).exists() && contactFile.canRead()) {
            String contactString = FileUtils.readFileToString((File)contactFile);
            String[] parts = contactString.split(":");
            AdminServiceContactInfo info = new AdminServiceContactInfo(voName, parts[0], Integer.parseInt(parts[1]));
            return info;
        }
        throw new IllegalArgumentException("VOMS Admin service configuration cannot be read from " + voConfDirPath);
    }

    public static List<AdminServiceContactInfo> getAdminServiceContactInfo(String configDir) {
        ArrayList<AdminServiceContactInfo> contacts = new ArrayList<AdminServiceContactInfo>();
        File confDir = new File(configDir);
        if (confDir.exists() && confDir.isDirectory() && confDir.canExecute() && confDir.canRead()) {
            File[] voFiles;
            for (File f : voFiles = confDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                try {
                    AdminServiceContactInfo info = AdminServiceContactUtil.parseContactInfo(f.getAbsolutePath());
                    contacts.add(info);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return contacts;
    }
}

