/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.taglib;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.utils.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelTag
extends TagSupport {
    private static final Logger log = LoggerFactory.getLogger(PanelTag.class);
    private static final long serialVersionUID = 1L;
    String id;
    String title;
    String headerClass;
    String contentClass;
    String panelClass;
    String titleClass;
    String buttonClass;

    protected boolean isActive() {
        Map statusMap = (Map)this.pageContext.findAttribute("uiStatusMap");
        log.debug("statusMap:" + statusMap);
        if (statusMap == null) {
            return true;
        }
        Boolean status = (Boolean)statusMap.get(this.getId());
        if (status == null) {
            return true;
        }
        return status;
    }

    protected String getUrl() {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        return req.getContextPath() + "/UI.do";
    }

    protected String getGetStatusJs() {
        return "getStatus('" + this.getUrl() + "','" + this.getId() + "','" + this.getImgUrl() + "')";
    }

    protected String getShowJs() {
        if (this.isActive()) {
            return "show('" + this.getUrl() + "','" + this.getContentId() + "',this,'" + this.getImgUrl() + "')";
        }
        return "hide('" + this.getUrl() + "','" + this.getContentId() + "',this,'" + this.getImgUrl() + "')";
    }

    protected String getJs() {
        return "toggleVisibility('" + this.getUrl() + "', '" + this.getId() + "','" + this.getImgUrl() + "')";
    }

    protected String getLoadJs() {
        return "load('" + this.getId() + "','" + this.getImgUrl() + "')";
    }

    protected String getImgUrl() {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        return req.getContextPath() + "/img";
    }

    protected String getImgSrc() {
        if (this.isActive()) {
            return this.getImgUrl() + "/minimize.png";
        }
        return this.getImgUrl() + "/maximize.png";
    }

    protected String getHeaderId() {
        return this.id + "_header";
    }

    protected String getContentId() {
        return this.id + "_content";
    }

    protected String getButtonId() {
        return this.id + "_button";
    }

    protected String getReloadId() {
        return this.id + "_reload";
    }

    protected String getTitleId() {
        return this.id + "_title";
    }

    protected void setCookie() {
        Cookie c = new Cookie(this.getId(), Boolean.toString(this.isActive()));
        c.setMaxAge(3600);
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        res.addCookie(c);
    }

    protected void buildHeaderContent(Document doc) {
        Element titleElement = doc.createElement("div");
        titleElement.setAttribute("id", this.getTitleId());
        titleElement.setAttribute("class", this.titleClass == null ? "" : this.titleClass);
        titleElement.appendChild(doc.createTextNode(this.getTitle()));
        doc.getDocumentElement().appendChild(titleElement);
        Element buttonElement = doc.createElement("img");
        buttonElement.setAttribute("id", this.getButtonId());
        buttonElement.setAttribute("class", this.buttonClass == null ? "" : this.buttonClass);
        buttonElement.setAttribute("src", this.getImgSrc());
        buttonElement.setAttribute("style", "cursor:pointer;");
        buttonElement.setAttribute("alt", "toggle");
        doc.getDocumentElement().appendChild(buttonElement);
    }

    public void write() throws JspException {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            log.error("Error creating XML parser!", (Throwable)e1);
            throw new JspTagException("Error creating XML parser!", (Throwable)e1);
        }
        catch (FactoryConfigurationError e1) {
            log.error("Error creating XML parser!", (Throwable)e1);
            throw new JspTagException("Error creating XML parser!", (Throwable)e1);
        }
        Document doc = builder.getDOMImplementation().createDocument("http://c", "div", null);
        try {
            this.pageContext.getOut().write("<div id=\"" + this.getId() + "\" class='" + this.getPanelClass() + "' >");
            doc.getDocumentElement().setAttribute("id", this.getHeaderId());
            doc.getDocumentElement().setAttribute("class", this.getHeaderClass());
            this.buildHeaderContent(doc);
            doc.normalize();
            String headerString = DOM2Writer.nodeToString((Node)doc, (boolean)true);
            log.debug("Header XML: " + headerString);
            this.pageContext.getOut().write(headerString);
            if (this.isActive()) {
                this.pageContext.getOut().write("<div id=\"" + this.getContentId() + "\" class='" + (this.getContentClass() == null ? "" : this.getContentClass()) + "' style='clear:both'>");
            } else {
                this.pageContext.getOut().write("<div id=\"" + this.getContentId() + "\" class='" + (this.getContentClass() == null ? "" : this.getContentClass()) + "' style='clear: both; display: none'>");
            }
            this.pageContext.getOut().write("<div class='separator'>&nbsp;</div>");
            this.pageContext.getOut().write("<div>");
        }
        catch (IOException e) {
            log.error("Error writing jsp page: " + e.getMessage(), (Throwable)e);
            throw new JspException("Error writing jsp page: " + e.getMessage(), (Throwable)e);
        }
    }

    public int doStartTag() throws JspException {
        this.write();
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            this.pageContext.getOut().write("</div>");
            this.pageContext.getOut().write("</div><!-- " + this.getContentId() + " --> </div> <!-- " + this.getId() + " -->");
            this.pageContext.getOut().write("<div class='separator'>&nbsp;</div>");
        }
        catch (IOException e) {
            log.error("Error writing jsp page: " + e.getMessage(), (Throwable)e);
            throw new JspException("Error writing jsp page: " + e.getMessage(), (Throwable)e);
        }
        return 6;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = contentClass;
    }

    public String getHeaderClass() {
        return this.headerClass;
    }

    public void setHeaderClass(String headerClass) {
        this.headerClass = headerClass;
    }

    public String getPanelClass() {
        return this.panelClass;
    }

    public void setPanelClass(String panelClass) {
        this.panelClass = panelClass;
    }

    public String getButtonClass() {
        return this.buttonClass;
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getTitleClass() {
        return this.titleClass;
    }

    public void setTitleClass(String titleClass) {
        this.titleClass = titleClass;
    }
}

